/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.util;

import com.mirth.connect.donkey.util.DateParser;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelProperties;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.Filter;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.model.ServerConfiguration;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.util.ImportConverter;
import com.mirth.connect.model.util.MigrationException;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImportConverter3_0_0 {
    private static final String VERSION_STRING = "3.0.0";
    private static final Pattern STRING_NODE_PATTERN = Pattern.compile("(?<=<(string)>).*(?=</string>)|<null/>");
    private static Logger logger = LogManager.getLogger(ImportConverter3_0_0.class);

    public static boolean isMigratable(Class<?> clazz) {
        return clazz.equals(Channel.class) || clazz.equals(Connector.class) || clazz.equals(AlertModel.class) || clazz.equals(ChannelProperties.class) || clazz.equals(CodeTemplate.class) || clazz.equals(ServerConfiguration.class) || clazz.equals(Filter.class) || clazz.equals(MetaData.class);
    }

    public static DonkeyElement migrate(DonkeyElement element, Class<?> expectedClass) throws MigrationException {
        if (element.hasAttribute("version")) {
            return element;
        }
        try {
            if (expectedClass == Channel.class) {
                element = new DonkeyElement(ImportConverter.convertChannelString(element.toXml()));
                ImportConverter3_0_0.migrateChannel(element);
            } else if (expectedClass == Connector.class) {
                element = new DonkeyElement(ImportConverter.convertConnector(element.toXml()));
                ImportConverter3_0_0.migrateConnector(element, null);
            } else if (expectedClass == AlertModel.class) {
                ImportConverter3_0_0.migrateAlert(element);
            } else if (expectedClass == ChannelProperties.class) {
                ImportConverter3_0_0.migrateChannelProperties(element, false, false);
                element.setNodeName("channelProperties");
            } else if (expectedClass == CodeTemplate.class) {
                element = new DonkeyElement(ImportConverter.convertCodeTemplates(element.toXml()).getDocumentElement());
                ImportConverter3_0_0.migrateCodeTemplate(element);
            } else if (expectedClass == ServerConfiguration.class) {
                element = new DonkeyElement(ImportConverter.convertServerConfiguration(element.toXml()).getDocumentElement());
                ImportConverter3_0_0.migrateServerConfiguration(element);
            } else if (expectedClass == Filter.class) {
                element = new DonkeyElement(ImportConverter.convertFilter(element.toXml()));
            } else if (expectedClass == MetaData.class) {
                ImportConverter3_0_0.migrateMetaData(element);
            }
        }
        catch (MigrationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MigrationException(e);
        }
        element.setAttribute("version", VERSION_STRING);
        return element;
    }

    private static void migrateChannel(DonkeyElement channel) throws MigrationException {
        logger.debug("Migrating channel to version 3.0.0");
        channel.removeChild("version");
        DonkeyElement sourceConnector = channel.getChildElement("sourceConnector");
        boolean isDataTypeDICOM = ImportConverter3_0_0.migrateConnector((DonkeyElement)sourceConnector, (Integer)Integer.valueOf((int)0)).isDataTypeDICOM;
        DonkeyElement responseConnectorProperties = sourceConnector.getChildElement("properties").getChildElement("responseConnectorProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(channel.getChildElement("properties"));
        String synchronous = oldProperties.getProperty("synchronous", "true");
        int metaDataId = 1;
        boolean isQueuingEnabled = false;
        for (DonkeyElement destinationConnector : channel.getChildElement("destinationConnectors").getChildElements()) {
            ConnectorMigrationMetaData connectorMetaData = ImportConverter3_0_0.migrateConnector(destinationConnector, metaDataId);
            if (connectorMetaData.dispatcherMetaData.isQueueEnabled) {
                isQueuingEnabled = true;
            }
            String destinationName = destinationConnector.getChildElement("name").getTextContent();
            destinationConnector.getChildElement("waitForPrevious").setTextContent(synchronous);
            if (responseConnectorProperties != null && destinationName.equals(responseConnectorProperties.getChildElement("responseVariable").getTextContent())) {
                responseConnectorProperties.getChildElement("responseVariable").setTextContent("d" + metaDataId);
            }
            ++metaDataId;
        }
        ImportConverter3_0_0.migrateChannelProperties(channel.getChildElement("properties"), isDataTypeDICOM, isQueuingEnabled);
        channel.addChildElement("nextMetaDataId").setTextContent(Integer.toString(metaDataId));
    }

    private static ConnectorMigrationMetaData migrateConnector(DonkeyElement connector, Integer metaDataId) throws MigrationException {
        logger.debug("Migrating connector");
        connector.removeChild("version");
        String mode = connector.getChildElement("mode").getTextContent();
        if (metaDataId != null) {
            connector.addChildElement("metaDataId").setTextContent(metaDataId.toString());
        } else if (mode.equals("SOURCE")) {
            connector.addChildElement("metaDataId").setTextContent("0");
        }
        DonkeyElement transportName = connector.getChildElement("transportName");
        String connectorName = transportName.getTextContent();
        DonkeyElement properties = connector.getChildElement("properties");
        DispatcherMigrationMetaData dispatcherMetaData = new DispatcherMigrationMetaData();
        if (connectorName.equals("Channel Reader")) {
            ImportConverter3_0_0.migrateVmReceiverProperties(properties);
        } else if (connectorName.equals("Channel Writer")) {
            dispatcherMetaData = ImportConverter3_0_0.migrateVmDispatcherProperties(properties);
        } else if (connectorName.equals("Database Reader")) {
            ImportConverter3_0_0.migrateDatabaseReceiverProperties(properties);
        } else if (connectorName.equals("Database Writer")) {
            ImportConverter3_0_0.migrateDatabaseDispatcherProperties(properties);
        } else if (connectorName.equals("DICOM Listener")) {
            ImportConverter3_0_0.migrateDICOMReceiverProperties(properties);
        } else if (connectorName.equals("DICOM Sender")) {
            ImportConverter3_0_0.migrateDICOMDispatcherProperties(properties);
        } else if (connectorName.equals("Document Writer")) {
            ImportConverter3_0_0.migrateDocumentDispatcherProperties(properties);
        } else if (connectorName.equals("File Reader")) {
            ImportConverter3_0_0.migrateFileReceiverProperties(properties);
        } else if (connectorName.equals("File Writer")) {
            ImportConverter3_0_0.migrateFileDispatcherProperties(properties);
        } else if (connectorName.equals("HTTP Listener")) {
            ImportConverter3_0_0.migrateHttpReceiverProperties(properties);
        } else if (connectorName.equals("HTTP Sender")) {
            dispatcherMetaData = ImportConverter3_0_0.migrateHttpDispatcherProperties(properties);
        } else if (connectorName.equals("JavaScript Reader")) {
            ImportConverter3_0_0.migrateJavaScriptReceiverProperties(properties);
        } else if (connectorName.equals("JavaScript Writer")) {
            ImportConverter3_0_0.migrateJavaScriptDispatcherProperties(properties);
        } else if (connectorName.equals("JMS Reader")) {
            ImportConverter3_0_0.migrateJmsReceiverProperties(properties);
        } else if (connectorName.equals("JMS Writer")) {
            ImportConverter3_0_0.migrateJmsDispatcherProperties(properties);
        } else if (connectorName.equals("LLP Listener")) {
            DonkeyElement transformer = connector.getChildElement("transformer");
            if (transformer.getChildElement("inboundProtocol").getTextContent().equals("HL7V2")) {
                Properties connectorProperties = ImportConverter3_0_0.readPropertiesElement(properties);
                DonkeyElement inboundProperties = transformer.getChildElement("inboundProperties");
                if (inboundProperties == null) {
                    inboundProperties = transformer.addChildElement("inboundProperties");
                }
                ImportConverter3_0_0.addChildAndSetName(inboundProperties, "successfulACKCode").setTextContent(connectorProperties.getProperty("ackCodeSuccessful", "AA"));
                ImportConverter3_0_0.addChildAndSetName(inboundProperties, "successfulACKMessage").setTextContent(connectorProperties.getProperty("ackMsgSuccessful", ""));
                ImportConverter3_0_0.addChildAndSetName(inboundProperties, "errorACKCode").setTextContent(connectorProperties.getProperty("ackCodeError", "AE"));
                ImportConverter3_0_0.addChildAndSetName(inboundProperties, "errorACKMessage").setTextContent(connectorProperties.getProperty("ackMsgError", "An Error Occurred Processing Message."));
                ImportConverter3_0_0.addChildAndSetName(inboundProperties, "rejectedACKCode").setTextContent(connectorProperties.getProperty("ackCodeRejected", "AR"));
                ImportConverter3_0_0.addChildAndSetName(inboundProperties, "rejectedACKMessage").setTextContent(connectorProperties.getProperty("ackMsgRejected", "Message Rejected."));
                ImportConverter3_0_0.addChildAndSetName(inboundProperties, "msh15ACKAccept").setTextContent(ImportConverter3_0_0.readBooleanProperty(connectorProperties, "checkMSH15", false));
            }
            ImportConverter3_0_0.migrateLLPListenerProperties(properties);
        } else if (connectorName.equals("LLP Sender")) {
            dispatcherMetaData = ImportConverter3_0_0.migrateLLPSenderProperties(properties);
        } else if (connectorName.equals("TCP Listener")) {
            ImportConverter3_0_0.migrateTCPListenerProperties(properties);
        } else if (connectorName.equals("TCP Sender")) {
            dispatcherMetaData = ImportConverter3_0_0.migrateTCPSenderProperties(properties);
        } else if (connectorName.equals("SMTP Sender")) {
            ImportConverter3_0_0.migrateSmtpDispatcherProperties(properties);
        } else if (connectorName.equals("Web Service Listener")) {
            ImportConverter3_0_0.migrateWebServiceListenerProperties(properties);
        } else if (connectorName.equals("Web Service Sender")) {
            dispatcherMetaData = ImportConverter3_0_0.migrateWebServiceSenderProperties(properties);
        } else if (connectorName.equals("Email Reader")) {
            try {
                Class<?> migratorClass = Class.forName("com.mirth.connect.connectors.email.shared.EmailReceiverMigrate3_0_0");
                Method migrateMethod = migratorClass.getMethod("migrate", DonkeyElement.class);
                migrateMethod.invoke(migratorClass.newInstance(), properties);
            }
            catch (Exception e) {
                throw new MigrationException("Failed to migrate " + connectorName + " properties", e);
            }
        } else {
            throw new MigrationException("Failed to migrate properties for unrecognized connector: " + connectorName);
        }
        String[] dataTypes = ImportConverter3_0_0.migrateTransformer(connector.getChildElement("transformer"));
        if (mode.equals("DESTINATION")) {
            boolean sendResponseTo;
            String outboundDataType = dataTypes[1];
            String sendResponseToChannelId = dispatcherMetaData.sendResponseToChannelId;
            boolean bl = sendResponseTo = StringUtils.isNotBlank((CharSequence)sendResponseToChannelId) && !sendResponseToChannelId.equals("sink");
            String convertedOutboundDataType = sendResponseTo ? (connectorName.equals("LLP Sender") && outboundDataType.equals("HL7V2") && properties.getChildElement("processHL7ACK").getTextContent().equals("true") ? "HL7V2" : "RAW") : (outboundDataType.equals("EDI") || outboundDataType.equals("X12") ? "EDI/X12" : outboundDataType);
            DonkeyElement responseTransformer = connector.addChildElement("responseTransformer");
            DonkeyElement steps = responseTransformer.addChildElement("steps");
            if (sendResponseTo) {
                String script = "if (response.getMessage() != '') {\n\trouter.routeMessageByChannelId('" + sendResponseToChannelId + "', response.getMessage());\n}";
                DonkeyElement step = steps.addChildElement("step");
                step.addChildElement("sequenceNumber", "0");
                step.addChildElement("name", "Send Response To Channel " + sendResponseToChannelId);
                step.addChildElement("script", script);
                step.addChildElement("type", "JavaScript");
                DonkeyElement data = step.addChildElement("data");
                data.setAttribute("class", "map");
                DonkeyElement entry = data.addChildElement("entry");
                entry.addChildElement("string", "Script");
                entry.addChildElement("string", script);
            }
            responseTransformer.addChildElement("inboundDataType").setTextContent(convertedOutboundDataType);
            responseTransformer.addChildElement("outboundDataType").setTextContent(convertedOutboundDataType);
            ImportConverter3_0_0.migrateDataTypeProperties(responseTransformer.addChildElement("inboundProperties"), outboundDataType);
            ImportConverter3_0_0.migrateDataTypeProperties(responseTransformer.addChildElement("outboundProperties"), outboundDataType);
        }
        transportName.setTextContent(ImportConverter3_0_0.convertTransportName(transportName.getTextContent()));
        connector.addChildElement("waitForPrevious").setTextContent("true");
        return new ConnectorMigrationMetaData(dataTypes[0].equals("DICOM"), dispatcherMetaData);
    }

    private static DonkeyElement addChildAndSetName(DonkeyElement parent, String name) {
        DonkeyElement child = parent.addChildElement(name);
        child.setAttribute("name", name);
        return child;
    }

    private static void migrateChannelProperties(DonkeyElement properties, boolean useDICOMAttachmentHandler, boolean isQueuingEnabled) {
        logger.debug("Migrating channel properties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.removeChildren();
        properties.addChildElement("clearGlobalChannelMap").setTextContent(oldProperties.getProperty("clearGlobalChannelMap", "true"));
        boolean storeMessages = oldProperties.getProperty("store_messages", "true").equals("true");
        if (storeMessages) {
            properties.addChildElement("messageStorageMode").setTextContent("DEVELOPMENT");
        } else if (isQueuingEnabled) {
            properties.addChildElement("messageStorageMode").setTextContent("PRODUCTION");
        } else {
            properties.addChildElement("messageStorageMode").setTextContent("DISABLED");
        }
        properties.addChildElement("encryptData").setTextContent(oldProperties.getProperty("encryptData", "false"));
        String removeData = Boolean.toString(ImportConverter3_0_0.readBooleanValue(oldProperties, "error_messages_only", false) || !storeMessages && isQueuingEnabled);
        properties.addChildElement("removeContentOnCompletion").setTextContent(removeData);
        properties.addChildElement("removeAttachmentsOnCompletion").setTextContent(removeData);
        if (ImportConverter3_0_0.readBooleanValue(oldProperties, "dont_store_filtered", false)) {
            properties.getChildElement("removeContentOnCompletion").setTextContent("true");
            properties.addChildElement("removeOnlyFilteredOnCompletion", "true");
        }
        properties.addChildElement("initialState").setTextContent(oldProperties.getProperty("initialState", "started").equals("started") ? "STARTED" : "STOPPED");
        properties.addChildElement("tags").setAttribute("class", "linked-hash-set");
        DonkeyElement metaDataColumns = properties.addChildElement("metaDataColumns");
        ImportConverter3_0_0.addMetaDataColumn(metaDataColumns, "SOURCE", "STRING", "message_source");
        ImportConverter3_0_0.addMetaDataColumn(metaDataColumns, "TYPE", "STRING", "message_type");
        properties.addChildElement("archiveEnabled").setTextContent("true");
        if (useDICOMAttachmentHandler) {
            attachmentProperties = properties.addChildElement("attachmentProperties");
            attachmentProperties.addChildElement("className").setTextContent("com.mirth.connect.server.attachments.DICOMAttachmentHandler");
            attachmentProperties.addChildElement("type").setTextContent("DICOM");
            attachmentProperties.addChildElement("properties");
            properties.addChildElement("storeAttachments").setTextContent("true");
        } else {
            attachmentProperties = properties.addChildElement("attachmentProperties");
            attachmentProperties.addChildElement("type").setTextContent("None");
            attachmentProperties.addChildElement("properties");
            properties.addChildElement("storeAttachments").setTextContent("false");
        }
        String maxMessageAge = oldProperties.getProperty("max_message_age");
        if (!StringUtils.isBlank((CharSequence)maxMessageAge) && !maxMessageAge.equals("-1")) {
            properties.addChildElement("pruneMetaDataDays").setTextContent(maxMessageAge);
        }
    }

    private static void addMetaDataColumn(DonkeyElement metaDataColumns, String name, String type, String mappingName) {
        DonkeyElement metaDataColumn = metaDataColumns.addChildElement("metaDataColumn");
        metaDataColumn.addChildElement("name", name);
        metaDataColumn.addChildElement("type", type);
        metaDataColumn.addChildElement("mappingName", mappingName);
    }

    private static void migrateCodeTemplate(DonkeyElement codeTemplate) {
        codeTemplate.removeChild("version");
    }

    private static void migrateAlert(DonkeyElement alert) {
        logger.debug("Migrating alert");
        alert.setNodeName("alertModel");
        alert.removeChild("expression");
        String template = alert.removeChild("template").getTextContent();
        String subject = alert.removeChild("subject").getTextContent();
        DonkeyElement channels = alert.removeChild("channels");
        ArrayList<String> channelList = new ArrayList<String>();
        if (channels != null) {
            for (DonkeyElement channel : channels.getChildElements()) {
                channelList.add(channel.getTextContent());
            }
        }
        DonkeyElement emails = alert.removeChild("emails");
        ArrayList<String> emailList = new ArrayList<String>();
        if (emails != null) {
            for (DonkeyElement email : emails.getChildElements()) {
                emailList.add(email.getTextContent());
            }
        }
        DonkeyElement triggerProperties = alert.addChildElement("trigger");
        triggerProperties.setAttribute("class", "defaultTrigger");
        DonkeyElement alertChannelsProperties = triggerProperties.addChildElement("alertChannels");
        alertChannelsProperties.addChildElement("newChannelSource", "false");
        alertChannelsProperties.addChildElement("newChannelDestination", "false");
        DonkeyElement enabledChannelsProperties = alertChannelsProperties.addChildElement("enabledChannels");
        for (String channelId : channelList) {
            enabledChannelsProperties.addChildElement("string", channelId);
        }
        alertChannelsProperties.addChildElement("disabledChannels");
        alertChannelsProperties.addChildElement("partialChannels");
        triggerProperties.addChildElement("errorEventTypes").addChildElement("errorEventType", "ANY");
        triggerProperties.addChildElement("regex");
        DonkeyElement actionGroupsProperties = alert.addChildElement("actionGroups");
        DonkeyElement alertActionGroupProperties = actionGroupsProperties.addChildElement("alertActionGroup");
        DonkeyElement actionsProperties = alertActionGroupProperties.addChildElement("actions");
        for (String email : emailList) {
            DonkeyElement alertActionProperties = actionsProperties.addChildElement("alertAction");
            alertActionProperties.addChildElement("protocol").setTextContent("EMAIL");
            alertActionProperties.addChildElement("recipient").setTextContent(email);
        }
        alertActionGroupProperties.addChildElement("subject").setTextContent(subject);
        alertActionGroupProperties.addChildElement("template").setTextContent(template);
        alert.addChildElement("properties");
    }

    private static void migrateServerConfiguration(DonkeyElement serverConfiguration) throws MigrationException {
        DonkeyElement serverSettings;
        DonkeyElement pluginProperties;
        DonkeyElement codeTemplates;
        DonkeyElement alerts;
        DonkeyElement channels = serverConfiguration.getChildElement("channels");
        if (channels != null) {
            for (DonkeyElement channel : channels.getChildElements()) {
                ImportConverter3_0_0.migrateChannel(channel);
            }
        }
        if ((alerts = serverConfiguration.getChildElement("alerts")) != null) {
            for (DonkeyElement alert : alerts.getChildElements()) {
                ImportConverter3_0_0.migrateAlert(alert);
            }
        }
        if ((codeTemplates = serverConfiguration.getChildElement("codeTemplates")) != null) {
            for (DonkeyElement codeTemplate : codeTemplates.getChildElements()) {
                ImportConverter3_0_0.migrateCodeTemplate(codeTemplate);
            }
        }
        if ((pluginProperties = serverConfiguration.getChildElement("pluginProperties")) != null) {
            for (DonkeyElement entry : pluginProperties.getChildElements()) {
                DonkeyElement pluginName = entry.getChildElement("string");
                if (!pluginName.getTextContent().equals("Message Pruner")) continue;
                pluginName.setTextContent("Data Pruner");
                ImportConverter3_0_0.convertDataPrunerProperties(entry.getChildElement("properties"));
            }
        }
        if ((serverSettings = serverConfiguration.getChildElement("serverSettings")) != null) {
            serverSettings.removeChild("maxQueueSize");
            serverSettings.addChildElement("queueBufferSize", "1000");
        }
    }

    private static void migrateMetaData(DonkeyElement metaData) {
        if (metaData.getTagName().equals("connectorMetaData")) {
            metaData.removeChild("mule-properties");
        }
    }

    private static void convertDataPrunerProperties(DonkeyElement propertiesElement) {
        Properties properties = ImportConverter3_0_0.readPropertiesElement(propertiesElement);
        properties.remove("allowBatchPruning");
        properties.setProperty("archiveEnabled", "false");
        ImportConverter3_0_0.writePropertiesElement(propertiesElement, properties);
    }

    private static String[] migrateTransformer(DonkeyElement transformer) {
        logger.debug("Migrating Transformer");
        DonkeyElement inboundDataTypeElement = transformer.getChildElement("inboundProtocol");
        DonkeyElement outboundDataTypeElement = transformer.getChildElement("outboundProtocol");
        inboundDataTypeElement.setNodeName("inboundDataType");
        outboundDataTypeElement.setNodeName("outboundDataType");
        String inboundDataType = inboundDataTypeElement.getTextContent();
        String outboundDataType = outboundDataTypeElement.getTextContent();
        DonkeyElement inboundProperties = transformer.getChildElement("inboundProperties");
        DonkeyElement outboundProperties = transformer.getChildElement("outboundProperties");
        if (inboundDataType.equals("HL7V2") && outboundDataType.equals("HL7V2")) {
            boolean convertLFtoCROutbound;
            boolean bl = convertLFtoCROutbound = outboundProperties == null ? true : ImportConverter3_0_0.readBooleanValue(ImportConverter3_0_0.readPropertiesElement(outboundProperties), "convertLFtoCR", true);
            if (inboundProperties != null && convertLFtoCROutbound) {
                for (DonkeyElement propertyElement : inboundProperties.getChildElements()) {
                    if (!propertyElement.getAttribute("name").equals("convertLFtoCR")) continue;
                    propertyElement.setTextContent("true");
                }
            }
        }
        if (inboundProperties == null) {
            inboundProperties = transformer.addChildElement("inboundProperties");
        }
        if (outboundProperties == null) {
            outboundProperties = transformer.addChildElement("outboundProperties");
        }
        DonkeyElement outboundTemplate = transformer.getChildElement("outboundTemplate");
        if (inboundDataType.equals(outboundDataType) && (outboundTemplate == null || StringUtils.isEmpty((CharSequence)outboundTemplate.getTextContent()))) {
            outboundProperties.removeChildren();
            for (DonkeyElement propertyElement : inboundProperties.getChildElements()) {
                outboundProperties.appendChild(propertyElement.cloneNode(true));
            }
        }
        ImportConverter3_0_0.migrateDataTypeProperties(inboundProperties, inboundDataType);
        ImportConverter3_0_0.migrateDataTypeProperties(outboundProperties, outboundDataType);
        if (inboundDataType.equals("EDI") || inboundDataType.equals("X12")) {
            inboundDataTypeElement.setTextContent("EDI/X12");
        }
        if (outboundDataType.equals("EDI") || outboundDataType.equals("X12")) {
            outboundDataTypeElement.setTextContent("EDI/X12");
        }
        return new String[]{inboundDataType, outboundDataType};
    }

    private static void migrateDataTypeProperties(DonkeyElement properties, String dataType) {
        if (dataType.equals("DELIMITED")) {
            ImportConverter3_0_0.migrateDelimitedProperties(properties);
        } else if (dataType.equals("DICOM")) {
            ImportConverter3_0_0.migrateDICOMProperties(properties);
        } else if (dataType.equals("EDI")) {
            ImportConverter3_0_0.migrateEDIProperties(properties);
        } else if (dataType.equals("HL7V2")) {
            ImportConverter3_0_0.migrateHL7v2Properties(properties);
        } else if (dataType.equals("HL7V3")) {
            ImportConverter3_0_0.migrateHL7v3Properties(properties);
        } else if (dataType.equals("NCPDP")) {
            ImportConverter3_0_0.migrateNCPDPProperties(properties);
        } else if (dataType.equals("X12")) {
            ImportConverter3_0_0.migrateX12Properties(properties);
        } else if (dataType.equals("XML")) {
            ImportConverter3_0_0.migrateXMLProperties(properties);
        } else {
            logger.error("Unrecognized data type: " + dataType);
        }
    }

    private static void migrateVmReceiverProperties(DonkeyElement properties) {
        logger.debug("Migrating VmReceiverProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.vm.VmReceiverProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildResponseConnectorProperties(properties.addChildElement("responseConnectorProperties"), oldProperties.getProperty("responseValue", "None"));
    }

    private static DispatcherMigrationMetaData migrateVmDispatcherProperties(DonkeyElement properties) {
        logger.debug("Migrating VmDispatcherProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.vm.VmDispatcherProperties");
        properties.removeChildren();
        boolean useQueue = !ImportConverter3_0_0.readBooleanValue(oldProperties, "synchronised", false);
        ImportConverter3_0_0.buildQueueConnectorProperties(properties.addChildElement("queueConnectorProperties"), useQueue ? "true" : "false", null, null, null);
        String host = oldProperties.getProperty("host", "none");
        if (host.equals("sink")) {
            host = "none";
        }
        properties.addChildElement("channelId").setTextContent(host);
        properties.addChildElement("channelTemplate").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("template", "${message.encodedData}")));
        return new DispatcherMigrationMetaData(null, useQueue);
    }

    private static void migrateDICOMReceiverProperties(DonkeyElement properties) {
        logger.debug("Migrating DICOMReceiverProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.dimse.DICOMReceiverProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildListenerConnectorProperties(properties.addChildElement("listenerConnectorProperties"), oldProperties.getProperty("host"), oldProperties.getProperty("port"), 104);
        ImportConverter3_0_0.buildResponseConnectorProperties(properties.addChildElement("responseConnectorProperties"));
        properties.addChildElement("soCloseDelay").setTextContent(oldProperties.getProperty("soclosedelay", "50"));
        properties.addChildElement("releaseTo").setTextContent(oldProperties.getProperty("releaseto", "5"));
        properties.addChildElement("requestTo").setTextContent(oldProperties.getProperty("requestto", "5"));
        properties.addChildElement("idleTo").setTextContent(oldProperties.getProperty("idleto", "60"));
        properties.addChildElement("reaper").setTextContent(oldProperties.getProperty("reaper", "10"));
        properties.addChildElement("rspDelay").setTextContent(oldProperties.getProperty("rspdelay", "0"));
        properties.addChildElement("pdv1").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "pdv1", false));
        properties.addChildElement("sndpdulen").setTextContent(oldProperties.getProperty("sndpdulen", "16"));
        properties.addChildElement("rcvpdulen").setTextContent(oldProperties.getProperty("rcvpdulen", "16"));
        properties.addChildElement("async").setTextContent(oldProperties.getProperty("async", "0"));
        properties.addChildElement("bigEndian").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "bigendian", false));
        properties.addChildElement("bufSize").setTextContent(oldProperties.getProperty("bufsize", "1"));
        properties.addChildElement("defts").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "defts", false));
        properties.addChildElement("dest").setTextContent(oldProperties.getProperty("dest", ""));
        properties.addChildElement("nativeData").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "nativeData", false));
        properties.addChildElement("sorcvbuf").setTextContent(oldProperties.getProperty("sorcvbuf", "0"));
        properties.addChildElement("sosndbuf").setTextContent(oldProperties.getProperty("sosndbuf", "0"));
        properties.addChildElement("tcpDelay").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "tcpdelay", true));
        properties.addChildElement("keyPW").setTextContent(oldProperties.getProperty("keypw", ""));
        properties.addChildElement("keyStore").setTextContent(oldProperties.getProperty("keystore", ""));
        properties.addChildElement("keyStorePW").setTextContent(oldProperties.getProperty("keystorepw", ""));
        properties.addChildElement("noClientAuth").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "noclientauth", true));
        properties.addChildElement("nossl2").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "nossl2", true));
        properties.addChildElement("tls").setTextContent(oldProperties.getProperty("tls", "notls"));
        properties.addChildElement("trustStore").setTextContent(oldProperties.getProperty("truststore", ""));
        properties.addChildElement("trustStorePW").setTextContent(oldProperties.getProperty("truststorepw", ""));
        properties.addChildElement("applicationEntity").setTextContent(oldProperties.getProperty("applicationEntity", ""));
        properties.addChildElement("localHost").setTextContent(oldProperties.getProperty("localHost", ""));
        properties.addChildElement("localPort").setTextContent(oldProperties.getProperty("localPort", ""));
        properties.addChildElement("localApplicationEntity").setTextContent(oldProperties.getProperty("localApplicationEntity", ""));
    }

    private static void migrateDICOMDispatcherProperties(DonkeyElement properties) {
        logger.debug("Migrating DICOMDispatcherProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.dimse.DICOMDispatcherProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildQueueConnectorProperties(properties.addChildElement("queueConnectorProperties"));
        properties.addChildElement("host").setTextContent(oldProperties.getProperty("host", "127.0.0.1"));
        properties.addChildElement("port").setTextContent(oldProperties.getProperty("port", "104"));
        properties.addChildElement("applicationEntity").setTextContent(oldProperties.getProperty("applicationEntity", ""));
        properties.addChildElement("localHost").setTextContent(oldProperties.getProperty("localHost", ""));
        properties.addChildElement("localPort").setTextContent(oldProperties.getProperty("localPort", ""));
        properties.addChildElement("localApplicationEntity").setTextContent(oldProperties.getProperty("localApplicationEntity", ""));
        properties.addChildElement("template").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("template", "${DICOMMESSAGE}")));
        properties.addChildElement("acceptTo").setTextContent(oldProperties.getProperty("accecptto", "5000"));
        properties.addChildElement("async").setTextContent(oldProperties.getProperty("async", "0"));
        properties.addChildElement("bufSize").setTextContent(oldProperties.getProperty("bufsize", "1"));
        properties.addChildElement("connectTo").setTextContent(oldProperties.getProperty("connectto", "0"));
        properties.addChildElement("priority").setTextContent(oldProperties.getProperty("priority", "med"));
        properties.addChildElement("passcode").setTextContent(oldProperties.getProperty("passcode", ""));
        properties.addChildElement("pdv1").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "pdv1", false));
        properties.addChildElement("rcvpdulen").setTextContent(oldProperties.getProperty("rcvpdulen", "16"));
        properties.addChildElement("reaper").setTextContent(oldProperties.getProperty("reaper", "10"));
        properties.addChildElement("releaseTo").setTextContent(oldProperties.getProperty("releaseto", "5"));
        properties.addChildElement("rspTo").setTextContent(oldProperties.getProperty("rspto", "60"));
        properties.addChildElement("shutdownDelay").setTextContent(oldProperties.getProperty("shutdowndelay", "1000"));
        properties.addChildElement("sndpdulen").setTextContent(oldProperties.getProperty("sndpdulen", "16"));
        properties.addChildElement("soCloseDelay").setTextContent(oldProperties.getProperty("soclosedelay", "50"));
        properties.addChildElement("sorcvbuf").setTextContent(oldProperties.getProperty("sorcvbuf", "0"));
        properties.addChildElement("sosndbuf").setTextContent(oldProperties.getProperty("sosndbuf", "0"));
        properties.addChildElement("stgcmt").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "stgcmt", false));
        properties.addChildElement("tcpDelay").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "tcpdelay", true));
        properties.addChildElement("ts1").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "pdv1", false));
        properties.addChildElement("uidnegrsp").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "uidnegrsp", false));
        properties.addChildElement("username").setTextContent(oldProperties.getProperty("username", ""));
        properties.addChildElement("keyPW").setTextContent(oldProperties.getProperty("keypw", ""));
        properties.addChildElement("keyStore").setTextContent(oldProperties.getProperty("keystore", ""));
        properties.addChildElement("keyStorePW").setTextContent(oldProperties.getProperty("keystorepw", ""));
        properties.addChildElement("noClientAuth").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "noclientauth", true));
        properties.addChildElement("nossl2").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "nossl2", true));
        properties.addChildElement("tls").setTextContent(oldProperties.getProperty("tls", "notls"));
        properties.addChildElement("trustStore").setTextContent(oldProperties.getProperty("truststore", ""));
        properties.addChildElement("trustStorePW").setTextContent(oldProperties.getProperty("truststorepw", ""));
    }

    private static void migrateDocumentDispatcherProperties(DonkeyElement properties) {
        logger.debug("Migrating DocumentDispatcherProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.doc.DocumentDispatcherProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildQueueConnectorProperties(properties.addChildElement("queueConnectorProperties"));
        properties.addChildElement("host").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("host", "")));
        properties.addChildElement("outputPattern").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("outputPattern", "")));
        properties.addChildElement("documentType").setTextContent(oldProperties.getProperty("documentType", "pdf"));
        properties.addChildElement("encrypt").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "encrypt", false));
        properties.addChildElement("password").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("password", "")));
        properties.addChildElement("template").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("template", "")));
    }

    private static void migrateFileReceiverProperties(DonkeyElement properties) {
        logger.debug("Migrating FileReceiverProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.file.FileReceiverProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildPollConnectorProperties(properties.addChildElement("pollConnectorProperties"), oldProperties.getProperty("pollingType"), oldProperties.getProperty("pollingTime"), oldProperties.getProperty("pollingFrequency"));
        ImportConverter3_0_0.buildResponseConnectorProperties(properties.addChildElement("responseConnectorProperties"), "Auto-generate (After source transformer)");
        properties.addChildElement("scheme").setTextContent(oldProperties.getProperty("scheme", "file").toUpperCase());
        properties.addChildElement("host").setTextContent(oldProperties.getProperty("host", ""));
        properties.addChildElement("fileFilter").setTextContent(oldProperties.getProperty("fileFilter", "*"));
        properties.addChildElement("regex").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "regex", false));
        properties.addChildElement("directoryRecursion").setTextContent("false");
        properties.addChildElement("ignoreDot").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "ignoreDot", true));
        properties.addChildElement("anonymous").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "FTPAnonymous", true));
        properties.addChildElement("username").setTextContent(oldProperties.getProperty("username", "anonymous"));
        properties.addChildElement("password").setTextContent(oldProperties.getProperty("password", "anonymous"));
        properties.addChildElement("timeout").setTextContent(oldProperties.getProperty("timeout", "10000"));
        properties.addChildElement("secure").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "secure", true));
        properties.addChildElement("passive").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "passive", true));
        properties.addChildElement("validateConnection").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "validateConnections", true));
        properties.addChildElement("checkFileAge").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "checkFileAge", true));
        properties.addChildElement("fileAge").setTextContent(oldProperties.getProperty("fileAge", "1000"));
        properties.addChildElement("fileSizeMinimum").setTextContent("0");
        properties.addChildElement("fileSizeMaximum").setTextContent("");
        properties.addChildElement("ignoreFileSizeMaximum").setTextContent("true");
        properties.addChildElement("sortBy").setTextContent(oldProperties.getProperty("sortAttribute", "date"));
        properties.addChildElement("binary").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "binary", false));
        properties.addChildElement("charsetEncoding").setTextContent(oldProperties.getProperty("charsetEncoding", "DEFAULT_ENCODING"));
        properties.addChildElement("processBatch").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "processBatchFiles", false));
        String moveToDirectory = ImportConverter3_0_0.convertReferences(oldProperties.getProperty("moveToDirectory"));
        String moveToFileName = ImportConverter3_0_0.convertReferences(oldProperties.getProperty("moveToPattern"));
        properties.addChildElement("moveToDirectory").setTextContent(moveToDirectory);
        properties.addChildElement("moveToFileName").setTextContent(moveToFileName);
        String afterProcessingAction = "NONE";
        if (ImportConverter3_0_0.readBooleanValue(oldProperties, "autoDelete", false)) {
            afterProcessingAction = "DELETE";
        } else if (!StringUtils.isBlank((CharSequence)moveToDirectory) || !StringUtils.isBlank((CharSequence)moveToFileName)) {
            afterProcessingAction = "MOVE";
        }
        properties.addChildElement("afterProcessingAction").setTextContent(afterProcessingAction);
        String errorMoveToDirectory = ImportConverter3_0_0.convertReferences(oldProperties.getProperty("moveToErrorDirectory"));
        String errorReadingAction = "NONE";
        String errorResponseAction = "AFTER_PROCESSING";
        if (!StringUtils.isBlank((CharSequence)errorMoveToDirectory)) {
            errorReadingAction = "MOVE";
            errorResponseAction = "MOVE";
        }
        properties.addChildElement("errorReadingAction").setTextContent(errorReadingAction);
        properties.addChildElement("errorMoveToDirectory").setTextContent(errorMoveToDirectory);
        properties.addChildElement("errorMoveToFileName").setTextContent("");
        properties.addChildElement("errorResponseAction").setTextContent(errorResponseAction);
    }

    private static void migrateFileDispatcherProperties(DonkeyElement properties) {
        logger.debug("Migrating FileDispatcherProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.file.FileDispatcherProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildQueueConnectorProperties(properties.addChildElement("queueConnectorProperties"));
        properties.addChildElement("scheme").setTextContent(oldProperties.getProperty("scheme", "file").toUpperCase());
        properties.addChildElement("host").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("host", "")));
        properties.addChildElement("outputPattern").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("outputPattern", "")));
        properties.addChildElement("anonymous").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "FTPAnonymous", true));
        properties.addChildElement("username").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("username", "anonymous")));
        properties.addChildElement("password").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("password", "anonymous")));
        properties.addChildElement("timeout").setTextContent(oldProperties.getProperty("timeout", "10000"));
        properties.addChildElement("secure").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "secure", true));
        properties.addChildElement("passive").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "passive", true));
        properties.addChildElement("validateConnection").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "validateConnections", true));
        properties.addChildElement("outputAppend").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "outputAppend", true));
        properties.addChildElement("errorOnExists").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "errorOnExists", false));
        properties.addChildElement("temporary").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "temporary", false));
        properties.addChildElement("binary").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "binary", false));
        properties.addChildElement("charsetEncoding").setTextContent(oldProperties.getProperty("charsetEncoding", "DEFAULT_ENCODING"));
        properties.addChildElement("template").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("template", "")));
    }

    private static void migrateHttpReceiverProperties(DonkeyElement properties) {
        logger.debug("Migrating HttpReceiverProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.http.HttpReceiverProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildListenerConnectorProperties(properties.addChildElement("listenerConnectorProperties"), oldProperties.getProperty("host"), oldProperties.getProperty("port"), 80);
        ImportConverter3_0_0.buildResponseConnectorProperties(properties.addChildElement("responseConnectorProperties"), oldProperties.getProperty("receiverResponse"));
        properties.addChildElement("bodyOnly").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "receiverBodyOnly", true));
        properties.addChildElement("responseContentType").setTextContent(oldProperties.getProperty("receiverResponseContentType", "text/plain"));
        properties.addChildElement("responseStatusCode").setTextContent(oldProperties.getProperty("receiverResponseStatusCode", ""));
        properties.addChildElement("charset").setTextContent(oldProperties.getProperty("receiverCharset", "UTF-8"));
        properties.addChildElement("contextPath").setTextContent(oldProperties.getProperty("receiverContextPath", ""));
        properties.addChildElement("timeout").setTextContent(oldProperties.getProperty("receiverTimeout", "0"));
        try {
            ImportConverter3_0_0.convertEscapedText(properties.addChildElement("responseHeaders"), ImportConverter3_0_0.convertReferences(oldProperties.getProperty("receiverResponseHeaders", "&lt;linked-hash-map/&gt;")));
        }
        catch (DonkeyElement.DonkeyElementException e) {
            logger.error("Failed to convert HTTP Receiver connection properties", (Throwable)e);
        }
    }

    private static DispatcherMigrationMetaData migrateHttpDispatcherProperties(DonkeyElement properties) throws MigrationException {
        logger.debug("Migrating HttpDispatcherProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.http.HttpDispatcherProperties");
        properties.removeChildren();
        String useQueue = ImportConverter3_0_0.readBooleanProperty(oldProperties, "usePersistentQueues");
        ImportConverter3_0_0.buildQueueConnectorProperties(properties.addChildElement("queueConnectorProperties"), useQueue, ImportConverter3_0_0.readBooleanProperty(oldProperties, "rotateQueue"), oldProperties.getProperty("reconnectMillisecs"), null);
        properties.addChildElement("host").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("host", "")));
        properties.addChildElement("method").setTextContent(oldProperties.getProperty("dispatcherMethod", "post"));
        properties.addChildElement("includeHeadersInResponse").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "dispatcherIncludeHeadersInResponse", false));
        properties.addChildElement("multipart").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "dispatcherMultipart", false));
        properties.addChildElement("useAuthentication").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "dispatcherUseAuthentication", false));
        properties.addChildElement("authenticationType").setTextContent(oldProperties.getProperty("dispatcherAuthenticationType", "Basic"));
        properties.addChildElement("username").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherUsername", "")));
        properties.addChildElement("password").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherPassword", "")));
        properties.addChildElement("content").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherContent", "")));
        properties.addChildElement("contentType").setTextContent(oldProperties.getProperty("dispatcherContentType", "text/plain"));
        properties.addChildElement("charset").setTextContent(oldProperties.getProperty("dispatcherCharset", "UTF-8"));
        properties.addChildElement("socketTimeout").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherSocketTimeout", "30000")));
        try {
            Properties oldHeaderProperties = ImportConverter3_0_0.readPropertiesElement(new DonkeyElement(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherHeaders"))));
            DonkeyElement headerProperties = properties.addChildElement("headers");
            headerProperties.setAttribute("class", "linked-hash-map");
            for (Object key : oldHeaderProperties.keySet()) {
                String value = oldHeaderProperties.getProperty((String)key);
                DonkeyElement entry = headerProperties.addChildElement("entry");
                entry.addChildElement("string", (String)key);
                entry.addChildElement("string", value);
            }
            Properties oldParameterProperties = ImportConverter3_0_0.readPropertiesElement(new DonkeyElement(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherParameters"))));
            DonkeyElement parameterProperties = properties.addChildElement("parameters");
            parameterProperties.setAttribute("class", "linked-hash-map");
            for (Object key : oldParameterProperties.keySet()) {
                String value = oldParameterProperties.getProperty((String)key);
                DonkeyElement entry = parameterProperties.addChildElement("entry");
                entry.addChildElement("string", (String)key);
                entry.addChildElement("string", value);
            }
            return new DispatcherMigrationMetaData(oldProperties.getProperty("dispatcherReplyChannelId"), Boolean.parseBoolean(useQueue));
        }
        catch (DonkeyElement.DonkeyElementException e) {
            throw new MigrationException("Failed to migrate HTTP Dispatcher properties", e);
        }
    }

    private static void migrateDatabaseReceiverProperties(DonkeyElement properties) {
        logger.debug("Migrating DatabaseReceiverProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.jdbc.DatabaseReceiverProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildPollConnectorProperties(properties.addChildElement("pollConnectorProperties"), oldProperties.getProperty("pollingType"), oldProperties.getProperty("pollingTime"), oldProperties.getProperty("pollingFrequency"));
        ImportConverter3_0_0.buildResponseConnectorProperties(properties.addChildElement("responseConnectorProperties"));
        boolean useScript = ImportConverter3_0_0.readBooleanValue(oldProperties, "useScript", false);
        boolean useAck = ImportConverter3_0_0.readBooleanValue(oldProperties, "useAck", false);
        properties.addChildElement("driver").setTextContent(oldProperties.getProperty("driver", "Please Select One"));
        properties.addChildElement("url").setTextContent(oldProperties.getProperty("URL", ""));
        properties.addChildElement("username").setTextContent(oldProperties.getProperty("username", ""));
        properties.addChildElement("password").setTextContent(oldProperties.getProperty("password", ""));
        properties.addChildElement("select").setTextContent(oldProperties.getProperty(useScript ? "script" : "query", ""));
        properties.addChildElement("update").setTextContent(useScript ? oldProperties.getProperty("ackScript", "") : ImportConverter3_0_0.convertReferences(oldProperties.getProperty("ack", "")));
        properties.addChildElement("useScript").setTextContent(Boolean.toString(useScript));
        properties.addChildElement("cacheResults").setTextContent("true");
        properties.addChildElement("keepConnectionOpen").setTextContent("true");
        properties.addChildElement("updateMode").setTextContent(useAck ? "3" : "1");
        properties.addChildElement("retryCount").setTextContent("3");
        properties.addChildElement("retryInterval").setTextContent("10000");
        properties.addChildElement("fetchSize").setTextContent("1000");
    }

    private static void migrateDatabaseDispatcherProperties(DonkeyElement properties) {
        logger.debug("Migrating DatabaseDispatcherProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.jdbc.DatabaseDispatcherProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildQueueConnectorProperties(properties.addChildElement("queueConnectorProperties"));
        boolean useScript = ImportConverter3_0_0.readBooleanValue(oldProperties, "useScript", false);
        properties.addChildElement("driver").setTextContent(oldProperties.getProperty("driver", "Please Select One"));
        properties.addChildElement("url").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("URL", "")));
        properties.addChildElement("username").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("username", "")));
        properties.addChildElement("password").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("password", "")));
        properties.addChildElement("query").setTextContent(useScript ? oldProperties.getProperty("script", "") : ImportConverter3_0_0.convertReferences(oldProperties.getProperty("query", "")));
        properties.addChildElement("useScript").setTextContent(Boolean.toString(useScript));
    }

    private static void migrateJmsReceiverProperties(DonkeyElement properties) throws MigrationException {
        boolean topic;
        logger.debug("Migrating JmsReceiverProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.jms.JmsReceiverProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildResponseConnectorProperties(properties.addChildElement("responseConnectorProperties"));
        properties.addChildElement("useJndi").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "useJndi", false));
        properties.addChildElement("jndiProviderUrl").setTextContent(oldProperties.getProperty("jndiProviderUrl", ""));
        properties.addChildElement("jndiInitialContextFactory").setTextContent(oldProperties.getProperty("jndiInitialFactory", ""));
        properties.addChildElement("jndiConnectionFactoryName").setTextContent(oldProperties.getProperty("connectionFactoryJndiName", ""));
        properties.addChildElement("connectionFactoryClass").setTextContent(oldProperties.getProperty("connectionFactoryClass", ""));
        properties.addChildElement("username").setTextContent(oldProperties.getProperty("username", ""));
        properties.addChildElement("password").setTextContent(oldProperties.getProperty("password", ""));
        String destinationName = oldProperties.getProperty("host", "");
        boolean durableTopic = topic = ImportConverter3_0_0.readBooleanValue(oldProperties, "durable", false);
        if (StringUtils.startsWith((CharSequence)destinationName, (CharSequence)"topic://") || StringUtils.startsWith((CharSequence)destinationName, (CharSequence)"//topic:")) {
            destinationName = destinationName.substring(8);
            topic = true;
        } else if (StringUtils.startsWith((CharSequence)destinationName, (CharSequence)"//queue:") || StringUtils.startsWith((CharSequence)destinationName, (CharSequence)"queue://")) {
            destinationName = destinationName.substring(8);
            topic = false;
            durableTopic = false;
        }
        properties.addChildElement("destinationName").setTextContent(destinationName);
        properties.addChildElement("reconnectIntervalMillis").setTextContent("10000");
        properties.addChildElement("clientId").setTextContent(oldProperties.getProperty("clientId", ""));
        properties.addChildElement("topic").setTextContent(Boolean.toString(topic));
        properties.addChildElement("durableTopic").setTextContent(Boolean.toString(durableTopic));
        properties.addChildElement("selector").setTextContent(oldProperties.getProperty("selector", ""));
        DonkeyElement connectionProperties = properties.addChildElement("connectionProperties");
        connectionProperties.setAttribute("class", "linked-hash-map");
        try {
            Properties oldConnectionProperties = ImportConverter3_0_0.readPropertiesElement(new DonkeyElement(oldProperties.getProperty("connectionFactoryProperties")));
            for (Object key : oldConnectionProperties.keySet()) {
                String value = oldConnectionProperties.getProperty((String)key);
                DonkeyElement entry = connectionProperties.addChildElement("entry");
                entry.addChildElement("string", (String)key);
                entry.addChildElement("string", value);
            }
        }
        catch (Exception e) {
            throw new MigrationException(e);
        }
    }

    private static void migrateJmsDispatcherProperties(DonkeyElement properties) throws MigrationException {
        logger.debug("Migrating JmsDispatcherProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.jms.JmsDispatcherProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildQueueConnectorProperties(properties.addChildElement("queueConnectorProperties"));
        properties.addChildElement("useJndi").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "useJndi", false));
        properties.addChildElement("jndiProviderUrl").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("jndiProviderUrl", "")));
        properties.addChildElement("jndiInitialContextFactory").setTextContent(oldProperties.getProperty("jndiInitialFactory", ""));
        properties.addChildElement("jndiConnectionFactoryName").setTextContent(oldProperties.getProperty("connectionFactoryJndiName", ""));
        properties.addChildElement("connectionFactoryClass").setTextContent(oldProperties.getProperty("connectionFactoryClass", ""));
        properties.addChildElement("username").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("username", "")));
        properties.addChildElement("password").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("password", "")));
        String destinationName = ImportConverter3_0_0.convertReferences(oldProperties.getProperty("host", ""));
        boolean topic = false;
        if (StringUtils.startsWith((CharSequence)destinationName, (CharSequence)"topic://") || StringUtils.startsWith((CharSequence)destinationName, (CharSequence)"//topic:")) {
            destinationName = destinationName.substring(8);
            topic = true;
        } else if (StringUtils.startsWith((CharSequence)destinationName, (CharSequence)"//queue:") || StringUtils.startsWith((CharSequence)destinationName, (CharSequence)"queue://")) {
            destinationName = destinationName.substring(8);
            topic = false;
        }
        properties.addChildElement("destinationName").setTextContent(destinationName);
        properties.addChildElement("clientId").setTextContent("");
        properties.addChildElement("topic").setTextContent(Boolean.toString(topic));
        properties.addChildElement("template").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("template", "${message.encodedData}")));
        try {
            Properties oldConnectionProperties = ImportConverter3_0_0.readPropertiesElement(new DonkeyElement(oldProperties.getProperty("connectionFactoryProperties")));
            DonkeyElement connectionProperties = properties.addChildElement("connectionProperties");
            connectionProperties.setAttribute("class", "linked-hash-map");
            for (Object key : oldConnectionProperties.keySet()) {
                String value = ImportConverter3_0_0.convertReferences(oldConnectionProperties.getProperty((String)key));
                DonkeyElement entry = connectionProperties.addChildElement("entry");
                entry.addChildElement("string", (String)key);
                entry.addChildElement("string", value);
            }
        }
        catch (DonkeyElement.DonkeyElementException e) {
            throw new MigrationException(e);
        }
    }

    private static void migrateJavaScriptReceiverProperties(DonkeyElement properties) {
        logger.debug("Migrating JavaScriptReceiverProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.js.JavaScriptReceiverProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildPollConnectorProperties(properties.addChildElement("pollConnectorProperties"), oldProperties.getProperty("pollingType"), oldProperties.getProperty("pollingTime"), oldProperties.getProperty("pollingFrequency"));
        ImportConverter3_0_0.buildResponseConnectorProperties(properties.addChildElement("responseConnectorProperties"));
        properties.addChildElement("script").setTextContent(oldProperties.getProperty("script", ""));
    }

    private static void migrateJavaScriptDispatcherProperties(DonkeyElement properties) {
        logger.debug("Migrating JavaScriptDispatcherProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.js.JavaScriptDispatcherProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildQueueConnectorProperties(properties.addChildElement("queueConnectorProperties"));
        properties.addChildElement("script").setTextContent(oldProperties.getProperty("script", ""));
    }

    private static void migrateSmtpDispatcherProperties(DonkeyElement properties) throws MigrationException {
        logger.debug("Migrating SmtpDispatcherProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.smtp.SmtpDispatcherProperties");
        properties.removeChildren();
        ImportConverter3_0_0.buildQueueConnectorProperties(properties.addChildElement("queueConnectorProperties"));
        properties.addChildElement("authentication").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "authentication", false));
        properties.addChildElement("body").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("body", "")));
        properties.addChildElement("charsetEncoding").setTextContent(oldProperties.getProperty("charsetEncoding", "DEFAULT_ENCODING"));
        properties.addChildElement("encryption").setTextContent(oldProperties.getProperty("encryption", "none"));
        properties.addChildElement("from").setTextContent(oldProperties.getProperty("from", ""));
        properties.addChildElement("html").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "html", false));
        properties.addChildElement("password").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("password", "")));
        properties.addChildElement("smtpHost").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("smtpHost", "")));
        properties.addChildElement("smtpPort").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("smtpPort", "25")));
        properties.addChildElement("subject").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("subject", "25")));
        properties.addChildElement("timeout").setTextContent(oldProperties.getProperty("timeout", "5000"));
        properties.addChildElement("to").setTextContent(oldProperties.getProperty("to", ""));
        properties.addChildElement("username").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("username", "")));
        properties.addChildElement("cc").setTextContent("");
        properties.addChildElement("bcc").setTextContent("");
        properties.addChildElement("replyTo").setTextContent("");
        try {
            ImportConverter3_0_0.convertEscapedText(properties.addChildElement("headers"), ImportConverter3_0_0.convertReferences(oldProperties.getProperty("headers", "")));
            ImportConverter3_0_0.convertEscapedText(properties.addChildElement("attachments"), ImportConverter3_0_0.convertReferences(oldProperties.getProperty("attachments", "")));
        }
        catch (DonkeyElement.DonkeyElementException e) {
            throw new MigrationException("Failed to convert SMTP Dispatcher connection properties", e);
        }
    }

    private static void migrateLLPListenerProperties(DonkeyElement properties) {
        Object endOfMessageBytes;
        String startOfMessageBytes;
        logger.debug("Migrating LLPListenerProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.tcp.TcpReceiverProperties");
        properties.removeChildren();
        DonkeyElement listenerConnectorProperties = properties.addChildElement("listenerConnectorProperties");
        listenerConnectorProperties.addChildElement("host").setTextContent(oldProperties.getProperty("host", "0.0.0.0"));
        listenerConnectorProperties.addChildElement("port").setTextContent(oldProperties.getProperty("port", "6661"));
        String responseValue = oldProperties.getProperty("responseValue", "None");
        if (ImportConverter3_0_0.readBooleanValue(oldProperties, "sendACK", true)) {
            responseValue = "Auto-generate (After source transformer)";
        }
        ImportConverter3_0_0.buildResponseConnectorProperties(properties.addChildElement("responseConnectorProperties"), responseValue);
        DonkeyElement transmissionModeProperties = properties.addChildElement("transmissionModeProperties");
        transmissionModeProperties.setAttribute("class", "com.mirth.connect.model.transmission.framemode.FrameModeProperties");
        transmissionModeProperties.addChildElement("pluginPointName").setTextContent("MLLP");
        boolean frameEncodingHex = oldProperties.getProperty("charEncoding", "hex").equals("hex");
        if (frameEncodingHex) {
            startOfMessageBytes = ImportConverter3_0_0.stripHexPrefix(oldProperties.getProperty("messageStart", "0B"));
            endOfMessageBytes = ImportConverter3_0_0.stripHexPrefix(oldProperties.getProperty("messageEnd", "1C"));
            String recordSeparator = ImportConverter3_0_0.stripHexPrefix(oldProperties.getProperty("recordSeparator", "0D"));
            if (!recordSeparator.equals("00")) {
                endOfMessageBytes = (String)endOfMessageBytes + recordSeparator;
            }
        } else {
            startOfMessageBytes = ImportConverter3_0_0.convertToHexString(oldProperties.getProperty("messageStart", "\u000b"));
            endOfMessageBytes = oldProperties.getProperty("messageEnd", "\u001c");
            String recordSeparator = oldProperties.getProperty("recordSeparator", "\r");
            if (!recordSeparator.equals("\u0000")) {
                endOfMessageBytes = (String)endOfMessageBytes + recordSeparator;
            }
            endOfMessageBytes = ImportConverter3_0_0.convertToHexString((String)endOfMessageBytes);
        }
        transmissionModeProperties.addChildElement("startOfMessageBytes").setTextContent(startOfMessageBytes);
        transmissionModeProperties.addChildElement("endOfMessageBytes").setTextContent((String)endOfMessageBytes);
        properties.addChildElement("serverMode").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "serverMode", true));
        properties.addChildElement("reconnectInterval").setTextContent(oldProperties.getProperty("reconnectInterval", "5000"));
        properties.addChildElement("receiveTimeout").setTextContent(oldProperties.getProperty("receiveTimeout", "0"));
        properties.addChildElement("bufferSize").setTextContent(oldProperties.getProperty("bufferSize", "65536"));
        properties.addChildElement("maxConnections").setTextContent("10");
        properties.addChildElement("keepConnectionOpen").setTextContent("true");
        properties.addChildElement("processBatch").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "processBatchFiles", false));
        properties.addChildElement("dataTypeBinary").setTextContent("false");
        properties.addChildElement("charsetEncoding").setTextContent(oldProperties.getProperty("charsetEncoding", "DEFAULT_ENCODING"));
        properties.addChildElement("respondOnNewConnection").setTextContent(ImportConverter3_0_0.readBooleanValue(oldProperties, "ackOnNewConnection", false) ? "1" : "0");
        properties.addChildElement("responseAddress").setTextContent(oldProperties.getProperty("ackIP", ""));
        properties.addChildElement("responsePort").setTextContent(oldProperties.getProperty("ackPort", ""));
    }

    private static String stripHexPrefix(String hexString) {
        return hexString.startsWith("0x") || hexString.startsWith("0X") ? hexString.substring(2) : hexString;
    }

    private static String convertToEscapedString(String str, boolean hex) {
        String fixedString = str;
        if (hex) {
            byte[] bytes = ImportConverter3_0_0.stringToByteArray(ImportConverter3_0_0.stripHexPrefix(str));
            try {
                fixedString = new String(bytes, "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                fixedString = new String(bytes);
            }
        }
        return StringEscapeUtils.escapeJava((String)fixedString);
    }

    private static String convertToHexString(String str) {
        try {
            return Hex.encodeHexString((byte[])str.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            return Hex.encodeHexString((byte[])str.getBytes());
        }
    }

    private static byte[] stringToByteArray(String str) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        if (StringUtils.isNotBlank((CharSequence)str)) {
            String hexString = str.toUpperCase().replaceAll("[^0-9A-F]", "");
            for (String hexByte : ((hexString.length() % 2 > 0 ? "0" : "") + hexString).split("(?<=\\G..)")) {
                bytes.write((byte)((Character.digit(hexByte.charAt(0), 16) << 4) + Character.digit(hexByte.charAt(1), 16)));
            }
        }
        return bytes.toByteArray();
    }

    private static DispatcherMigrationMetaData migrateLLPSenderProperties(DonkeyElement properties) {
        Object endOfMessageBytes;
        String startOfMessageBytes;
        logger.debug("Migrating LLPSenderProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.tcp.TcpDispatcherProperties");
        properties.removeChildren();
        String useQueue = ImportConverter3_0_0.readBooleanProperty(oldProperties, "usePersistentQueues");
        ImportConverter3_0_0.buildQueueConnectorProperties(properties.addChildElement("queueConnectorProperties"), useQueue, ImportConverter3_0_0.readBooleanProperty(oldProperties, "rotateQueue"), oldProperties.getProperty("reconnectMillisecs"), oldProperties.getProperty("maxRetryCount"));
        DonkeyElement transmissionModeProperties = properties.addChildElement("transmissionModeProperties");
        transmissionModeProperties.setAttribute("class", "com.mirth.connect.model.transmission.framemode.FrameModeProperties");
        transmissionModeProperties.addChildElement("pluginPointName").setTextContent("MLLP");
        boolean frameEncodingHex = oldProperties.getProperty("charEncoding", "hex").equals("hex");
        if (frameEncodingHex) {
            startOfMessageBytes = ImportConverter3_0_0.stripHexPrefix(oldProperties.getProperty("messageStart", "0B"));
            endOfMessageBytes = ImportConverter3_0_0.stripHexPrefix(oldProperties.getProperty("messageEnd", "1C"));
            recordSeparator = ImportConverter3_0_0.stripHexPrefix(oldProperties.getProperty("recordSeparator", "0D"));
            if (!recordSeparator.equals("00")) {
                endOfMessageBytes = (String)endOfMessageBytes + recordSeparator;
            }
        } else {
            startOfMessageBytes = ImportConverter3_0_0.convertToHexString(oldProperties.getProperty("messageStart", "\u000b"));
            endOfMessageBytes = oldProperties.getProperty("messageEnd", "\u001c");
            recordSeparator = oldProperties.getProperty("recordSeparator", "\r");
            if (!recordSeparator.equals("\u0000")) {
                endOfMessageBytes = (String)endOfMessageBytes + recordSeparator;
            }
            endOfMessageBytes = ImportConverter3_0_0.convertToHexString((String)endOfMessageBytes);
        }
        transmissionModeProperties.addChildElement("startOfMessageBytes").setTextContent(startOfMessageBytes);
        transmissionModeProperties.addChildElement("endOfMessageBytes").setTextContent((String)endOfMessageBytes);
        properties.addChildElement("remoteAddress").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("host", "127.0.0.1")));
        properties.addChildElement("remotePort").setTextContent(oldProperties.getProperty("port", "6660"));
        properties.addChildElement("overrideLocalBinding").setTextContent("false");
        properties.addChildElement("localAddress").setTextContent("0.0.0.0");
        properties.addChildElement("localPort").setTextContent("0");
        properties.addChildElement("sendTimeout").setTextContent(oldProperties.getProperty("sendTimeout", "5000"));
        properties.addChildElement("bufferSize").setTextContent(oldProperties.getProperty("bufferSize", "65536"));
        properties.addChildElement("keepConnectionOpen").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "keepSendSocketOpen", false));
        String ackTimeout = oldProperties.getProperty("ackTimeout", "5000");
        properties.addChildElement("responseTimeout").setTextContent(ackTimeout);
        properties.addChildElement("ignoreResponse").setTextContent(ackTimeout.equals("0") ? "true" : "false");
        properties.addChildElement("queueOnResponseTimeout").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "queueAckTimeout", true));
        properties.addChildElement("processHL7ACK").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "processHl7AckResponse", true));
        properties.addChildElement("dataTypeBinary").setTextContent("false");
        properties.addChildElement("charsetEncoding").setTextContent(oldProperties.getProperty("charsetEncoding", "DEFAULT_ENCODING"));
        properties.addChildElement("template").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("template", "${message.encodedData}")));
        return new DispatcherMigrationMetaData(oldProperties.getProperty("replyChannelId"), Boolean.parseBoolean(useQueue));
    }

    private static void migrateTCPListenerProperties(DonkeyElement properties) {
        logger.debug("Migrating TCPListenerProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.tcp.TcpReceiverProperties");
        properties.removeChildren();
        DonkeyElement listenerConnectorProperties = properties.addChildElement("listenerConnectorProperties");
        listenerConnectorProperties.addChildElement("host").setTextContent(oldProperties.getProperty("host", "0.0.0.0"));
        listenerConnectorProperties.addChildElement("port").setTextContent(oldProperties.getProperty("port", "6661"));
        ImportConverter3_0_0.buildResponseConnectorProperties(properties.addChildElement("responseConnectorProperties"), oldProperties.getProperty("responseValue", "None"));
        DonkeyElement transmissionModeProperties = properties.addChildElement("transmissionModeProperties");
        transmissionModeProperties.setAttribute("class", "com.mirth.connect.model.transmission.framemode.FrameModeProperties");
        transmissionModeProperties.addChildElement("pluginPointName").setTextContent("Basic");
        transmissionModeProperties.addChildElement("startOfMessageBytes").setTextContent("");
        transmissionModeProperties.addChildElement("endOfMessageBytes").setTextContent("");
        properties.addChildElement("serverMode").setTextContent("true");
        properties.addChildElement("reconnectInterval").setTextContent("5000");
        properties.addChildElement("receiveTimeout").setTextContent(oldProperties.getProperty("receiveTimeout", "5000"));
        properties.addChildElement("bufferSize").setTextContent(oldProperties.getProperty("bufferSize", "65536"));
        properties.addChildElement("maxConnections").setTextContent("10");
        properties.addChildElement("keepConnectionOpen").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "keepSendSocketOpen", false));
        properties.addChildElement("processBatch").setTextContent("false");
        properties.addChildElement("dataTypeBinary").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "binary", false));
        properties.addChildElement("charsetEncoding").setTextContent(oldProperties.getProperty("charsetEncoding", "DEFAULT_ENCODING"));
        properties.addChildElement("respondOnNewConnection").setTextContent(ImportConverter3_0_0.readBooleanValue(oldProperties, "ackOnNewConnection", false) ? "1" : "0");
        properties.addChildElement("responseAddress").setTextContent(oldProperties.getProperty("ackIP", ""));
        properties.addChildElement("responsePort").setTextContent(oldProperties.getProperty("ackPort", ""));
    }

    private static DispatcherMigrationMetaData migrateTCPSenderProperties(DonkeyElement properties) {
        logger.debug("Migrating TCPSenderProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.tcp.TcpDispatcherProperties");
        properties.removeChildren();
        String useQueue = ImportConverter3_0_0.readBooleanProperty(oldProperties, "usePersistentQueues");
        ImportConverter3_0_0.buildQueueConnectorProperties(properties.addChildElement("queueConnectorProperties"), useQueue, ImportConverter3_0_0.readBooleanProperty(oldProperties, "rotateQueue"), oldProperties.getProperty("reconnectMillisecs"), oldProperties.getProperty("maxRetryCount"));
        DonkeyElement transmissionModeProperties = properties.addChildElement("transmissionModeProperties");
        transmissionModeProperties.setAttribute("class", "com.mirth.connect.model.transmission.framemode.FrameModeProperties");
        transmissionModeProperties.addChildElement("pluginPointName").setTextContent("Basic");
        transmissionModeProperties.addChildElement("startOfMessageBytes").setTextContent("");
        transmissionModeProperties.addChildElement("endOfMessageBytes").setTextContent("");
        properties.addChildElement("remoteAddress").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("host", "127.0.0.1")));
        properties.addChildElement("remotePort").setTextContent(oldProperties.getProperty("port", "6660"));
        properties.addChildElement("overrideLocalBinding").setTextContent("false");
        properties.addChildElement("localAddress").setTextContent("0.0.0.0");
        properties.addChildElement("localPort").setTextContent("0");
        properties.addChildElement("sendTimeout").setTextContent(oldProperties.getProperty("sendTimeout", "5000"));
        properties.addChildElement("bufferSize").setTextContent(oldProperties.getProperty("bufferSize", "65536"));
        properties.addChildElement("keepConnectionOpen").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "keepSendSocketOpen", false));
        String ackTimeout = oldProperties.getProperty("ackTimeout", "5000");
        properties.addChildElement("responseTimeout").setTextContent(ackTimeout);
        properties.addChildElement("ignoreResponse").setTextContent(ackTimeout.equals("0") ? "true" : "false");
        properties.addChildElement("queueOnResponseTimeout").setTextContent("true");
        properties.addChildElement("processHL7ACK").setTextContent("false");
        properties.addChildElement("dataTypeBinary").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "binary", false));
        properties.addChildElement("charsetEncoding").setTextContent(oldProperties.getProperty("charsetEncoding", "DEFAULT_ENCODING"));
        properties.addChildElement("template").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("template", "${message.encodedData}")));
        return new DispatcherMigrationMetaData(oldProperties.getProperty("replyChannelId"), Boolean.parseBoolean(useQueue));
    }

    private static void migrateWebServiceListenerProperties(DonkeyElement properties) {
        logger.debug("Migrating WebServiceListenerProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.ws.WebServiceReceiverProperties");
        properties.removeChildren();
        DonkeyElement listenerConnectorProperties = properties.addChildElement("listenerConnectorProperties");
        listenerConnectorProperties.addChildElement("host").setTextContent(oldProperties.getProperty("host", "0.0.0.0"));
        listenerConnectorProperties.addChildElement("port").setTextContent(oldProperties.getProperty("port", "8081"));
        ImportConverter3_0_0.buildResponseConnectorProperties(properties.addChildElement("responseConnectorProperties"), oldProperties.getProperty("receiverResponseValue", "None"));
        properties.addChildElement("className").setTextContent(oldProperties.getProperty("receiverClassName", "com.mirth.connect.connectors.ws.DefaultAcceptMessage"));
        properties.addChildElement("serviceName").setTextContent(oldProperties.getProperty("receiverServiceName", "Mirth"));
        ImportConverter3_0_0.convertList(properties.addChildElement("usernames"), oldProperties.getProperty("receiverUsernames", ""));
        ImportConverter3_0_0.convertList(properties.addChildElement("passwords"), oldProperties.getProperty("receiverPasswords", ""));
    }

    private static DispatcherMigrationMetaData migrateWebServiceSenderProperties(DonkeyElement properties) {
        logger.debug("Migrating WebServiceSenderProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.connectors.ws.WebServiceDispatcherProperties");
        properties.removeChildren();
        String useQueue = ImportConverter3_0_0.readBooleanProperty(oldProperties, "usePersistentQueues");
        ImportConverter3_0_0.buildQueueConnectorProperties(properties.addChildElement("queueConnectorProperties"), useQueue, ImportConverter3_0_0.readBooleanProperty(oldProperties, "rotateQueue"), oldProperties.getProperty("reconnectMillisecs"), null);
        properties.addChildElement("wsdlUrl").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherWsdlUrl", "")));
        properties.addChildElement("service").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherService", "")));
        properties.addChildElement("port").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherPort", "")));
        properties.addChildElement("operation").setTextContent(oldProperties.getProperty("dispatcherOperation", "Press Get Operations"));
        properties.addChildElement("useAuthentication").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "dispatcherUseAuthentication", false));
        properties.addChildElement("username").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherUsername", "")));
        properties.addChildElement("password").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherPassword", "")));
        properties.addChildElement("envelope").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherEnvelope", "")));
        properties.addChildElement("oneWay").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "dispatcherOneWay", false));
        properties.addChildElement("useMtom").setTextContent(ImportConverter3_0_0.readBooleanProperty(oldProperties, "dispatcherUseMtom", false));
        ImportConverter3_0_0.convertList(properties.addChildElement("attachmentNames"), ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherAttachmentNames", "")));
        ImportConverter3_0_0.convertList(properties.addChildElement("attachmentContents"), ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherAttachmentContents", "")));
        ImportConverter3_0_0.convertList(properties.addChildElement("attachmentTypes"), ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherAttachmentTypes", "")));
        properties.addChildElement("soapAction").setTextContent(ImportConverter3_0_0.convertReferences(oldProperties.getProperty("dispatcherSoapAction", "")));
        properties.addChildElement("wsdlCacheId").setTextContent("");
        ImportConverter3_0_0.convertList(properties.addChildElement("wsdlOperations"), oldProperties.getProperty("dispatcherWsdlOperations", "<list><string>Press Get Operations</string></list>"));
        return new DispatcherMigrationMetaData(oldProperties.getProperty("dispatcherReplyChannelId"), Boolean.parseBoolean(useQueue));
    }

    private static void migrateDelimitedProperties(DonkeyElement properties) {
        logger.debug("Migrating DelimitedDataTypeProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.plugins.datatypes.delimited.DelimitedDataTypeProperties");
        properties.removeChildren();
        DonkeyElement serializationProperties = properties.addChildElement("serializationProperties");
        serializationProperties.setAttribute("class", "com.mirth.connect.plugins.datatypes.delimited.DelimitedSerializationProperties");
        serializationProperties.addChildElement("columnDelimiter").setTextContent(ImportConverter3_0_0.getNonEmptyProperty(oldProperties, "columnDelimiter", ","));
        serializationProperties.addChildElement("recordDelimiter").setTextContent(ImportConverter3_0_0.escapeString(ImportConverter3_0_0.getNonEmptyProperty(oldProperties, "recordDelimiter", "\n")));
        String columnWidths = oldProperties.getProperty("columnWidths");
        if (StringUtils.isNotBlank((CharSequence)columnWidths)) {
            serializationProperties.addChildElement("columnWidths");
            for (String width : columnWidths.split(",")) {
                serializationProperties.getChildElement("columnWidths").addChildElement("int").setTextContent(String.valueOf(NumberUtils.toInt((String)width, (int)0)));
            }
        }
        serializationProperties.addChildElement("quoteChar").setTextContent(ImportConverter3_0_0.getNonEmptyProperty(oldProperties, "quoteChar", "\""));
        serializationProperties.addChildElement("escapeWithDoubleQuote").setTextContent(oldProperties.getProperty("escapeWithDoubleQuote", "true"));
        serializationProperties.addChildElement("quoteEscapeChar").setTextContent(ImportConverter3_0_0.getNonEmptyProperty(oldProperties, "quoteEscapeChar", "\\"));
        String columnNames = oldProperties.getProperty("columnNames");
        if (StringUtils.isNotBlank((CharSequence)columnNames)) {
            serializationProperties.addChildElement("columnNames");
            for (String name : columnNames.split(",")) {
                serializationProperties.getChildElement("columnNames").addChildElement("string").setTextContent(name);
            }
        }
        serializationProperties.addChildElement("numberedRows").setTextContent(oldProperties.getProperty("numberedRows", "false"));
        serializationProperties.addChildElement("ignoreCR").setTextContent(oldProperties.getProperty("ignoreCR", "true"));
        DonkeyElement deserializationProperties = properties.addChildElement("deserializationProperties");
        deserializationProperties.setAttribute("class", "com.mirth.connect.plugins.datatypes.delimited.DelimitedDeserializationProperties");
        deserializationProperties.addChildElement("columnDelimiter").setTextContent(ImportConverter3_0_0.getNonEmptyProperty(oldProperties, "columnDelimiter", ","));
        deserializationProperties.addChildElement("recordDelimiter").setTextContent(ImportConverter3_0_0.escapeString(ImportConverter3_0_0.getNonEmptyProperty(oldProperties, "recordDelimiter", "\n")));
        if (StringUtils.isNotBlank((CharSequence)columnWidths)) {
            deserializationProperties.addChildElement("columnWidths");
            for (String width : columnWidths.split(",")) {
                deserializationProperties.getChildElement("columnWidths").addChildElement("int").setTextContent(String.valueOf(NumberUtils.toInt((String)width, (int)0)));
            }
        }
        deserializationProperties.addChildElement("quoteChar").setTextContent(ImportConverter3_0_0.getNonEmptyProperty(oldProperties, "quoteChar", "\""));
        deserializationProperties.addChildElement("escapeWithDoubleQuote").setTextContent(oldProperties.getProperty("escapeWithDoubleQuote", "true"));
        deserializationProperties.addChildElement("quoteEscapeChar").setTextContent(ImportConverter3_0_0.getNonEmptyProperty(oldProperties, "quoteEscapeChar", "\\"));
        DonkeyElement batchProperties = properties.addChildElement("batchProperties");
        batchProperties.setAttribute("class", "com.mirth.connect.plugins.datatypes.delimited.DelimitedBatchProperties");
        String batchSkipRecords = ImportConverter3_0_0.getNonEmptyProperty(oldProperties, "batchSkipRecords", "0");
        try {
            Integer.parseInt(batchSkipRecords);
        }
        catch (NumberFormatException e) {
            batchSkipRecords = "0";
        }
        batchProperties.addChildElement("batchSkipRecords", batchSkipRecords);
        batchProperties.addChildElement("batchSplitByRecord").setTextContent(oldProperties.getProperty("batchSplitByRecord", "true"));
        batchProperties.addChildElement("batchMessageDelimiter").setTextContent(oldProperties.getProperty("batchMessageDelimiter", ""));
        batchProperties.addChildElement("batchMessageDelimiterIncluded").setTextContent(oldProperties.getProperty("batchMessageDelimiterIncluded", "false"));
        batchProperties.addChildElement("batchGroupingColumn").setTextContent(oldProperties.getProperty("batchGroupingColumn", ""));
        batchProperties.addChildElement("batchScript").setTextContent(oldProperties.getProperty("batchScript", ""));
    }

    private static String escapeString(String str) {
        return str.replace("\b", "\\b").replace("\t", "\\t").replace("\n", "\\n").replace("\f", "\\f").replace("\r", "\\r");
    }

    private static void migrateDICOMProperties(DonkeyElement properties) {
        logger.debug("Migrating DICOMDataTypeProperties");
        properties.setAttribute("class", "com.mirth.connect.plugins.datatypes.dicom.DICOMDataTypeProperties");
        properties.removeChildren();
    }

    private static void migrateEDIProperties(DonkeyElement properties) {
        logger.debug("Migrating EDIDataTypeProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.plugins.datatypes.edi.EDIDataTypeProperties");
        properties.removeChildren();
        DonkeyElement serializationProperties = properties.addChildElement("serializationProperties");
        serializationProperties.setAttribute("class", "com.mirth.connect.plugins.datatypes.edi.EDISerializationProperties");
        serializationProperties.addChildElement("segmentDelimiter").setTextContent(oldProperties.getProperty("segmentDelimiter", "~"));
        serializationProperties.addChildElement("elementDelimiter").setTextContent(oldProperties.getProperty("elementDelimiter", "*"));
        serializationProperties.addChildElement("subelementDelimiter").setTextContent(oldProperties.getProperty("subelementDelimiter", ":"));
        serializationProperties.addChildElement("inferX12Delimiters").setTextContent("false");
    }

    private static void migrateHL7v2Properties(DonkeyElement properties) {
        logger.debug("Migrating HL7v2DataTypeProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.plugins.datatypes.hl7v2.HL7v2DataTypeProperties");
        properties.removeChildren();
        DonkeyElement serializationProperties = properties.addChildElement("serializationProperties");
        serializationProperties.setAttribute("class", "com.mirth.connect.plugins.datatypes.hl7v2.HL7v2SerializationProperties");
        serializationProperties.addChildElement("handleRepetitions").setTextContent(oldProperties.getProperty("handleRepetitions", "false"));
        serializationProperties.addChildElement("handleSubcomponents").setTextContent(oldProperties.getProperty("handleSubcomponents", "false"));
        serializationProperties.addChildElement("useStrictParser").setTextContent(oldProperties.getProperty("useStrictParser", "false"));
        serializationProperties.addChildElement("useStrictValidation").setTextContent(oldProperties.getProperty("useStrictValidation", "false"));
        serializationProperties.addChildElement("stripNamespaces").setTextContent(oldProperties.getProperty("stripNamespaces", "true"));
        serializationProperties.addChildElement("segmentDelimiter").setTextContent("\\r");
        serializationProperties.addChildElement("convertLineBreaks").setTextContent(oldProperties.getProperty("convertLFtoCR", "true"));
        DonkeyElement deserializationProperties = properties.addChildElement("deserializationProperties");
        deserializationProperties.setAttribute("class", "com.mirth.connect.plugins.datatypes.hl7v2.HL7v2DeserializationProperties");
        deserializationProperties.addChildElement("useStrictParser").setTextContent(oldProperties.getProperty("useStrictParser", "false"));
        deserializationProperties.addChildElement("useStrictValidation").setTextContent(oldProperties.getProperty("useStrictValidation", "false"));
        deserializationProperties.addChildElement("segmentDelimiter").setTextContent("\\r");
        DonkeyElement responseGenerationProperties = properties.addChildElement("responseGenerationProperties");
        responseGenerationProperties.setAttribute("class", "com.mirth.connect.plugins.datatypes.hl7v2.HL7v2ResponseGenerationProperties");
        responseGenerationProperties.addChildElement("segmentDelimiter").setTextContent("\\r");
        responseGenerationProperties.addChildElement("successfulACKCode").setTextContent(oldProperties.getProperty("successfulACKCode", "AA"));
        responseGenerationProperties.addChildElement("successfulACKMessage").setTextContent(oldProperties.getProperty("successfulACKMessage", ""));
        responseGenerationProperties.addChildElement("errorACKCode").setTextContent(oldProperties.getProperty("errorACKCode", "AE"));
        responseGenerationProperties.addChildElement("errorACKMessage").setTextContent(oldProperties.getProperty("errorACKMessage", "An Error Occurred Processing Message."));
        responseGenerationProperties.addChildElement("rejectedACKCode").setTextContent(oldProperties.getProperty("rejectedACKCode", "AR"));
        responseGenerationProperties.addChildElement("rejectedACKMessage").setTextContent(oldProperties.getProperty("rejectedACKMessage", "Message Rejected."));
        responseGenerationProperties.addChildElement("msh15ACKAccept").setTextContent(oldProperties.getProperty("msh15ACKAccept", "false"));
        DonkeyElement responseValidationProperties = properties.addChildElement("responseValidationProperties");
        responseValidationProperties.setAttribute("class", "com.mirth.connect.plugins.datatypes.hl7v2.HL7v2ResponseValidationProperties");
        responseValidationProperties.addChildElement("successfulACKCode").setTextContent("AA,CA");
        responseValidationProperties.addChildElement("errorACKCode").setTextContent("AE,CE");
        responseValidationProperties.addChildElement("rejectedACKCode").setTextContent("AR,CR");
    }

    private static void migrateHL7v3Properties(DonkeyElement properties) {
        logger.debug("Migrating HL7v3DataTypeProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.plugins.datatypes.hl7v3.HL7V3DataTypeProperties");
        properties.removeChildren();
        DonkeyElement serializationProperties = properties.addChildElement("serializationProperties");
        serializationProperties.setAttribute("class", "com.mirth.connect.plugins.datatypes.hl7v3.HL7V3SerializationProperties");
        serializationProperties.addChildElement("stripNamespaces").setTextContent(oldProperties.getProperty("stripNamespaces", "true"));
    }

    private static void migrateNCPDPProperties(DonkeyElement properties) {
        logger.debug("Migrating NCPDPDataTypeProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.plugins.datatypes.ncpdp.NCPDPDataTypeProperties");
        properties.removeChildren();
        DonkeyElement serializationProperties = properties.addChildElement("serializationProperties");
        serializationProperties.setAttribute("class", "com.mirth.connect.plugins.datatypes.ncpdp.NCPDPSerializationProperties");
        serializationProperties.addChildElement("fieldDelimiter").setTextContent(oldProperties.getProperty("fieldDelimiter", "0x1C"));
        serializationProperties.addChildElement("groupDelimiter").setTextContent(oldProperties.getProperty("groupDelimiter", "0x1D"));
        serializationProperties.addChildElement("segmentDelimiter").setTextContent(oldProperties.getProperty("segmentDelimiter", "0x1E"));
        DonkeyElement deserializationProperties = properties.addChildElement("deserializationProperties");
        deserializationProperties.setAttribute("class", "com.mirth.connect.plugins.datatypes.ncpdp.NCPDPDeserializationProperties");
        deserializationProperties.addChildElement("fieldDelimiter").setTextContent(oldProperties.getProperty("fieldDelimiter", "0x1C"));
        deserializationProperties.addChildElement("groupDelimiter").setTextContent(oldProperties.getProperty("groupDelimiter", "0x1D"));
        deserializationProperties.addChildElement("segmentDelimiter").setTextContent(oldProperties.getProperty("segmentDelimiter", "0x1E"));
        deserializationProperties.addChildElement("useStrictValidation").setTextContent(oldProperties.getProperty("useStrictValidation", "false"));
    }

    private static void migrateX12Properties(DonkeyElement properties) {
        logger.debug("Migrating X12DataTypeProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.plugins.datatypes.edi.EDIDataTypeProperties");
        properties.removeChildren();
        DonkeyElement serializationProperties = properties.addChildElement("serializationProperties");
        serializationProperties.setAttribute("class", "com.mirth.connect.plugins.datatypes.edi.EDISerializationProperties");
        serializationProperties.addChildElement("segmentDelimiter").setTextContent(oldProperties.getProperty("segmentDelimiter", "~"));
        serializationProperties.addChildElement("elementDelimiter").setTextContent(oldProperties.getProperty("elementDelimiter", "*"));
        serializationProperties.addChildElement("subelementDelimiter").setTextContent(oldProperties.getProperty("subelementDelimiter", ":"));
        serializationProperties.addChildElement("inferX12Delimiters").setTextContent(oldProperties.getProperty("inferX12Delimiters", "true"));
    }

    private static void migrateXMLProperties(DonkeyElement properties) {
        logger.debug("Migrating XMLDataTypeProperties");
        Properties oldProperties = ImportConverter3_0_0.readPropertiesElement(properties);
        properties.setAttribute("class", "com.mirth.connect.plugins.datatypes.xml.XMLDataTypeProperties");
        properties.removeChildren();
        DonkeyElement serializationProperties = properties.addChildElement("serializationProperties");
        serializationProperties.setAttribute("class", "com.mirth.connect.plugins.datatypes.xml.XMLSerializationProperties");
        serializationProperties.addChildElement("stripNamespaces").setTextContent(oldProperties.getProperty("stripNamespaces", "true"));
    }

    public static void buildPollConnectorProperties(DonkeyElement properties, String type, String time, String freq) {
        if (type == null) {
            type = "interval";
        }
        if (freq == null) {
            freq = "5000";
        }
        String hour = "0";
        String minute = "0";
        if (time != null && !StringUtils.isBlank((CharSequence)time)) {
            try {
                Calendar timestamp = new DateParser().parse(time);
                hour = Integer.toString(timestamp.get(11));
                minute = Integer.toString(timestamp.get(12));
            }
            catch (DateParser.DateParserException dateParserException) {
                // empty catch block
            }
        }
        properties.addChildElement("pollingType").setTextContent(type);
        properties.addChildElement("pollingHour").setTextContent(hour);
        properties.addChildElement("pollingMinute").setTextContent(minute);
        properties.addChildElement("pollingFrequency").setTextContent(freq);
    }

    public static void buildListenerConnectorProperties(DonkeyElement properties, String host, String port, int defaultPort) {
        if (host == null) {
            host = "0.0.0.0";
        }
        if (port == null) {
            port = Integer.toString(defaultPort);
        }
        properties.addChildElement("host").setTextContent(host);
        properties.addChildElement("port").setTextContent(port);
    }

    public static void buildResponseConnectorProperties(DonkeyElement properties) {
        ImportConverter3_0_0.buildResponseConnectorProperties(properties, "None");
    }

    public static void buildResponseConnectorProperties(DonkeyElement properties, String responseValue) {
        properties.addChildElement("responseVariable").setTextContent(responseValue);
        DonkeyElement defaultQueueOnResponses = properties.addChildElement("defaultQueueOnResponses");
        defaultQueueOnResponses.addChildElement("string").setTextContent("None");
        defaultQueueOnResponses.addChildElement("string").setTextContent("Auto-generate (Before processing)");
        DonkeyElement defaultQueueOffResponses = properties.addChildElement("defaultQueueOffResponses");
        defaultQueueOffResponses.addChildElement("string").setTextContent("None");
        defaultQueueOffResponses.addChildElement("string").setTextContent("Auto-generate (Before processing)");
        defaultQueueOffResponses.addChildElement("string").setTextContent("Auto-generate (After source transformer)");
        defaultQueueOffResponses.addChildElement("string").setTextContent("Auto-generate (Destinations completed)");
        defaultQueueOffResponses.addChildElement("string").setTextContent("Postprocessor");
        properties.addChildElement("respondAfterProcessing").setTextContent("true");
    }

    public static void buildQueueConnectorProperties(DonkeyElement queueConnectorProperties) {
        ImportConverter3_0_0.buildQueueConnectorProperties(queueConnectorProperties, null, null, null, null);
    }

    public static void buildQueueConnectorProperties(DonkeyElement queueConnectorProperties, String queueEnabled, String rotate, String reconnectInterval, String retryCount) {
        if (queueEnabled == null) {
            queueEnabled = "false";
        }
        if (rotate == null) {
            rotate = "false";
        }
        if (reconnectInterval == null) {
            reconnectInterval = "10000";
        }
        if (retryCount == null) {
            retryCount = "0";
        }
        queueConnectorProperties.addChildElement("queueEnabled").setTextContent(queueEnabled);
        queueConnectorProperties.addChildElement("sendFirst").setTextContent("false");
        queueConnectorProperties.addChildElement("retryIntervalMillis").setTextContent(reconnectInterval);
        queueConnectorProperties.addChildElement("regenerateTemplate").setTextContent("false");
        queueConnectorProperties.addChildElement("retryCount").setTextContent(retryCount);
        queueConnectorProperties.addChildElement("rotate").setTextContent(rotate);
        queueConnectorProperties.addChildElement("threadCount").setTextContent("1");
    }

    public static Properties readPropertiesElement(DonkeyElement propertiesElement) {
        Properties properties = new Properties();
        for (DonkeyElement propertyElement : propertiesElement.getChildElements()) {
            properties.setProperty(propertyElement.getAttribute("name"), propertyElement.getTextContent());
        }
        return properties;
    }

    public static void writePropertiesElement(DonkeyElement propertiesElement, Properties properties) {
        propertiesElement.removeChildren();
        for (Object key : properties.keySet()) {
            DonkeyElement property = propertiesElement.addChildElement("property");
            property.setAttribute("name", key.toString());
            property.setTextContent(properties.getProperty(key.toString()));
        }
    }

    public static String readBooleanProperty(Properties properties, String name) {
        String value = properties.getProperty(name);
        if (value == null) {
            return null;
        }
        return ImportConverter3_0_0.readBooleanProperty(properties, name, false);
    }

    public static String readBooleanProperty(Properties properties, String name, boolean defaultValue) {
        return Boolean.toString(ImportConverter3_0_0.readBooleanValue(properties, name, defaultValue));
    }

    public static boolean readBooleanValue(Properties properties, String name, boolean defaultValue) {
        String property = properties.getProperty(name, Boolean.toString(defaultValue));
        return property.equals("1") || Boolean.parseBoolean(property);
    }

    public static String getNonEmptyProperty(Properties properties, String name, String defaultValue) {
        String property = properties.getProperty(name, defaultValue);
        return StringUtils.isNotEmpty((CharSequence)property) ? property : defaultValue;
    }

    public static void convertList(DonkeyElement properties, String list) {
        if (StringUtils.isNotEmpty((CharSequence)list)) {
            Matcher matcher = STRING_NODE_PATTERN.matcher(list);
            while (matcher.find()) {
                if (matcher.group(1) != null) {
                    properties.addChildElement("string").setTextContent(matcher.group());
                    continue;
                }
                properties.addChildElement("null");
            }
        }
    }

    public static void convertEscapedText(DonkeyElement newProperties, String list) throws DonkeyElement.DonkeyElementException {
        if (StringUtils.isNotEmpty((CharSequence)list)) {
            DonkeyElement oldProperties = new DonkeyElement(list);
            for (DonkeyElement oldProperty : oldProperties.getChildElements()) {
                newProperties.appendChild(newProperties.getOwnerDocument().importNode(oldProperty.getElement(), true));
            }
        }
    }

    public static String convertReferences(String reference) {
        reference = reference.replace("${MESSAGEATTACH}", "${message.encodedData}");
        reference = reference.replace("$!{MESSAGEATTACH}", "$!{message.encodedData}");
        reference = reference.replace("${ORIGINALNAME}", "${originalFilename}");
        reference = reference.replace("$!{ORIGINALNAME}", "$!{originalFilename}");
        return reference;
    }

    private static void dumpElement(DonkeyElement element) {
        try {
            System.out.println(element.toXml());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String convertTransportName(String transportName) {
        if (transportName.equals("JMS Reader")) {
            return "JMS Listener";
        }
        if (transportName.equals("JMS Writer")) {
            return "JMS Sender";
        }
        if (transportName.equals("LLP Listener")) {
            return "TCP Listener";
        }
        if (transportName.equals("LLP Sender")) {
            return "TCP Sender";
        }
        return transportName;
    }

    public static Set<String> getMissingDataTypes(DonkeyElement transformer, Set<String> loadedDataTypes) {
        DonkeyElement outboundDataType;
        HashSet<String> missingDataTypes = new HashSet<String>();
        DonkeyElement inboundDataType = transformer.getChildElement("inboundProtocol");
        if (inboundDataType != null) {
            String dataTypeContent = inboundDataType.getTextContent();
            if (dataTypeContent.equals("EDI") || dataTypeContent.equals("X12")) {
                dataTypeContent = "EDI/X12";
            }
            if (!loadedDataTypes.contains(dataTypeContent)) {
                missingDataTypes.add(dataTypeContent);
            }
        }
        if ((outboundDataType = transformer.getChildElement("outboundProtocol")) != null) {
            String dataTypeContent = outboundDataType.getTextContent();
            if (dataTypeContent.equals("EDI") || dataTypeContent.equals("X12")) {
                dataTypeContent = "EDI/X12";
            }
            if (!loadedDataTypes.contains(dataTypeContent)) {
                missingDataTypes.add(dataTypeContent);
            }
        }
        return missingDataTypes;
    }

    private static class ConnectorMigrationMetaData {
        public boolean isDataTypeDICOM;
        public DispatcherMigrationMetaData dispatcherMetaData;

        public ConnectorMigrationMetaData(boolean isDataTypeDICOM, DispatcherMigrationMetaData dispatcherMetaData) {
            this.isDataTypeDICOM = isDataTypeDICOM;
            this.dispatcherMetaData = dispatcherMetaData;
        }
    }

    private static class DispatcherMigrationMetaData {
        public String sendResponseToChannelId;
        public boolean isQueueEnabled;

        public DispatcherMigrationMetaData() {
            this(null, false);
        }

        public DispatcherMigrationMetaData(String sendResponseToChannelId, boolean isQueueEnabled) {
            this.sendResponseToChannelId = sendResponseToChannelId;
            this.isQueueEnabled = isQueueEnabled;
        }
    }
}

