/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.mirth.connect.util.messagewriter.EncryptionType;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import net.lingala.zip4j.io.ZipOutputStream;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArchiveUtils {
    private static final int BUFFER_SIZE = 0x100000;
    private static Logger logger = LogManager.getLogger(ArchiveUtils.class);

    public static void createArchive(File sourceFolder, File destinationFile, String archiver) throws CompressException {
        ArchiveUtils.createArchive(sourceFolder, destinationFile, archiver, null, null, null);
    }

    public static void createArchive(File sourceFolder, File destinationFile, String archiver, String compressor, String password, EncryptionType encryptionType) throws CompressException {
        if (!sourceFolder.isDirectory() || !sourceFolder.exists()) {
            throw new CompressException("Invalid source folder: " + sourceFolder.getAbsolutePath());
        }
        logger.debug("Creating archive \"" + destinationFile.getAbsolutePath() + "\" from folder \"" + sourceFolder.getAbsolutePath() + "\"");
        BufferedOutputStream outputStream = null;
        ZipOutputStream archiveOutputStream = null;
        try {
            if (archiver.equals("zip") && compressor == null) {
                archiveOutputStream = new ZipOutputStream((OutputStream)new FileOutputStream(destinationFile));
            } else {
                outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
                if (compressor != null) {
                    outputStream = new CompressorStreamFactory().createCompressorOutputStream(compressor, (OutputStream)outputStream);
                }
                archiveOutputStream = new ArchiveStreamFactory().createArchiveOutputStream(archiver, (OutputStream)outputStream);
            }
            ArchiveUtils.createFolderArchive(sourceFolder, (OutputStream)archiveOutputStream, sourceFolder.getAbsolutePath() + IOUtils.DIR_SEPARATOR, password, encryptionType);
        }
        catch (Exception e) {
            try {
                throw new CompressException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(archiveOutputStream);
                IOUtils.closeQuietly(outputStream);
                logger.debug("Finished creating archive \"" + destinationFile.getAbsolutePath() + "\"");
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)archiveOutputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        logger.debug("Finished creating archive \"" + destinationFile.getAbsolutePath() + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFolderArchive(File folder, OutputStream outputStream, String rootFolder, String password, EncryptionType encryptionType) throws CompressException {
        byte[] buffer = new byte[0x100000];
        ZipOutputStream zipOutputStream = null;
        try {
            for (File file : folder.listFiles()) {
                if (file.isDirectory()) {
                    ArchiveUtils.createFolderArchive(file, outputStream, rootFolder, password, encryptionType);
                    continue;
                }
                try {
                    String entryName = file.getAbsolutePath();
                    if (entryName.substring(0, rootFolder.length()).equals(rootFolder)) {
                        entryName = entryName.substring(rootFolder.length());
                    }
                    ArchiveOutputStream archiveOutputStream = null;
                    FileInputStream inputStream = new FileInputStream(file);
                    try {
                        logger.debug("Adding \"" + entryName + "\" to archive");
                        if (outputStream instanceof ArchiveOutputStream) {
                            archiveOutputStream = (ArchiveOutputStream)outputStream;
                            archiveOutputStream.putArchiveEntry(archiveOutputStream.createArchiveEntry(file, entryName));
                        } else if (outputStream instanceof ZipOutputStream) {
                            zipOutputStream = (ZipOutputStream)outputStream;
                            ZipParameters parameters = new ZipParameters();
                            parameters.setSourceExternalStream(true);
                            parameters.setFileNameInZip(entryName);
                            parameters.setCompressionMethod(8);
                            parameters.setCompressionLevel(5);
                            if (StringUtils.isNotBlank((CharSequence)password)) {
                                parameters.setEncryptFiles(true);
                                boolean isAes = encryptionType != EncryptionType.STANDARD;
                                parameters.setEncryptionMethod(isAes ? 99 : 0);
                                if (isAes) {
                                    parameters.setAesKeyStrength(encryptionType.getKeyStrength());
                                }
                                parameters.setPassword(password);
                            }
                            zipOutputStream.putNextEntry(null, parameters);
                        }
                        IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream, (byte[])buffer);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                        if (outputStream instanceof ArchiveOutputStream) {
                            archiveOutputStream.closeArchiveEntry();
                        } else if (outputStream instanceof ZipOutputStream) {
                            zipOutputStream.closeEntry();
                        }
                    }
                }
                catch (Exception e) {
                    throw new CompressException(e);
                }
            }
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.finish();
                }
                catch (Exception e) {
                    throw new CompressException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URL> extractArchive(File targetDir, ZipInputStream source) throws IOException, ZipException {
        ZipEntry zipEntry;
        ArrayList<URL> fileUrls = new ArrayList<URL>();
        while ((zipEntry = source.getNextEntry()) != null) {
            File file = new File(targetDir, zipEntry.getName());
            if (!file.getCanonicalPath().startsWith(targetDir.getCanonicalPath() + File.separator)) {
                throw new ZipException("Zip file is attempting to traverse out of base directory");
            }
            fileUrls.add(file.toURI().toURL());
            if (zipEntry.isDirectory()) {
                if (!file.mkdir()) {
                    throw new IOException("Unable to create directory: " + file.toString());
                }
                source.closeEntry();
                continue;
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                IOUtils.copy((InputStream)source, (OutputStream)outputStream);
                source.closeEntry();
            }
        }
        return fileUrls;
    }

    public static class CompressException
    extends Exception {
        public CompressException(String message) {
            super(message);
        }

        public CompressException(Throwable cause) {
            super(cause);
        }
    }
}

