/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json;

import de.odysseus.staxon.base.AbstractXMLInputFactory;
import de.odysseus.staxon.event.SimpleXMLEventReader;
import de.odysseus.staxon.event.SimpleXMLFilteredEventReader;
import de.odysseus.staxon.json.JsonXMLConfig;
import de.odysseus.staxon.json.JsonXMLStreamReader;
import de.odysseus.staxon.json.stream.JsonStreamFactory;
import de.odysseus.staxon.json.stream.JsonStreamSource;
import de.odysseus.staxon.json.stream.util.AddRootSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class JsonXMLInputFactory
extends AbstractXMLInputFactory {
    public static final String PROP_MULTIPLE_PI = "JsonXMLInputFactory.multiplePI";
    public static final String PROP_VIRTUAL_ROOT = "JsonXMLInputFactory.virtualRoot";
    public static final String PROP_NAMESPACE_SEPARATOR = "JsonXMLInputFactory.namespaceSeparator";
    public static final String PROP_NAMESPACE_MAPPINGS = "JsonXMLInputFactory.namespaceMappings";
    protected final JsonStreamFactory streamFactory;
    protected boolean multiplePI;
    private QName virtualRoot;
    protected char namespaceSeparator;
    protected Map<String, String> namespaceMappings;

    public JsonXMLInputFactory() throws FactoryConfigurationError {
        this(JsonXMLConfig.DEFAULT);
    }

    public JsonXMLInputFactory(JsonStreamFactory streamFactory) {
        this(JsonXMLConfig.DEFAULT, streamFactory);
    }

    public JsonXMLInputFactory(JsonXMLConfig config) throws FactoryConfigurationError {
        this(config, JsonStreamFactory.newFactory());
    }

    public JsonXMLInputFactory(JsonXMLConfig config, JsonStreamFactory streamFactory) {
        this.multiplePI = config.isMultiplePI();
        this.virtualRoot = config.getVirtualRoot();
        this.namespaceSeparator = config.getNamespaceSeparator();
        this.namespaceMappings = config.getNamespaceMappings();
        this.streamFactory = streamFactory;
        super.setProperty("javax.xml.stream.isCoalescing", (Object)Boolean.TRUE);
        super.setProperty("javax.xml.stream.isNamespaceAware", (Object)Boolean.TRUE);
        super.setProperty("javax.xml.stream.isReplacingEntityReferences", (Object)Boolean.TRUE);
        super.setProperty("javax.xml.stream.isSupportingExternalEntities", (Object)Boolean.FALSE);
        super.setProperty("javax.xml.stream.isValidating", (Object)Boolean.FALSE);
        super.setProperty("javax.xml.stream.supportDTD", (Object)Boolean.FALSE);
    }

    protected JsonStreamSource decorate(JsonStreamSource source) {
        if (this.virtualRoot != null) {
            source = new AddRootSource(source, this.virtualRoot, this.namespaceSeparator);
        }
        return source;
    }

    public JsonXMLStreamReader createXMLStreamReader(InputStream stream, String encoding) throws XMLStreamException {
        try {
            return this.createXMLStreamReader(new InputStreamReader(stream, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException(e);
        }
    }

    public JsonXMLStreamReader createXMLStreamReader(String systemId, InputStream stream) throws XMLStreamException {
        return this.createXMLStreamReader(stream);
    }

    public JsonXMLStreamReader createXMLStreamReader(String systemId, Reader reader) throws XMLStreamException {
        return this.createXMLStreamReader(reader);
    }

    public JsonXMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        try {
            return new JsonXMLStreamReader(this.decorate(this.streamFactory.createJsonStreamSource(reader)), this.multiplePI, this.namespaceSeparator, this.namespaceMappings);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public JsonXMLStreamReader createXMLStreamReader(InputStream stream) throws XMLStreamException {
        try {
            return new JsonXMLStreamReader(this.decorate(this.streamFactory.createJsonStreamSource(stream)), this.multiplePI, this.namespaceSeparator, this.namespaceMappings);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public XMLEventReader createXMLEventReader(XMLStreamReader reader) throws XMLStreamException {
        if (this.getEventAllocator() == null) {
            return new SimpleXMLEventReader(reader);
        }
        return new SimpleXMLEventReader(reader, this.getEventAllocator().newInstance());
    }

    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) throws XMLStreamException {
        return new SimpleXMLFilteredEventReader(reader, filter);
    }

    public void setXMLResolver(XMLResolver resolver) {
        throw new UnsupportedOperationException();
    }

    public void setXMLReporter(XMLReporter reporter) {
        throw new UnsupportedOperationException();
    }

    public boolean isPropertySupported(String name) {
        return super.isPropertySupported(name) || Arrays.asList(PROP_MULTIPLE_PI, PROP_VIRTUAL_ROOT, PROP_NAMESPACE_SEPARATOR, PROP_NAMESPACE_MAPPINGS).contains(name);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (super.isPropertySupported(name)) {
            return super.getProperty(name);
        }
        if (PROP_MULTIPLE_PI.equals(name)) {
            return this.multiplePI;
        }
        if (PROP_VIRTUAL_ROOT.equals(name)) {
            return this.virtualRoot;
        }
        if (PROP_NAMESPACE_SEPARATOR.equals(name)) {
            return Character.valueOf(this.namespaceSeparator);
        }
        if (PROP_NAMESPACE_MAPPINGS.equals(name)) {
            return this.namespaceMappings;
        }
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if ("javax.xml.stream.isNamespaceAware".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if ("javax.xml.stream.isReplacingEntityReferences".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if ("javax.xml.stream.isSupportingExternalEntities".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if ("javax.xml.stream.isValidating".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if ("javax.xml.stream.supportDTD".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if (super.isPropertySupported(name)) {
            super.setProperty(name, value);
        } else if (PROP_MULTIPLE_PI.equals(name)) {
            this.multiplePI = (Boolean)value;
        } else if (PROP_VIRTUAL_ROOT.equals(name)) {
            this.virtualRoot = value instanceof String ? QName.valueOf((String)value) : (QName)value;
        } else if (PROP_NAMESPACE_SEPARATOR.equals(name)) {
            this.namespaceSeparator = ((Character)value).charValue();
        } else if (PROP_NAMESPACE_MAPPINGS.equals(name)) {
            Map map;
            this.namespaceMappings = map = (Map)value;
        } else {
            throw new IllegalArgumentException("Unsupported property: " + name);
        }
    }
}

