/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.util;

import de.odysseus.staxon.json.stream.JsonStreamTarget;
import de.odysseus.staxon.json.stream.JsonStreamToken;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class MirthArrayTarget
implements JsonStreamTarget {
    protected static final Event START_OBJECT = new Event(){

        @Override
        public void write(JsonStreamTarget target) throws IOException {
            target.startObject();
        }

        @Override
        public JsonStreamToken token() {
            return JsonStreamToken.START_OBJECT;
        }

        public String toString() {
            return this.token().name();
        }
    };
    protected static final Event END_OBJECT = new Event(){

        @Override
        public void write(JsonStreamTarget target) throws IOException {
            target.endObject();
        }

        @Override
        public JsonStreamToken token() {
            return JsonStreamToken.END_OBJECT;
        }

        public String toString() {
            return this.token().name();
        }
    };
    protected static final Event END_ARRAY = new Event(){

        @Override
        public void write(JsonStreamTarget target) throws IOException {
            target.endArray();
        }

        @Override
        public JsonStreamToken token() {
            return JsonStreamToken.END_ARRAY;
        }

        public String toString() {
            return this.token().name();
        }
    };
    protected final JsonStreamTarget delegate;
    private final Stack<Map<String, List<Object>>> levelEventStack = new Stack();
    private final Stack<Integer> nameEventCounts = new Stack();
    protected final Stack<NameEvent> fields = new Stack();
    private boolean alwaysArray = false;

    public MirthArrayTarget(JsonStreamTarget delegate) {
        this(delegate, false);
    }

    public MirthArrayTarget(JsonStreamTarget delegate, boolean alwaysArray) {
        this.delegate = delegate;
        this.alwaysArray = alwaysArray;
    }

    public void name(String name) throws IOException {
        Map<String, List<Object>> levelEventMap = this.levelEventStack.peek();
        if (levelEventMap != null) {
            List<Object> levelObjects = levelEventMap.get(name);
            if (levelObjects == null) {
                levelObjects = new LinkedList<Object>();
                levelEventMap.put(name, levelObjects);
            }
            this.fields.push(new NameEvent(name));
        }
        this.nameEventCounts.push(this.nameEventCounts.pop() + 1);
    }

    private boolean isSpecialField(String name) {
        return StringUtils.equals((CharSequence)name, (CharSequence)"@xmlns") || StringUtils.equals((CharSequence)name, (CharSequence)"@xmlnsprefix") || StringUtils.startsWith((CharSequence)name, (CharSequence)"@xmlns:") || StringUtils.equals((CharSequence)name, (CharSequence)"$");
    }

    public void value(Object value) throws IOException {
        NameEvent nameEvent = this.fields.peek();
        Map<String, List<Object>> levelEventMap = this.levelEventStack.peek();
        if (levelEventMap != null) {
            List<Object> levelEvents = levelEventMap.get(nameEvent.name);
            if (levelEvents == null) {
                levelEvents = new LinkedList<Object>();
                levelEventMap.put(nameEvent.name, levelEvents);
            }
            levelEvents.add(new ValueEvent(value));
        }
    }

    public void startObject() throws IOException {
        this.levelEventStack.push(new LinkedHashMap());
        this.nameEventCounts.push(0);
    }

    public void endObject() throws IOException {
        Integer nameEvents = this.nameEventCounts.pop();
        for (int i = 0; i < nameEvents; ++i) {
            this.fields.pop();
        }
        if (this.fields.isEmpty()) {
            Deque<Event> events = this.generateEventList(this.levelEventStack.peek(), true);
            while (!events.isEmpty()) {
                events.pollFirst().write(this.delegate);
            }
        } else {
            NameEvent currentName = this.fields.peek();
            Map<String, List<Object>> levelEventMap = this.levelEventStack.pop();
            Map<String, List<Object>> currentLevelEventMap = this.levelEventStack.peek();
            currentLevelEventMap.get(currentName.name).add(levelEventMap);
        }
    }

    private Deque<Event> generateEventList(Map<String, List<Object>> levelEventMap, boolean root) {
        LinkedList<Event> eventList = new LinkedList<Event>();
        eventList.add(START_OBJECT);
        for (Map.Entry<String, List<Object>> element : levelEventMap.entrySet()) {
            NameEvent event = new NameEvent(element.getKey());
            if (this.alwaysArray) {
                if (!root && !this.isSpecialField(event.name)) {
                    event.setArray(true);
                }
            } else if (element.getValue().size() > 1) {
                event.setArray(true);
            }
            eventList.add(event);
            for (Object obj : element.getValue()) {
                if (obj instanceof Map) {
                    eventList.addAll(this.generateEventList((Map)obj, false));
                    continue;
                }
                eventList.add((Event)obj);
            }
            if (!event.isArray()) continue;
            eventList.add(END_ARRAY);
        }
        eventList.add(END_OBJECT);
        return eventList;
    }

    public void startArray() throws IOException {
    }

    public void endArray() throws IOException {
    }

    public void close() throws IOException {
        Deque<Event> events = this.generateEventList(this.levelEventStack.peek(), true);
        while (!events.isEmpty()) {
            events.pollFirst().write(this.delegate);
        }
        this.delegate.close();
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    protected static final class NameEvent
    implements Event {
        final String name;
        boolean array;

        public NameEvent(String name) {
            this.name = name;
        }

        @Override
        public void write(JsonStreamTarget target) throws IOException {
            target.name(this.name);
            if (this.array) {
                target.startArray();
            }
        }

        @Override
        public JsonStreamToken token() {
            return JsonStreamToken.NAME;
        }

        public String name() {
            return this.name;
        }

        public boolean isArray() {
            return this.array;
        }

        public void setArray(boolean array) {
            this.array = array;
        }

        public String toString() {
            if (this.array) {
                return this.token().name() + " = " + this.name + " " + String.valueOf(JsonStreamToken.START_ARRAY);
            }
            return this.token().name() + " = " + this.name;
        }
    }

    protected static final class ValueEvent
    implements Event {
        final Object value;

        ValueEvent(Object value) {
            this.value = value;
        }

        @Override
        public void write(JsonStreamTarget target) throws IOException {
            target.value(this.value);
        }

        @Override
        public JsonStreamToken token() {
            return JsonStreamToken.VALUE;
        }

        public String toString() {
            return this.token().name() + " = " + String.valueOf(this.value);
        }
    }

    protected static interface Event {
        public JsonStreamToken token();

        public void write(JsonStreamTarget var1) throws IOException;
    }
}

