/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.client.control;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthDatePicker;
import com.mirth.connect.client.ui.components.MirthTimePicker;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.text.DateFormatter;
import net.miginfocom.swing.MigLayout;

public class JumpToTimeDialog
extends MirthDialog {
    private final Frame parent;
    private MirthDatePicker datePicker;
    private MirthTimePicker timePicker;
    private JButton okButton;
    private JButton cancelButton;
    private Long selectedEndMillis = null;

    public JumpToTimeDialog(Frame frame) {
        super((Window)frame, true);
        this.parent = frame;
        this.initComponents();
        this.initLayout();
        this.setDefaultCloseOperation(2);
        this.setTitle("Jump to time");
        this.pack();
        this.setLocationRelativeTo((Component)frame);
        this.setVisible(true);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.datePicker = new MirthDatePicker();
        this.timePicker = new MirthTimePicker();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(actionEvent -> this.save());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(actionEvent -> this.close());
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 0 10 10 10, novisualpadding, hidemode 0, align center, fill", "5[right][fill][80]"));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        jPanel.setMinimumSize(this.getMinimumSize());
        jPanel.setMaximumSize(this.getMaximumSize());
        jPanel.add((Component)new JLabel("Date/Time:"), "right");
        jPanel.add((Component)this.datePicker, "w 150!");
        jPanel.add((Component)this.timePicker, "w 80!, gapleft 8, wrap");
        this.add(jPanel, "growx");
        this.add(new JSeparator(), "newline, sx, growx");
        this.add(this.okButton, "newline, sx, right, split 2");
        this.add(this.cancelButton);
    }

    private void save() {
        if (!this.validateTime()) {
            return;
        }
        try {
            Calendar calendar = this.buildDateTimeCalendar();
            this.selectedEndMillis = calendar.getTimeInMillis();
        }
        catch (Exception exception) {
            this.selectedEndMillis = null;
            this.showError("Invalid date/time. Error: " + exception.getMessage());
            return;
        }
        this.close();
    }

    private void close() {
        this.dispose();
    }

    private boolean validateTime() {
        try {
            Calendar calendar = this.buildDateTimeCalendar();
            long l = calendar.getTimeInMillis();
            long l2 = System.currentTimeMillis();
            if (l > l2) {
                this.showError("Selected time cannot be in the future.");
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            this.showError("Invalid date/time. Error: " + exception.getMessage());
            return false;
        }
    }

    private Calendar buildDateTimeCalendar() throws ParseException {
        Date date = this.datePicker.getDate();
        String string = this.timePicker.getDate();
        if (date == null) {
            throw new ParseException("Date is required", 0);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (this.timePicker.isEnabled()) {
            if (string == null || string.trim().isEmpty()) {
                throw new ParseException("Time is required", 0);
            }
            DateFormatter dateFormatter = new DateFormatter(new SimpleDateFormat("hh:mm aa"));
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime((Date)dateFormatter.stringToValue(string));
            calendar.set(11, calendar2.get(11));
            calendar.set(12, calendar2.get(12));
            calendar.set(13, calendar2.get(13));
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        }
        calendar.set(14, 0);
        return calendar;
    }

    private void showError(String string) {
        PlatformUI.MIRTH_FRAME.alertError((Component)((Object)this), string);
    }

    public Long getSelectedEndMillis() {
        return this.selectedEndMillis;
    }

    public static Long showDialog(Frame frame) {
        JumpToTimeDialog jumpToTimeDialog = new JumpToTimeDialog(frame);
        return jumpToTimeDialog.getSelectedEndMillis();
    }
}

