/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.client.summary;

import com.mirth.connect.plugins.messagetrends.client.panel.MessageTrendsDashboardPanel;
import com.mirth.connect.plugins.messagetrends.client.summary.SummaryView;
import com.mirth.connect.plugins.messagetrends.client.util.RangeTextFormatter;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class SummaryAllView
extends JPanel
implements SummaryView {
    private final JLabel totalReceivedLabel = new JLabel("Total Received: 0");
    private final JLabel totalSentLabel = new JLabel("Total Sent: 0");
    private final JLabel totalFilteredLabel = new JLabel("Total Filtered: 0");
    private final JLabel totalQueuedLabel = new JLabel("Last Queued: 0");
    private final JLabel totalErrorLabel = new JLabel("Total Errors: 0");
    private final JLabel blankLabel = new JLabel("");
    private final TitledBorder border = new TitledBorder("All Statistics Summary");
    private MessageTrendsDashboardPanel.View view;
    protected Long winStartMs;
    protected Long winEndMs;

    public SummaryAllView() {
        this.setBorder(this.border);
        this.setLayout(new GridLayout(2, 3, 10, 6));
        this.add(this.totalReceivedLabel);
        this.add(this.totalSentLabel);
        this.add(this.totalFilteredLabel);
        this.add(this.totalQueuedLabel);
        this.add(this.totalErrorLabel);
        this.add(this.blankLabel);
    }

    private void setTotals(long l, long l2, long l3, long l4, long l5) {
        this.totalReceivedLabel.setText("Total Received: " + SummaryAllView.format(l));
        this.totalSentLabel.setText("Total Sent: " + SummaryAllView.format(l2));
        this.totalFilteredLabel.setText("Total Filtered: " + SummaryAllView.format(l3));
        this.totalQueuedLabel.setText("Last Queued: " + SummaryAllView.format(l4));
        this.totalErrorLabel.setText("Total Errors: " + SummaryAllView.format(l5));
    }

    private void updateTitle(String string) {
        Object object = string;
        String string2 = RangeTextFormatter.formatRange(this.winStartMs, this.winEndMs);
        if (string2 != null && !string2.isEmpty()) {
            object = (String)object + " \u2014 " + string2;
        }
        this.border.setTitle((String)object);
        this.repaint();
    }

    private void setBlankSlotText(String string) {
        this.blankLabel.setText(string == null ? "" : string);
    }

    @Override
    public void reset() {
        this.setTotals(0L, 0L, 0L, 0L, 0L);
        this.setBlankSlotText("");
    }

    @Override
    public final JComponent getComponent() {
        return this;
    }

    @Override
    public void setView(MessageTrendsDashboardPanel.View view) {
        this.view = view;
    }

    @Override
    public void setWindowRange(long l, long l2) {
        this.winStartMs = l;
        this.winEndMs = l2;
    }

    @Override
    public void setData(List<MessageStatisticsTimeseries> list) {
        MessageTrendsDashboardPanel.View view = this.view;
        if (view == null || view != MessageTrendsDashboardPanel.View.ALL) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (MessageStatisticsTimeseries messageStatisticsTimeseries : list) {
            l += (long)messageStatisticsTimeseries.getReceived().intValue();
            l2 += (long)messageStatisticsTimeseries.getSent().intValue();
            l3 += (long)messageStatisticsTimeseries.getFiltered().intValue();
            l4 += (long)messageStatisticsTimeseries.getError().intValue();
        }
        long l5 = list.isEmpty() ? 0L : (long)list.get(list.size() - 1).getQueued().intValue();
        this.setTotals(l, l2, l3, l5, l4);
        this.updateTitle("All Statistics Summary");
    }

    @Override
    public void setSeriesColors(Color color, Color color2, Color color3, Color color4, Color color5) {
        if (color != null) {
            this.totalReceivedLabel.setForeground(color);
        }
        if (color2 != null) {
            this.totalSentLabel.setForeground(color2);
        }
        if (color3 != null) {
            this.totalFilteredLabel.setForeground(color3);
        }
        if (color4 != null) {
            this.totalQueuedLabel.setForeground(color4);
        }
        if (color5 != null) {
            this.totalErrorLabel.setForeground(color5);
        }
    }

    private static String format(long l) {
        return String.format(Locale.US, "%,d", l);
    }
}

