/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.connectors.file.AdvancedSettingsDialog;
import com.mirth.connect.connectors.file.SchemeProperties;
import com.mirth.connect.connectors.file.SmbDialectVersion;
import com.mirth.connect.connectors.file.SmbSchemeProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class AdvancedSmbSettingsDialog
extends AdvancedSettingsDialog {
    private boolean saved;
    private SmbSchemeProperties schemeProperties;
    private JLabel smbMinVersionLabel;
    private MirthComboBox<SmbDialectVersion> smbMinVersionComboBox;
    private JLabel smbMaxVersionLabel;
    private MirthComboBox<SmbDialectVersion> smbMaxVersionComboBox;
    private JButton okButton;
    private JButton cancelButton;

    public AdvancedSmbSettingsDialog(SmbSchemeProperties schemeProperties) {
        this.setTitle("SMB Settings");
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(250, 170));
        DisplayUtil.setResizable((Dialog)((Object)this), (boolean)false);
        this.setLayout((LayoutManager)new MigLayout("insets 8 8 0 8, novisualpadding, hidemode 3"));
        this.getContentPane().setBackground(UIConstants.BACKGROUND_COLOR);
        this.schemeProperties = schemeProperties != null ? schemeProperties : new SmbSchemeProperties();
        this.initComponents();
        this.initLayout();
        this.initSmbVersionComboBoxes();
        this.setLocationRelativeTo((Component)PlatformUI.MIRTH_FRAME);
        this.setVisible(true);
    }

    @Override
    public boolean wasSaved() {
        return this.saved;
    }

    @Override
    public SchemeProperties getSchemeProperties() {
        SmbSchemeProperties props = new SmbSchemeProperties();
        props.setSmbMinVersion(((SmbDialectVersion)this.smbMinVersionComboBox.getSelectedItem()).getVersion());
        props.setSmbMaxVersion(((SmbDialectVersion)this.smbMaxVersionComboBox.getSelectedItem()).getVersion());
        return props;
    }

    public void initSmbVersionComboBoxes() {
        this.smbMinVersionComboBox.setCanEnableSave(false);
        this.smbMinVersionComboBox.setSelectedItem((Object)SmbSchemeProperties.getSmbDialectVersion((String)this.schemeProperties.getSmbMinVersion()));
        this.smbMinVersionComboBox.setCanEnableSave(true);
        this.smbMaxVersionComboBox.setCanEnableSave(false);
        this.smbMaxVersionComboBox.setSelectedItem((Object)SmbSchemeProperties.getSmbDialectVersion((String)this.schemeProperties.getSmbMaxVersion()));
        this.smbMaxVersionComboBox.setCanEnableSave(true);
    }

    public boolean validateProperties() {
        boolean valid = true;
        SmbDialectVersion minVersion = (SmbDialectVersion)this.smbMinVersionComboBox.getSelectedItem();
        SmbDialectVersion maxVersion = (SmbDialectVersion)this.smbMaxVersionComboBox.getSelectedItem();
        if (minVersion.getVersion().compareTo(maxVersion.getVersion()) > 0) {
            this.smbMinVersionComboBox.setBackground(UIConstants.INVALID_COLOR);
            this.smbMaxVersionComboBox.setBackground(UIConstants.INVALID_COLOR);
            valid = false;
        } else {
            this.smbMinVersionComboBox.setBackground(null);
            this.smbMaxVersionComboBox.setBackground(null);
        }
        return valid;
    }

    private void initComponents() {
        this.smbMinVersionLabel = new JLabel("SMB Minimum Version:");
        this.smbMinVersionComboBox = new MirthComboBox();
        this.smbMinVersionComboBox.setModel(new DefaultComboBoxModel<SmbDialectVersion>(SmbSchemeProperties.getSupportedVersions()));
        this.smbMinVersionComboBox.setToolTipText("Select the minimum SMB version to connect with.");
        this.smbMaxVersionLabel = new JLabel("SMB Maximum Version:");
        this.smbMaxVersionComboBox = new MirthComboBox();
        this.smbMaxVersionComboBox.setModel(new DefaultComboBoxModel<SmbDialectVersion>(SmbSchemeProperties.getSupportedVersions()));
        this.smbMaxVersionComboBox.setToolTipText("Select the maximum SMB version to connect with.");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedSmbSettingsDialog.this.okButtonActionPerformed();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedSmbSettingsDialog.this.dispose();
            }
        });
    }

    private void initLayout() {
        JPanel propertiesPanel = new JPanel((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fillx", "[right][left]"));
        propertiesPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        propertiesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(204, 204, 204)), "SMB Settings", 0, 0, new Font("Tahoma", 1, 11)));
        propertiesPanel.add(this.smbMinVersionLabel);
        propertiesPanel.add((Component)this.smbMinVersionComboBox);
        propertiesPanel.add((Component)this.smbMaxVersionLabel, "newline");
        propertiesPanel.add((Component)this.smbMaxVersionComboBox);
        this.add(propertiesPanel, "grow, push, top, wrap");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("insets 0 8 8 8, novisualpadding, hidemode 3, fill"));
        buttonPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        buttonPanel.add((Component)new JSeparator(), "growx, sx, wrap");
        buttonPanel.add((Component)this.okButton, "newline, w 50!, sx, right, split");
        buttonPanel.add((Component)this.cancelButton, "w 50!");
        this.add(buttonPanel, "south, span");
    }

    private void okButtonActionPerformed() {
        if (!this.validateProperties()) {
            return;
        }
        if ((((SmbDialectVersion)this.smbMinVersionComboBox.getSelectedItem()).getVersion().equals("SMB1") || ((SmbDialectVersion)this.smbMaxVersionComboBox.getSelectedItem()).getVersion().equals("SMB1")) && JOptionPane.showConfirmDialog((Component)((Object)this), "SMB v1 is outdated and may pose a security risk. Do you wish to proceed?", "Outdated SMB Version", 0, 2) == 1) {
            return;
        }
        this.saved = true;
        PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
        this.dispose();
    }
}

