/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.ConnectorTypeDecoration;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthPasswordField;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthSyntaxTextArea;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.ResponseHandler;
import com.mirth.connect.connectors.file.AdvancedFTPSettingsDialog;
import com.mirth.connect.connectors.file.AdvancedS3SettingsDialog;
import com.mirth.connect.connectors.file.AdvancedSettingsDialog;
import com.mirth.connect.connectors.file.AdvancedSftpSettingsDialog;
import com.mirth.connect.connectors.file.AdvancedSmbSettingsDialog;
import com.mirth.connect.connectors.file.FTPSchemeProperties;
import com.mirth.connect.connectors.file.FileConnectorServletInterface;
import com.mirth.connect.connectors.file.FileDispatcherProperties;
import com.mirth.connect.connectors.file.FileScheme;
import com.mirth.connect.connectors.file.S3SchemeProperties;
import com.mirth.connect.connectors.file.SchemeProperties;
import com.mirth.connect.connectors.file.SftpSchemeProperties;
import com.mirth.connect.connectors.file.SmbSchemeProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.model.Connector;
import com.mirth.connect.util.ConnectionTestResponse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileWriter
extends ConnectorSettingsPanel {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private FileScheme selectedScheme;
    private SchemeProperties advancedProperties;
    private JLabel anonymousLabel;
    private MirthRadioButton anonymousNoRadio;
    private MirthRadioButton anonymousYesRadio;
    private ButtonGroup anonymousButtonGroup;
    private ButtonGroup passiveModeButtonGroup;
    private ButtonGroup validateConnectionButtonGroup;
    private ButtonGroup fileExistsButtonGroup;
    private ButtonGroup fileTypeButtonGroup;
    private ButtonGroup secureModeButtonGroup;
    private ButtonGroup tempFileButtonGroup;
    private ButtonGroup keepConnectionOpenButtonGroup;
    private MirthComboBox charsetEncodingComboBox;
    private MirthTextField directoryField;
    private JLabel directoryLabel;
    private JLabel encodingLabel;
    private MirthSyntaxTextArea fileContentsTextPane;
    private MirthRadioButton fileExistsAppendRadio;
    private MirthRadioButton fileExistsErrorRadio;
    private JLabel fileExistsLabel;
    private MirthRadioButton fileExistsOverwriteRadio;
    private MirthTextField fileNameField;
    private JLabel fileNameLabel;
    private MirthRadioButton fileTypeText;
    private MirthRadioButton fileTypeBinary;
    private JLabel fileTypeLabel;
    private MirthTextField hostField;
    private JLabel hostLabel;
    private JLabel passiveModeLabel;
    private MirthRadioButton passiveModeNoRadio;
    private MirthRadioButton passiveModeYesRadio;
    private MirthPasswordField passwordField;
    private JLabel passwordLabel;
    private MirthTextField pathField;
    private JLabel pathLabel;
    private MirthComboBox<FileScheme> schemeComboBox;
    private JLabel schemeLabel;
    private JLabel secureModeLabel;
    private MirthRadioButton secureModeNoRadio;
    private MirthRadioButton secureModeYesRadio;
    private JLabel tempFileLabel;
    private MirthRadioButton tempFileNoRadio;
    private MirthRadioButton tempFileYesRadio;
    private JLabel templateLabel;
    private JButton testConnectionButton;
    private MirthTextField timeoutField;
    private JLabel timeoutLabel;
    private JLabel keepConnectionOpenLabel;
    private MirthRadioButton keepConnectionOpenNoRadio;
    private MirthRadioButton keepConnectionOpenYesRadio;
    private JLabel maxIdleTimeLabel;
    private MirthTextField maxIdleTimeField;
    private MirthTextField usernameField;
    private JLabel usernameLabel;
    private JLabel validateConnectionLabel;
    private MirthRadioButton validateConnectionNoRadio;
    private MirthRadioButton validateConnectionYesRadio;
    private JButton advancedSettingsButton;
    private JLabel summaryLabel;
    private JLabel summaryField;

    public FileWriter() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setLayout((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 0, fill, gapy 6", "[right,120][left]"));
        this.initComponents();
        this.initToolTips();
        this.initLayout();
        this.parent.setupCharsetEncodingForConnector((JComboBox)this.charsetEncodingComboBox);
    }

    public String getConnectorName() {
        return new FileDispatcherProperties().getName();
    }

    public ConnectorProperties getProperties() {
        FileDispatcherProperties properties = new FileDispatcherProperties();
        properties.setScheme((FileScheme)this.schemeComboBox.getSelectedItem());
        properties.setSchemeProperties(this.advancedProperties);
        if (this.schemeComboBox.getSelectedItem() == FileScheme.FILE) {
            properties.setHost(this.directoryField.getText().replace('\\', '/'));
        } else {
            properties.setHost(this.hostField.getText() + "/" + this.pathField.getText());
        }
        properties.setOutputPattern(this.fileNameField.getText());
        properties.setAnonymous(this.anonymousYesRadio.isSelected());
        properties.setUsername(this.usernameField.getText());
        properties.setPassword(new String(this.passwordField.getPassword()));
        properties.setTimeout(this.timeoutField.getText());
        properties.setKeepConnectionOpen(this.keepConnectionOpenYesRadio.isSelected());
        properties.setMaxIdleTime(this.maxIdleTimeField.getText());
        properties.setSecure(this.secureModeYesRadio.isSelected());
        properties.setPassive(this.passiveModeYesRadio.isSelected());
        properties.setValidateConnection(this.validateConnectionYesRadio.isSelected());
        if (this.fileExistsAppendRadio.isSelected()) {
            properties.setOutputAppend(true);
            properties.setErrorOnExists(false);
        } else if (this.fileExistsErrorRadio.isSelected()) {
            properties.setOutputAppend(false);
            properties.setErrorOnExists(true);
        } else {
            properties.setOutputAppend(false);
            properties.setErrorOnExists(false);
        }
        properties.setTemporary(this.tempFileYesRadio.isSelected());
        properties.setTemplate(this.fileContentsTextPane.getText());
        properties.setCharsetEncoding(this.parent.getSelectedEncodingForConnector((JComboBox)this.charsetEncodingComboBox));
        properties.setBinary(this.fileTypeBinary.isSelected());
        this.logger.debug("getProperties: properties=" + String.valueOf(properties));
        return properties;
    }

    public boolean setDirHostPath(FileDispatcherProperties props, boolean store, boolean highlight) {
        boolean valid = true;
        FileScheme scheme = props.getScheme();
        String hostPropValue = props.getHost();
        String directoryValue = "";
        String hostValue = "";
        String pathValue = "";
        if (scheme.equals((Object)FileScheme.FILE)) {
            directoryValue = hostPropValue;
            if (directoryValue.length() <= 0) {
                if (highlight) {
                    this.directoryField.setBackground(UIConstants.INVALID_COLOR);
                }
                valid = false;
            }
        } else {
            int splitIndex = hostPropValue.indexOf(47);
            if (splitIndex != -1) {
                hostValue = hostPropValue.substring(0, splitIndex);
                pathValue = hostPropValue.substring(splitIndex + 1);
            } else {
                hostValue = hostPropValue;
            }
            if (hostValue.length() <= 0) {
                if (highlight) {
                    this.hostField.setBackground(UIConstants.INVALID_COLOR);
                }
                valid = false;
            }
        }
        if (store) {
            this.directoryField.setText(directoryValue);
            this.hostField.setText(hostValue);
            this.pathField.setText(pathValue);
        }
        return valid;
    }

    public void setProperties(ConnectorProperties properties) {
        this.logger.debug("setProperties: props=" + String.valueOf(properties));
        FileDispatcherProperties props = (FileDispatcherProperties)properties;
        this.selectedScheme = null;
        FileScheme scheme = props.getScheme();
        this.schemeComboBox.setSelectedItem((Object)scheme);
        this.schemeComboBoxActionPerformed(null);
        this.advancedProperties = props.getSchemeProperties();
        this.setSummaryText();
        this.setDirHostPath(props, true, false);
        this.fileNameField.setText(props.getOutputPattern());
        if (props.isAnonymous()) {
            this.anonymousYesRadio.setSelected(true);
            this.anonymousNoRadio.setSelected(false);
            this.anonymousYesActionPerformed(null);
        } else {
            this.anonymousYesRadio.setSelected(false);
            this.anonymousNoRadio.setSelected(true);
            this.anonymousNoActionPerformed(null);
            this.usernameField.setText(props.getUsername());
            this.passwordField.setText(props.getPassword());
        }
        this.timeoutField.setText(props.getTimeout());
        if (props.isKeepConnectionOpen()) {
            this.keepConnectionOpenYesRadio.setSelected(true);
            this.keepConnectionOpenNoRadio.setSelected(false);
            this.keepConnectionOpenYesActionPerformed(null);
        } else {
            this.keepConnectionOpenYesRadio.setSelected(false);
            this.keepConnectionOpenNoRadio.setSelected(true);
            this.keepConnectionOpenNoActionPerformed(null);
        }
        this.maxIdleTimeField.setText(props.getMaxIdleTime());
        if (props.isSecure()) {
            this.secureModeYesRadio.setSelected(true);
            this.secureModeNoRadio.setSelected(false);
            if (scheme == FileScheme.WEBDAV) {
                this.hostLabel.setText("https://");
            }
        } else {
            this.secureModeYesRadio.setSelected(false);
            this.secureModeNoRadio.setSelected(true);
            if (scheme == FileScheme.WEBDAV) {
                this.hostLabel.setText("http://");
            }
        }
        if (props.isPassive()) {
            this.passiveModeYesRadio.setSelected(true);
            this.passiveModeNoRadio.setSelected(false);
        } else {
            this.passiveModeYesRadio.setSelected(false);
            this.passiveModeNoRadio.setSelected(true);
        }
        if (props.isValidateConnection()) {
            this.validateConnectionYesRadio.setSelected(true);
            this.validateConnectionNoRadio.setSelected(false);
        } else {
            this.validateConnectionYesRadio.setSelected(false);
            this.validateConnectionNoRadio.setSelected(true);
        }
        if (props.isTemporary()) {
            this.tempFileYesRadio.setSelected(true);
        } else {
            this.tempFileNoRadio.setSelected(true);
        }
        if (props.isOutputAppend()) {
            this.fileExistsAppendRadio.setSelected(true);
            this.fileExistsAppendRadioActionPerformed(null);
        } else if (props.isErrorOnExists()) {
            this.fileExistsErrorRadio.setSelected(true);
            this.fileExistsErrorRadioActionPerformed(null);
        } else {
            this.fileExistsOverwriteRadio.setSelected(true);
            this.fileExistsOverwriteRadioActionPerformed(null);
        }
        this.parent.setPreviousSelectedEncodingForConnector((JComboBox)this.charsetEncodingComboBox, props.getCharsetEncoding());
        this.fileContentsTextPane.setText(props.getTemplate());
        if (props.isBinary()) {
            this.fileTypeBinary.setSelected(true);
            this.fileTypeText.setSelected(false);
            this.fileTypeBinaryActionPerformed(null);
        } else {
            this.fileTypeBinary.setSelected(false);
            this.fileTypeText.setSelected(true);
            this.fileTypeASCIIActionPerformed(null);
        }
    }

    private void setSummaryText() {
        if (this.advancedProperties != null) {
            this.summaryLabel.setEnabled(true);
            this.summaryField.setEnabled(true);
            this.summaryField.setText(this.advancedProperties.getSummaryText());
        } else {
            this.summaryLabel.setEnabled(false);
            this.summaryField.setEnabled(false);
            this.summaryField.setText("<None>");
        }
    }

    public ConnectorProperties getDefaults() {
        return new FileDispatcherProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        FileScheme scheme;
        FileDispatcherProperties props = (FileDispatcherProperties)properties;
        boolean valid = true;
        valid = this.setDirHostPath(props, false, highlight);
        if (props.getOutputPattern().length() == 0) {
            valid = false;
            if (highlight) {
                this.fileNameField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getTemplate().length() == 0) {
            valid = false;
            if (highlight) {
                this.fileContentsTextPane.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (!(props.isAnonymous() || props.getScheme() == FileScheme.S3 && ((S3SchemeProperties)props.getSchemeProperties()).isUseDefaultCredentialProviderChain())) {
            boolean ignorePassword;
            if (props.getUsername().length() == 0) {
                valid = false;
                if (highlight) {
                    this.usernameField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
            boolean bl = ignorePassword = props.getScheme() == FileScheme.SFTP && !((SftpSchemeProperties)props.getSchemeProperties()).isPasswordAuth();
            if (!ignorePassword && props.getPassword().length() == 0) {
                valid = false;
                if (highlight) {
                    this.passwordField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
        }
        if (props.isKeepConnectionOpen() && NumberUtils.toInt((String)props.getMaxIdleTime(), (int)-1) < 0) {
            valid = false;
            if (highlight) {
                this.maxIdleTimeField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (((scheme = props.getScheme()).equals((Object)FileScheme.FTP) || scheme.equals((Object)FileScheme.SFTP) || scheme.equals((Object)FileScheme.SMB)) && props.getTimeout().length() == 0) {
            valid = false;
            if (highlight) {
                this.timeoutField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        this.directoryField.setBackground(null);
        this.hostField.setBackground(null);
        this.pathField.setBackground(null);
        this.fileNameField.setBackground(null);
        this.fileContentsTextPane.setBackground(null);
        this.usernameField.setBackground(null);
        this.passwordField.setBackground(null);
        this.timeoutField.setBackground(null);
        this.maxIdleTimeField.setBackground(null);
    }

    public ConnectorTypeDecoration getConnectorTypeDecoration() {
        return new ConnectorTypeDecoration(Connector.Mode.DESTINATION);
    }

    public void doLocalDecoration(ConnectorTypeDecoration connectorTypeDecoration) {
        if (FileScheme.FTP == this.schemeComboBox.getSelectedItem()) {
            this.hostLabel.setText("ftp" + (connectorTypeDecoration != null && connectorTypeDecoration.getHighlightColor() != null ? "s" : "") + "://");
        }
    }

    private void initComponents() {
        this.schemeLabel = new JLabel();
        this.schemeLabel.setText("Method:");
        this.schemeComboBox = new MirthComboBox();
        this.schemeComboBox.setModel(new DefaultComboBoxModel<FileScheme>(FileScheme.values()));
        this.schemeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileWriter.this.schemeComboBoxActionPerformed(evt);
            }
        });
        this.testConnectionButton = new JButton();
        this.testConnectionButton.setText("Test Write");
        this.testConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileWriter.this.testConnectionActionPerformed(evt);
            }
        });
        this.advancedSettingsButton = new JButton(new ImageIcon(Frame.class.getResource("images/wrench.png")));
        this.advancedSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileWriter.this.advancedFileSettingsActionPerformed();
            }
        });
        this.summaryLabel = new JLabel("Advanced Options:");
        this.summaryField = new JLabel("");
        this.directoryLabel = new JLabel();
        this.directoryLabel.setText("Directory:");
        this.directoryField = new MirthTextField();
        this.hostLabel = new JLabel();
        this.hostLabel.setText("ftp://");
        this.hostField = new MirthTextField();
        this.pathLabel = new JLabel();
        this.pathLabel.setText("/");
        this.pathField = new MirthTextField();
        this.fileNameLabel = new JLabel();
        this.fileNameLabel.setText("File Name:");
        this.fileNameField = new MirthTextField();
        this.anonymousLabel = new JLabel();
        this.anonymousLabel.setText("Anonymous:");
        this.anonymousYesRadio = new MirthRadioButton();
        this.anonymousYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.anonymousYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.anonymousYesRadio.setText("Yes");
        this.anonymousYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.anonymousYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileWriter.this.anonymousYesActionPerformed(evt);
            }
        });
        this.anonymousNoRadio = new MirthRadioButton();
        this.anonymousNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.anonymousNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.anonymousNoRadio.setSelected(true);
        this.anonymousNoRadio.setText("No");
        this.anonymousNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.anonymousNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileWriter.this.anonymousNoActionPerformed(evt);
            }
        });
        this.anonymousButtonGroup = new ButtonGroup();
        this.anonymousButtonGroup.add((AbstractButton)this.anonymousYesRadio);
        this.anonymousButtonGroup.add((AbstractButton)this.anonymousNoRadio);
        this.usernameLabel = new JLabel();
        this.usernameLabel.setText("Username:");
        this.usernameField = new MirthTextField();
        this.passwordLabel = new JLabel();
        this.passwordLabel.setText("Password:");
        this.passwordField = new MirthPasswordField();
        this.timeoutLabel = new JLabel();
        this.timeoutLabel.setText("Timeout (ms):");
        this.timeoutField = new MirthTextField();
        this.keepConnectionOpenLabel = new JLabel();
        this.keepConnectionOpenLabel.setText("Keep Connection Open: ");
        this.keepConnectionOpenYesRadio = new MirthRadioButton();
        this.keepConnectionOpenYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.keepConnectionOpenYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.keepConnectionOpenYesRadio.setSelected(true);
        this.keepConnectionOpenYesRadio.setText("Yes");
        this.keepConnectionOpenYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.keepConnectionOpenYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileWriter.this.keepConnectionOpenYesActionPerformed(evt);
            }
        });
        this.keepConnectionOpenNoRadio = new MirthRadioButton();
        this.keepConnectionOpenNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.keepConnectionOpenNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.keepConnectionOpenNoRadio.setText("No");
        this.keepConnectionOpenNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.keepConnectionOpenNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileWriter.this.keepConnectionOpenNoActionPerformed(evt);
            }
        });
        this.keepConnectionOpenButtonGroup = new ButtonGroup();
        this.keepConnectionOpenButtonGroup.add((AbstractButton)this.keepConnectionOpenYesRadio);
        this.keepConnectionOpenButtonGroup.add((AbstractButton)this.keepConnectionOpenNoRadio);
        this.maxIdleTimeLabel = new JLabel();
        this.maxIdleTimeLabel.setText("Max Idle Time (ms): ");
        this.maxIdleTimeField = new MirthTextField();
        this.secureModeLabel = new JLabel();
        this.secureModeLabel.setText("Secure Mode:");
        this.secureModeYesRadio = new MirthRadioButton();
        this.secureModeYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.secureModeYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.secureModeYesRadio.setText("Yes");
        this.secureModeYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.secureModeYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileWriter.this.secureModeYesActionPerformed(evt);
            }
        });
        this.secureModeNoRadio = new MirthRadioButton();
        this.secureModeNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.secureModeNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.secureModeNoRadio.setSelected(true);
        this.secureModeNoRadio.setText("No");
        this.secureModeNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.secureModeNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileWriter.this.secureModeNoActionPerformed(evt);
            }
        });
        this.secureModeButtonGroup = new ButtonGroup();
        this.secureModeButtonGroup.add((AbstractButton)this.secureModeYesRadio);
        this.secureModeButtonGroup.add((AbstractButton)this.secureModeNoRadio);
        this.passiveModeLabel = new JLabel();
        this.passiveModeLabel.setText("Passive Mode:");
        this.passiveModeYesRadio = new MirthRadioButton();
        this.passiveModeYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.passiveModeYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.passiveModeYesRadio.setText("Yes");
        this.passiveModeYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.passiveModeNoRadio = new MirthRadioButton();
        this.passiveModeNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.passiveModeNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.passiveModeNoRadio.setSelected(true);
        this.passiveModeNoRadio.setText("No");
        this.passiveModeNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.passiveModeButtonGroup = new ButtonGroup();
        this.passiveModeButtonGroup.add((AbstractButton)this.passiveModeYesRadio);
        this.passiveModeButtonGroup.add((AbstractButton)this.passiveModeNoRadio);
        this.validateConnectionLabel = new JLabel();
        this.validateConnectionLabel.setText("Validate Connection:");
        this.validateConnectionYesRadio = new MirthRadioButton();
        this.validateConnectionYesRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.validateConnectionYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.validateConnectionYesRadio.setText("Yes");
        this.validateConnectionYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.validateConnectionNoRadio = new MirthRadioButton();
        this.validateConnectionNoRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.validateConnectionNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.validateConnectionNoRadio.setText("No");
        this.validateConnectionNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.validateConnectionButtonGroup = new ButtonGroup();
        this.validateConnectionButtonGroup.add((AbstractButton)this.validateConnectionYesRadio);
        this.validateConnectionButtonGroup.add((AbstractButton)this.validateConnectionNoRadio);
        this.fileExistsLabel = new JLabel();
        this.fileExistsLabel.setText("File Exists:");
        this.fileExistsAppendRadio = new MirthRadioButton();
        this.fileExistsAppendRadio.setBackground(new Color(255, 255, 255));
        this.fileExistsAppendRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileExistsAppendRadio.setText("Append");
        this.fileExistsAppendRadio.setMargin(new Insets(0, 0, 0, 0));
        this.fileExistsAppendRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileWriter.this.fileExistsAppendRadioActionPerformed(evt);
            }
        });
        this.fileExistsOverwriteRadio = new MirthRadioButton();
        this.fileExistsOverwriteRadio.setBackground(new Color(255, 255, 255));
        this.fileExistsOverwriteRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileExistsOverwriteRadio.setText("Overwrite");
        this.fileExistsOverwriteRadio.setMargin(new Insets(0, 0, 0, 0));
        this.fileExistsOverwriteRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileWriter.this.fileExistsOverwriteRadioActionPerformed(evt);
            }
        });
        this.fileExistsErrorRadio = new MirthRadioButton();
        this.fileExistsErrorRadio.setBackground(new Color(255, 255, 255));
        this.fileExistsErrorRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileExistsErrorRadio.setSelected(true);
        this.fileExistsErrorRadio.setText("Error");
        this.fileExistsErrorRadio.setMargin(new Insets(0, 0, 0, 0));
        this.fileExistsErrorRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileWriter.this.fileExistsErrorRadioActionPerformed(evt);
            }
        });
        this.fileExistsButtonGroup = new ButtonGroup();
        this.fileExistsButtonGroup.add((AbstractButton)this.fileExistsAppendRadio);
        this.fileExistsButtonGroup.add((AbstractButton)this.fileExistsOverwriteRadio);
        this.fileExistsButtonGroup.add((AbstractButton)this.fileExistsErrorRadio);
        this.tempFileLabel = new JLabel();
        this.tempFileLabel.setText("Create Temp File:");
        this.tempFileYesRadio = new MirthRadioButton();
        this.tempFileYesRadio.setBackground(new Color(255, 255, 255));
        this.tempFileYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tempFileYesRadio.setText("Yes");
        this.tempFileYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.tempFileNoRadio = new MirthRadioButton();
        this.tempFileNoRadio.setBackground(new Color(255, 255, 255));
        this.tempFileNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tempFileNoRadio.setSelected(true);
        this.tempFileNoRadio.setText("No");
        this.tempFileNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.tempFileButtonGroup = new ButtonGroup();
        this.tempFileButtonGroup.add((AbstractButton)this.tempFileYesRadio);
        this.tempFileButtonGroup.add((AbstractButton)this.tempFileNoRadio);
        this.fileTypeLabel = new JLabel();
        this.fileTypeLabel.setText("File Type:");
        this.fileTypeBinary = new MirthRadioButton();
        this.fileTypeBinary.setBackground(UIConstants.BACKGROUND_COLOR);
        this.fileTypeBinary.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileTypeBinary.setText("Binary");
        this.fileTypeBinary.setMargin(new Insets(0, 0, 0, 0));
        this.fileTypeBinary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileWriter.this.fileTypeBinaryActionPerformed(evt);
            }
        });
        this.fileTypeText = new MirthRadioButton();
        this.fileTypeText.setBackground(UIConstants.BACKGROUND_COLOR);
        this.fileTypeText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileTypeText.setSelected(true);
        this.fileTypeText.setText("Text");
        this.fileTypeText.setMargin(new Insets(0, 0, 0, 0));
        this.fileTypeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileWriter.this.fileTypeASCIIActionPerformed(evt);
            }
        });
        this.fileTypeButtonGroup = new ButtonGroup();
        this.fileTypeButtonGroup.add((AbstractButton)this.fileTypeBinary);
        this.fileTypeButtonGroup.add((AbstractButton)this.fileTypeText);
        this.encodingLabel = new JLabel();
        this.encodingLabel.setText("Encoding:");
        this.charsetEncodingComboBox = new MirthComboBox();
        this.charsetEncodingComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Default", "UTF-8", "ISO-8859-1", "UTF-16 (le)", "UTF-16 (be)", "UTF-16 (bom)", "US-ASCII"}));
        this.templateLabel = new JLabel();
        this.templateLabel.setText("Template:");
        this.fileContentsTextPane = new MirthSyntaxTextArea();
        this.fileContentsTextPane.setBorder(BorderFactory.createEtchedBorder());
    }

    private void initToolTips() {
        this.schemeComboBox.setToolTipText("The basic method used to write files with - file (local filesystem), FTP, SFTP, SMB, or WebDAV");
        this.directoryField.setToolTipText("The directory (folder) to write the files to.");
        this.hostField.setToolTipText("The name or IP address of the host (computer) on which the files can be written.");
        this.pathField.setToolTipText("The directory (folder) to write the files to.");
        this.anonymousYesRadio.setToolTipText("Connects to the file anonymously instead of using a username and password.");
        this.anonymousNoRadio.setToolTipText("Connects to the file using a username and password instead of anonymously.");
        this.usernameField.setToolTipText("The user name used to gain access to the server.");
        this.passwordField.setToolTipText("The password used to gain access to the server.");
        this.timeoutField.setToolTipText("The socket timeout (in ms) for connecting to the server.");
        String toolTipText = "Select yes to keep the connection to the file system open after writing to it.";
        this.keepConnectionOpenYesRadio.setToolTipText(toolTipText);
        this.keepConnectionOpenNoRadio.setToolTipText(toolTipText);
        toolTipText = "<html>Sets the max idle timeout, in milliseconds, before closing a connection.<br>A timeout value of zero is interpreted as an infinite timeout.</html>";
        this.maxIdleTimeField.setToolTipText(toolTipText);
        toolTipText = "<html>Select Yes to connect to the server via HTTPS.<br>Select No to connect via HTTP.</html>";
        this.secureModeYesRadio.setToolTipText(toolTipText);
        this.secureModeNoRadio.setToolTipText(toolTipText);
        this.passiveModeYesRadio.setToolTipText("<html>Select Yes to connect to the server in \"passive mode\".<br>Passive mode sometimes allows a connection through a firewall that normal mode does not.</html>");
        this.passiveModeNoRadio.setToolTipText("Select Yes to connect to the server in \"normal mode\" as opposed to passive mode.");
        this.validateConnectionYesRadio.setToolTipText("Select Yes to test the connection to the server before each operation.");
        this.validateConnectionNoRadio.setToolTipText("Select No to skip testing the connection to the server before each operation.");
        toolTipText = "<html>If 'append' is selected, messages accepted by this destination will be appended to the file specified in the File Name.<br>If 'overwrite' is selected, messages accepted by this destination will replace any existing file of the same name.<br>If 'error' is selected and a file with the specified file name already exists, the message will error.</html>";
        this.fileExistsAppendRadio.setToolTipText(toolTipText);
        this.fileExistsOverwriteRadio.setToolTipText(toolTipText);
        this.fileExistsErrorRadio.setToolTipText(toolTipText);
        toolTipText = "<html>If 'yes' is selected, the file contents will first be written to a temp file and then renamed to the specified file name.<br>If 'no' is selected, the file contents will be written directly to the destination file.<br>Using a temp file is not an option if the specified file is being appended to.</html>";
        this.tempFileYesRadio.setToolTipText(toolTipText);
        this.tempFileNoRadio.setToolTipText(toolTipText);
        toolTipText = "<html>Select Binary if files contain binary data; the contents will be Base64 decoded before being written out.<br>Select Text if files contain text data; the contents will be written out using the specified character set encoding.</html>";
        this.fileTypeBinary.setToolTipText(toolTipText);
        this.fileTypeText.setToolTipText(toolTipText);
        this.charsetEncodingComboBox.setToolTipText("If File Type Text is selected, select the character set encoding (ASCII, UTF-8, etc.) to be used in writing the contents of each file.");
    }

    private void initLayout() {
        this.add(this.schemeLabel);
        this.add((Component)this.schemeComboBox, "split 3");
        this.add(this.testConnectionButton);
        this.add(this.advancedSettingsButton, "h 22!, w 22!, wrap");
        this.add(this.summaryLabel);
        this.add(this.summaryField, "growx, wrap");
        this.add(this.directoryLabel);
        this.add((Component)this.directoryField, "w 200!, wrap");
        this.add(this.hostLabel);
        this.add((Component)this.hostField, "w 200!, split 3");
        this.add(this.pathLabel, "gapleft 14");
        this.add((Component)this.pathField, "gapleft 14, w 200!, wrap");
        this.add(this.fileNameLabel);
        this.add((Component)this.fileNameField, "w 200!, wrap");
        this.add(this.anonymousLabel);
        this.add((Component)this.anonymousYesRadio, "split 2");
        this.add((Component)this.anonymousNoRadio, "wrap");
        this.add(this.usernameLabel);
        this.add((Component)this.usernameField, "w 125!, wrap");
        this.add(this.passwordLabel);
        this.add((Component)this.passwordField, "w 125!, wrap");
        this.add(this.timeoutLabel);
        this.add((Component)this.timeoutField, "w 75!, wrap");
        this.add(this.keepConnectionOpenLabel);
        this.add((Component)this.keepConnectionOpenYesRadio, "split 2");
        this.add((Component)this.keepConnectionOpenNoRadio, "wrap");
        this.add(this.maxIdleTimeLabel);
        this.add((Component)this.maxIdleTimeField, "w 75!, wrap");
        this.add(this.secureModeLabel);
        this.add((Component)this.secureModeYesRadio, "split 2");
        this.add((Component)this.secureModeNoRadio, "wrap");
        this.add(this.passiveModeLabel);
        this.add((Component)this.passiveModeYesRadio, "split 2");
        this.add((Component)this.passiveModeNoRadio, "wrap");
        this.add(this.validateConnectionLabel);
        this.add((Component)this.validateConnectionYesRadio, "split 2");
        this.add((Component)this.validateConnectionNoRadio, "wrap");
        this.add(this.fileExistsLabel);
        this.add((Component)this.fileExistsAppendRadio, "split 3");
        this.add((Component)this.fileExistsOverwriteRadio);
        this.add((Component)this.fileExistsErrorRadio, "wrap");
        this.add(this.tempFileLabel);
        this.add((Component)this.tempFileYesRadio, "split 2");
        this.add((Component)this.tempFileNoRadio, "wrap");
        this.add(this.fileTypeLabel);
        this.add((Component)this.fileTypeBinary, "split 2");
        this.add((Component)this.fileTypeText, "wrap");
        this.add(this.encodingLabel);
        this.add((Component)this.charsetEncodingComboBox, "w 125!, wrap");
        this.add(this.templateLabel, "aligny top");
        this.add((Component)this.fileContentsTextPane, "w 425, h 105, grow, span, push");
    }

    private void anonymousNoActionPerformed(ActionEvent evt) {
        this.usernameLabel.setEnabled(true);
        this.usernameField.setEnabled(true);
        this.passwordLabel.setEnabled(true);
        this.passwordField.setEnabled(true);
        FileScheme scheme = (FileScheme)this.schemeComboBox.getSelectedItem();
        if (scheme == FileScheme.S3) {
            this.usernameField.setText("");
            this.passwordField.setText("");
        }
    }

    private void anonymousYesActionPerformed(ActionEvent evt) {
        this.usernameLabel.setEnabled(false);
        this.usernameField.setEnabled(false);
        this.passwordLabel.setEnabled(false);
        this.passwordField.setEnabled(false);
        FileScheme scheme = (FileScheme)this.schemeComboBox.getSelectedItem();
        if (scheme == FileScheme.S3) {
            this.usernameField.setText("");
            this.passwordField.setText("");
        } else {
            this.usernameField.setText("anonymous");
            this.passwordField.setText("anonymous");
        }
    }

    private void keepConnectionOpenNoActionPerformed(ActionEvent evt) {
        this.maxIdleTimeField.setEnabled(false);
    }

    private void keepConnectionOpenYesActionPerformed(ActionEvent evt) {
        this.maxIdleTimeField.setEnabled(true);
    }

    private void onSchemeChange(boolean enableHost, boolean anonymous, boolean allowAppend, FileScheme scheme) {
        if (anonymous) {
            this.anonymousYesRadio.setSelected(true);
            this.anonymousYesActionPerformed(null);
        } else {
            this.anonymousNoRadio.setSelected(true);
            this.anonymousNoActionPerformed(null);
        }
        this.hostLabel.setEnabled(enableHost);
        this.hostField.setEnabled(enableHost);
        this.pathLabel.setEnabled(enableHost);
        this.pathField.setEnabled(enableHost);
        this.directoryLabel.setEnabled(!enableHost);
        this.directoryField.setEnabled(!enableHost);
        this.anonymousLabel.setEnabled(false);
        this.anonymousYesRadio.setEnabled(false);
        this.anonymousNoRadio.setEnabled(false);
        this.passiveModeLabel.setEnabled(false);
        this.passiveModeYesRadio.setEnabled(false);
        this.passiveModeNoRadio.setEnabled(false);
        this.secureModeLabel.setEnabled(false);
        this.secureModeYesRadio.setEnabled(false);
        this.secureModeNoRadio.setEnabled(false);
        this.validateConnectionLabel.setEnabled(false);
        this.validateConnectionYesRadio.setEnabled(false);
        this.validateConnectionNoRadio.setEnabled(false);
        this.timeoutLabel.setEnabled(false);
        this.timeoutField.setEnabled(false);
        this.advancedSettingsButton.setEnabled(false);
        this.advancedProperties = null;
        this.usernameLabel.setText("Username:");
        this.passwordLabel.setText("Password:");
        this.usernameField.setToolTipText("The user name used to gain access to the server.");
        this.passwordField.setToolTipText("The password used to gain access to the server.");
        if (allowAppend) {
            this.fileExistsOverwriteRadio.setEnabled(true);
            this.fileExistsAppendRadio.setEnabled(true);
        } else {
            if (this.fileExistsAppendRadio.isSelected()) {
                this.fileExistsOverwriteRadio.setSelected(true);
                this.fileExistsAppendRadio.setSelected(false);
                this.fileExistsOverwriteRadioActionPerformed(null);
            }
            this.fileExistsAppendRadio.setEnabled(false);
        }
        this.tempFileLabel.setEnabled(true);
        this.tempFileYesRadio.setEnabled(true);
        this.tempFileNoRadio.setEnabled(true);
        if (scheme.equals((Object)FileScheme.FTP)) {
            this.anonymousLabel.setEnabled(true);
            this.anonymousYesRadio.setEnabled(true);
            this.anonymousNoRadio.setEnabled(true);
            this.passiveModeLabel.setEnabled(true);
            this.passiveModeYesRadio.setEnabled(true);
            this.passiveModeNoRadio.setEnabled(true);
            this.validateConnectionLabel.setEnabled(true);
            this.validateConnectionYesRadio.setEnabled(true);
            this.validateConnectionNoRadio.setEnabled(true);
            this.timeoutLabel.setEnabled(true);
            this.timeoutField.setEnabled(true);
            this.advancedSettingsButton.setEnabled(true);
            this.advancedProperties = new FTPSchemeProperties();
        } else if (scheme.equals((Object)FileScheme.SFTP)) {
            this.timeoutLabel.setEnabled(true);
            this.timeoutField.setEnabled(true);
            this.advancedSettingsButton.setEnabled(true);
            this.advancedProperties = new SftpSchemeProperties();
        } else if (scheme == FileScheme.S3) {
            this.anonymousLabel.setEnabled(true);
            this.anonymousYesRadio.setEnabled(true);
            this.anonymousNoRadio.setEnabled(true);
            this.timeoutLabel.setEnabled(true);
            this.timeoutField.setEnabled(true);
            this.advancedSettingsButton.setEnabled(true);
            this.advancedProperties = new S3SchemeProperties();
            this.usernameLabel.setText("AWS Access Key ID:");
            this.usernameField.setToolTipText("The access key ID used to authenticate to AWS S3. This is optional when using the default credential provider chain.");
            this.passwordLabel.setText("AWS Secret Access Key:");
            this.passwordField.setToolTipText("The secret access key used to authenticate to AWS S3. This is optional when using the default credential provider chain.");
            this.tempFileLabel.setEnabled(false);
            this.tempFileNoRadio.setSelected(true);
            this.tempFileYesRadio.setEnabled(false);
            this.tempFileNoRadio.setEnabled(false);
        } else if (scheme.equals((Object)FileScheme.WEBDAV)) {
            this.anonymousLabel.setEnabled(true);
            this.anonymousYesRadio.setEnabled(true);
            this.anonymousNoRadio.setEnabled(true);
            this.secureModeLabel.setEnabled(true);
            this.secureModeYesRadio.setEnabled(true);
            this.secureModeNoRadio.setEnabled(true);
            this.passiveModeNoRadio.setSelected(true);
            this.validateConnectionNoRadio.setSelected(true);
        } else if (scheme.equals((Object)FileScheme.SMB)) {
            this.timeoutLabel.setEnabled(true);
            this.timeoutField.setEnabled(true);
            this.advancedSettingsButton.setEnabled(true);
            this.advancedProperties = new SmbSchemeProperties();
        }
        this.setSummaryText();
    }

    private void advancedFileSettingsActionPerformed() {
        AdvancedSmbSettingsDialog dialog;
        if (this.selectedScheme == FileScheme.SFTP) {
            AdvancedSftpSettingsDialog dialog2 = new AdvancedSftpSettingsDialog((SftpSchemeProperties)this.advancedProperties);
            if (((AdvancedSettingsDialog)dialog2).wasSaved()) {
                this.advancedProperties = ((AdvancedSettingsDialog)dialog2).getSchemeProperties();
                this.setSummaryText();
            }
        } else if (this.selectedScheme == FileScheme.S3) {
            AdvancedS3SettingsDialog dialog3 = new AdvancedS3SettingsDialog((S3SchemeProperties)this.advancedProperties, this.anonymousYesRadio.isSelected());
            if (dialog3.wasSaved()) {
                this.advancedProperties = dialog3.getSchemeProperties();
                this.setSummaryText();
            }
        } else if (this.selectedScheme == FileScheme.FTP) {
            AdvancedFTPSettingsDialog dialog4 = new AdvancedFTPSettingsDialog((FTPSchemeProperties)this.advancedProperties);
            if (dialog4.wasSaved()) {
                this.advancedProperties = dialog4.getSchemeProperties();
                this.setSummaryText();
            }
        } else if (this.selectedScheme == FileScheme.SMB && ((AdvancedSettingsDialog)(dialog = new AdvancedSmbSettingsDialog((SmbSchemeProperties)this.advancedProperties))).wasSaved()) {
            this.advancedProperties = ((AdvancedSettingsDialog)dialog).getSchemeProperties();
            this.setSummaryText();
        }
    }

    private boolean isAdvancedDefault() {
        if (this.selectedScheme == FileScheme.SFTP) {
            return Objects.equals(this.advancedProperties, new SftpSchemeProperties());
        }
        if (this.selectedScheme == FileScheme.S3) {
            return Objects.equals(this.advancedProperties, new S3SchemeProperties());
        }
        if (this.selectedScheme == FileScheme.FTP) {
            return Objects.equals(this.advancedProperties, new FTPSchemeProperties());
        }
        if (this.selectedScheme == FileScheme.SMB) {
            return Objects.equals(this.advancedProperties, new SmbSchemeProperties());
        }
        return true;
    }

    private void schemeComboBoxActionPerformed(ActionEvent evt) {
        FileScheme scheme = (FileScheme)this.schemeComboBox.getSelectedItem();
        if (scheme != this.selectedScheme) {
            if (this.selectedScheme != null && !this.isAdvancedDefault() && JOptionPane.showConfirmDialog((Component)this.parent, "Are you sure you would like to change the scheme mode and lose all of the current properties?", "Select an Option", 0) != 0) {
                this.schemeComboBox.setSelectedItem((Object)this.selectedScheme);
                return;
            }
            if (scheme == FileScheme.FILE) {
                this.onSchemeChange(false, true, true, FileScheme.FILE);
            } else if (scheme == FileScheme.FTP) {
                this.onSchemeChange(true, this.anonymousYesRadio.isSelected(), true, FileScheme.FTP);
                this.hostLabel.setText("ftp://");
            } else if (scheme == FileScheme.SFTP) {
                this.onSchemeChange(true, false, true, FileScheme.SFTP);
                this.hostLabel.setText("sftp://");
            } else if (scheme == FileScheme.S3) {
                this.onSchemeChange(true, true, false, FileScheme.S3);
                this.hostLabel.setText("S3 Bucket:");
            } else if (scheme == FileScheme.SMB) {
                this.onSchemeChange(true, false, true, FileScheme.SMB);
                this.hostLabel.setText("smb://");
            } else if (scheme == FileScheme.WEBDAV) {
                this.onSchemeChange(true, this.anonymousYesRadio.isSelected(), false, FileScheme.WEBDAV);
                if (this.secureModeYesRadio.isSelected()) {
                    this.hostLabel.setText("https://");
                } else {
                    this.hostLabel.setText("http://");
                }
            }
            this.decorateConnectorType();
        }
        this.selectedScheme = scheme;
    }

    private void testConnectionActionPerformed(ActionEvent evt) {
        ResponseHandler handler = new ResponseHandler(){

            public void handle(Object response) {
                ConnectionTestResponse connectionTestResponse = (ConnectionTestResponse)response;
                if (connectionTestResponse == null) {
                    FileWriter.this.parent.alertError((Component)FileWriter.this.parent, "Failed to invoke service.");
                } else if (connectionTestResponse.getType().equals((Object)ConnectionTestResponse.Type.SUCCESS)) {
                    FileWriter.this.parent.alertInformation((Component)FileWriter.this.parent, connectionTestResponse.getMessage());
                } else {
                    FileWriter.this.parent.alertWarning((Component)FileWriter.this.parent, connectionTestResponse.getMessage());
                }
            }
        };
        try {
            ((FileConnectorServletInterface)this.getServlet(FileConnectorServletInterface.class, "Testing connection...", "Failed to invoke service: ", handler)).testWrite(this.getChannelId(), this.getChannelName(), (FileDispatcherProperties)this.getFilledProperties());
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    private void secureModeYesActionPerformed(ActionEvent evt) {
        this.hostLabel.setText("https://");
    }

    private void secureModeNoActionPerformed(ActionEvent evt) {
        this.hostLabel.setText("http://");
    }

    private void fileExistsAppendRadioActionPerformed(ActionEvent evt) {
        this.tempFileNoRadio.setSelected(true);
        this.tempFileLabel.setEnabled(false);
        this.tempFileYesRadio.setEnabled(false);
        this.tempFileNoRadio.setEnabled(false);
    }

    private void fileExistsOverwriteRadioActionPerformed(ActionEvent evt) {
        FileScheme scheme = (FileScheme)this.schemeComboBox.getSelectedItem();
        if (scheme != FileScheme.S3) {
            this.tempFileLabel.setEnabled(true);
            this.tempFileYesRadio.setEnabled(true);
            this.tempFileNoRadio.setEnabled(true);
        }
    }

    private void fileExistsErrorRadioActionPerformed(ActionEvent evt) {
        FileScheme scheme = (FileScheme)this.schemeComboBox.getSelectedItem();
        if (scheme != FileScheme.S3) {
            this.tempFileLabel.setEnabled(true);
            this.tempFileYesRadio.setEnabled(true);
            this.tempFileNoRadio.setEnabled(true);
        }
    }

    private void fileTypeASCIIActionPerformed(ActionEvent evt) {
        this.encodingLabel.setEnabled(true);
        this.charsetEncodingComboBox.setEnabled(true);
    }

    private void fileTypeBinaryActionPerformed(ActionEvent evt) {
        this.encodingLabel.setEnabled(false);
        this.charsetEncodingComboBox.setEnabled(false);
        this.charsetEncodingComboBox.setSelectedIndex(0);
    }
}

