/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.doc;

import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.html.HtmlParser;
import com.lowagie.text.rtf.RtfWriter2;
import com.mirth.connect.connectors.doc.DocumentDispatcherProperties;
import com.mirth.connect.connectors.doc.Unit;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.controllers.MessageController;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.ErrorMessageBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.xhtmlrenderer.resource.FSEntityResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DocumentDispatcher
extends DestinationConnector {
    private static final Pattern PAGE_SIZE_PATTERN = Pattern.compile("@page\\s*\\{[\\s\\S]*?size\\s*:[\\s\\S]*?\\}");
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private DocumentDispatcherProperties connectorProperties;
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private static long ownerPasswordSeq = System.currentTimeMillis();

    public void onDeploy() throws ConnectorTaskException {
        this.connectorProperties = (DocumentDispatcherProperties)this.getConnectorProperties();
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
    }

    public void onUndeploy() throws ConnectorTaskException {
    }

    public void onStart() throws ConnectorTaskException {
    }

    public void onStop() throws ConnectorTaskException {
    }

    public void onHalt() throws ConnectorTaskException {
    }

    public void replaceConnectorProperties(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        DocumentDispatcherProperties props = (DocumentDispatcherProperties)connectorProperties;
        props.setHost(this.replacer.replaceValues(props.getHost(), connectorMessage));
        props.setOutputPattern(this.replacer.replaceValues(props.getOutputPattern(), connectorMessage));
        props.setPassword(this.replacer.replaceValues(props.getPassword(), connectorMessage));
        props.setTemplate(this.replacer.replaceValues(props.getTemplate(), connectorMessage));
        props.setPageWidth(this.replacer.replaceValues(props.getPageWidth(), connectorMessage));
        props.setPageHeight(this.replacer.replaceValues(props.getPageHeight(), connectorMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response send(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        DocumentDispatcherProperties documentDispatcherProperties = (DocumentDispatcherProperties)connectorProperties;
        String responseData = null;
        String responseError = null;
        String responseStatusMessage = null;
        Status responseStatus = Status.QUEUED;
        Object info = "";
        if (documentDispatcherProperties.isEncrypt()) {
            info = "Encrypted ";
        }
        info = (String)info + documentDispatcherProperties.getDocumentType() + " Document Type Result Written To: " + documentDispatcherProperties.getHost() + "/" + documentDispatcherProperties.getOutputPattern();
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.WRITING, (String)info));
        try {
            responseData = this.writeDocument(documentDispatcherProperties.getTemplate(), documentDispatcherProperties, connectorMessage);
            StringBuilder builder = new StringBuilder();
            builder.append("Document successfully written to ");
            if (StringUtils.isNotBlank((CharSequence)documentDispatcherProperties.getOutput())) {
                if (documentDispatcherProperties.getOutput().equalsIgnoreCase("file")) {
                    builder.append("file: ");
                    builder.append(documentDispatcherProperties.toURIString());
                } else if (documentDispatcherProperties.getOutput().equalsIgnoreCase("attachment")) {
                    builder.append("attachment");
                } else if (documentDispatcherProperties.getOutput().equalsIgnoreCase("both")) {
                    builder.append("attachment and file: ");
                    builder.append(documentDispatcherProperties.toURIString());
                }
            } else {
                builder.append("file: ");
                builder.append(documentDispatcherProperties.toURIString());
            }
            responseStatusMessage = builder.toString();
            responseStatus = Status.SENT;
        }
        catch (Exception e) {
            this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(connectorMessage.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), "Error writing document", (Throwable)e));
            responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)"Error writing document", (Throwable)e);
            responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)"Error writing document", (Throwable)e);
        }
        finally {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
        }
        return new Response(responseStatus, responseData, responseStatusMessage, responseError);
    }

    private String writeDocument(String template, DocumentDispatcherProperties documentDispatcherProperties, ConnectorMessage connectorMessage) throws Exception {
        StringBuilder contents = new StringBuilder();
        if (template.lastIndexOf("<html") < 0) {
            contents.append("<html>");
            if (template.lastIndexOf("<body") < 0) {
                contents.append("<body>");
                contents.append(template);
                contents.append("</body>");
            } else {
                contents.append(template);
            }
            contents.append("</html>");
        } else {
            contents.append(template);
        }
        String stringContents = this.getAttachmentHandlerProvider().reAttachMessage(contents.toString(), connectorMessage, documentDispatcherProperties.getDestinationConnectorProperties().isReattachAttachments());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (documentDispatcherProperties.getDocumentType().equalsIgnoreCase("pdf")) {
            this.createPDF(new StringReader(stringContents), outputStream, documentDispatcherProperties);
            boolean encrypt = documentDispatcherProperties.isEncrypt();
            String password = documentDispatcherProperties.getPassword();
            if (encrypt && password != null) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                outputStream = new ByteArrayOutputStream();
                this.encryptPDF(inputStream, outputStream, password);
            }
        } else if (documentDispatcherProperties.getDocumentType().equalsIgnoreCase("rtf")) {
            this.createRTF(new ByteArrayInputStream(stringContents.getBytes()), outputStream, documentDispatcherProperties);
        }
        if (StringUtils.isBlank((CharSequence)documentDispatcherProperties.getOutput()) || !documentDispatcherProperties.getOutput().equalsIgnoreCase("attachment")) {
            FileOutputStream fileOutputStream = null;
            try {
                File file = this.createFile(documentDispatcherProperties.getHost() + "/" + documentDispatcherProperties.getOutputPattern());
                this.logger.info("Writing document to: " + file.getAbsolutePath());
                fileOutputStream = new FileOutputStream(file);
                outputStream.writeTo(fileOutputStream);
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileOutputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
        if (StringUtils.isNotBlank((CharSequence)documentDispatcherProperties.getOutput()) && !documentDispatcherProperties.getOutput().equalsIgnoreCase("file")) {
            Attachment attachment = MessageController.getInstance().createAttachment((Object)new String(Base64Util.encodeBase64((byte[])outputStream.toByteArray(), (boolean)false), "US-ASCII"), documentDispatcherProperties.getDocumentType().contains("pdf") ? "application/pdf" : "application/rtf");
            MessageController.getInstance().insertAttachment(attachment, connectorMessage.getChannelId(), Long.valueOf(connectorMessage.getMessageId()));
            return attachment.getAttachmentId();
        }
        return null;
    }

    private void createPDF(Reader reader, OutputStream outputStream, DocumentDispatcherProperties props) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        builder.setEntityResolver((EntityResolver)FSEntityResolver.instance());
        org.w3c.dom.Document doc = builder.parse(new InputSource(reader));
        try {
            try {
                DonkeyElement element = new DonkeyElement(doc.getDocumentElement());
                DonkeyElement head = element.addChildElementIfNotExists("head");
                DonkeyElement style = head.addChildElementIfNotExists("style");
                double width = Double.parseDouble(props.getPageWidth());
                double height = Double.parseDouble(props.getPageHeight());
                Unit unit = props.getPageUnit();
                if (!PAGE_SIZE_PATTERN.matcher(style.getTextContent()).find()) {
                    if (unit == Unit.TWIPS) {
                        width = unit.convertTo(width, Unit.MM);
                        height = unit.convertTo(height, Unit.MM);
                        unit = Unit.MM;
                    }
                    double min = Unit.MM.convertTo(26.0, unit);
                    width = Math.max(width, min);
                    height = Math.max(height, min);
                    StringBuilder pageSelector = new StringBuilder("@page { size: ");
                    pageSelector.append(String.format("%f", width)).append(unit).append(' ');
                    pageSelector.append(String.format("%f", height)).append(unit).append("; }\n");
                    pageSelector.append(style.getTextContent());
                    style.setTextContent(pageSelector.toString());
                }
            }
            catch (Exception element) {
                // empty catch block
            }
            PdfRendererBuilder pdfRenderedBuilder = new PdfRendererBuilder();
            pdfRenderedBuilder.useFastMode();
            pdfRenderedBuilder.withW3cDocument(doc, "");
            pdfRenderedBuilder.toStream(outputStream);
            pdfRenderedBuilder.run();
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    private void encryptPDF(InputStream inputStream, OutputStream outputStream, String password) throws Exception {
        try (PDDocument document = null;){
            document = PDDocument.load((InputStream)inputStream);
            AccessPermission accessPermission = new AccessPermission();
            accessPermission.setCanAssembleDocument(false);
            accessPermission.setCanExtractContent(true);
            accessPermission.setCanExtractForAccessibility(false);
            accessPermission.setCanFillInForm(false);
            accessPermission.setCanModify(false);
            accessPermission.setCanModifyAnnotations(false);
            accessPermission.setCanPrint(true);
            accessPermission.setCanPrintDegraded(true);
            String ownerPassword = System.currentTimeMillis() + "+" + Runtime.getRuntime().freeMemory() + "+" + ownerPasswordSeq++;
            StandardProtectionPolicy policy = new StandardProtectionPolicy(ownerPassword, password, accessPermission);
            policy.setEncryptionKeyLength(128);
            document.protect((ProtectionPolicy)policy);
            document.save(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRTF(InputStream inputStream, OutputStream outputStream, DocumentDispatcherProperties props) throws Exception {
        try (Document document = null;){
            document = new Document();
            RtfWriter2.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            try {
                double width = Double.parseDouble(props.getPageWidth());
                double height = Double.parseDouble(props.getPageHeight());
                Unit unit = props.getPageUnit();
                if (unit != Unit.TWIPS) {
                    width = unit.convertTo(width, Unit.TWIPS);
                    height = unit.convertTo(height, Unit.TWIPS);
                    unit = Unit.TWIPS;
                }
                width = Math.max(width, 1.0);
                height = Math.max(height, 1.0);
                document.setPageSize(new Rectangle((float)((double)Math.round(width) / 20.0), (float)((double)Math.round(height) / 20.0)));
            }
            catch (Exception width) {
                // empty catch block
            }
            HtmlParser parser = new HtmlParser();
            parser.go((DocListener)document, inputStream);
        }
    }

    private File createFile(String filename) throws IOException {
        File file = new File(filename);
        if (!file.canWrite()) {
            String dirName = file.getPath();
            int i = dirName.lastIndexOf(File.separator);
            if (i > -1) {
                dirName = dirName.substring(0, i);
                File dir = new File(dirName);
                dir.mkdirs();
            }
            file.createNewFile();
        }
        return file;
    }
}

