/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.dimse;

import com.mirth.connect.client.ui.ConnectorTypeDecoration;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthButton;
import com.mirth.connect.client.ui.components.MirthIconTextField;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthSyntaxTextArea;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.util.PortUsageDialog;
import com.mirth.connect.connectors.dimse.DICOMDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.model.Connector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class DICOMSender
extends ConnectorSettingsPanel {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private boolean tlsComponentsEnabled = true;
    private JLabel acceptSSLv2Label;
    private MirthRadioButton acceptSSLv2NoRadio;
    private MirthRadioButton acceptSSLv2YesRadio;
    private MirthTextField associateTimeoutField;
    private MirthTextField remoteApplicationEntityField;
    private MirthTextField maxAsyncOperationsField;
    private MirthTextField transcoderBufferSizeField;
    private ButtonGroup clientAuthTLSButtonGroup;
    private JLabel clientAuthenticationLabel;
    private MirthRadioButton clientAuthenticationNoRadio;
    private MirthRadioButton clientAuthenticationYesRadio;
    private MirthTextField tcpConnectionTimeoutField;
    private MirthSyntaxTextArea fileContentsTextPane;
    private MirthRadioButton highPriority;
    private JLabel remoteAddressLabel;
    private JLabel usernameLabel;
    private JLabel passCodeLabel;
    private JLabel pduMaxLengthReceivedLabel;
    private JLabel packPdvLabel;
    private JLabel dimseRspIntervalPeriodLabel;
    private JLabel releaseTimeoutLabel;
    private JLabel remotePortLabel;
    private JLabel dimseRspTimeoutLabel;
    private JLabel shutdownDelayLabel;
    private JLabel pduMaxLengthSentLabel;
    private JLabel socketCloseDelayLabel;
    private JLabel receiveSocketBufferLabel;
    private JLabel sendSocketBufferLabel;
    private JLabel requestStorageCommLabel;
    private JLabel tcpDelayField;
    private JLabel templateLabel;
    private JLabel defaultPresentationLabel;
    private JLabel requestPositiveUserLabel;
    private JLabel remoteApplicationEntityLabel;
    private JLabel localAddressLabel;
    private JLabel localPortLabel;
    private JLabel localApplicationEntityLabel;
    private JLabel associateTimeoutLabel;
    private JLabel maxAsyncOperationsLabel;
    private JLabel transcoderBufferSizeLabel;
    private JLabel tcpConnectionTimeoutLabel;
    private JLabel priorityLabel;
    private MirthTextField keyPasswordField;
    private JLabel keyPasswordLabel;
    private MirthTextField keyStoreField;
    private JLabel keyStoreLabel;
    private MirthTextField keyStorePasswordField;
    private JLabel keyStorePasswordLabel;
    private MirthIconTextField remoteAddressField;
    private MirthTextField remotePortField;
    private MirthTextField localAddressField;
    private MirthTextField localApplicationEntityField;
    private MirthTextField localPortField;
    private MirthRadioButton lowPriority;
    private MirthRadioButton mediumPriority;
    private ButtonGroup acceptSSLv2ButtonGroup;
    private MirthTextField passcodeField;
    private ButtonGroup packPdvButtonGroup;
    private MirthRadioButton packPdvNo;
    private MirthRadioButton packPdvYes;
    private MirthButton portsInUse;
    private ButtonGroup priorityButtonGroup;
    private MirthTextField pduMaxLengthReceivedField;
    private MirthTextField dimseRspIntervalPeriodField;
    private MirthTextField releaseTimeoutField;
    private MirthTextField dimseRspTimeoutField;
    private MirthTextField shutdowndelayField;
    private MirthTextField pduMaxLengthSentField;
    private MirthTextField socketCloseDelayField;
    private MirthTextField receiveSocketBufferField;
    private MirthTextField sendSocketBufferField;
    private ButtonGroup requestStorageCommButtonGroup;
    private MirthRadioButton requestStorageCommNo;
    private MirthRadioButton requestStorageCommYes;
    private ButtonGroup tcpDelayButtonGroup;
    private MirthRadioButton tcpDelayNo;
    private MirthRadioButton tcpDelayYes;
    private MirthRadioButton tls3DESRadio;
    private MirthRadioButton tlsAESRadio;
    private ButtonGroup tlsButtonGroup;
    private JLabel tlsLabel;
    private MirthRadioButton tlsNoRadio;
    private MirthRadioButton tlsWithoutRadio;
    private MirthTextField trustStoreField;
    private JLabel trustStoreLabel;
    private MirthTextField trustStorePasswordField;
    private JLabel trustStorePasswordLabel;
    private ButtonGroup defaultPresentationButtonGroup;
    private MirthRadioButton defaultPresentationNo;
    private MirthRadioButton defaultPresentationYes;
    private ButtonGroup requestPositiveUserButtonGroup;
    private MirthRadioButton requestPositiveUserNo;
    private MirthRadioButton requestPositiveUserYes;
    private MirthTextField usernameField;

    public DICOMSender() {
        this.initComponents();
        this.initLayout();
    }

    public String getConnectorName() {
        return new DICOMDispatcherProperties().getName();
    }

    public ConnectorProperties getProperties() {
        DICOMDispatcherProperties properties = new DICOMDispatcherProperties();
        properties.setHost(this.remoteAddressField.getText());
        properties.setPort(this.remotePortField.getText());
        properties.setLocalHost(this.localAddressField.getText());
        properties.setLocalPort(this.localPortField.getText());
        properties.setTemplate(this.fileContentsTextPane.getText());
        properties.setAcceptTo(this.associateTimeoutField.getText());
        properties.setAsync(this.maxAsyncOperationsField.getText());
        properties.setBufSize(this.transcoderBufferSizeField.getText());
        properties.setConnectTo(this.tcpConnectionTimeoutField.getText());
        properties.setKeyPW(this.keyPasswordField.getText());
        properties.setKeyStore(this.keyStoreField.getText());
        properties.setKeyStorePW(this.keyStorePasswordField.getText());
        properties.setNoClientAuth(this.clientAuthenticationYesRadio.isSelected());
        properties.setNossl2(this.acceptSSLv2YesRadio.isSelected());
        properties.setPasscode(this.passcodeField.getText());
        properties.setPdv1(this.packPdvYes.isSelected());
        if (this.lowPriority.isSelected()) {
            properties.setPriority("low");
        } else if (this.mediumPriority.isSelected()) {
            properties.setPriority("med");
        } else if (this.highPriority.isSelected()) {
            properties.setPriority("high");
        }
        properties.setRcvpdulen(this.pduMaxLengthReceivedField.getText());
        properties.setReaper(this.dimseRspIntervalPeriodField.getText());
        properties.setReleaseTo(this.releaseTimeoutField.getText());
        properties.setRspTo(this.dimseRspTimeoutField.getText());
        properties.setShutdownDelay(this.shutdowndelayField.getText());
        properties.setSndpdulen(this.pduMaxLengthSentField.getText());
        properties.setSoCloseDelay(this.socketCloseDelayField.getText());
        properties.setSorcvbuf(this.receiveSocketBufferField.getText());
        properties.setSosndbuf(this.sendSocketBufferField.getText());
        properties.setStgcmt(this.requestStorageCommYes.isSelected());
        properties.setTcpDelay(this.tcpDelayYes.isSelected());
        if (this.tlsAESRadio.isSelected()) {
            properties.setTls("aes");
        } else if (this.tls3DESRadio.isSelected()) {
            properties.setTls("3des");
        } else if (this.tlsWithoutRadio.isSelected()) {
            properties.setTls("without");
        } else {
            properties.setTls("notls");
        }
        properties.setTrustStore(this.trustStoreField.getText());
        properties.setTrustStorePW(this.trustStorePasswordField.getText());
        properties.setTs1(this.defaultPresentationYes.isSelected());
        properties.setUidnegrsp(this.requestPositiveUserYes.isSelected());
        properties.setUsername(this.usernameField.getText());
        properties.setApplicationEntity(this.remoteApplicationEntityField.getText());
        properties.setLocalApplicationEntity(this.localApplicationEntityField.getText());
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        DICOMDispatcherProperties props = (DICOMDispatcherProperties)properties;
        this.remoteAddressField.setText(props.getHost());
        this.remotePortField.setText(props.getPort());
        this.localAddressField.setText(props.getLocalHost());
        this.localPortField.setText(props.getLocalPort());
        this.fileContentsTextPane.setText(props.getTemplate());
        this.associateTimeoutField.setText(props.getAcceptTo());
        this.maxAsyncOperationsField.setText(props.getAsync());
        this.transcoderBufferSizeField.setText(props.getBufSize());
        this.tcpConnectionTimeoutField.setText(props.getConnectTo());
        this.keyPasswordField.setText(props.getKeyPW());
        this.keyStoreField.setText(props.getKeyStore());
        this.keyStorePasswordField.setText(props.getKeyStorePW());
        this.passcodeField.setText(props.getPasscode());
        this.pduMaxLengthReceivedField.setText(props.getRcvpdulen());
        this.dimseRspIntervalPeriodField.setText(props.getReaper());
        this.releaseTimeoutField.setText(props.getReleaseTo());
        this.dimseRspTimeoutField.setText(props.getRspTo());
        this.shutdowndelayField.setText(props.getShutdownDelay());
        this.pduMaxLengthSentField.setText(props.getSndpdulen());
        this.socketCloseDelayField.setText(props.getSoCloseDelay());
        this.receiveSocketBufferField.setText(props.getSorcvbuf());
        this.sendSocketBufferField.setText(props.getSosndbuf());
        this.trustStoreField.setText(props.getTrustStore());
        this.trustStorePasswordField.setText(props.getTrustStorePW());
        this.usernameField.setText(props.getUsername());
        this.remoteApplicationEntityField.setText(props.getApplicationEntity());
        this.localApplicationEntityField.setText(props.getLocalApplicationEntity());
        if (props.isNoClientAuth()) {
            this.clientAuthenticationYesRadio.setSelected(true);
        } else {
            this.clientAuthenticationNoRadio.setSelected(true);
        }
        if (props.isNossl2()) {
            this.acceptSSLv2YesRadio.setSelected(true);
        } else {
            this.acceptSSLv2NoRadio.setSelected(true);
        }
        if (props.isPdv1()) {
            this.packPdvYes.setSelected(true);
        } else {
            this.packPdvNo.setSelected(true);
        }
        if (props.getPriority().equals("low")) {
            this.lowPriority.setSelected(true);
        } else if (props.getPriority().equals("med")) {
            this.mediumPriority.setSelected(true);
        } else {
            this.highPriority.setSelected(true);
        }
        if (props.isStgcmt()) {
            this.requestStorageCommYes.setSelected(true);
        } else {
            this.requestStorageCommNo.setSelected(true);
        }
        if (props.isTcpDelay()) {
            this.tcpDelayYes.setSelected(true);
        } else {
            this.tcpDelayNo.setSelected(true);
        }
        if (props.getTls().equals("aes")) {
            this.tlsAESRadio.setSelected(true);
            this.tlsAESRadioActionPerformed(null);
        } else if (props.getTls().equals("3des")) {
            this.tls3DESRadio.setSelected(true);
            this.tls3DESRadioActionPerformed(null);
        } else if (props.getTls().equals("without")) {
            this.tlsWithoutRadio.setSelected(true);
            this.tlsWithoutRadioActionPerformed(null);
        } else {
            this.tlsNoRadio.setSelected(true);
            this.tlsNoRadioActionPerformed(null);
        }
        if (props.isTs1()) {
            this.defaultPresentationYes.setSelected(true);
        } else {
            this.defaultPresentationNo.setSelected(true);
        }
        if (props.isUidnegrsp()) {
            this.requestPositiveUserYes.setSelected(true);
        } else {
            this.requestPositiveUserNo.setSelected(true);
        }
    }

    public ConnectorProperties getDefaults() {
        return new DICOMDispatcherProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        DICOMDispatcherProperties props = (DICOMDispatcherProperties)properties;
        boolean valid = true;
        if (props.getHost().length() <= 3) {
            valid = false;
            if (highlight) {
                this.remoteAddressField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getPort().length() == 0) {
            valid = false;
            if (highlight) {
                this.remotePortField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getTemplate().length() == 0) {
            valid = false;
            if (highlight) {
                this.fileContentsTextPane.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        this.remoteAddressField.setBackground(null);
        this.decorateConnectorType();
        this.remotePortField.setBackground(null);
        this.fileContentsTextPane.setBackground(null);
    }

    public ConnectorTypeDecoration getConnectorTypeDecoration() {
        return new ConnectorTypeDecoration(Connector.Mode.DESTINATION);
    }

    public void doLocalDecoration(ConnectorTypeDecoration connectorTypeDecoration) {
        if (connectorTypeDecoration != null) {
            this.remoteAddressField.setIcon((Icon)connectorTypeDecoration.getIcon());
            this.remoteAddressField.setAlternateToolTipText(connectorTypeDecoration.getIconToolTipText());
            this.remoteAddressField.setIconPopupMenuComponent(connectorTypeDecoration.getIconPopupComponent());
            this.remoteAddressField.setBackground(connectorTypeDecoration.getHighlightColor());
        }
    }

    public void enableTLSComponents() {
        this.tlsComponentsEnabled = true;
        this.tlsLabel.setEnabled(true);
        this.tls3DESRadio.setEnabled(true);
        this.tlsAESRadio.setEnabled(true);
        this.tlsWithoutRadio.setEnabled(true);
        this.tlsNoRadio.setEnabled(true);
        if (this.tls3DESRadio.isSelected()) {
            this.tls3DESRadioActionPerformed(null);
        } else if (this.tlsAESRadio.isSelected()) {
            this.tlsAESRadioActionPerformed(null);
        } else if (this.tlsWithoutRadio.isSelected()) {
            this.tlsWithoutRadioActionPerformed(null);
        } else {
            this.tlsNoRadioActionPerformed(null);
        }
    }

    public void disableTLSComponents() {
        this.tlsComponentsEnabled = false;
        this.tlsLabel.setEnabled(false);
        this.tls3DESRadio.setEnabled(false);
        this.tlsAESRadio.setEnabled(false);
        this.tlsWithoutRadio.setEnabled(false);
        this.tlsNoRadio.setEnabled(false);
        this.tlsNoRadioActionPerformed(null);
    }

    private void initComponents() {
        this.remoteAddressLabel = new JLabel();
        this.remoteAddressField = new MirthIconTextField();
        this.localAddressLabel = new JLabel();
        this.localAddressField = new MirthTextField();
        this.remotePortLabel = new JLabel();
        this.remotePortField = new MirthTextField();
        this.localPortLabel = new JLabel();
        this.localPortField = new MirthTextField();
        this.portsInUse = new MirthButton();
        this.remoteApplicationEntityLabel = new JLabel();
        this.remoteApplicationEntityField = new MirthTextField();
        this.localApplicationEntityLabel = new JLabel();
        this.localApplicationEntityField = new MirthTextField();
        this.maxAsyncOperationsLabel = new JLabel();
        this.maxAsyncOperationsField = new MirthTextField();
        this.priorityLabel = new JLabel();
        this.priorityButtonGroup = new ButtonGroup();
        this.highPriority = new MirthRadioButton();
        this.mediumPriority = new MirthRadioButton();
        this.lowPriority = new MirthRadioButton();
        this.requestStorageCommLabel = new JLabel();
        this.requestStorageCommButtonGroup = new ButtonGroup();
        this.requestStorageCommYes = new MirthRadioButton();
        this.requestStorageCommNo = new MirthRadioButton();
        this.usernameLabel = new JLabel();
        this.usernameField = new MirthTextField();
        this.passCodeLabel = new JLabel();
        this.passcodeField = new MirthTextField();
        this.requestPositiveUserLabel = new JLabel();
        this.requestPositiveUserButtonGroup = new ButtonGroup();
        this.requestPositiveUserYes = new MirthRadioButton();
        this.requestPositiveUserNo = new MirthRadioButton();
        this.packPdvLabel = new JLabel();
        this.packPdvButtonGroup = new ButtonGroup();
        this.packPdvYes = new MirthRadioButton();
        this.packPdvNo = new MirthRadioButton();
        this.dimseRspIntervalPeriodLabel = new JLabel();
        this.dimseRspIntervalPeriodField = new MirthTextField();
        this.pduMaxLengthSentLabel = new JLabel();
        this.pduMaxLengthSentField = new MirthTextField();
        this.releaseTimeoutLabel = new JLabel();
        this.releaseTimeoutField = new MirthTextField();
        this.pduMaxLengthReceivedLabel = new JLabel();
        this.pduMaxLengthReceivedField = new MirthTextField();
        this.dimseRspTimeoutLabel = new JLabel();
        this.dimseRspTimeoutField = new MirthTextField();
        this.sendSocketBufferLabel = new JLabel();
        this.sendSocketBufferField = new MirthTextField();
        this.shutdownDelayLabel = new JLabel();
        this.shutdowndelayField = new MirthTextField();
        this.receiveSocketBufferLabel = new JLabel();
        this.receiveSocketBufferField = new MirthTextField();
        this.socketCloseDelayLabel = new JLabel();
        this.socketCloseDelayField = new MirthTextField();
        this.transcoderBufferSizeLabel = new JLabel();
        this.transcoderBufferSizeField = new MirthTextField();
        this.associateTimeoutLabel = new JLabel();
        this.associateTimeoutField = new MirthTextField();
        this.tcpConnectionTimeoutLabel = new JLabel();
        this.tcpConnectionTimeoutField = new MirthTextField();
        this.tcpDelayField = new JLabel();
        this.tcpDelayButtonGroup = new ButtonGroup();
        this.tcpDelayYes = new MirthRadioButton();
        this.tcpDelayNo = new MirthRadioButton();
        this.defaultPresentationLabel = new JLabel();
        this.defaultPresentationButtonGroup = new ButtonGroup();
        this.defaultPresentationYes = new MirthRadioButton();
        this.defaultPresentationNo = new MirthRadioButton();
        this.tlsLabel = new JLabel();
        this.tlsButtonGroup = new ButtonGroup();
        this.tls3DESRadio = new MirthRadioButton();
        this.tlsAESRadio = new MirthRadioButton();
        this.tlsWithoutRadio = new MirthRadioButton();
        this.tlsNoRadio = new MirthRadioButton();
        this.clientAuthenticationLabel = new JLabel();
        this.clientAuthTLSButtonGroup = new ButtonGroup();
        this.clientAuthenticationYesRadio = new MirthRadioButton();
        this.clientAuthenticationNoRadio = new MirthRadioButton();
        this.acceptSSLv2Label = new JLabel();
        this.acceptSSLv2ButtonGroup = new ButtonGroup();
        this.acceptSSLv2YesRadio = new MirthRadioButton();
        this.acceptSSLv2NoRadio = new MirthRadioButton();
        this.keyStoreLabel = new JLabel();
        this.keyStoreField = new MirthTextField();
        this.keyStorePasswordLabel = new JLabel();
        this.keyStorePasswordField = new MirthTextField();
        this.trustStoreLabel = new JLabel();
        this.trustStoreField = new MirthTextField();
        this.trustStorePasswordLabel = new JLabel();
        this.trustStorePasswordField = new MirthTextField();
        this.keyPasswordLabel = new JLabel();
        this.keyPasswordField = new MirthTextField();
        this.templateLabel = new JLabel();
        this.fileContentsTextPane = new MirthSyntaxTextArea();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.remoteAddressLabel.setText("Remote Host:");
        this.remoteAddressField.setToolTipText("Remote IP to send to.");
        this.localAddressLabel.setText("Local Host:");
        this.localAddressField.setToolTipText("Local address that the client socket will be bound to.");
        this.remotePortLabel.setText("Remote Port:");
        this.remotePortField.setToolTipText("Remote PORT to send to.");
        this.localPortLabel.setText("Local Port:");
        this.localPortField.setToolTipText("Local port that the client socket will be bound to.");
        this.portsInUse.setText("Ports in Use");
        this.portsInUse.setToolTipText("View all ports currently used by BridgeLink.");
        this.portsInUse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMSender.this.portsInUseActionPerformed(evt);
            }
        });
        this.remoteApplicationEntityField.setToolTipText("Remote Application Entity");
        this.remoteApplicationEntityLabel.setText("Remote Application Entity:");
        this.localApplicationEntityLabel.setText("Local Application Entity:");
        this.localApplicationEntityField.setToolTipText("Local Application Entity");
        this.maxAsyncOperationsLabel.setText("Max Async operations:");
        this.maxAsyncOperationsField.setToolTipText("Maximum number of outstanding operations it may invoke asynchronously, unlimited by default.");
        this.priorityLabel.setText("Priority:");
        this.highPriority.setBackground(new Color(255, 255, 255));
        this.highPriority.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.priorityButtonGroup.add((AbstractButton)this.highPriority);
        this.highPriority.setText("High");
        this.highPriority.setToolTipText("Priority of the C-STORE operation, MEDIUM by default.");
        this.highPriority.setMargin(new Insets(0, 0, 0, 0));
        this.mediumPriority.setBackground(new Color(255, 255, 255));
        this.mediumPriority.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.priorityButtonGroup.add((AbstractButton)this.mediumPriority);
        this.mediumPriority.setSelected(true);
        this.mediumPriority.setText("Medium");
        this.mediumPriority.setToolTipText("Priority of the C-STORE operation, MEDIUM by default.");
        this.mediumPriority.setMargin(new Insets(0, 0, 0, 0));
        this.lowPriority.setBackground(new Color(255, 255, 255));
        this.lowPriority.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.priorityButtonGroup.add((AbstractButton)this.lowPriority);
        this.lowPriority.setText("Low");
        this.lowPriority.setToolTipText("Priority of the C-STORE operation, MEDIUM by default.");
        this.lowPriority.setMargin(new Insets(0, 0, 0, 0));
        this.requestStorageCommLabel.setText("Request Storage Commitment:");
        this.requestStorageCommYes.setBackground(new Color(255, 255, 255));
        this.requestStorageCommYes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.requestStorageCommButtonGroup.add((AbstractButton)this.requestStorageCommYes);
        this.requestStorageCommYes.setSelected(true);
        this.requestStorageCommYes.setText("Yes");
        this.requestStorageCommYes.setToolTipText("Request storage commitment of (successfully) sent objects afterwards.");
        this.requestStorageCommYes.setMargin(new Insets(0, 0, 0, 0));
        this.requestStorageCommNo.setBackground(new Color(255, 255, 255));
        this.requestStorageCommNo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.requestStorageCommButtonGroup.add((AbstractButton)this.requestStorageCommNo);
        this.requestStorageCommNo.setText("No");
        this.requestStorageCommNo.setToolTipText("Request storage commitment of (successfully) sent objects afterwards.");
        this.requestStorageCommNo.setMargin(new Insets(0, 0, 0, 0));
        this.usernameLabel.setText("User Name:");
        this.usernameField.setToolTipText("Enable User Identity Negotiation with specified username and  optional passcode.");
        this.passCodeLabel.setText("Pass Code:");
        this.passcodeField.setToolTipText("Optional passcode for User Identity Negotiation, only effective with option -username.");
        this.requestPositiveUserLabel.setText("Request Positive User Identity Response:");
        this.requestPositiveUserYes.setBackground(new Color(255, 255, 255));
        this.requestPositiveUserYes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.requestPositiveUserButtonGroup.add((AbstractButton)this.requestPositiveUserYes);
        this.requestPositiveUserYes.setText("Yes");
        this.requestPositiveUserYes.setToolTipText("Request positive User Identity Negotation response, only effective with option -username.");
        this.requestPositiveUserYes.setMargin(new Insets(0, 0, 0, 0));
        this.requestPositiveUserNo.setBackground(new Color(255, 255, 255));
        this.requestPositiveUserNo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.requestPositiveUserButtonGroup.add((AbstractButton)this.requestPositiveUserNo);
        this.requestPositiveUserNo.setSelected(true);
        this.requestPositiveUserNo.setText("No");
        this.requestPositiveUserNo.setToolTipText("Request positive User Identity Negotation response, only effective with option -username.");
        this.requestPositiveUserNo.setMargin(new Insets(0, 0, 0, 0));
        this.packPdvLabel.setText("Pack PDV:");
        this.packPdvYes.setBackground(new Color(255, 255, 255));
        this.packPdvYes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.packPdvButtonGroup.add((AbstractButton)this.packPdvYes);
        this.packPdvYes.setText("Yes");
        this.packPdvYes.setToolTipText("Send only one PDV in one P-Data-TF PDU, pack command and data PDV in one P-DATA-TF PDU by default.");
        this.packPdvYes.setMargin(new Insets(0, 0, 0, 0));
        this.packPdvNo.setBackground(new Color(255, 255, 255));
        this.packPdvNo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.packPdvButtonGroup.add((AbstractButton)this.packPdvNo);
        this.packPdvNo.setSelected(true);
        this.packPdvNo.setText("No");
        this.packPdvNo.setToolTipText("Send only one PDV in one P-Data-TF PDU, pack command and data PDV in one P-DATA-TF PDU by default.");
        this.packPdvNo.setMargin(new Insets(0, 0, 0, 0));
        this.dimseRspIntervalPeriodLabel.setText("DIMSE-RSP interval period (s):");
        this.dimseRspIntervalPeriodField.setToolTipText("Period in ms to check for outstanding DIMSE-RSP, 10s by default.");
        this.pduMaxLengthSentLabel.setText("P-DATA-TF PDUs max length sent (KB):");
        this.pduMaxLengthSentField.setToolTipText("Maximal length in KB of sent P-DATA-TF PDUs, 16KB by default.");
        this.releaseTimeoutLabel.setText("A-RELEASE-RP timeout (s):");
        this.releaseTimeoutField.setToolTipText("Timeout in ms for receiving A-RELEASE-RP, 5s by default.");
        this.pduMaxLengthReceivedLabel.setText("P-DATA-TF PDUs  max length received (KB):");
        this.pduMaxLengthReceivedField.setToolTipText("Maximal length in KB of received P-DATA-TF PDUs, 16KB by default.");
        this.dimseRspTimeoutLabel.setText("DIMSE-RSP timeout (s):");
        this.dimseRspTimeoutField.setToolTipText("Timeout in ms for receiving DIMSE-RSP, 60s by default.");
        this.sendSocketBufferLabel.setText("Send Socket Buffer Size (KB):");
        this.sendSocketBufferField.setToolTipText("Set send socket buffer to specified value in KB.");
        this.shutdownDelayLabel.setText("Shutdown delay (ms):");
        this.shutdowndelayField.setToolTipText("Delay in ms for closing the listening socket, 1000ms by default.");
        this.receiveSocketBufferLabel.setText("Receive Socket Buffer Size (KB):");
        this.receiveSocketBufferField.setToolTipText("Set receive socket buffer to specified value in KB.");
        this.socketCloseDelayLabel.setText("Socket Close Delay After A-ABORT (ms):");
        this.socketCloseDelayField.setToolTipText("Delay in ms for Socket close after sending A-ABORT, 50ms by default.");
        this.transcoderBufferSizeLabel.setText("Transcoder Buffer Size (KB):");
        this.transcoderBufferSizeField.setToolTipText("Transcoder buffer size in KB, 1KB by default.");
        this.associateTimeoutLabel.setText("Timeout A-ASSOCIATE-AC (ms):");
        this.associateTimeoutField.setToolTipText("Timeout in ms for receiving A-ASSOCIATE-AC, 5000ms by default.");
        this.tcpConnectionTimeoutLabel.setText("TCP Connection Timeout (ms):");
        this.tcpConnectionTimeoutField.setToolTipText("Timeout in ms for TCP connect, no timeout by default.");
        this.tcpDelayField.setText("TCP Delay:");
        this.tcpDelayYes.setBackground(new Color(255, 255, 255));
        this.tcpDelayYes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tcpDelayButtonGroup.add((AbstractButton)this.tcpDelayYes);
        this.tcpDelayYes.setSelected(true);
        this.tcpDelayYes.setText("Yes");
        this.tcpDelayYes.setToolTipText("Set TCP_NODELAY socket option to false, true by default.");
        this.tcpDelayYes.setMargin(new Insets(0, 0, 0, 0));
        this.tcpDelayNo.setBackground(new Color(255, 255, 255));
        this.tcpDelayNo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tcpDelayButtonGroup.add((AbstractButton)this.tcpDelayNo);
        this.tcpDelayNo.setText("No");
        this.tcpDelayNo.setToolTipText("Set TCP_NODELAY socket option to false, true by default.");
        this.tcpDelayNo.setMargin(new Insets(0, 0, 0, 0));
        this.defaultPresentationLabel.setText("Default Presentation Syntax:");
        this.defaultPresentationYes.setBackground(new Color(255, 255, 255));
        this.defaultPresentationYes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultPresentationButtonGroup.add((AbstractButton)this.defaultPresentationYes);
        this.defaultPresentationYes.setText("Yes");
        this.defaultPresentationYes.setToolTipText("Offer Default Transfer Syntax in separate Presentation Context. By default offered with Explicit VR Little Endian TS in one PC.");
        this.defaultPresentationYes.setMargin(new Insets(0, 0, 0, 0));
        this.defaultPresentationNo.setBackground(new Color(255, 255, 255));
        this.defaultPresentationNo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultPresentationButtonGroup.add((AbstractButton)this.defaultPresentationNo);
        this.defaultPresentationNo.setSelected(true);
        this.defaultPresentationNo.setText("No");
        this.defaultPresentationNo.setToolTipText("Offer Default Transfer Syntax in separate Presentation Context. By default offered with Explicit VR Little Endian TS in one PC.");
        this.defaultPresentationNo.setMargin(new Insets(0, 0, 0, 0));
        this.tlsLabel.setText("TLS:");
        this.tls3DESRadio.setBackground(new Color(255, 255, 255));
        this.tls3DESRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tlsButtonGroup.add((AbstractButton)this.tls3DESRadio);
        this.tls3DESRadio.setText("3DES");
        this.tls3DESRadio.setToolTipText("Enable TLS connection without, 3DES or AES encryption.");
        this.tls3DESRadio.setMargin(new Insets(0, 0, 0, 0));
        this.tls3DESRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMSender.this.tls3DESRadioActionPerformed(evt);
            }
        });
        this.tlsAESRadio.setBackground(new Color(255, 255, 255));
        this.tlsAESRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tlsButtonGroup.add((AbstractButton)this.tlsAESRadio);
        this.tlsAESRadio.setText("AES");
        this.tlsAESRadio.setToolTipText("Enable TLS connection without, 3DES or AES encryption.");
        this.tlsAESRadio.setMargin(new Insets(0, 0, 0, 0));
        this.tlsAESRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMSender.this.tlsAESRadioActionPerformed(evt);
            }
        });
        this.tlsWithoutRadio.setBackground(new Color(255, 255, 255));
        this.tlsWithoutRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tlsButtonGroup.add((AbstractButton)this.tlsWithoutRadio);
        this.tlsWithoutRadio.setText("Without");
        this.tlsWithoutRadio.setToolTipText("Enable TLS connection without, 3DES or AES encryption.");
        this.tlsWithoutRadio.setMargin(new Insets(0, 0, 0, 0));
        this.tlsWithoutRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMSender.this.tlsWithoutRadioActionPerformed(evt);
            }
        });
        this.tlsNoRadio.setBackground(new Color(255, 255, 255));
        this.tlsNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tlsButtonGroup.add((AbstractButton)this.tlsNoRadio);
        this.tlsNoRadio.setSelected(true);
        this.tlsNoRadio.setText("No TLS");
        this.tlsNoRadio.setToolTipText("Enable TLS connection without, 3DES or AES encryption.");
        this.tlsNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.tlsNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DICOMSender.this.tlsNoRadioActionPerformed(evt);
            }
        });
        this.clientAuthenticationLabel.setText("Client Authentication TLS:");
        this.clientAuthenticationYesRadio.setBackground(new Color(255, 255, 255));
        this.clientAuthenticationYesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clientAuthTLSButtonGroup.add((AbstractButton)this.clientAuthenticationYesRadio);
        this.clientAuthenticationYesRadio.setSelected(true);
        this.clientAuthenticationYesRadio.setText("Yes");
        this.clientAuthenticationYesRadio.setToolTipText("Enable client authentification for TLS.");
        this.clientAuthenticationYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.clientAuthenticationNoRadio.setBackground(new Color(255, 255, 255));
        this.clientAuthenticationNoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clientAuthTLSButtonGroup.add((AbstractButton)this.clientAuthenticationNoRadio);
        this.clientAuthenticationNoRadio.setText("No");
        this.clientAuthenticationNoRadio.setToolTipText("Enable client authentification for TLS.");
        this.clientAuthenticationNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.acceptSSLv2Label.setText("Accept ssl v2 TLS handshake:");
        this.acceptSSLv2YesRadio.setBackground(new Color(255, 255, 255));
        this.acceptSSLv2YesRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.acceptSSLv2ButtonGroup.add((AbstractButton)this.acceptSSLv2YesRadio);
        this.acceptSSLv2YesRadio.setSelected(true);
        this.acceptSSLv2YesRadio.setText("Yes");
        this.acceptSSLv2YesRadio.setToolTipText("Enable acceptance of SSLv2Hello TLS handshake.");
        this.acceptSSLv2YesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.acceptSSLv2NoRadio.setBackground(new Color(255, 255, 255));
        this.acceptSSLv2NoRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.acceptSSLv2ButtonGroup.add((AbstractButton)this.acceptSSLv2NoRadio);
        this.acceptSSLv2NoRadio.setText("No");
        this.acceptSSLv2NoRadio.setToolTipText("Enable acceptance of SSLv2Hello TLS handshake.");
        this.acceptSSLv2NoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.keyStoreLabel.setText("Keystore:");
        this.keyStoreField.setToolTipText("File path or URL of P12 or JKS keystore, resource:tls/test_sys_2.p12 by default.");
        this.keyStorePasswordLabel.setText("Keystore Password:");
        this.keyStorePasswordField.setToolTipText("Password for keystore file.");
        this.trustStoreLabel.setText("Trust Store:");
        this.trustStoreField.setToolTipText("File path or URL of JKS truststore, resource:tls/mesa_certs.jks by default.");
        this.trustStorePasswordLabel.setText("Trust Store Password:");
        this.trustStorePasswordField.setToolTipText("Password for truststore file.");
        this.keyPasswordLabel.setText("Key Password:");
        this.keyPasswordField.setToolTipText("Password for accessing the key in the keystore, keystore password by default.");
        this.fileContentsTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.templateLabel.setText("Template:");
    }

    private void initLayout() {
        JPanel remoteLocalPortsPanel = new JPanel();
        remoteLocalPortsPanel.setLayout((LayoutManager)new MigLayout("novisualpadding, gap 10 6, hidemode 3, insets 0, fill", "[200, right][][right][grow]"));
        remoteLocalPortsPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        remoteLocalPortsPanel.add(this.remoteAddressLabel);
        remoteLocalPortsPanel.add((Component)this.remoteAddressField, "w 150!");
        remoteLocalPortsPanel.add(this.localAddressLabel);
        remoteLocalPortsPanel.add((Component)this.localAddressField, "w 150!");
        remoteLocalPortsPanel.add((Component)this.remotePortLabel, "newline");
        remoteLocalPortsPanel.add((Component)this.remotePortField, "w 50!");
        remoteLocalPortsPanel.add(this.localPortLabel);
        remoteLocalPortsPanel.add((Component)this.localPortField, "w 50!, split 2, sx");
        remoteLocalPortsPanel.add((Component)this.portsInUse, "gapleft 6");
        remoteLocalPortsPanel.add((Component)this.remoteApplicationEntityLabel, "newline");
        remoteLocalPortsPanel.add((Component)this.remoteApplicationEntityField, "w 50!");
        remoteLocalPortsPanel.add(this.localApplicationEntityLabel);
        remoteLocalPortsPanel.add((Component)this.localApplicationEntityField, "w 50!");
        remoteLocalPortsPanel.add((Component)this.maxAsyncOperationsLabel, "newline");
        remoteLocalPortsPanel.add((Component)this.maxAsyncOperationsField, "w 50!, spanx");
        remoteLocalPortsPanel.add((Component)this.priorityLabel, "newline, h 18!");
        remoteLocalPortsPanel.add((Component)this.highPriority, "split 3");
        remoteLocalPortsPanel.add((Component)this.mediumPriority);
        remoteLocalPortsPanel.add((Component)this.lowPriority, "spanx");
        remoteLocalPortsPanel.add((Component)this.requestStorageCommLabel, "newline, h 18!");
        remoteLocalPortsPanel.add((Component)this.requestStorageCommYes, "split 4");
        remoteLocalPortsPanel.add((Component)this.requestStorageCommNo, "spanx");
        remoteLocalPortsPanel.add((Component)this.usernameLabel, "newline");
        remoteLocalPortsPanel.add((Component)this.usernameField, "w 50!, spanx");
        remoteLocalPortsPanel.add((Component)this.passCodeLabel, "newline");
        remoteLocalPortsPanel.add((Component)this.passcodeField, "w 50!, spanx");
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout((LayoutManager)new MigLayout("novisualpadding, gap 10 6, hidemode 3, insets 0, fill", "[200, right][][right][grow]"));
        settingsPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        settingsPanel.add((Component)this.requestPositiveUserLabel, "h 18!");
        settingsPanel.add((Component)this.requestPositiveUserYes, "split 2");
        settingsPanel.add((Component)this.requestPositiveUserNo, "spanx");
        settingsPanel.add((Component)this.packPdvLabel, "newline, h 18!");
        settingsPanel.add((Component)this.packPdvYes, "split 2");
        settingsPanel.add((Component)this.packPdvNo, "spanx");
        settingsPanel.add((Component)this.dimseRspIntervalPeriodLabel, "newline");
        settingsPanel.add((Component)this.dimseRspIntervalPeriodField, "w 50!");
        settingsPanel.add(this.pduMaxLengthSentLabel);
        settingsPanel.add((Component)this.pduMaxLengthSentField, "w 50!, spanx");
        settingsPanel.add((Component)this.releaseTimeoutLabel, "newline");
        settingsPanel.add((Component)this.releaseTimeoutField, "w 50!");
        settingsPanel.add(this.pduMaxLengthReceivedLabel);
        settingsPanel.add((Component)this.pduMaxLengthReceivedField, "w 50!, spanx");
        settingsPanel.add((Component)this.dimseRspTimeoutLabel, "newline");
        settingsPanel.add((Component)this.dimseRspTimeoutField, "w 50!, spanx");
        settingsPanel.add(this.sendSocketBufferLabel);
        settingsPanel.add((Component)this.sendSocketBufferField, "w 50!");
        settingsPanel.add((Component)this.shutdownDelayLabel, "newline");
        settingsPanel.add((Component)this.shutdowndelayField, "w 50!");
        settingsPanel.add(this.receiveSocketBufferLabel);
        settingsPanel.add((Component)this.receiveSocketBufferField, "w 50!");
        settingsPanel.add((Component)this.socketCloseDelayLabel, "newline");
        settingsPanel.add((Component)this.socketCloseDelayField, "w 50!");
        settingsPanel.add(this.transcoderBufferSizeLabel);
        settingsPanel.add((Component)this.transcoderBufferSizeField, "w 50!");
        settingsPanel.add((Component)this.associateTimeoutLabel, "newline");
        settingsPanel.add((Component)this.associateTimeoutField, "w 50!");
        settingsPanel.add((Component)this.tcpConnectionTimeoutLabel, "newline");
        settingsPanel.add((Component)this.tcpConnectionTimeoutField, "w 50!");
        JPanel tlsPanel = new JPanel();
        tlsPanel.setLayout((LayoutManager)new MigLayout("novisualpadding, gap 10 6, hidemode 3, insets 0, fill", "[200, right][grow]"));
        tlsPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        tlsPanel.add((Component)this.tcpDelayField, "h 18!");
        tlsPanel.add((Component)this.tcpDelayYes, "split 2");
        tlsPanel.add((Component)this.tcpDelayNo);
        tlsPanel.add((Component)this.defaultPresentationLabel, "newline, h 18!");
        tlsPanel.add((Component)this.defaultPresentationYes, "split 2");
        tlsPanel.add((Component)this.defaultPresentationNo);
        tlsPanel.add((Component)this.tlsLabel, "newline, h 18!");
        tlsPanel.add((Component)this.tls3DESRadio, "split 4");
        tlsPanel.add((Component)this.tlsAESRadio);
        tlsPanel.add((Component)this.tlsWithoutRadio);
        tlsPanel.add((Component)this.tlsNoRadio);
        tlsPanel.add((Component)this.clientAuthenticationLabel, "newline, h 18!");
        tlsPanel.add((Component)this.clientAuthenticationYesRadio, "split 2");
        tlsPanel.add((Component)this.clientAuthenticationNoRadio);
        tlsPanel.add((Component)this.acceptSSLv2Label, "newline, h 18!");
        tlsPanel.add((Component)this.acceptSSLv2YesRadio, "split 2");
        tlsPanel.add((Component)this.acceptSSLv2NoRadio);
        JPanel keystorePanel = new JPanel();
        keystorePanel.setLayout((LayoutManager)new MigLayout("novisualpadding, gap 10 6, hidemode 3, insets 0, fill", "[200, right][][right][]"));
        keystorePanel.setBackground(UIConstants.BACKGROUND_COLOR);
        keystorePanel.add(this.keyStoreLabel);
        keystorePanel.add((Component)this.keyStoreField, "w 150!");
        keystorePanel.add(this.keyStorePasswordLabel);
        keystorePanel.add((Component)this.keyStorePasswordField, "w 80!");
        keystorePanel.add((Component)this.trustStoreLabel, "newline");
        keystorePanel.add((Component)this.trustStoreField, "w 150!");
        keystorePanel.add(this.trustStorePasswordLabel);
        keystorePanel.add((Component)this.trustStorePasswordField, "w 80!");
        keystorePanel.add((Component)this.keyPasswordLabel, "newline");
        keystorePanel.add((Component)this.keyPasswordField, "w 150!");
        JPanel templatePanel = new JPanel();
        templatePanel.setLayout((LayoutManager)new MigLayout("novisualpadding, gap 10 6, hidemode 3, insets 0, fill", "[200, right][]"));
        templatePanel.setBackground(UIConstants.BACKGROUND_COLOR);
        templatePanel.add((Component)this.templateLabel, "aligny top");
        templatePanel.add((Component)this.fileContentsTextPane, "grow, push, w :400, h :150");
        this.setLayout((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 0, wrap, gapy 6, fill"));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.add(remoteLocalPortsPanel);
        this.add(settingsPanel);
        this.add(tlsPanel);
        this.add(keystorePanel);
        this.add(templatePanel, "sx, grow");
    }

    private void tlsNoRadioActionPerformed(ActionEvent evt) {
        this.clientAuthenticationLabel.setEnabled(false);
        this.clientAuthenticationYesRadio.setEnabled(false);
        this.clientAuthenticationNoRadio.setEnabled(false);
        this.acceptSSLv2Label.setEnabled(false);
        this.acceptSSLv2YesRadio.setEnabled(false);
        this.acceptSSLv2NoRadio.setEnabled(false);
        this.keyStoreLabel.setEnabled(false);
        this.keyStoreField.setEnabled(false);
        this.keyStorePasswordLabel.setEnabled(false);
        this.keyStorePasswordField.setEnabled(false);
        this.trustStoreLabel.setEnabled(false);
        this.trustStoreField.setEnabled(false);
        this.trustStorePasswordLabel.setEnabled(false);
        this.trustStorePasswordField.setEnabled(false);
        this.keyPasswordLabel.setEnabled(false);
        this.keyPasswordField.setEnabled(false);
    }

    private void tls3DESRadioActionPerformed(ActionEvent evt) {
        if (!this.tlsComponentsEnabled) {
            return;
        }
        this.clientAuthenticationLabel.setEnabled(true);
        this.clientAuthenticationYesRadio.setEnabled(true);
        this.clientAuthenticationNoRadio.setEnabled(true);
        this.acceptSSLv2Label.setEnabled(true);
        this.acceptSSLv2YesRadio.setEnabled(true);
        this.acceptSSLv2NoRadio.setEnabled(true);
        this.keyStoreLabel.setEnabled(true);
        this.keyStoreField.setEnabled(true);
        this.keyStorePasswordLabel.setEnabled(true);
        this.keyStorePasswordField.setEnabled(true);
        this.trustStoreLabel.setEnabled(true);
        this.trustStoreField.setEnabled(true);
        this.trustStorePasswordLabel.setEnabled(true);
        this.trustStorePasswordField.setEnabled(true);
        this.keyPasswordLabel.setEnabled(true);
        this.keyPasswordField.setEnabled(true);
    }

    private void tlsAESRadioActionPerformed(ActionEvent evt) {
        if (!this.tlsComponentsEnabled) {
            return;
        }
        this.clientAuthenticationLabel.setEnabled(true);
        this.clientAuthenticationYesRadio.setEnabled(true);
        this.clientAuthenticationNoRadio.setEnabled(true);
        this.acceptSSLv2Label.setEnabled(true);
        this.acceptSSLv2YesRadio.setEnabled(true);
        this.acceptSSLv2NoRadio.setEnabled(true);
        this.keyStoreLabel.setEnabled(true);
        this.keyStoreField.setEnabled(true);
        this.keyStorePasswordLabel.setEnabled(true);
        this.keyStorePasswordField.setEnabled(true);
        this.trustStoreLabel.setEnabled(true);
        this.trustStoreField.setEnabled(true);
        this.trustStorePasswordLabel.setEnabled(true);
        this.trustStorePasswordField.setEnabled(true);
        this.keyPasswordLabel.setEnabled(true);
        this.keyPasswordField.setEnabled(true);
    }

    private void tlsWithoutRadioActionPerformed(ActionEvent evt) {
        if (!this.tlsComponentsEnabled) {
            return;
        }
        this.clientAuthenticationLabel.setEnabled(true);
        this.clientAuthenticationYesRadio.setEnabled(true);
        this.clientAuthenticationNoRadio.setEnabled(true);
        this.acceptSSLv2Label.setEnabled(true);
        this.acceptSSLv2YesRadio.setEnabled(true);
        this.acceptSSLv2NoRadio.setEnabled(true);
        this.keyStoreLabel.setEnabled(true);
        this.keyStoreField.setEnabled(true);
        this.keyStorePasswordLabel.setEnabled(true);
        this.keyStorePasswordField.setEnabled(true);
        this.trustStoreLabel.setEnabled(true);
        this.trustStoreField.setEnabled(true);
        this.trustStorePasswordLabel.setEnabled(true);
        this.trustStorePasswordField.setEnabled(true);
        this.keyPasswordLabel.setEnabled(true);
        this.keyPasswordField.setEnabled(true);
    }

    private void portsInUseActionPerformed(ActionEvent evt) {
        PortUsageDialog dialog = new PortUsageDialog((Window)this.parent);
    }
}

