/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dashboardstatus;

import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionStateItem {
    private String serverId;
    private String channelId;
    private String metadataId;
    private ConnectionStatusEventType status;
    private AtomicInteger connectionCount;
    private AtomicInteger maxConnectionCount;
    private Logger logger = LogManager.getLogger(this.getClass());

    public ConnectionStateItem(String serverId, String channelId, String metadataId, ConnectionStatusEventType status, int connectionCount, int maxConnectionCount) {
        this.serverId = serverId;
        this.channelId = channelId;
        this.metadataId = metadataId;
        this.status = status;
        this.connectionCount = new AtomicInteger(connectionCount);
        this.maxConnectionCount = new AtomicInteger(maxConnectionCount);
    }

    public ConnectionStateItem(ResultSet resultSet) {
        try {
            this.serverId = resultSet.getString("server_id");
            this.channelId = resultSet.getString("channel_id");
            this.metadataId = resultSet.getString("metadata_id").trim();
            this.status = ConnectionStatusEventType.valueOf((String)resultSet.getString("connection_status"));
            this.connectionCount = new AtomicInteger(resultSet.getInt("connection_count"));
            this.maxConnectionCount = new AtomicInteger(resultSet.getInt("connection_count_max"));
        }
        catch (SQLException e) {
            this.logger.error("Error instantiating a ConnectionStateItem from database ResultSet", (Throwable)e);
        }
    }

    public int addToConnectionCount(int value) {
        return this.connectionCount.addAndGet(value);
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String newId) {
        this.serverId = newId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String newId) {
        this.channelId = newId;
    }

    public String getMetadataId() {
        return this.metadataId;
    }

    public void setMetadataId(String newId) {
        this.metadataId = newId;
    }

    public ConnectionStatusEventType getStatus() {
        return this.status;
    }

    public void setStatus(ConnectionStatusEventType newStatus) {
        this.status = newStatus;
    }

    public int getConnectionCount() {
        return this.connectionCount.get();
    }

    public void setConnectionCount(int newCount) {
        this.connectionCount = new AtomicInteger(newCount);
    }

    public int getMaxConnectionCount() {
        return this.maxConnectionCount.get();
    }

    public void setMaxConnectionCount(int newMax) {
        this.maxConnectionCount = new AtomicInteger(newMax);
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof ConnectionStateItem)) {
            return false;
        }
        ConnectionStateItem otherStateItem = (ConnectionStateItem)otherObject;
        if (!otherStateItem.getServerId().equals(this.getServerId())) {
            return false;
        }
        if (!otherStateItem.getChannelId().equals(this.getChannelId())) {
            return false;
        }
        if (!otherStateItem.getMetadataId().equals(this.getMetadataId())) {
            return false;
        }
        if (!otherStateItem.getStatus().equals((Object)this.getStatus())) {
            return false;
        }
        if (otherStateItem.getConnectionCount() != this.getConnectionCount()) {
            return false;
        }
        return otherStateItem.getMaxConnectionCount() == this.getMaxConnectionCount();
    }
}

