/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.maintenance;

import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MessageTrendsConfig {
    private final boolean enabled;
    private final Clock clock;
    private final boolean flushEnabled;
    private final boolean rollupEnabled;
    private final int rollupFixedRateSeconds;
    private final boolean purgeEnabled;
    private final int purgeFixedRateSeconds;
    private final long purgeThrottleMs;
    private final Map<Integer, Duration> retentionByBucket;

    private MessageTrendsConfig(boolean bl, Clock clock, boolean bl2, boolean bl3, int n, boolean bl4, int n2, long l, Map<Integer, Duration> map) {
        this.enabled = bl;
        this.clock = clock != null ? clock : Clock.systemUTC();
        this.flushEnabled = bl2;
        this.rollupEnabled = bl3;
        this.rollupFixedRateSeconds = n;
        this.purgeEnabled = bl4;
        this.purgeFixedRateSeconds = n2;
        this.purgeThrottleMs = l;
        this.retentionByBucket = MessageTrendsConfig.toUnmodifiable(map);
        this.validate();
    }

    public static MessageTrendsConfig defaultConfig() {
        return new MessageTrendsConfig(false, Clock.systemUTC(), true, true, 120, true, 3600, 1000L, MessageTrendsConfig.defaultRetention());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Clock getClock() {
        return this.clock;
    }

    public boolean isFlushEnabled() {
        return this.flushEnabled;
    }

    public boolean isRollupEnabled() {
        return this.rollupEnabled;
    }

    public int getRollupFixedRateSeconds() {
        return this.rollupFixedRateSeconds;
    }

    public boolean isPurgeEnabled() {
        return this.purgeEnabled;
    }

    public int getPurgeFixedRateSeconds() {
        return this.purgeFixedRateSeconds;
    }

    public long getPurgeThrottleMs() {
        return this.purgeThrottleMs;
    }

    public Map<Integer, Duration> getRetentionByBucket() {
        return this.retentionByBucket;
    }

    public MessageTrendsConfig withEnabled(boolean bl) {
        return new MessageTrendsConfig(bl, this.clock, this.flushEnabled, this.rollupEnabled, this.rollupFixedRateSeconds, this.purgeEnabled, this.purgeFixedRateSeconds, this.purgeThrottleMs, this.retentionByBucket);
    }

    private static Map<Integer, Duration> defaultRetention() {
        LinkedHashMap<Integer, Duration> linkedHashMap = new LinkedHashMap<Integer, Duration>();
        linkedHashMap.put(1, Duration.ofDays(1L));
        linkedHashMap.put(5, Duration.ofDays(7L));
        linkedHashMap.put(15, Duration.ofDays(30L));
        linkedHashMap.put(60, Duration.ofDays(90L));
        linkedHashMap.put(1440, Duration.ofDays(1095L));
        return linkedHashMap;
    }

    private void validate() {
        if (this.rollupFixedRateSeconds < 30) {
            throw new IllegalArgumentException("rollupFixedRateSeconds must be >= 30");
        }
        if (this.purgeFixedRateSeconds < 3600) {
            throw new IllegalArgumentException("purgeFixedRateSeconds must be >= 3600");
        }
        if (this.purgeThrottleMs < 1000L) {
            throw new IllegalArgumentException("purgeThrottleMs must be >= 1000");
        }
    }

    private static <K, V> Map<K, V> toUnmodifiable(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }
}

