/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file.filesystems;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.UserInfo;
import com.mirth.connect.connectors.file.FileSystemConnectionOptions;
import com.mirth.connect.connectors.file.SftpSchemeProperties;
import com.mirth.connect.connectors.file.filesystems.FileInfo;
import com.mirth.connect.connectors.file.filesystems.FileSystemConnection;
import com.mirth.connect.connectors.file.filesystems.SftpUserInfo;
import com.mirth.connect.connectors.file.filters.RegexFilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SftpConnection
implements FileSystemConnection {
    private static transient Log logger = LogFactory.getLog(SftpConnection.class);
    private ChannelSftp client = null;
    private Session session = null;
    private String lastDir = null;
    private Properties configuration;
    private boolean isPasswordAuth = true;

    public SftpConnection(String host, int port, FileSystemConnectionOptions fileSystemOptions, int timeout) throws Exception {
        JSch jsch = new JSch();
        this.configuration = new Properties();
        try {
            Map configurationSettings;
            SftpSchemeProperties sftpSchemeProperties = (SftpSchemeProperties)fileSystemOptions.getSchemeProperties();
            this.isPasswordAuth = sftpSchemeProperties.isPasswordAuth();
            String knownHostsFile = sftpSchemeProperties.getKnownHostsFile();
            if (StringUtils.isNotEmpty((CharSequence)knownHostsFile)) {
                jsch.setKnownHosts(knownHostsFile);
            }
            this.configuration.put("StrictHostKeyChecking", sftpSchemeProperties.getHostChecking());
            if (sftpSchemeProperties.isKeyAuth()) {
                String keyLocation = sftpSchemeProperties.getKeyFile();
                String keyPassphrase = sftpSchemeProperties.getPassPhrase();
                if (StringUtils.isNotEmpty((CharSequence)keyPassphrase)) {
                    jsch.addIdentity(keyLocation, keyPassphrase);
                } else {
                    jsch.addIdentity(keyLocation);
                }
            }
            if (MapUtils.isNotEmpty((Map)(configurationSettings = sftpSchemeProperties.getConfigurationSettings()))) {
                for (Map.Entry entry : configurationSettings.entrySet()) {
                    this.configuration.put(entry.getKey(), entry.getValue());
                }
            }
            String username = fileSystemOptions.getUsername();
            this.session = port > 0 ? jsch.getSession(username, host, port) : jsch.getSession(username, host);
            this.session.setTimeout(timeout);
            if (this.isPasswordAuth) {
                SftpUserInfo sftpUserInfo = new SftpUserInfo(fileSystemOptions.getPassword());
                this.session.setUserInfo((UserInfo)sftpUserInfo);
            }
            if (!this.configuration.isEmpty()) {
                this.session.setConfig(this.configuration);
            }
            this.session.connect(timeout);
            Channel channel = this.session.openChannel("sftp");
            channel.connect();
            this.client = (ChannelSftp)channel;
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    @Override
    public List<FileInfo> listFiles(String fromDir, String filenamePattern, boolean isRegex, boolean ignoreDot) throws Exception {
        this.lastDir = fromDir;
        RegexFilenameFilter filenameFilter = isRegex ? new RegexFilenameFilter(filenamePattern) : new WildcardFileFilter(filenamePattern.trim().split("\\s*,\\s*"));
        this.cwd(fromDir);
        Vector entries = this.client.ls(".");
        ArrayList<FileInfo> files = new ArrayList<FileInfo>(entries.size());
        for (ChannelSftp.LsEntry entry : entries) {
            if (entry.getAttrs().isDir() || entry.getAttrs().isLink() || filenameFilter != null && !filenameFilter.accept(null, entry.getFilename()) || ignoreDot && entry.getFilename().startsWith(".")) continue;
            files.add(new SftpFileInfo(fromDir, entry));
        }
        return files;
    }

    @Override
    public List<String> listDirectories(String fromDir) throws Exception {
        ArrayList<String> directories = new ArrayList<String>();
        this.cwd(fromDir);
        Vector entries = this.client.ls(".");
        for (ChannelSftp.LsEntry entry : entries) {
            if (!entry.getAttrs().isDir() && !entry.getAttrs().isLink() || entry.getFilename().equals(".") || entry.getFilename().equals("..")) continue;
            directories.add(new SftpFileInfo(fromDir, entry).getAbsolutePath());
        }
        return directories;
    }

    @Override
    public boolean exists(String file, String path) {
        if (null == file) {
            return false;
        }
        try {
            this.cwd(path);
            Vector entries = this.client.ls(".");
            return entries.stream().anyMatch(le -> file.equals(le.getFilename()));
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to check for the existence of file " + file + " in path " + path + " on server " + this.session.getHost()), (Throwable)e);
            return false;
        }
    }

    private void cwd(String path) throws Exception {
        this.client.cd(URLDecoder.decode(path, Charset.defaultCharset().name()));
    }

    @Override
    public boolean canRead(String readDir) {
        try {
            this.lastDir = readDir;
            this.cwd(readDir);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean canWrite(String writeDir) {
        try {
            this.lastDir = writeDir;
            this.cwd(writeDir);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public InputStream readFile(String file, String fromDir, Map<String, Object> sourceMap) throws Exception {
        this.lastDir = fromDir;
        this.cwd(fromDir);
        return this.client.get(file);
    }

    @Override
    public void closeReadFile() throws Exception {
    }

    @Override
    public boolean canAppend() {
        return true;
    }

    @Override
    public void writeFile(String file, String toDir, boolean append, InputStream is, long contentLength, Map<String, Object> connectorMap) throws Exception {
        this.lastDir = toDir;
        this.cdmake(toDir);
        int mode = 0;
        mode = append ? 2 : 0;
        this.client.put(is, file, mode);
    }

    @Override
    public void delete(String file, String fromDir, boolean mayNotExist) throws Exception {
        block2: {
            this.cwd(fromDir);
            try {
                this.client.rm(file);
            }
            catch (Exception e) {
                if (mayNotExist) break block2;
                throw e;
            }
        }
    }

    private void cdmake(String dir) throws Exception {
        block6: {
            try {
                this.cwd(dir);
            }
            catch (Exception e) {
                String[] dirs;
                String toDir = dir;
                if (toDir.startsWith("/")) {
                    toDir = toDir.substring(1);
                    this.client.cd("/");
                }
                if ((dirs = toDir.split("/")).length <= 0) break block6;
                for (int i = 0; i < dirs.length; ++i) {
                    try {
                        this.client.cd(dirs[i]);
                        continue;
                    }
                    catch (Exception ex) {
                        logger.debug((Object)("Making directory: " + dirs[i]));
                        this.client.mkdir(dirs[i]);
                        this.client.cd(dirs[i]);
                    }
                }
            }
        }
    }

    @Override
    public void move(String fromName, String fromDir, String toName, String toDir) throws Exception {
        this.cwd(fromDir);
        this.cdmake(toDir);
        try {
            this.client.rm(toName);
        }
        catch (Exception e) {
            logger.info((Object)"Unable to delete destination file");
        }
        this.cwd(fromDir);
        this.client.rename(fromName.replaceAll("//", "/"), (toDir + "/" + toName).replaceAll("//", "/"));
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void activate() {
    }

    @Override
    public void passivate() {
    }

    @Override
    public void destroy() {
        if (this.client != null) {
            this.client.quit();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    @Override
    public boolean isValid() {
        if (this.lastDir == null) {
            return this.client.isConnected();
        }
        return this.client.isConnected() && this.canRead(this.lastDir);
    }

    public class SftpFileInfo
    implements FileInfo {
        String thePath;
        ChannelSftp.LsEntry theFile;

        public SftpFileInfo(String path, ChannelSftp.LsEntry theFile) {
            this.thePath = path;
            this.theFile = theFile;
        }

        @Override
        public long getLastModified() {
            return Long.valueOf(this.theFile.getAttrs().getMTime()) * 1000L;
        }

        @Override
        public String getName() {
            return this.theFile.getFilename();
        }

        @Override
        public String getAbsolutePath() {
            return this.getParent() + "/" + this.getName();
        }

        @Override
        public String getCanonicalPath() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getParent() {
            return this.thePath;
        }

        @Override
        public long getSize() {
            return this.theFile.getAttrs().getSize();
        }

        @Override
        public boolean isDirectory() {
            return this.theFile.getAttrs().isDir();
        }

        @Override
        public boolean isFile() {
            SftpATTRS attrs = this.theFile.getAttrs();
            return !attrs.isDir() && !attrs.isLink();
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public void populateSourceMap(Map<String, Object> sourceMap) {
        }
    }
}

