/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file.filesystems;

import com.mirth.connect.connectors.file.FileSystemConnectionOptions;
import com.mirth.connect.connectors.file.filesystems.FileInfo;
import com.mirth.connect.connectors.file.filesystems.FileSystemConnection;
import com.mirth.connect.connectors.file.filters.RegexFilenameFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.webdav.lib.WebdavFile;
import org.apache.webdav.lib.WebdavResource;

public class WebDavConnection
implements FileSystemConnection {
    private static transient Log logger = LogFactory.getLog(WebDavConnection.class);
    private WebdavResource client = null;
    private boolean secure = false;
    private String username = null;
    private String password = null;

    public WebDavConnection(String host, boolean secure, FileSystemConnectionOptions fileSystemOptions) throws Exception {
        this.secure = secure;
        this.username = fileSystemOptions.getUsername();
        this.password = fileSystemOptions.getPassword();
        Object url = null;
        url = secure ? new HttpsURL("https://" + host) : new HttpURL("http://" + host);
        if (!this.username.equals("null")) {
            url.setUserinfo(this.username, this.password);
        }
        this.client = new WebdavResource((HttpURL)url);
    }

    @Override
    public List<FileInfo> listFiles(String fromDir, String filenamePattern, boolean isRegex, boolean ignoreDot) throws Exception {
        RegexFilenameFilter filenameFilter = isRegex ? new RegexFilenameFilter(filenamePattern) : new WildcardFileFilter(filenamePattern.trim().split("\\s*,\\s*"));
        return this.list(fromDir, true, filenameFilter, ignoreDot);
    }

    @Override
    public List<String> listDirectories(String fromDir) throws Exception {
        ArrayList<String> directories = new ArrayList<String>();
        for (FileInfo directory : this.list(fromDir, false, null, false)) {
            directories.add(directory.getCanonicalPath());
        }
        return directories;
    }

    private List<FileInfo> list(String fromDir, boolean files, FilenameFilter filenameFilter, boolean ignoreDot) throws Exception {
        this.client.setPath(fromDir);
        WebdavResource[] resources = this.client.listWebdavResources();
        if (resources == null || resources.length == 0) {
            return new ArrayList<FileInfo>();
        }
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>(resources.length);
        for (int i = 0; i < resources.length; ++i) {
            WebdavFile file = null;
            String filePath = this.getFullPath(fromDir, resources[i].getPath());
            if (this.secure) {
                hrl = new HttpsURL("https://" + this.client.getHost() + filePath);
                if (!this.username.equals("null")) {
                    hrl.setUserinfo(this.username, this.password);
                }
                file = new WebdavFile((HttpURL)hrl);
            } else {
                hrl = new HttpURL("http://" + this.client.getHost() + filePath);
                if (!this.username.equals("null")) {
                    hrl.setUserinfo(this.username, this.password);
                }
                file = new WebdavFile((HttpURL)hrl);
            }
            if (files) {
                if (!file.isFile() || !filenameFilter.accept(null, file.getName()) || ignoreDot && file.getName().startsWith(".")) continue;
                fileInfoList.add(new WebDavFileInfo(fromDir, file));
                continue;
            }
            if (!file.isDirectory()) continue;
            fileInfoList.add(new WebDavFileInfo(fromDir, file));
        }
        return fileInfoList;
    }

    @Override
    public boolean exists(String file, String path) {
        try {
            this.client.setPath(this.getFullPath(path, file));
            return this.client.exists();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public InputStream readFile(String file, String fromDir, Map<String, Object> sourceMap) throws Exception {
        String fullPath = this.getFullPath(fromDir, file);
        this.client.setPath(fullPath);
        if (this.client.isCollection()) {
            logger.error((Object)("Invalid filepath: " + fullPath));
            throw new Exception("Invalid Path");
        }
        return this.client.getMethodData();
    }

    @Override
    public void closeReadFile() throws Exception {
    }

    @Override
    public boolean canAppend() {
        return false;
    }

    @Override
    public void writeFile(String file, String toDir, boolean append, InputStream is, long contentLength, Map<String, Object> connectorMap) throws Exception {
        String fullPath = this.getFullPath(toDir, file);
        this.client.setPath(toDir);
        if (!this.client.exists()) {
            this.client.mkcolMethod(toDir);
            logger.info((Object)("Destination directory does not exist. Creating directory: '" + toDir + "'"));
            if (!this.client.putMethod(fullPath, is)) {
                logger.error((Object)("Unable to write file: '" + fullPath));
            }
        } else {
            if (!this.client.isCollection()) {
                throw new Exception("The destination directory path is invalid: '" + this.client.getPath() + "'");
            }
            if (!this.client.putMethod(fullPath, is)) {
                logger.error((Object)("Unable to write file: '" + fullPath));
            }
        }
    }

    @Override
    public void delete(String file, String fromDir, boolean mayNotExist) throws Exception {
        String fullPath = this.getFullPath(fromDir, file);
        if (!this.client.deleteMethod(fullPath) && !mayNotExist) {
            logger.error((Object)("Unable to delete file: '" + fullPath + "'"));
        }
    }

    @Override
    public void move(String fromName, String fromDir, String toName, String toDir) throws Exception {
        String sourcePath = this.getFullPath(fromDir, fromName);
        String targetPath = this.getFullPath(toDir, toName);
        this.client.setPath(toDir);
        if (!this.client.exists()) {
            this.client.mkcolMethod(toDir);
            logger.info((Object)("Move-To directory does not exist. Creating directory: '" + toDir + "'"));
            if (!this.client.moveMethod(sourcePath, targetPath)) {
                logger.error((Object)("Unable to move file: '" + sourcePath + "' to '" + targetPath + "'"));
            }
        } else {
            if (!this.client.isCollection()) {
                throw new Exception("The move-to directory path is invalid: '" + this.client.getPath() + "'");
            }
            if (!this.client.moveMethod(sourcePath, targetPath)) {
                logger.error((Object)("Unable to move file: '" + sourcePath + "' to '" + targetPath + "'"));
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.client != null && this.client.exists();
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void activate() {
    }

    @Override
    public void passivate() {
    }

    @Override
    public void destroy() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException e) {
            logger.debug((Object)e);
        }
    }

    @Override
    public boolean isValid() {
        return this.client != null && this.client.exists();
    }

    @Override
    public boolean canRead(String readDir) {
        try {
            this.client.setPath(readDir);
            return this.client.exists() && this.client.isCollection();
        }
        catch (IOException e) {
            logger.debug((Object)e);
            return false;
        }
    }

    @Override
    public boolean canWrite(String writeDir) {
        try {
            this.client.setPath(writeDir);
            return this.client.exists() && this.client.isCollection() && !this.client.isLocked();
        }
        catch (IOException e) {
            logger.debug((Object)e);
            return false;
        }
    }

    private String getFullPath(String dir, String file) {
        return ("/" + dir + "/" + file).replaceAll("//", "/");
    }

    public class WebDavFileInfo
    implements FileInfo {
        private String thePath;
        private WebdavFile theFile;

        public WebDavFileInfo(String path, WebdavFile theFile) {
            this.thePath = path;
            this.theFile = theFile;
        }

        @Override
        public long getLastModified() {
            return this.theFile.lastModified();
        }

        @Override
        public String getName() {
            return this.theFile.getName();
        }

        @Override
        public String getAbsolutePath() {
            return this.theFile.getAbsolutePath();
        }

        @Override
        public String getCanonicalPath() throws IOException {
            return this.theFile.getCanonicalPath();
        }

        @Override
        public String getParent() {
            return this.thePath;
        }

        @Override
        public long getSize() {
            return this.theFile.length();
        }

        @Override
        public boolean isDirectory() {
            return this.theFile.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.theFile.isFile();
        }

        @Override
        public boolean isReadable() {
            return this.theFile.canRead();
        }

        @Override
        public void populateSourceMap(Map<String, Object> sourceMap) {
        }
    }
}

