/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.sun.pdfview.HexDump;
import java.io.File;
import java.io.FileInputStream;

public class Type1Decode {
    private static byte[] decrypt(byte[] d, int start, int end, int key, int skip) {
        if (end - start - skip < 0) {
            skip = 0;
        }
        byte[] o = new byte[end - start - skip];
        int r = key;
        int c1 = 52845;
        int c2 = 22719;
        for (int ipos = start; ipos < end; ++ipos) {
            int c = d[ipos] & 0xFF;
            int p = (c ^ r >> 8) & 0xFF;
            if (ipos - start < 16) {
                System.out.println("c = " + Integer.toHexString(c) + ", p = " + Integer.toHexString(p) + ", r = " + Integer.toHexString(r));
            }
            r = (c + r) * c1 + c2 & 0xFFFF;
            if (ipos - start - skip < 0) continue;
            o[ipos - start - skip] = (byte)p;
        }
        return o;
    }

    private static byte[] readASCII(byte[] data, int start, int end) {
        byte[] o = new byte[(end - start) / 2];
        int count = 0;
        int bit = 0;
        for (int loc = start; loc < end; ++loc) {
            char c = (char)(data[loc] & 0xFF);
            byte b = 0;
            if (c >= '0' && c <= '9') {
                b = (byte)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                b = (byte)(10 + (c - 97));
            } else {
                if (c < 'A' || c > 'F') continue;
                b = (byte)(10 + (c - 65));
            }
            if (bit++ % 2 == 0) {
                o[count] = (byte)(b << 4);
                continue;
            }
            int n = count++;
            o[n] = (byte)(o[n] | b);
        }
        return o;
    }

    private static boolean isASCII(byte[] data, int start) {
        for (int i = start; i < start + 4; ++i) {
            char c = (char)(data[i] & 0xFF);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage:");
            System.out.println("    Type1Decode <filename> <decode-start>");
            System.exit(-1);
        }
        try {
            File file = new File(args[0]);
            if (!file.exists() || !file.canRead()) {
                System.out.println("Can't read file: " + args[0]);
                System.exit(-1);
            }
            FileInputStream fis = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            int cur = 0;
            while ((long)cur < file.length()) {
                cur += fis.read(data, cur, data.length - cur);
            }
            int start = 0;
            if ((data[0] & 0xFF) == 128) {
                start = data[2] & 0xFF;
                start |= (data[3] & 0xFF) << 8;
                start |= (data[4] & 0xFF) << 16;
                start |= (data[5] & 0xFF) << 24;
                start += 6;
            } else if (args.length > 1) {
                start = Integer.parseInt(args[1]);
            } else {
                System.out.println("Unable to read size");
                System.exit(-1);
            }
            int size = data.length - start;
            if (Type1Decode.isASCII(data, start)) {
                data = Type1Decode.readASCII(data, start, size);
                start = 0;
                size = data.length;
            } else if ((data[start] & 0xFF) == 128) {
                size = data[start + 2] & 0xFF;
                size |= (data[start + 3] & 0xFF) << 8;
                size |= (data[start + 4] & 0xFF) << 16;
                size |= (data[start + 5] & 0xFF) << 24;
                start += 6;
            }
            byte[] outData = Type1Decode.decrypt(data, start, start + size, 55665, 4);
            HexDump.printData(outData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

