/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth.basic;

import com.mirth.connect.plugins.httpauth.HttpAuthConnectorPluginProperties;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class BasicHttpAuthProperties
extends HttpAuthConnectorPluginProperties {
    private String realm;
    private Map<String, String> credentials;
    private boolean isUseCredentialsVariable;
    private String credentialsVariable;

    public BasicHttpAuthProperties() {
        super(HttpAuthConnectorPluginProperties.AuthType.BASIC);
        this.realm = "My Realm";
        this.credentials = new LinkedHashMap<String, String>();
        this.isUseCredentialsVariable = false;
        this.credentialsVariable = "";
    }

    public BasicHttpAuthProperties(BasicHttpAuthProperties props) {
        super(HttpAuthConnectorPluginProperties.AuthType.BASIC);
        this.realm = props.getRealm();
        this.credentials = new LinkedHashMap<String, String>(props.getCredentialsMap());
        this.isUseCredentialsVariable = props.isUseCredentialsVariable();
        this.credentialsVariable = props.getCredentialsVariable();
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public Map<String, String> getCredentialsMap() {
        return this.credentials;
    }

    public void setCredentialsMap(Map<String, String> credentials) {
        this.credentials = credentials;
    }

    public boolean isUseCredentialsVariable() {
        return this.isUseCredentialsVariable;
    }

    public void setUseCredentialsVariable(boolean isUseCredentialsVariable) {
        this.isUseCredentialsVariable = isUseCredentialsVariable;
    }

    public String getCredentialsVariable() {
        return this.credentialsVariable;
    }

    public void setCredentialsVariable(String credentialsVariable) {
        this.credentialsVariable = credentialsVariable;
    }

    public BasicHttpAuthProperties clone() {
        return new BasicHttpAuthProperties(this);
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("authType", (Object)this.getAuthType());
        purgedProperties.put("credentialsCount", this.credentials.size());
        return purgedProperties;
    }
}

