/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth.digest;

import com.mirth.connect.plugins.httpauth.HttpAuthConnectorPluginProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DigestHttpAuthProperties
extends HttpAuthConnectorPluginProperties {
    private String realm;
    private Set<Algorithm> algorithms;
    private Set<QOPMode> qopModes;
    private String opaque;
    private Map<String, String> credentials;
    private boolean isUseCredentialsVariable;
    private String credentialsVariable;

    public DigestHttpAuthProperties() {
        super(HttpAuthConnectorPluginProperties.AuthType.DIGEST);
        this.realm = "My Realm";
        this.algorithms = new LinkedHashSet<Algorithm>(Arrays.asList(Algorithm.values()));
        this.qopModes = new LinkedHashSet<QOPMode>(Arrays.asList(QOPMode.values()));
        this.opaque = "${UUID}";
        this.credentials = new LinkedHashMap<String, String>();
        this.isUseCredentialsVariable = false;
        this.credentialsVariable = "";
    }

    public DigestHttpAuthProperties(DigestHttpAuthProperties props) {
        super(HttpAuthConnectorPluginProperties.AuthType.DIGEST);
        this.realm = props.getRealm();
        this.algorithms = new LinkedHashSet<Algorithm>(props.getAlgorithms());
        this.qopModes = new LinkedHashSet<QOPMode>(props.getQopModes());
        this.opaque = props.getOpaque();
        this.credentials = new LinkedHashMap<String, String>(props.getCredentialsMap());
        this.isUseCredentialsVariable = props.isUseCredentialsVariable();
        this.credentialsVariable = props.getCredentialsVariable();
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public Set<Algorithm> getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(Set<Algorithm> algorithms) {
        this.algorithms = algorithms;
    }

    public Set<QOPMode> getQopModes() {
        return this.qopModes;
    }

    public void setQopModes(Set<QOPMode> qopModes) {
        this.qopModes = qopModes;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public Map<String, String> getCredentialsMap() {
        return this.credentials;
    }

    public void setCredentialsMap(Map<String, String> credentials) {
        this.credentials = credentials;
    }

    public boolean isUseCredentialsVariable() {
        return this.isUseCredentialsVariable;
    }

    public void setUseCredentialsVariable(boolean isUseCredentialsVariable) {
        this.isUseCredentialsVariable = isUseCredentialsVariable;
    }

    public String getCredentialsVariable() {
        return this.credentialsVariable;
    }

    public void setCredentialsVariable(String credentialsVariable) {
        this.credentialsVariable = credentialsVariable;
    }

    public DigestHttpAuthProperties clone() {
        return new DigestHttpAuthProperties(this);
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("authType", (Object)this.getAuthType());
        purgedProperties.put("algorithms", this.algorithms);
        purgedProperties.put("qopModes", this.qopModes);
        purgedProperties.put("credentialsCount", this.credentials.size());
        return purgedProperties;
    }

    public static enum Algorithm {
        MD5("MD5"),
        MD5_SESS("MD5-sess");

        private String value;

        private Algorithm(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum QOPMode {
        AUTH("auth"),
        AUTH_INT("auth-int");

        private String value;

        private QOPMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

