/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.serverlog;

import com.mirth.connect.plugins.serverlog.ServerLogProvider;
import com.mirth.connect.server.logging.MirthLog4jFilter;
import java.io.Serializable;
import java.util.Date;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.util.Strings;

public class ArrayAppender
extends AbstractAppender {
    private ServerLogProvider serverLogProvider;

    public ArrayAppender(ServerLogProvider serverLogProvider, Layout<? extends Serializable> layout) {
        super(serverLogProvider.getClass().getName(), (Filter)new MirthLog4jFilter(), layout, true, Property.EMPTY_ARRAY);
        this.serverLogProvider = serverLogProvider;
    }

    public void append(LogEvent logEvent) {
        int line;
        if (this.getLayout() == null) {
            this.getHandler().error("No layout for appender " + this.getName(), logEvent, null);
            return;
        }
        String level = String.valueOf(logEvent.getLevel());
        Date date = new Date(logEvent.getTimeMillis());
        String threadName = logEvent.getThreadName();
        String category = logEvent.getLoggerName();
        String message = logEvent.getMessage().getFormattedMessage();
        String lineNumber = "?";
        StackTraceElement source = logEvent.getSource();
        if (source != null && (line = source.getLineNumber()) >= 0) {
            lineNumber = Integer.toString(line);
        }
        String throwableInformation = null;
        if (logEvent.getThrown() != null) {
            String[] completeLogTrace = Throwables.toStringList((Throwable)logEvent.getThrown()).toArray(Strings.EMPTY_ARRAY);
            StringBuffer logText = new StringBuffer();
            for (String aCompleteLogTrace : completeLogTrace) {
                logText.append(aCompleteLogTrace);
            }
            throwableInformation = logText.toString();
        }
        this.serverLogProvider.newServerLogReceived(level, date, threadName, category, lineNumber, message, throwableInformation);
    }
}

