/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.serverlog;

import com.mirth.connect.plugins.serverlog.ServerLogController;
import com.mirth.connect.plugins.serverlog.ServerLogItem;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;

public class DefaultServerLogController
extends ServerLogController {
    private static int LOG_SIZE = 100;
    private static LinkedList<ServerLogItem> serverLogs = new LinkedList();

    protected DefaultServerLogController() {
    }

    @Override
    public synchronized void addLogItem(ServerLogItem logItem) {
        if (serverLogs.size() == LOG_SIZE) {
            serverLogs.removeLast();
        }
        serverLogs.addFirst(logItem);
    }

    @Override
    public List<ServerLogItem> getServerLogs(int fetchSize, Long lastLogId) {
        LinkedList serverLogsCloned = new LinkedList();
        try {
            serverLogsCloned = (LinkedList)SerializationUtils.clone(serverLogs);
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        ArrayList<ServerLogItem> newServerLogEntries = new ArrayList<ServerLogItem>();
        for (ServerLogItem logItem : serverLogsCloned) {
            if (lastLogId != null && lastLogId >= logItem.getId()) continue;
            newServerLogEntries.add(logItem);
            if (newServerLogEntries.size() < fetchSize) continue;
            break;
        }
        return newServerLogEntries;
    }
}

