/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.pdfboxout.PdfBoxLinkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxReplacedElement;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.swing.ImageMapParser;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.w3c.dom.Element;

public class PdfBoxPDFReplacedElement
implements PdfBoxReplacedElement,
PdfBoxLinkManager.IPdfBoxElementWithShapedLinks {
    private final PDFormXObject _srcFormObject;
    private final float _width;
    private final float _height;
    private final Map<Shape, String> _imageMap;
    private Point _location = new Point(0, 0);

    private PdfBoxPDFReplacedElement(PDFormXObject srcForm, Element e, Box box, CssContext ctx, SharedContext shared, float w, float h) {
        this._srcFormObject = srcForm;
        this._width = w;
        this._height = h;
        this._imageMap = ImageMapParser.findAndParseMap((Element)e, (SharedContext)shared);
    }

    private static int parsePage(Element e) {
        if (e.getAttribute("page").isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(e.getAttribute("page")) - 1;
        }
        catch (NumberFormatException e1) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.EXCEPTION_UNABLE_TO_PARSE_PAGE_OF_IMG_TAG_WITH_PDF, (Throwable)e1);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PdfBoxPDFReplacedElement create(PDDocument target, byte[] pdfBytes, Element e, Box box, CssContext ctx, SharedContext shared) {
        try (PDDocument srcDocument = PDDocument.load((byte[])pdfBytes);){
            int pageNo = PdfBoxPDFReplacedElement.parsePage(e);
            if (pageNo >= srcDocument.getNumberOfPages()) {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.LOAD_PAGE_DOES_NOT_EXIST_FOR_PDF_IN_IMG_TAG);
                PdfBoxPDFReplacedElement pdfBoxPDFReplacedElement2 = null;
                return pdfBoxPDFReplacedElement2;
            }
            PDPage page = srcDocument.getPage(pageNo);
            float conversion = 1.3333334f;
            float width = page.getMediaBox().getWidth() * (float)shared.getDotsPerPixel() * conversion;
            float height = page.getMediaBox().getHeight() * (float)shared.getDotsPerPixel() * conversion;
            LayerUtility util = new LayerUtility(target);
            PDFormXObject formXObject = util.importPageAsForm(srcDocument, page);
            PdfBoxPDFReplacedElement pdfBoxPDFReplacedElement = new PdfBoxPDFReplacedElement(formXObject, e, box, ctx, shared, width, height);
            return pdfBoxPDFReplacedElement;
        }
        catch (InvalidPasswordException e1) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.EXCEPTION_TRIED_TO_OPEN_A_PASSWORD_PROTECTED_DOCUMENT_AS_SRC_FOR_IMG, (Throwable)e1);
            return null;
        }
        catch (IOException e1) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.EXCEPTION_COULD_NOT_READ_PDF_AS_SRC_FOR_IMG, (Throwable)e1);
        }
        return null;
    }

    public int getIntrinsicWidth() {
        return (int)this._width;
    }

    public int getIntrinsicHeight() {
        return (int)this._height;
    }

    public Point getLocation() {
        return this._location;
    }

    public void setLocation(int x, int y) {
        this._location = new Point(x, y);
    }

    @Override
    public Map<Shape, String> getLinkMap() {
        return this._imageMap;
    }

    public void detach(LayoutContext c) {
    }

    public boolean isRequiresInteractivePaint() {
        return false;
    }

    @Override
    public void paint(RenderingContext c, PdfBoxOutputDevice outputDevice, BlockBox box) {
        Rectangle contentBounds = box.getContentAreaEdge(box.getAbsX(), box.getAbsY(), (CssContext)c);
        outputDevice.drawPdfAsImage(this._srcFormObject, contentBounds, this.getIntrinsicWidth(), this.getIntrinsicHeight());
    }

    public int getBaseline() {
        return 0;
    }

    public boolean hasBaseline() {
        return false;
    }
}

