/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.shared.model;

import java.util.Date;
import java.util.Objects;

public class MessageStatisticsTimeseries {
    private Long id;
    private String channelId;
    private String connectorId;
    private Date ts;
    private Integer bucketSizeMinutes;
    private Integer received;
    private Integer filtered;
    private Integer queued;
    private Integer sent;
    private Integer error;
    private String serverId;

    public MessageStatisticsTimeseries() {
    }

    public MessageStatisticsTimeseries(MessageStatisticsTimeseries messageStatisticsTimeseries) {
        if (messageStatisticsTimeseries == null) {
            throw new IllegalArgumentException("Source MessageStatisticsTimeseries cannot be null");
        }
        this.id = messageStatisticsTimeseries.getId();
        this.serverId = messageStatisticsTimeseries.getServerId();
        this.channelId = messageStatisticsTimeseries.getChannelId();
        this.connectorId = messageStatisticsTimeseries.getConnectorId();
        this.ts = messageStatisticsTimeseries.getTs() == null ? null : new Date(messageStatisticsTimeseries.getTs().getTime());
        this.bucketSizeMinutes = messageStatisticsTimeseries.getBucketSizeMinutes();
        this.received = messageStatisticsTimeseries.getReceived();
        this.filtered = messageStatisticsTimeseries.getFiltered();
        this.queued = messageStatisticsTimeseries.getQueued();
        this.sent = messageStatisticsTimeseries.getSent();
        this.error = messageStatisticsTimeseries.getError();
    }

    public MessageStatisticsTimeseries(String string, String string2, Date date, int n, String string3) {
        this.channelId = string;
        this.connectorId = string2;
        this.ts = date;
        this.bucketSizeMinutes = n;
        this.serverId = string3;
        this.normalize();
    }

    public void normalize() {
        if (this.connectorId == null) {
            this.connectorId = "";
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String string) {
        this.channelId = string;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public void setConnectorId(String string) {
        this.connectorId = string;
    }

    public Date getTs() {
        return this.ts;
    }

    public void setTs(Date date) {
        this.ts = date;
    }

    public Integer getBucketSizeMinutes() {
        return this.bucketSizeMinutes;
    }

    public void setBucketSizeMinutes(Integer n) {
        this.bucketSizeMinutes = n;
    }

    public Integer getReceived() {
        return this.received;
    }

    public void setReceived(Integer n) {
        this.received = n;
    }

    public Integer getFiltered() {
        return this.filtered;
    }

    public void setFiltered(Integer n) {
        this.filtered = n;
    }

    public Integer getQueued() {
        return this.queued;
    }

    public void setQueued(Integer n) {
        this.queued = n;
    }

    public Integer getSent() {
        return this.sent;
    }

    public void setSent(Integer n) {
        this.sent = n;
    }

    public Integer getError() {
        return this.error;
    }

    public void setError(Integer n) {
        this.error = n;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String string) {
        this.serverId = string;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageStatisticsTimeseries)) {
            return false;
        }
        MessageStatisticsTimeseries messageStatisticsTimeseries = (MessageStatisticsTimeseries)object;
        return Objects.equals(this.serverId, messageStatisticsTimeseries.serverId) && Objects.equals(this.channelId, messageStatisticsTimeseries.channelId) && Objects.equals(this.connectorId, messageStatisticsTimeseries.connectorId) && Objects.equals(this.ts, messageStatisticsTimeseries.ts) && Objects.equals(this.bucketSizeMinutes, messageStatisticsTimeseries.bucketSizeMinutes);
    }

    public int hashCode() {
        return Objects.hash(this.serverId, this.channelId, this.connectorId, this.ts, this.bucketSizeMinutes);
    }

    public String toString() {
        return "MessageStatisticsTimeseries{id=" + this.id + ", serverId='" + this.serverId + "', channelId='" + this.channelId + "', connectorId='" + this.connectorId + "', ts=" + String.valueOf(this.ts) + ", bucketSizeMinutes=" + this.bucketSizeMinutes + ", received=" + this.received + ", filtered=" + this.filtered + ", queued=" + this.queued + ", sent=" + this.sent + ", error=" + this.error + "}";
    }

    public static class Builder {
        private final MessageStatisticsTimeseries m = new MessageStatisticsTimeseries();

        public Builder id(Long l) {
            this.m.id = l;
            return this;
        }

        public Builder channelId(String string) {
            this.m.channelId = string;
            return this;
        }

        public Builder connectorId(String string) {
            this.m.connectorId = string;
            return this;
        }

        public Builder ts(Date date) {
            this.m.ts = date;
            return this;
        }

        public Builder bucket(int n) {
            this.m.bucketSizeMinutes = n;
            return this;
        }

        public Builder received(int n) {
            this.m.received = n;
            return this;
        }

        public Builder filtered(int n) {
            this.m.filtered = n;
            return this;
        }

        public Builder queued(int n) {
            this.m.queued = n;
            return this;
        }

        public Builder sent(int n) {
            this.m.sent = n;
            return this;
        }

        public Builder error(int n) {
            this.m.error = n;
            return this;
        }

        public Builder serverId(String string) {
            this.m.serverId = string;
            return this;
        }

        public MessageStatisticsTimeseries build() {
            this.m.normalize();
            return this.m;
        }
    }
}

