/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.shared.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class MessageTrendsProperties {
    public static final String KEY_ENABLED = "messagetrends.enabled";
    public static final String KEY_RESOLUTIONS = "messagetrends.dashboard.defaultResolutions";
    public static final String KEY_RANGE = "messagetrends.dashboard.defaultTimeRange";
    public static final List<Integer> ALLOWED_RESOLUTIONS_LIST = Arrays.asList(1, 5, 15, 60, 1440);
    public static final Set<Integer> ALLOWED_RESOLUTIONS = new HashSet<Integer>(ALLOWED_RESOLUTIONS_LIST);
    private boolean enabled;
    private List<Integer> defaultResolutions;
    private String defaultTimeRange;

    public MessageTrendsProperties() {
        this(false, ALLOWED_RESOLUTIONS_LIST, "last_24h");
    }

    public MessageTrendsProperties(boolean bl, List<Integer> list, String string) {
        this.enabled = bl;
        this.defaultResolutions = list;
        this.defaultTimeRange = string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public List<Integer> getDefaultResolutions() {
        return this.defaultResolutions;
    }

    public void setDefaultResolutions(List<Integer> list) {
        this.defaultResolutions = list;
    }

    public String getDefaultTimeRange() {
        return this.defaultTimeRange;
    }

    public void setDefaultTimeRange(String string) {
        this.defaultTimeRange = string;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.setProperty(KEY_ENABLED, Boolean.toString(this.enabled));
        if (this.defaultResolutions != null && !this.defaultResolutions.isEmpty()) {
            String string = this.defaultResolutions.stream().map(String::valueOf).collect(Collectors.joining(","));
            properties.setProperty(KEY_RESOLUTIONS, string);
        }
        if (this.defaultTimeRange != null) {
            properties.setProperty(KEY_RANGE, this.defaultTimeRange);
        }
        return properties;
    }

    public static MessageTrendsProperties fromProperties(Properties properties) {
        if (properties == null) {
            return MessageTrendsProperties.getDefault();
        }
        boolean bl = MessageTrendsProperties.parseBoolean(properties.getProperty(KEY_ENABLED), false);
        List<Object> list = MessageTrendsProperties.parseCsvIntList(properties.getProperty(KEY_RESOLUTIONS, ALLOWED_RESOLUTIONS_LIST.stream().map(String::valueOf).collect(Collectors.joining(",")))).stream().filter(ALLOWED_RESOLUTIONS::contains).collect(Collectors.toList());
        if (list.isEmpty()) {
            list = MessageTrendsProperties.getDefault().getDefaultResolutions();
        }
        String string = properties.getProperty(KEY_RANGE, "last_24h");
        return new MessageTrendsProperties(bl, list, string);
    }

    public static MessageTrendsProperties getDefault() {
        return new MessageTrendsProperties(false, ALLOWED_RESOLUTIONS_LIST, "last_24h");
    }

    private static boolean parseBoolean(String string, boolean bl) {
        String string2;
        if (string == null) {
            return bl;
        }
        switch (string2 = string.trim().toLowerCase()) {
            case "true": 
            case "1": 
            case "yes": 
            case "on": {
                return true;
            }
            case "false": 
            case "0": 
            case "no": 
            case "off": {
                return false;
            }
        }
        return bl;
    }

    private static List<Integer> parseCsvIntList(String string2) {
        return Arrays.stream(string2.split(",")).map(String::trim).filter(string -> !string.isEmpty()).map(Integer::valueOf).collect(Collectors.toList());
    }
}

