/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jms;

import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.util.DonkeyElement;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class JmsConnectorProperties
extends ConnectorProperties {
    private boolean useJndi;
    private String jndiProviderUrl;
    private String jndiInitialContextFactory;
    private String jndiConnectionFactoryName;
    private String connectionFactoryClass;
    private Map<String, String> connectionProperties;
    private String username;
    private String password;
    private String destinationName;
    private boolean topic;
    private String clientId;

    public JmsConnectorProperties() {
        this.useJndi = false;
        this.jndiProviderUrl = "";
        this.jndiInitialContextFactory = "";
        this.jndiConnectionFactoryName = "";
        this.connectionFactoryClass = "";
        this.connectionProperties = new LinkedHashMap<String, String>();
        this.username = "";
        this.password = "";
        this.destinationName = "";
        this.topic = false;
        this.clientId = "";
    }

    protected JmsConnectorProperties(JmsConnectorProperties props) {
        super((ConnectorProperties)props);
        this.useJndi = props.isUseJndi();
        this.jndiProviderUrl = props.getJndiProviderUrl();
        this.jndiInitialContextFactory = props.getJndiInitialContextFactory();
        this.jndiConnectionFactoryName = props.getJndiConnectionFactoryName();
        this.connectionFactoryClass = props.getConnectionFactoryClass();
        this.connectionProperties = props.getConnectionProperties();
        this.username = props.getUsername();
        this.password = props.getPassword();
        this.destinationName = props.getDestinationName();
        this.topic = props.isTopic();
        this.clientId = props.getClientId();
    }

    public String getName() {
        return null;
    }

    public String getProtocol() {
        return "JMS";
    }

    public String toFormattedString() {
        String newLine = "\n";
        StringBuilder builder = new StringBuilder();
        if (this.useJndi) {
            builder.append("PROVIDER URL: " + this.jndiProviderUrl + newLine);
            builder.append("INITIAL CONTEXT FACTORY: " + this.jndiInitialContextFactory + newLine);
            builder.append("CONNECTION FACTORY NAME: " + this.jndiConnectionFactoryName + newLine);
            builder.append("DESTINATION: " + this.destinationName + newLine);
        } else {
            builder.append("CONNECTION FACTORY CLASS: " + this.connectionFactoryClass + newLine);
            if (this.topic) {
                builder.append("TOPIC: " + this.destinationName + newLine);
            } else {
                builder.append("QUEUE: " + this.destinationName + newLine);
            }
        }
        if (!this.clientId.isEmpty()) {
            builder.append("CLIENT ID: " + this.clientId + newLine);
        }
        if (!this.username.isEmpty()) {
            builder.append("USERNAME: " + this.username + newLine);
        }
        if (!this.connectionProperties.isEmpty()) {
            builder.append(newLine + "[CONNECTION PROPERTIES]" + newLine);
            for (Map.Entry<String, String> property : this.connectionProperties.entrySet()) {
                builder.append(property.getKey() + ": " + property.getValue() + newLine);
            }
            builder.append(newLine);
        }
        return builder.toString();
    }

    public boolean isUseJndi() {
        return this.useJndi;
    }

    public void setUseJndi(boolean useJndi) {
        this.useJndi = useJndi;
    }

    public String getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.jndiProviderUrl = jndiProviderUrl;
    }

    public String getJndiInitialContextFactory() {
        return this.jndiInitialContextFactory;
    }

    public void setJndiInitialContextFactory(String jndiInitialContextFactory) {
        this.jndiInitialContextFactory = jndiInitialContextFactory;
    }

    public String getJndiConnectionFactoryName() {
        return this.jndiConnectionFactoryName;
    }

    public void setJndiConnectionFactoryName(String jndiConnectionFactoryName) {
        this.jndiConnectionFactoryName = jndiConnectionFactoryName;
    }

    public String getConnectionFactoryClass() {
        return this.connectionFactoryClass;
    }

    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.connectionFactoryClass = connectionFactoryClass;
    }

    public Map<String, String> getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(Map<String, String> connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public boolean isTopic() {
        return this.topic;
    }

    public void setTopic(boolean topic) {
        this.topic = topic;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        super.migrate3_1_0(element);
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("useJndi", this.useJndi);
        purgedProperties.put("connectionPropertyChars", this.connectionProperties.size());
        purgedProperties.put("topic", this.topic);
        return purgedProperties;
    }
}

