/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.destinationsetfilter;

import com.mirth.connect.model.Step;
import com.mirth.connect.util.ScriptBuilderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class DestinationSetFilterStep
extends Step {
    public static final String PLUGIN_POINT = "Destination Set Filter";
    private Behavior behavior;
    private List<Integer> metaDataIds;
    private String field;
    private Condition condition;
    private List<String> values;

    public DestinationSetFilterStep() {
        this.behavior = Behavior.REMOVE;
        this.metaDataIds = new ArrayList<Integer>();
        this.field = "";
        this.condition = Condition.EXISTS;
        this.values = new ArrayList<String>();
    }

    public DestinationSetFilterStep(DestinationSetFilterStep props) {
        super((Step)props);
        this.behavior = props.getBehavior();
        this.metaDataIds = new ArrayList<Integer>(props.getMetaDataIds());
        this.field = props.getField();
        this.condition = props.getCondition();
        this.values = new ArrayList<String>(props.getValues());
    }

    public String getScript(boolean loadFiles) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        script.append("if (");
        if (this.condition == Condition.EXISTS) {
            script.append("getArrayOrXmlLength(").append(this.field).append(") > 0) ");
        } else if (this.condition == Condition.NOT_EXIST) {
            script.append("getArrayOrXmlLength(").append(this.field).append(") == 0) ");
        } else if (this.condition == Condition.CONTAINS || this.condition == Condition.NOT_CONTAIN) {
            String conditionOperator;
            String equalsOperator;
            if (this.condition == Condition.CONTAINS) {
                equalsOperator = "!=";
                conditionOperator = "||";
            } else {
                equalsOperator = "==";
                conditionOperator = "&&";
            }
            if (this.values.size() > 0) {
                for (int i = 0; i < this.values.size(); ++i) {
                    script.append("(").append(this.field).append(".indexOf(").append(this.values.get(i)).append(") ").append(equalsOperator).append(" -1)");
                    if (i + 1 == this.values.size()) {
                        script.append(") ");
                        continue;
                    }
                    script.append(' ').append(conditionOperator).append(' ');
                }
            } else {
                script.append(this.field + ".indexOf(\"\") " + equalsOperator + " -1) ");
            }
        } else {
            String conditionOperator;
            String equalsOperator;
            if (this.condition == Condition.EQUALS) {
                equalsOperator = "==";
                conditionOperator = "||";
            } else {
                equalsOperator = "!=";
                conditionOperator = "&&";
            }
            if (this.values.size() > 0) {
                for (int i = 0; i < this.values.size(); ++i) {
                    script.append(this.field).append(" ").append(equalsOperator).append(" ").append(this.values.get(i));
                    if (i + 1 == this.values.size()) {
                        script.append(") ");
                        continue;
                    }
                    script.append(' ').append(conditionOperator).append(' ');
                }
            } else {
                script.append(this.field).append(' ').append(equalsOperator).append(" \"\") ");
            }
        }
        script.append("{\n\tdestinationSet.");
        if (this.behavior == Behavior.REMOVE) {
            script.append("remove");
        } else if (this.behavior == Behavior.REMOVE_ALL_EXCEPT) {
            script.append("removeAllExcept");
        } else {
            script.append("removeAll");
        }
        script.append('(');
        if (this.behavior != Behavior.REMOVE_ALL) {
            script.append('[').append(StringUtils.join(this.metaDataIds, (String)", ")).append(']');
        }
        script.append(");\n}\n");
        return script.toString();
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Behavior behavior) {
        this.behavior = behavior;
    }

    public List<Integer> getMetaDataIds() {
        return this.metaDataIds;
    }

    public void setMetaDataIds(List<Integer> metaDataIds) {
        this.metaDataIds = metaDataIds;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public String getType() {
        return PLUGIN_POINT;
    }

    public Step clone() {
        return new DestinationSetFilterStep(this);
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("behavior", this.behavior);
        purgedProperties.put("metaDataIdsCount", this.metaDataIds.size());
        purgedProperties.put("condition", this.condition);
        purgedProperties.put("valuesCount", this.values.size());
        return purgedProperties;
    }

    public static enum Behavior {
        REMOVE("the following"),
        REMOVE_ALL_EXCEPT("all except the following"),
        REMOVE_ALL("all");

        private String value;

        private Behavior(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Condition {
        EXISTS(false, "exists"),
        NOT_EXIST(false, "does not exist"),
        EQUALS(true, "equals"),
        NOT_EQUAL(true, "does not equal"),
        CONTAINS(true, "contains"),
        NOT_CONTAIN(true, "does not contain");

        private boolean valuesEnabled;
        private String presentTense;

        private Condition(boolean valuesEnabled, String presentTense) {
            this.valuesEnabled = valuesEnabled;
            this.presentTense = presentTense;
        }

        public boolean isValuesEnabled() {
            return this.valuesEnabled;
        }

        public String getPresentTense() {
            return this.presentTense;
        }

        public String toString() {
            return WordUtils.capitalizeFully((String)super.toString().replace('_', ' '));
        }
    }
}

