/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.util;

import com.opencsv.CSVReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CsvLineParser {
    private static final Logger logger = LogManager.getLogger(CsvLineParser.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map.Entry<String, String> parseLine(String string, int n) {
        try (CSVReader cSVReader = new CSVReader((Reader)new StringReader(string));){
            String[] stringArray = cSVReader.readNext();
            if (stringArray == null || stringArray.length < 2) {
                logger.debug("Skipping malformed CSV line at {}: '{}'", (Object)n, (Object)string);
                Map.Entry<String, String> entry = null;
                return entry;
            }
            String string2 = stringArray[0].trim();
            String string3 = stringArray[1].trim();
            if (string2.isEmpty() || string3.isEmpty()) {
                logger.debug("Skipping line {} due to empty key or value: '{}'", (Object)n, (Object)string);
                Map.Entry<String, String> entry = null;
                return entry;
            }
            AbstractMap.SimpleEntry<String, String> simpleEntry = new AbstractMap.SimpleEntry<String, String>(string2, string3);
            return simpleEntry;
        }
        catch (Exception exception) {
            logger.debug("Failed to parse line {}: '{}'. Error: {}", (Object)n, (Object)string, (Object)exception.getMessage());
            return null;
        }
    }
}

