/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.text.DateFormat;
import java.util.List;

public class JsonUtils {
    private static final ObjectMapper mapper = JsonUtils.createDefaultMapper();

    private static ObjectMapper createDefaultMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true));
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return objectMapper;
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static <T> T fromJson(String string, Class<T> clazz) throws Exception {
        return (T)mapper.readValue(string, clazz);
    }

    public static String toJson(Object object) throws Exception {
        return mapper.writeValueAsString(object);
    }

    public static String toJsonPretty(Object object) throws Exception {
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
    }

    public static <T> List<T> fromJsonList(String string, Class<T> clazz) {
        try {
            return (List)mapper.readValue(string, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new RuntimeException("Failed to deserialize JSON list", jsonProcessingException);
        }
    }
}

