/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.model.event;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.text.WordUtils;

@XStreamAlias(value="connectionStatusEventType")
public enum ConnectionStatusEventType {
    IDLE(true),
    READING(true),
    WRITING(true),
    POLLING(true),
    RECEIVING(true),
    SENDING(true),
    WAITING_FOR_RESPONSE(true),
    CONNECTED(true),
    CONNECTING(true),
    DISCONNECTED(false),
    INFO(false),
    FAILURE(false);

    private static ConnectionStatusEventType[] priority;
    private boolean state;

    private ConnectionStatusEventType(boolean state) {
        this.state = state;
    }

    public List<ConnectionStatusEventType> getConnectorStates() {
        ArrayList<ConnectionStatusEventType> states = new ArrayList<ConnectionStatusEventType>();
        for (ConnectionStatusEventType type : ConnectionStatusEventType.values()) {
            if (!type.isState()) continue;
            states.add(type);
        }
        return states;
    }

    public boolean isState() {
        return this.state;
    }

    public String toString() {
        return WordUtils.capitalizeFully((String)super.toString().replace("_", " "));
    }

    public static ConnectionStatusEventType compare(ConnectionStatusEventType status1, ConnectionStatusEventType status2) {
        if (status1 == null && status2 != null) {
            return status2;
        }
        if (status2 == null && status1 != null) {
            return status1;
        }
        if (status1.equals((Object)status2)) {
            return status1;
        }
        for (ConnectionStatusEventType statusType : priority) {
            if (!statusType.equals((Object)status1) && !statusType.equals((Object)status2)) continue;
            return statusType;
        }
        return IDLE;
    }

    static {
        priority = new ConnectionStatusEventType[]{SENDING, RECEIVING, WRITING, READING, POLLING, CONNECTED, WAITING_FOR_RESPONSE, CONNECTING, IDLE};
    }
}

