/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class DateParser {
    private static final String[] DEFAULT_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss:SSS", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "EEE MMM dd HH:mm:ss:SSS zzz yyyy", "EEE MMM dd HH:mm:ss.SSS zzz yyyy", "EEE MMM dd HH:mm:ss zzz yyyy", "EEE MMM dd zzz yyyy", "dd-MMM-yyyy HH:mm:ss:SSS", "dd-MMM-yyyy HH:mm:ss.SSS", "dd-MMM-yyyy HH:mm:ss", "yyyy-MM-dd", "yyyy MM dd", "yyyy.MM.dd", "MM-dd-yyyy", "MM dd yyyy", "MM.dd.yyyy", "HH:mm:ss:SSS", "HH:mm:ss.SSS", "HH:mm:ss", "yyyyMMddHHmmssSSS", "yyyyMMddHHmmss", "yyyyMMddHHmm", "hh:mm aa"};
    private List<String> patterns = Arrays.asList(DEFAULT_PATTERNS);

    public void addPattern(String pattern) {
        this.patterns.add(pattern);
    }

    public Calendar parse(String dateString) throws DateParserException {
        Calendar date = Calendar.getInstance();
        for (String pattern : this.patterns) {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            try {
                date.setTime(format.parse(dateString));
                return date;
            }
            catch (ParseException parseException) {
            }
        }
        throw new DateParserException("Unrecognized date format");
    }

    public class DateParserException
    extends Exception {
        public DateParserException(String message) {
            super(message);
        }
    }
}

