/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.util.xstream;

import com.mirth.connect.donkey.model.channel.CronProperty;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.DeployedStateEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.MessageEventType;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.donkey.util.xstream.ConcurrentHashMapConverter;
import com.mirth.connect.donkey.util.xstream.DonkeyMapperWrapper;
import com.mirth.connect.donkey.util.xstream.PropertiesConverter;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;
import com.thoughtworks.xstream.io.xml.XppReader;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class XStreamSerializer
implements Serializer {
    private static final Class<?>[] annotatedClasses = new Class[]{Attachment.class, DeployedStateEventType.class, ConnectionStatusEventType.class, ConnectorMessage.class, CronProperty.class, ErrorEventType.class, Message.class, MessageEventType.class, Response.class};
    private XStream xstream;
    private ClassLoader classLoader;

    public XStreamSerializer() {
        this(1001, null, null);
    }

    public XStreamSerializer(int xstreamMode, final DonkeyMapperWrapper mapperWrapper, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.xstream = mapperWrapper != null ? new XStream((HierarchicalStreamDriver)new Xpp3Driver()){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return mapperWrapper.wrapMapper(next);
            }
        } : new XStream((HierarchicalStreamDriver)new Xpp3Driver());
        this.xstream.allowTypes(new String[]{"java.awt.Color"});
        this.xstream.allowTypes(new Class[]{Mapper.Null.class});
        this.xstream.allowTypesByWildcard(new String[]{"com.mirth.connect.client.core.**", "com.mirth.connect.connectors.**", "com.mirth.connect.model.**", "com.mirth.connect.plugins.**", "com.mirth.connect.util.**", "com.mirth.connect.userutil.**", "com.mirth.connect.donkey.model.**", "com.mirth.connect.donkey.util.**", "com.mirth.connect.jsonbuilder.**", "com.mirth.generator.model.**", "java.security.**", "com.google.common.collect.Immutable**"});
        if (classLoader != null) {
            this.xstream.setClassLoader(classLoader);
        }
        this.xstream.registerConverter((Converter)new ConcurrentHashMapConverter(this.xstream.getMapper()));
        this.xstream.registerConverter((Converter)new PropertiesConverter());
        this.xstream.setMode(xstreamMode);
        this.xstream.processAnnotations((Class[])annotatedClasses);
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String serialize(Object object) {
        try {
            return this.xstream.toXML(object);
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    @Override
    public <T> T deserialize(String serializedObject, Class<T> expectedClass) {
        try {
            return (T)this.xstream.fromXML(serializedObject);
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    @Override
    public Class<?> getClass(String serializedObject) {
        try {
            return HierarchicalStreams.readClassType((HierarchicalStreamReader)new XppReader((Reader)new StringReader(serializedObject), (XmlPullParser)new MXParser()), (Mapper)this.getXStream().getMapper());
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    public XStream getXStream() {
        return this.xstream;
    }
}

