/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.hl7v3;

import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptorFactory;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReader;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReceiver;
import com.mirth.connect.plugins.datatypes.hl7v3.HL7V3BatchProperties;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.message.DebuggableBatchAdaptor;
import com.mirth.connect.server.message.DebuggableBatchAdaptorFactory;
import com.mirth.connect.server.userutil.SourceMap;
import com.mirth.connect.server.util.CompiledScriptCache;
import com.mirth.connect.server.util.javascript.JavaScriptExecutorException;
import com.mirth.connect.server.util.javascript.JavaScriptScopeUtil;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class HL7V3BatchAdaptor
extends DebuggableBatchAdaptor {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private BufferedReader bufferedReader;

    public HL7V3BatchAdaptor(DebuggableBatchAdaptorFactory factory, SourceConnector sourceConnector, BatchRawMessage batchRawMessage) {
        super((BatchAdaptorFactory)factory, sourceConnector, batchRawMessage);
    }

    public void cleanup() throws BatchMessageException {
    }

    protected String getNextMessage(int batchSequenceId) throws Exception {
        if (this.batchRawMessage.getBatchMessageSource() instanceof BatchMessageReader) {
            if (batchSequenceId == 1) {
                BatchMessageReader batchMessageReader = (BatchMessageReader)this.batchRawMessage.getBatchMessageSource();
                this.bufferedReader = new BufferedReader(batchMessageReader.getReader());
            }
            return this.getMessageFromReader();
        }
        if (this.batchRawMessage.getBatchMessageSource() instanceof BatchMessageReceiver) {
            return this.getMessageFromReceiver((BatchMessageReceiver)this.batchRawMessage.getBatchMessageSource());
        }
        return null;
    }

    private String getMessageFromReceiver(BatchMessageReceiver batchMessageReceiver) throws Exception {
        byte[] bytes = null;
        if (batchMessageReceiver.canRead()) {
            try {
                bytes = batchMessageReceiver.readBytes();
            }
            finally {
                batchMessageReceiver.readCompleted();
            }
            if (bytes != null) {
                return batchMessageReceiver.getStringFromBytes(bytes);
            }
        }
        return null;
    }

    private String getMessageFromReader() throws Exception {
        HL7V3BatchProperties batchProperties = (HL7V3BatchProperties)this.getBatchProperties();
        HL7V3BatchProperties.SplitType splitType = batchProperties.getSplitType();
        if (splitType == HL7V3BatchProperties.SplitType.JavaScript) {
            if (StringUtils.isEmpty((CharSequence)batchProperties.getBatchScript())) {
                throw new BatchMessageException("No batch script was set.");
            }
            try {
                final String batchScriptId = ScriptController.getScriptId((String)"Batch", (String)this.sourceConnector.getChannelId());
                Boolean debug = ((DebuggableBatchAdaptorFactory)this.getFactory()).isDebug();
                MirthContextFactory contextFactory = this.getContextFactoryAndRecompile(this.contextFactoryController, debug, batchScriptId, batchProperties.getBatchScript());
                this.triggerDebug(debug);
                String result = (String)JavaScriptUtil.execute((JavaScriptTask)new JavaScriptTask<String>(contextFactory, "HL7 v3 Batch Adaptor", this.sourceConnector){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public String doCall() throws Exception {
                        Script compiledScript = CompiledScriptCache.getInstance().getCompiledScript(batchScriptId);
                        if (compiledScript == null) {
                            HL7V3BatchAdaptor.this.logger.error("Batch script could not be found in cache");
                            return null;
                        }
                        Logger scriptLogger = LogManager.getLogger((String)"Batch".toLowerCase());
                        try {
                            Scriptable scope = JavaScriptScopeUtil.getBatchProcessorScope((ContextFactory)this.getContextFactory(), (Object)scriptLogger, (String)HL7V3BatchAdaptor.this.sourceConnector.getChannelId(), (String)HL7V3BatchAdaptor.this.sourceConnector.getChannel().getName(), HL7V3BatchAdaptor.this.getScopeObjects(HL7V3BatchAdaptor.this.bufferedReader));
                            String string = (String)Context.jsToJava((Object)this.executeScript(compiledScript, scope), String.class);
                            return string;
                        }
                        finally {
                            Context.exit();
                        }
                    }
                });
                if (StringUtils.isEmpty((CharSequence)result)) {
                    return null;
                }
                return result;
            }
            catch (JavaScriptExecutorException e) {
                this.logger.error((Object)e.getCause());
            }
            catch (Throwable e) {
                this.logger.error((Object)e);
            }
        } else {
            throw new BatchMessageException("No valid batch splitting method configured");
        }
        return null;
    }

    private Map<String, Object> getScopeObjects(Reader in) {
        HashMap<String, Object> scopeObjects = new HashMap<String, Object>();
        scopeObjects.put("reader", in);
        scopeObjects.put("sourceMap", new SourceMap(Collections.unmodifiableMap(this.batchRawMessage.getSourceMap())));
        return scopeObjects;
    }
}

