-- Derby Migration script for Lookup Table Management System

-- Create LOOKUP_GROUP table
CREATE TABLE LOOKUP_GROUP (
    ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    NAME VARCHAR(255) NOT NULL,
    DESCRIPTION CLOB,
    VERSION VARCHAR(50),
    CACHE_SIZE INTEGER DEFAULT 1000,
    CACHE_POLICY VARCHAR(50) DEFAULT 'LRU',
    CREATED_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UPDATED_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT PK_LOOKUP_GROUP PRIMARY KEY (ID),
    CONSTRAINT UQ_LOOKUP_GROUP_NAME UNIQUE (NAME)
);

-- Create LOOKUP_AUDIT table
CREATE TABLE LOOKUP_AUDIT (
    ID BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    GROUP_ID INTEGER NOT NULL,
    TABLE_NAME VARCHAR(255) NOT NULL,
    KEY_VALUE VARCHAR(255) NOT NULL,
    ACTION VARCHAR(50) NOT NULL,
    OLD_VALUE CLOB,
    NEW_VALUE CLOB,
    USER_ID VARCHAR(255),
    AUDIT_TIMESTAMP TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT PK_LOOKUP_AUDIT PRIMARY KEY (ID),
    CONSTRAINT FK_LOOKUP_AUDIT_GROUP FOREIGN KEY (GROUP_ID) REFERENCES LOOKUP_GROUP(ID) ON DELETE CASCADE
);

-- Create indexes for LOOKUP_AUDIT
CREATE INDEX IDX_LOOKUP_AUDIT_GROUP ON LOOKUP_AUDIT (GROUP_ID);
CREATE INDEX IDX_LOOKUP_AUDIT_KEY ON LOOKUP_AUDIT (TABLE_NAME, KEY_VALUE);

-- Create LOOKUP_STATISTICS table
CREATE TABLE LOOKUP_STATISTICS (
    GROUP_ID INTEGER NOT NULL,
    TOTAL_LOOKUPS BIGINT DEFAULT 0,
    CACHE_HITS BIGINT DEFAULT 0,
    LAST_ACCESSED TIMESTAMP,
    RESET_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT PK_LOOKUP_STATISTICS PRIMARY KEY (GROUP_ID),
    CONSTRAINT FK_LOOKUP_STATISTICS_GROUP FOREIGN KEY (GROUP_ID) REFERENCES LOOKUP_GROUP(ID) ON DELETE CASCADE
);