/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.dcm4che2.net.Association;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssociationReaper {
    private static final float MILLISECONDS = 1000.0f;
    private static final Logger log = LoggerFactory.getLogger(AssociationReaper.class);
    private static Timer timer = new Timer(true);
    private Map<Association, TimerTask> timerTasks = new ConcurrentHashMap<Association, TimerTask>();
    private final int period;

    public AssociationReaper(int period) {
        if (log.isDebugEnabled()) {
            log.debug("Check for idle Associations every " + (float)period / 1000.0f + "s.");
        }
        this.period = period;
    }

    public void register(final Association a) {
        log.debug("Start check for idle {}", (Object)a);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                a.checkIdle(System.currentTimeMillis());
            }
        };
        TimerTask previous = this.timerTasks.put(a, task);
        if (previous != null) {
            previous.cancel();
        }
        this.schedule(task);
    }

    private void schedule(TimerTask task) {
        try {
            timer.schedule(task, this.period, (long)this.period);
        }
        catch (IllegalStateException e) {
            timer = new Timer(true);
            timer.schedule(task, this.period, (long)this.period);
        }
    }

    public void unregister(Association a) {
        log.debug("Stop check for idle {}", (Object)a);
        TimerTask task = this.timerTasks.remove(a);
        if (task != null) {
            task.cancel();
        }
    }
}

