/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net.service;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.DicomServiceException;
import org.dcm4che2.net.DimseRSP;
import org.dcm4che2.net.SingleDimseRSP;
import org.dcm4che2.net.service.CFindSCP;
import org.dcm4che2.net.service.DicomService;
import org.dcm4che2.net.service.WriteMultiDimseRsp;

public class CFindService
extends DicomService
implements CFindSCP {
    private final Executor executor;

    public CFindService(String[] sopClasses, Executor executor) {
        super(sopClasses);
        this.executor = executor;
    }

    public CFindService(String sopClass, Executor executor) {
        super(sopClass);
        this.executor = executor;
    }

    @Override
    public void cfind(Association as, int pcid, DicomObject rq, DicomObject data) throws DicomServiceException, IOException {
        DicomObject cmdrsp = CommandUtils.mkRSP(rq, 0);
        DimseRSP rsp = this.doCFind(as, pcid, rq, data, cmdrsp);
        try {
            rsp.next();
        }
        catch (InterruptedException e) {
            throw new DicomServiceException(rq, 272);
        }
        cmdrsp = rsp.getCommand();
        if (CommandUtils.isPending(cmdrsp)) {
            as.registerCancelRQHandler(rq, rsp);
            this.executor.execute(new WriteMultiDimseRsp(as, pcid, rsp));
        } else {
            as.writeDimseRSP(pcid, cmdrsp, rsp.getDataset());
        }
    }

    protected DimseRSP doCFind(Association as, int pcid, DicomObject cmd, DicomObject data, DicomObject rsp) throws DicomServiceException {
        return new SingleDimseRSP(rsp);
    }
}

