/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.serverlog;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ServerLogItem
implements Serializable {
    public static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private String serverId;
    private Long id;
    private String level;
    private Date date;
    private String threadName;
    private String category;
    private String lineNumber;
    private String message;
    private String throwableInformation;

    public ServerLogItem() {
    }

    public ServerLogItem(String message) {
        this(null, null, null, null, null, null, null, message, null);
    }

    public ServerLogItem(String serverId, Long id, String level, Date date, String threadName, String category, String lineNumber, String message, String throwableInformation) {
        this.serverId = serverId;
        this.id = id;
        this.level = level;
        this.date = date;
        this.threadName = threadName;
        this.category = category;
        this.lineNumber = lineNumber;
        this.message = message;
        this.throwableInformation = throwableInformation;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getThrowableInformation() {
        return this.throwableInformation;
    }

    public void setThrowableInformation(String throwableInformation) {
        this.throwableInformation = throwableInformation;
    }

    public String toString() {
        if (this.id != null) {
            StringBuilder builder = new StringBuilder();
            builder.append('[').append(DATE_FORMAT.format(this.date)).append("]  ");
            builder.append(this.level);
            builder.append("  (").append(this.category);
            if (StringUtils.isNotBlank((CharSequence)this.lineNumber)) {
                builder.append(':').append(this.lineNumber);
            }
            builder.append("): ").append(this.message);
            if (StringUtils.isNotBlank((CharSequence)this.throwableInformation)) {
                builder.append('\n').append(this.throwableInformation);
            }
            return builder.toString();
        }
        return this.message;
    }
}

