/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.hl7v2;

import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptor;
import com.mirth.connect.model.datatype.SerializerProperties;
import com.mirth.connect.plugins.datatypes.hl7v2.ER7BatchAdaptor;
import com.mirth.connect.plugins.datatypes.hl7v2.HL7v2SerializationProperties;
import com.mirth.connect.server.message.DebuggableBatchAdaptorFactory;
import com.mirth.connect.util.StringUtil;
import java.util.regex.Pattern;

public class ER7BatchAdaptorFactory
extends DebuggableBatchAdaptorFactory {
    private Pattern lineBreakPattern;
    private String segmentDelimiter;

    public ER7BatchAdaptorFactory(SourceConnector sourceConnector, SerializerProperties serializerProperties) {
        super(sourceConnector, serializerProperties);
        Object pattern;
        HL7v2SerializationProperties serializationProperties = (HL7v2SerializationProperties)serializerProperties.getSerializationProperties();
        this.segmentDelimiter = StringUtil.unescape((String)serializationProperties.getSegmentDelimiter());
        if (serializationProperties.isConvertLineBreaks()) {
            pattern = "\r\n|\r|\n";
            if (!(this.segmentDelimiter.equals("\r") || this.segmentDelimiter.equals("\n") || this.segmentDelimiter.equals("\r\n"))) {
                pattern = (String)pattern + "|" + Pattern.quote(this.segmentDelimiter);
            }
        } else {
            pattern = Pattern.quote(this.segmentDelimiter);
        }
        this.lineBreakPattern = Pattern.compile((String)pattern);
    }

    public BatchAdaptor createBatchAdaptor(BatchRawMessage batchRawMessage) {
        ER7BatchAdaptor batchAdaptor = new ER7BatchAdaptor(this, this.sourceConnector, batchRawMessage);
        batchAdaptor.setBatchProperties(this.batchProperties);
        batchAdaptor.setSegmentDelimiter(this.segmentDelimiter);
        batchAdaptor.setLineBreakPattern(this.lineBreakPattern);
        return batchAdaptor;
    }
}

