/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.hl7v2;

import com.mirth.connect.donkey.server.message.batch.BatchStreamReader;
import com.mirth.connect.model.transmission.EOFCheckInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class ER7BatchStreamReader
extends BatchStreamReader {
    private int previousByte;

    public ER7BatchStreamReader(InputStream inputStream) {
        this(inputStream, new byte[0]);
    }

    public ER7BatchStreamReader(InputStream inputStream, byte[] endOfMessageBytes) {
        super((InputStream)new EOFCheckInputStream(inputStream, 3), endOfMessageBytes);
    }

    public void setInputStream(InputStream inputStream) {
        super.setInputStream((InputStream)new EOFCheckInputStream(inputStream, 3));
    }

    public void initialize() throws IOException {
        super.initialize();
        this.previousByte = -1;
    }

    public int getNextByte() throws IOException {
        if (this.previousByte == -1 || this.previousByte == 13 || this.previousByte == 10) {
            this.skipSegments();
        }
        return super.getNextByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] checkForIntermediateMessage(ByteArrayOutputStream capturedBytes, List<Byte> endBytesBuffer, int lastByte) throws IOException {
        if (this.previousByte == -1 || lastByte == 13 || lastByte == 10) {
            this.skipSegments();
            this.inputStream.mark(3);
            try {
                if (this.inputStream.read() == 77 && this.inputStream.read() == 83 && this.inputStream.read() == 72) {
                    if (endBytesBuffer != null) {
                        for (Byte bufferByte : endBytesBuffer) {
                            capturedBytes.write(bufferByte.byteValue());
                        }
                    }
                    Object object = capturedBytes.toByteArray();
                    return object;
                }
            }
            finally {
                this.inputStream.reset();
            }
        }
        this.previousByte = lastByte;
        return null;
    }

    private void skipSegments() throws IOException {
        this.inputStream.mark(1);
        int tempByte = this.inputStream.read();
        if (tempByte == 13 || tempByte == 10) {
            if (tempByte == 13) {
                this.inputStream.mark(1);
                if (this.inputStream.read() != 10) {
                    this.inputStream.reset();
                }
            }
            this.skipSegments();
            return;
        }
        this.inputStream.reset();
        this.inputStream.mark(3);
        tempByte = this.inputStream.read();
        if (!(tempByte != 70 && tempByte != 66 || (tempByte = this.inputStream.read()) != 72 && tempByte != 84 || this.inputStream.read() != 83)) {
            do {
                this.inputStream.mark(1);
            } while ((tempByte = this.inputStream.read()) != -1 && tempByte != 13 && tempByte != 10 && (this.endOfMessageBytes.length <= 0 || tempByte != this.endOfMessageBytes[0]));
            if (this.endOfMessageBytes.length > 0 && tempByte == this.endOfMessageBytes[0]) {
                this.inputStream.reset();
            }
            if (tempByte == 13) {
                this.inputStream.mark(1);
                if (this.inputStream.read() != 10) {
                    this.inputStream.reset();
                }
            }
            if (tempByte != -1) {
                this.skipSegments();
            }
        } else {
            this.inputStream.reset();
        }
    }
}

