/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.hl7v2;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLEncodedHL7Handler
extends DefaultHandler {
    private Logger logger = LogManager.getLogger(this.getClass());
    private static final String ID_DELIMETER = ".";
    private String segmentSeparator;
    private String fieldSeparator;
    private String repetitionSeparator;
    private String escapeCharacter;
    private String componentSeparator;
    private String subcomponentSeparator;
    private boolean encodeEntities = false;
    private boolean inElement = false;
    private int rootLevel = -1;
    private int previousDelimeterCount = -1;
    private int previousDelimiterLength = 1;
    private String[] previousFieldNameArray;
    private String[] previousComponentNameArray;
    private String[] previousSubcomponentNameArray;
    private StringBuilder output = new StringBuilder();

    public XMLEncodedHL7Handler(String segmentSeparator, String fieldSeparator, String componentSeparator, String repetitionSeparator, String escapeCharacter, String subcomponentSeparator, boolean encodeEntities) {
        this.segmentSeparator = segmentSeparator;
        this.fieldSeparator = fieldSeparator;
        this.componentSeparator = componentSeparator;
        this.repetitionSeparator = repetitionSeparator;
        this.escapeCharacter = escapeCharacter;
        this.subcomponentSeparator = subcomponentSeparator;
        this.encodeEntities = encodeEntities;
        this.logger.trace("initialized ER7-to-XML handler: fieldSeparator=" + fieldSeparator + ", componentSeparator=" + componentSeparator + ", repetitionSeparator=" + repetitionSeparator + ", escapeCharacter=" + escapeCharacter + ", subcomponentSeparator=" + subcomponentSeparator);
    }

    public StringBuilder getOutput() {
        return this.output;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.logger.trace("starting element: " + localName);
        this.inElement = true;
        String[] localNameArray = StringUtils.split((String)localName, (String)ID_DELIMETER);
        if (this.rootLevel == -1) {
            this.rootLevel = localNameArray.length;
        }
        if (localNameArray.length == 1 && localNameArray[0].equals("HL7Message")) {
            this.rootLevel = 0;
            return;
        }
        if (localNameArray.length == 2 && this.isHeaderSegment(localNameArray[0]) && localNameArray[1].length() == 1 && (localNameArray[1].charAt(0) == '1' || localNameArray[1].charAt(0) == '2')) {
            this.previousFieldNameArray = localNameArray;
            return;
        }
        if (ArrayUtils.isEquals((Object)localNameArray, (Object)this.previousFieldNameArray)) {
            this.output.deleteCharAt(this.output.length() - 1);
            this.output.append(this.repetitionSeparator);
            this.previousComponentNameArray = null;
            return;
        }
        int currentDelimeterCount = localNameArray.length - 1;
        if (currentDelimeterCount == 1 && this.rootLevel <= 1) {
            int previousFieldId = 0;
            if (this.previousFieldNameArray != null) {
                previousFieldId = NumberUtils.toInt((String)this.previousFieldNameArray[1]);
            }
            int currentFieldId = NumberUtils.toInt((String)localNameArray[1]);
            for (int i = 1; i < currentFieldId - previousFieldId; ++i) {
                this.output.append(this.fieldSeparator);
            }
            this.previousFieldNameArray = localNameArray;
        } else if (currentDelimeterCount == 2 && this.rootLevel <= 2) {
            int previousComponentId = 0;
            if (this.previousComponentNameArray != null) {
                previousComponentId = NumberUtils.toInt((String)this.previousComponentNameArray[2]);
            }
            int currentComponentId = NumberUtils.toInt((String)localNameArray[2]);
            for (int i = 1; i < currentComponentId - previousComponentId; ++i) {
                this.output.append(this.componentSeparator);
                this.previousDelimiterLength = this.componentSeparator.length();
            }
            this.previousComponentNameArray = localNameArray;
        } else if (currentDelimeterCount == 3 && this.rootLevel <= 3) {
            int previousSubcomponentId = 0;
            if (this.previousSubcomponentNameArray != null) {
                previousSubcomponentId = NumberUtils.toInt((String)this.previousSubcomponentNameArray[3]);
            }
            int currentSubcomponentId = NumberUtils.toInt((String)localNameArray[3]);
            for (int i = 1; i < currentSubcomponentId - previousSubcomponentId; ++i) {
                this.output.append(this.subcomponentSeparator);
                this.previousDelimiterLength = this.subcomponentSeparator.length();
            }
            this.previousSubcomponentNameArray = localNameArray;
        }
        if (currentDelimeterCount == 0) {
            this.output.append(localName);
            this.output.append(this.fieldSeparator);
            this.previousFieldNameArray = null;
        } else if (currentDelimeterCount == 1) {
            this.previousComponentNameArray = null;
        } else if (currentDelimeterCount == 2) {
            this.previousSubcomponentNameArray = null;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        int currentDelimeterCount;
        this.logger.trace("ending element: " + localName);
        this.inElement = false;
        String[] localNameArray = StringUtils.split((String)localName, (String)ID_DELIMETER);
        if (localNameArray.length == 1 && localNameArray[0].equals("HL7Message")) {
            return;
        }
        if (localNameArray.length == 2 && this.isHeaderSegment(localNameArray[0])) {
            if (localNameArray[1].length() == 1 && localNameArray[1].charAt(0) == '1') {
                this.fieldSeparator = String.valueOf(this.output.charAt(this.output.length() - 1));
                return;
            }
            if (localNameArray[1].length() == 1 && localNameArray[1].charAt(0) == '2') {
                CharSequence separators = this.output.subSequence(4, this.output.length());
                this.componentSeparator = String.valueOf(separators.charAt(0));
                this.repetitionSeparator = String.valueOf(separators.charAt(1));
                this.escapeCharacter = separators.length() > 2 ? String.valueOf(separators.charAt(2)) : "";
                String string = this.subcomponentSeparator = separators.length() > 3 ? String.valueOf(separators.charAt(3)) : "";
            }
        }
        if ((currentDelimeterCount = localNameArray.length - 1) > this.previousDelimeterCount) {
            this.previousDelimeterCount = currentDelimeterCount;
        } else if (currentDelimeterCount < this.previousDelimeterCount && this.previousDelimiterLength > 0) {
            this.output.deleteCharAt(this.output.length() - 1);
            this.previousDelimeterCount = currentDelimeterCount;
        }
        if (this.rootLevel == 0 || currentDelimeterCount >= this.rootLevel) {
            switch (currentDelimeterCount) {
                case 0: {
                    this.output.append(this.segmentSeparator);
                    break;
                }
                case 1: {
                    this.output.append(this.fieldSeparator);
                    break;
                }
                case 2: {
                    this.output.append(this.componentSeparator);
                    this.previousDelimiterLength = this.componentSeparator.length();
                    break;
                }
                case 3: {
                    this.output.append(this.subcomponentSeparator);
                    this.previousDelimiterLength = this.subcomponentSeparator.length();
                    break;
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String str = new String(ch, start, length);
        if (this.inElement && !str.equals(this.fieldSeparator)) {
            this.logger.trace("writing output: " + str);
            this.output.append(str);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.logger.trace("found ignorable whitespace: length=" + length);
    }

    private boolean isHeaderSegment(String segmentName) {
        return segmentName.length() == 3 && (segmentName.charAt(0) == 'M' && segmentName.charAt(1) == 'S' && segmentName.charAt(2) == 'H' || segmentName.charAt(1) == 'H' && segmentName.charAt(2) == 'S' && (segmentName.charAt(0) == 'B' || segmentName.charAt(0) == 'F'));
    }
}

