/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth.basic;

import com.mirth.connect.donkey.util.MessageMaps;
import com.mirth.connect.plugins.httpauth.AuthenticationResult;
import com.mirth.connect.plugins.httpauth.Authenticator;
import com.mirth.connect.plugins.httpauth.RequestInfo;
import com.mirth.connect.plugins.httpauth.basic.BasicAuthenticatorProvider;
import com.mirth.connect.plugins.httpauth.basic.BasicHttpAuthProperties;
import com.mirth.connect.server.channel.MirthMessageMaps;
import com.mirth.connect.server.util.TemplateValueReplacer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.http.HttpHeader;

public class BasicAuthenticator
extends Authenticator {
    private BasicAuthenticatorProvider provider;
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    protected Logger logger = LogManager.getLogger(this.getClass());
    private MessageMaps messageMaps;

    public BasicAuthenticator(BasicAuthenticatorProvider provider) {
        this.provider = provider;
        this.messageMaps = new MirthMessageMaps(provider.getConnector().getChannelId());
    }

    BasicAuthenticator(BasicAuthenticatorProvider provider, MessageMaps messageMaps) {
        this.provider = provider;
        this.messageMaps = messageMaps;
    }

    @Override
    public AuthenticationResult authenticate(RequestInfo request) {
        String method;
        String authHeader;
        int index;
        BasicHttpAuthProperties properties = this.getReplacedProperties(request);
        List<String> authHeaderList = request.getHeaders().get(HttpHeader.AUTHORIZATION.asString());
        if (CollectionUtils.isNotEmpty(authHeaderList) && (index = (authHeader = StringUtils.trimToEmpty((String)authHeaderList.iterator().next())).indexOf(32)) > 0 && StringUtils.equalsIgnoreCase((CharSequence)(method = authHeader.substring(0, index)), (CharSequence)"Basic")) {
            String credentials = StringUtils.trim((String)authHeader.substring(index));
            index = (credentials = new String(Base64.decodeBase64((String)credentials), StandardCharsets.ISO_8859_1)).indexOf(58);
            if (index > 0) {
                Map<String, String> credentialsSource;
                String username = credentials.substring(0, index);
                String password = credentials.substring(index + 1);
                if (StringUtils.equals((CharSequence)password, (CharSequence)(credentialsSource = this.getCredentials(properties)).get(username))) {
                    return AuthenticationResult.Success(username, properties.getRealm());
                }
            }
        }
        return AuthenticationResult.Challenged("Basic realm=\"" + properties.getRealm() + "\"");
    }

    private BasicHttpAuthProperties getReplacedProperties(RequestInfo request) {
        BasicHttpAuthProperties properties = new BasicHttpAuthProperties((BasicHttpAuthProperties)this.provider.getProperties());
        String channelId = this.provider.getConnector().getChannelId();
        String channelName = this.provider.getConnector().getChannel().getName();
        HashMap<String, Object> map = new HashMap<String, Object>();
        request.populateMap(map);
        properties.setRealm(this.replacer.replaceValues(properties.getRealm(), channelId, channelName, map));
        LinkedHashMap<String, String> credentials = new LinkedHashMap<String, String>();
        for (Map.Entry entry : properties.getCredentialsMap().entrySet()) {
            String username = this.replacer.replaceValues((String)entry.getKey(), channelId, channelName, map);
            if (!StringUtils.isNotBlank((CharSequence)username)) continue;
            credentials.put(username, this.replacer.replaceValues((String)entry.getValue(), channelId, channelName, map));
        }
        properties.setCredentialsMap(credentials);
        properties.setCredentialsVariable(this.replacer.replaceValues(properties.getCredentialsVariable()));
        return properties;
    }

    protected Map<String, String> getCredentials(BasicHttpAuthProperties properties) {
        HashMap<String, String> credentialsSource;
        block6: {
            if (properties.isUseCredentialsVariable()) {
                credentialsSource = new HashMap<String, String>();
                try {
                    Map source = (Map)this.messageMaps.get(properties.getCredentialsVariable(), null);
                    if (source != null) {
                        for (Map.Entry entry : source.entrySet()) {
                            credentialsSource.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                        }
                        break block6;
                    }
                    this.logger.warn("Credentials map variable '" + properties.getCredentialsVariable() + "' not found.");
                }
                catch (Exception e) {
                    this.logger.warn("Error getting credentials from map '" + properties.getCredentialsVariable() + "'.", (Throwable)e);
                }
            } else {
                credentialsSource = properties.getCredentialsMap();
            }
        }
        return credentialsSource;
    }
}

