/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth.javascript;

import com.mirth.connect.plugins.httpauth.AuthenticationResult;
import com.mirth.connect.plugins.httpauth.Authenticator;
import com.mirth.connect.plugins.httpauth.RequestInfo;
import com.mirth.connect.plugins.httpauth.javascript.JavaScriptAuthenticatorProvider;
import com.mirth.connect.plugins.httpauth.userutil.AuthStatus;
import com.mirth.connect.server.MirthJavascriptTransformerException;
import com.mirth.connect.server.userutil.SourceMap;
import com.mirth.connect.server.util.CompiledScriptCache;
import com.mirth.connect.server.util.javascript.JavaScriptScopeUtil;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class JavaScriptAuthenticator
extends Authenticator {
    private static final CompiledScriptCache compiledScriptCache = CompiledScriptCache.getInstance();
    private Logger scriptLogger = LogManager.getLogger((String)"js-connector");
    private JavaScriptAuthenticatorProvider provider;

    public JavaScriptAuthenticator(JavaScriptAuthenticatorProvider provider) {
        this.provider = provider;
    }

    @Override
    public AuthenticationResult authenticate(RequestInfo request) throws Exception {
        return (AuthenticationResult)JavaScriptUtil.execute((JavaScriptTask)new JavaScriptAuthenticatorTask(request));
    }

    private class JavaScriptAuthenticatorTask
    extends JavaScriptTask<AuthenticationResult> {
        private RequestInfo request;

        public JavaScriptAuthenticatorTask(RequestInfo request) throws Exception {
            super(JavaScriptAuthenticator.this.provider.getContextFactory(), JavaScriptAuthenticator.this.provider.getConnector().getConnectorProperties().getName() + " Authenticator", JavaScriptAuthenticator.this.provider.getConnector());
            this.request = request;
        }

        public AuthenticationResult doCall() throws Exception {
            Script compiledScript = compiledScriptCache.getCompiledScript(JavaScriptAuthenticator.this.provider.getScriptId());
            if (compiledScript == null) {
                throw new Exception("Script not found in cache");
            }
            try {
                Scriptable scope = JavaScriptScopeUtil.getMessageReceiverScope((ContextFactory)this.getContextFactory(), (Object)JavaScriptAuthenticator.this.scriptLogger, (String)JavaScriptAuthenticator.this.provider.getConnector().getChannelId(), (String)JavaScriptAuthenticator.this.provider.getConnector().getChannel().getName());
                HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                this.request.populateMap(sourceMap);
                scope.put("sourceMap", scope, Context.javaToJS((Object)new SourceMap(sourceMap), (Scriptable)scope));
                for (AuthStatus status : AuthStatus.values()) {
                    scope.put(status.toString(), scope, Context.javaToJS((Object)((Object)status), (Scriptable)scope));
                }
                Object result = this.executeScript(compiledScript, scope);
                if (result != null && !(result instanceof Undefined)) {
                    if (result instanceof NativeJavaObject) {
                        Object object = ((NativeJavaObject)result).unwrap();
                        if (object instanceof AuthenticationResult) {
                            AuthenticationResult authenticationResult = (AuthenticationResult)object;
                            return authenticationResult;
                        }
                        if (object instanceof com.mirth.connect.plugins.httpauth.userutil.AuthenticationResult) {
                            AuthenticationResult authenticationResult = new AuthenticationResult((com.mirth.connect.plugins.httpauth.userutil.AuthenticationResult)object);
                            return authenticationResult;
                        }
                        if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                            AuthenticationResult authenticationResult = AuthenticationResult.Success();
                            return authenticationResult;
                        }
                    } else {
                        if (result instanceof AuthenticationResult) {
                            AuthenticationResult object = (AuthenticationResult)result;
                            return object;
                        }
                        if (result instanceof com.mirth.connect.plugins.httpauth.userutil.AuthenticationResult) {
                            AuthenticationResult object = new AuthenticationResult((com.mirth.connect.plugins.httpauth.userutil.AuthenticationResult)result);
                            return object;
                        }
                        if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                            AuthenticationResult object = AuthenticationResult.Success();
                            return object;
                        }
                        if (((Boolean)Context.jsToJava((Object)result, Boolean.class)).booleanValue()) {
                            AuthenticationResult object = AuthenticationResult.Success();
                            return object;
                        }
                    }
                }
            }
            catch (Exception e22) {
                MirthJavascriptTransformerException e22;
                if (e22 instanceof RhinoException) {
                    try {
                        String script = CompiledScriptCache.getInstance().getSourceScript(JavaScriptAuthenticator.this.provider.getScriptId());
                        int linenumber = ((RhinoException)e22).lineNumber();
                        String errorReport = JavaScriptUtil.getSourceCode((String)script, (int)linenumber, (int)0);
                        e22 = new MirthJavascriptTransformerException((RhinoException)e22, JavaScriptAuthenticator.this.provider.getConnector().getChannelId(), "Source", 0, JavaScriptAuthenticator.this.provider.getConnector().getConnectorProperties().getName(), errorReport);
                    }
                    catch (Exception ee) {
                        e22 = new MirthJavascriptTransformerException((RhinoException)e22, JavaScriptAuthenticator.this.provider.getConnector().getChannelId(), "Source", 0, JavaScriptAuthenticator.this.provider.getConnector().getConnectorProperties().getName(), null);
                    }
                }
                throw e22;
            }
            finally {
                Context.exit();
            }
            return AuthenticationResult.Failure();
        }
    }
}

