/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.http;

import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class HttpDispatcherProperties
extends ConnectorProperties
implements DestinationConnectorPropertiesInterface {
    private DestinationConnectorProperties destinationConnectorProperties;
    private String host;
    private boolean useProxyServer;
    private String proxyAddress;
    private String proxyPort;
    private String method;
    private Map<String, List<String>> headers;
    private Map<String, List<String>> parameters;
    private boolean useHeadersVariable;
    private String headersVariable;
    private boolean useParametersVariable;
    private String parametersVariable;
    private boolean responseXmlBody;
    private boolean responseParseMultipart;
    private boolean responseIncludeMetadata;
    private String responseBinaryMimeTypes;
    private boolean responseBinaryMimeTypesRegex;
    private boolean multipart;
    private boolean useAuthentication;
    private String authenticationType;
    private boolean usePreemptiveAuthentication;
    private String username;
    private String password;
    private String content;
    private String contentType;
    private boolean dataTypeBinary;
    private String charset;
    private String socketTimeout;

    public HttpDispatcherProperties() {
        this.destinationConnectorProperties = new DestinationConnectorProperties(false);
        this.host = "";
        this.useProxyServer = false;
        this.proxyAddress = "";
        this.proxyPort = "";
        this.method = "post";
        this.headers = new LinkedHashMap<String, List<String>>();
        this.useHeadersVariable = false;
        this.headersVariable = "";
        this.parameters = new LinkedHashMap<String, List<String>>();
        this.useParametersVariable = false;
        this.parametersVariable = "";
        this.responseXmlBody = false;
        this.responseParseMultipart = true;
        this.responseIncludeMetadata = false;
        this.responseBinaryMimeTypes = "application/.*(?<!json|xml)$|image/.*|video/.*|audio/.*";
        this.responseBinaryMimeTypesRegex = true;
        this.multipart = false;
        this.useAuthentication = false;
        this.authenticationType = "Basic";
        this.usePreemptiveAuthentication = false;
        this.username = "";
        this.password = "";
        this.content = "";
        this.contentType = "text/plain";
        this.dataTypeBinary = false;
        this.charset = "UTF-8";
        this.socketTimeout = "30000";
    }

    public HttpDispatcherProperties(HttpDispatcherProperties props) {
        super((ConnectorProperties)props);
        this.destinationConnectorProperties = new DestinationConnectorProperties(props.getDestinationConnectorProperties());
        this.host = props.getHost();
        this.useProxyServer = props.isUseProxyServer();
        this.proxyAddress = props.getProxyAddress();
        this.proxyPort = props.getProxyPort();
        this.method = props.getMethod();
        this.headers = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : props.getHeadersMap().entrySet()) {
            this.headers.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        this.useHeadersVariable = props.isUseHeadersVariable();
        this.headersVariable = props.getHeadersVariable();
        this.parameters = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : props.getParametersMap().entrySet()) {
            this.parameters.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        this.useParametersVariable = props.isUseParametersVariable();
        this.parametersVariable = props.getParametersVariable();
        this.responseXmlBody = props.isResponseXmlBody();
        this.responseParseMultipart = props.isResponseParseMultipart();
        this.responseIncludeMetadata = props.isResponseIncludeMetadata();
        this.responseBinaryMimeTypes = props.getResponseBinaryMimeTypes();
        this.responseBinaryMimeTypesRegex = props.isResponseBinaryMimeTypesRegex();
        this.multipart = props.isMultipart();
        this.useAuthentication = props.isUseAuthentication();
        this.authenticationType = props.getAuthenticationType();
        this.usePreemptiveAuthentication = props.isUsePreemptiveAuthentication();
        this.username = props.getUsername();
        this.password = props.getPassword();
        this.content = props.getContent();
        this.contentType = props.getContentType();
        this.dataTypeBinary = props.isDataTypeBinary();
        this.charset = props.getCharset();
        this.socketTimeout = props.getSocketTimeout();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isUseProxyServer() {
        return this.useProxyServer;
    }

    public void setUseProxyServer(boolean useProxyServer) {
        this.useProxyServer = useProxyServer;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public void setProxyAddress(String proxyAddress) {
        this.proxyAddress = proxyAddress;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Map<String, List<String>> getHeadersMap() {
        return this.headers;
    }

    public boolean isUseHeadersVariable() {
        return this.useHeadersVariable;
    }

    public void setUseHeadersVariable(boolean useHeadersVariable) {
        this.useHeadersVariable = useHeadersVariable;
    }

    public void setHeadersMap(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public String getHeadersVariable() {
        return this.headersVariable;
    }

    public void setHeadersVariable(String headerVariable) {
        this.headersVariable = headerVariable;
    }

    public Map<String, List<String>> getParametersMap() {
        return this.parameters;
    }

    public void setParametersMap(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public boolean isUseParametersVariable() {
        return this.useParametersVariable;
    }

    public void setUseParametersVariable(boolean useParametersVariable) {
        this.useParametersVariable = useParametersVariable;
    }

    public String getParametersVariable() {
        return this.parametersVariable;
    }

    public void setParametersVariable(String variableName) {
        this.parametersVariable = variableName;
    }

    public boolean isResponseXmlBody() {
        return this.responseXmlBody;
    }

    public void setResponseXmlBody(boolean responseXmlBody) {
        this.responseXmlBody = responseXmlBody;
    }

    public boolean isResponseParseMultipart() {
        return this.responseParseMultipart;
    }

    public void setResponseParseMultipart(boolean responseParseMultipart) {
        this.responseParseMultipart = responseParseMultipart;
    }

    public boolean isResponseIncludeMetadata() {
        return this.responseIncludeMetadata;
    }

    public void setResponseIncludeMetadata(boolean responseIncludeMetadata) {
        this.responseIncludeMetadata = responseIncludeMetadata;
    }

    public String getResponseBinaryMimeTypes() {
        return this.responseBinaryMimeTypes;
    }

    public void setResponseBinaryMimeTypes(String responseBinaryMimeTypes) {
        this.responseBinaryMimeTypes = responseBinaryMimeTypes;
    }

    public boolean isResponseBinaryMimeTypesRegex() {
        return this.responseBinaryMimeTypesRegex;
    }

    public void setResponseBinaryMimeTypesRegex(boolean responseBinaryMimeTypesRegex) {
        this.responseBinaryMimeTypesRegex = responseBinaryMimeTypesRegex;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public void setMultipart(boolean multipart) {
        this.multipart = multipart;
    }

    public boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean useAuthentication) {
        this.useAuthentication = useAuthentication;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public boolean isUsePreemptiveAuthentication() {
        return this.usePreemptiveAuthentication;
    }

    public void setUsePreemptiveAuthentication(boolean usePreemptiveAuthentication) {
        this.usePreemptiveAuthentication = usePreemptiveAuthentication;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean isDataTypeBinary() {
        return this.dataTypeBinary;
    }

    public void setDataTypeBinary(boolean dataTypeBinary) {
        this.dataTypeBinary = dataTypeBinary;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(String socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String getProtocol() {
        return "HTTP";
    }

    public String getName() {
        return "HTTP Sender";
    }

    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        String newLine = "\n";
        builder.append("URL: ");
        builder.append(this.host);
        builder.append(newLine);
        builder.append("METHOD: ");
        builder.append(this.method.toUpperCase());
        builder.append(newLine);
        if (StringUtils.isNotBlank((CharSequence)this.username)) {
            builder.append("USERNAME: ");
            builder.append(this.username);
            builder.append(newLine);
        }
        builder.append(newLine);
        builder.append("[HEADERS]");
        builder.append(newLine);
        if (this.isUseHeadersVariable()) {
            builder.append("Using variable '" + this.getHeadersVariable() + "'");
        } else {
            Map<String, List<String>> headers = this.getHeadersMap();
            for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                for (String value : header.getValue()) {
                    builder.append(header.getKey().toString());
                    builder.append(": ");
                    builder.append(value.toString());
                    builder.append(newLine);
                }
            }
        }
        builder.append(newLine);
        builder.append("[PARAMETERS]");
        builder.append(newLine);
        if (this.isUseParametersVariable()) {
            builder.append("Using variable '" + this.getParametersVariable() + "'");
        } else {
            Map<String, List<String>> parameters = this.getParametersMap();
            for (Map.Entry<String, List<String>> parameter : parameters.entrySet()) {
                for (String value : parameter.getValue()) {
                    builder.append(parameter.getKey().toString());
                    builder.append(": ");
                    builder.append(value.toString());
                    builder.append(newLine);
                }
            }
        }
        builder.append(newLine);
        builder.append("[CONTENT]");
        builder.append(newLine);
        builder.append(this.content);
        return builder.toString();
    }

    public DestinationConnectorProperties getDestinationConnectorProperties() {
        return this.destinationConnectorProperties;
    }

    public ConnectorProperties clone() {
        return new HttpDispatcherProperties(this);
    }

    public boolean canValidateResponse() {
        return true;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        super.migrate3_1_0(element);
        element.addChildElementIfNotExists("useProxyServer", "false");
        element.addChildElementIfNotExists("proxyAddress", "");
        element.addChildElementIfNotExists("proxyPort", "");
        boolean responseXmlBody = false;
        DonkeyElement includeHeadersElement = element.removeChild("includeHeadersInResponse");
        if (includeHeadersElement != null) {
            responseXmlBody = Boolean.parseBoolean(includeHeadersElement.getTextContent());
        }
        element.addChildElementIfNotExists("responseXmlBody", Boolean.toString(responseXmlBody));
        element.addChildElementIfNotExists("responseParseMultipart", Boolean.toString(!responseXmlBody));
        element.addChildElementIfNotExists("responseIncludeMetadata", Boolean.toString(responseXmlBody));
        if (responseXmlBody) {
            element.addChildElementIfNotExists("responseBinaryMimeTypes", "application/, image/, video/, audio/");
        } else {
            element.addChildElementIfNotExists("responseBinaryMimeTypes");
        }
        element.addChildElementIfNotExists("responseBinaryMimeTypesRegex", "false");
        boolean useAuthentication = false;
        DonkeyElement useAuthenticationElement = element.getChildElement("useAuthentication");
        if (useAuthenticationElement != null) {
            useAuthentication = Boolean.parseBoolean(useAuthenticationElement.getTextContent());
        }
        element.addChildElementIfNotExists("usePreemptiveAuthentication", Boolean.toString(useAuthentication));
        element.addChildElementIfNotExists("dataTypeBinary", "false");
    }

    public void migrate3_2_0(DonkeyElement element) {
        DonkeyElement entry;
        if (element.getChildElement("headers") != null) {
            DonkeyElement oldHeaders = element.removeChild("headers");
            DonkeyElement newHeaders = element.addChildElement("headers");
            newHeaders.setAttribute("class", "linked-hash-map");
            for (DonkeyElement oldEntry : oldHeaders.getChildElements()) {
                if (oldEntry.getChildElements().size() < 2) continue;
                entry = newHeaders.addChildElement("entry");
                entry.addChildElement("string", ((DonkeyElement)oldEntry.getChildElements().get(0)).getTextContent());
                entry.addChildElement("list").addChildElement("string", ((DonkeyElement)oldEntry.getChildElements().get(1)).getTextContent());
            }
        }
        if (element.getChildElement("parameters") != null) {
            DonkeyElement oldParameters = element.removeChild("parameters");
            DonkeyElement newParameters = element.addChildElement("parameters");
            newParameters.setAttribute("class", "linked-hash-map");
            for (DonkeyElement oldEntry : oldParameters.getChildElements()) {
                if (oldEntry.getChildElements().size() < 2) continue;
                entry = newParameters.addChildElement("entry");
                entry.addChildElement("string", ((DonkeyElement)oldEntry.getChildElements().get(0)).getTextContent());
                entry.addChildElement("list").addChildElement("string", ((DonkeyElement)oldEntry.getChildElements().get(1)).getTextContent());
            }
        }
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("destinationConnectorProperties", this.destinationConnectorProperties.getPurgedProperties());
        purgedProperties.put("method", this.method);
        purgedProperties.put("headerCount", this.headers.size());
        purgedProperties.put("parameterCount", this.parameters.size());
        purgedProperties.put("multipart", this.multipart);
        purgedProperties.put("responseBinaryMimeTypesRegex", this.responseBinaryMimeTypesRegex);
        purgedProperties.put("useAuthentication", this.useAuthentication);
        purgedProperties.put("contentLines", PurgeUtil.countLines((String)this.content));
        purgedProperties.put("dataTypeBinary", this.dataTypeBinary);
        purgedProperties.put("charset", this.charset);
        purgedProperties.put("socketTimeout", PurgeUtil.getNumericValue((String)this.socketTimeout));
        return purgedProperties;
    }
}

