/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagebuilder;

import com.mirth.connect.model.FilterTransformerIterable;
import com.mirth.connect.model.IteratorProperties;
import com.mirth.connect.model.Step;
import com.mirth.connect.util.JavaScriptSharedUtil;
import com.mirth.connect.util.ScriptBuilderException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringEscapeUtils;

public class MessageBuilderStep
extends Step
implements FilterTransformerIterable<Step> {
    public static final String PLUGIN_POINT = "Message Builder";
    private String messageSegment;
    private String mapping;
    private String defaultValue;
    private List<Pair<String, String>> replacements;

    public MessageBuilderStep() {
        this.messageSegment = "";
        this.mapping = "";
        this.defaultValue = "";
        this.replacements = new ArrayList<Pair<String, String>>();
    }

    public MessageBuilderStep(MessageBuilderStep props) {
        super((Step)props);
        this.messageSegment = props.getMessageSegment();
        this.mapping = props.getMapping();
        this.defaultValue = props.getDefaultValue();
        if (props.getReplacements() != null) {
            ArrayList<Pair<String, String>> replacements = new ArrayList<Pair<String, String>>();
            for (Pair<String, String> pair : props.getReplacements()) {
                replacements.add((Pair<String, String>)new ImmutablePair((Object)((String)pair.getLeft()), (Object)((String)pair.getRight())));
            }
            this.replacements = replacements;
        }
    }

    public String getScript(boolean loadFiles) {
        String tempMapping;
        String regexArray = this.buildRegexArray();
        StringBuilder script = new StringBuilder();
        String tempDefaultValue = this.defaultValue;
        if (StringUtils.isEmpty((CharSequence)tempDefaultValue)) {
            tempDefaultValue = "''";
        }
        if (StringUtils.isEmpty((CharSequence)(tempMapping = this.mapping))) {
            tempMapping = "''";
        }
        script.append(this.messageSegment);
        script.append(" = ");
        script.append("validate(" + tempMapping + ", " + tempDefaultValue + ", " + regexArray + ");");
        return script.toString();
    }

    public String getPreScript(boolean loadFiles, LinkedList<IteratorProperties<Step>> ancestors) throws ScriptBuilderException {
        return null;
    }

    public String getIterationScript(boolean loadFiles, LinkedList<IteratorProperties<Step>> ancestors) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        List exprParts = JavaScriptSharedUtil.getExpressionParts((String)this.messageSegment);
        HashSet<String> indexVariables = new HashSet<String>();
        Iterator<IteratorProperties<Step>> it = ancestors.descendingIterator();
        while (it.hasNext()) {
            indexVariables.add(it.next().getIndexVariable());
        }
        if (exprParts.size() > 1) {
            script.append("if (typeof(").append(exprParts.get(0)).append(") == 'xml') {\n");
            it = ancestors.descendingIterator();
            while (it.hasNext()) {
                IteratorProperties<Step> ancestor = it.next();
                String indexVar = ancestor.getIndexVariable();
                int currentIndex = this.getExprIndex(exprParts, indexVar);
                if (currentIndex <= 1) continue;
                JavaScriptSharedUtil.ExprPart segmentPart = (JavaScriptSharedUtil.ExprPart)exprParts.get(currentIndex - 1);
                Object segmentName = segmentPart.getPropertyName();
                if (segmentPart.isNumberLiteral() || indexVariables.contains(segmentName)) continue;
                if (currentIndex > 2) {
                    JavaScriptSharedUtil.ExprPart baseSegmentPart = (JavaScriptSharedUtil.ExprPart)exprParts.get(currentIndex - 2);
                    Object baseSegmentName = baseSegmentPart.getPropertyName();
                    if (!baseSegmentPart.isNumberLiteral() && !indexVariables.contains(baseSegmentName)) {
                        String baseSegment = StringUtils.join((Object[])exprParts.subList(0, currentIndex - 1).toArray());
                        script.append("if (typeof(").append(baseSegment).append("[0]) == 'undefined') {\n");
                        String targetSegment = StringUtils.join((Object[])exprParts.subList(0, currentIndex - 2).toArray());
                        if (!StringUtils.startsWithAny((CharSequence)baseSegmentName, (CharSequence[])new CharSequence[]{"\"", "'"})) {
                            baseSegmentName = "'" + StringEscapeUtils.escapeEcmaScript((String)baseSegmentName) + "'";
                        }
                        script.append("createSegment(").append((String)baseSegmentName).append(", ").append(targetSegment).append(");\n}\n");
                    }
                }
                String wholeSegment = StringUtils.join((Object[])exprParts.subList(0, currentIndex + 1).toArray());
                script.append("if (typeof(").append(wholeSegment).append(") == 'undefined') {\n");
                String targetSegment = StringUtils.join((Object[])exprParts.subList(0, currentIndex - 1).toArray());
                if (!StringUtils.startsWithAny((CharSequence)segmentName, (CharSequence[])new CharSequence[]{"\"", "'"})) {
                    segmentName = "'" + StringEscapeUtils.escapeEcmaScript((String)segmentName) + "'";
                }
                script.append("createSegment(").append((String)segmentName).append(", ").append(targetSegment).append(", ").append(indexVar).append(");\n}\n");
            }
            script.append("} else {\n");
            int lastIndexChecked = -1;
            Iterator<IteratorProperties<Step>> it2 = ancestors.descendingIterator();
            while (it2.hasNext()) {
                IteratorProperties<Step> ancestor = it2.next();
                String indexVar = ancestor.getIndexVariable();
                int currentIndex = this.getExprIndex(exprParts, indexVar);
                if (currentIndex <= 0) continue;
                int i = lastIndexChecked + 1;
                while (i <= currentIndex) {
                    String targetSegment = StringUtils.join((Object[])exprParts.subList(0, i + 1).toArray());
                    script.append("if (typeof(").append(targetSegment).append(") == 'undefined') {\n");
                    String value = "{}";
                    if (i == currentIndex - 1 || exprParts.size() > i + 1 && (((JavaScriptSharedUtil.ExprPart)exprParts.get(i + 1)).isNumberLiteral() || indexVariables.contains(((JavaScriptSharedUtil.ExprPart)exprParts.get(i + 1)).getPropertyName()))) {
                        value = "[]";
                    }
                    script.append(targetSegment).append(" = ").append(value).append(";\n");
                    script.append("}\n");
                    lastIndexChecked = i++;
                }
            }
            for (int i = lastIndexChecked + 1; i <= exprParts.size() - 2; ++i) {
                String targetSegment = StringUtils.join((Object[])exprParts.subList(0, i + 1).toArray());
                script.append("if (typeof(").append(targetSegment).append(") == 'undefined') {\n");
                String value = "{}";
                if (exprParts.size() > i + 1 && (((JavaScriptSharedUtil.ExprPart)exprParts.get(i + 1)).isNumberLiteral() || indexVariables.contains(((JavaScriptSharedUtil.ExprPart)exprParts.get(i + 1)).getPropertyName()))) {
                    value = "[]";
                }
                script.append(targetSegment).append(" = ").append(value).append(";\n");
                script.append("}\n");
            }
            script.append("}\n");
        }
        script.append(this.getScript(loadFiles));
        return script.toString();
    }

    private int getExprIndex(List<JavaScriptSharedUtil.ExprPart> exprParts, String indexVar) {
        for (int i = 0; i < exprParts.size(); ++i) {
            if (!StringUtils.equals((CharSequence)exprParts.get(i).getPropertyName(), (CharSequence)indexVar)) continue;
            return i;
        }
        return -1;
    }

    public String getPostScript(boolean loadFiles, LinkedList<IteratorProperties<Step>> ancestors) throws ScriptBuilderException {
        return null;
    }

    private String buildRegexArray() {
        StringBuilder regexArray = new StringBuilder();
        regexArray.append("new Array(");
        if (this.replacements != null && this.replacements.size() > 0) {
            for (int i = 0; i < this.replacements.size(); ++i) {
                regexArray.append("new Array(" + (String)this.replacements.get(i).getKey() + ", " + (String)this.replacements.get(i).getValue() + ")");
                if (i + 1 == this.replacements.size()) {
                    regexArray.append(")");
                    continue;
                }
                regexArray.append(",");
            }
        } else {
            regexArray.append(")");
        }
        return regexArray.toString();
    }

    public String getMessageSegment() {
        return this.messageSegment;
    }

    public void setMessageSegment(String messageSegment) {
        this.messageSegment = messageSegment;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public List<Pair<String, String>> getReplacements() {
        return this.replacements;
    }

    public void setReplacements(List<Pair<String, String>> replacements) {
        this.replacements = replacements;
    }

    public String getType() {
        return PLUGIN_POINT;
    }

    public Step clone() {
        return new MessageBuilderStep(this);
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        if (this.replacements != null) {
            purgedProperties.put("replacementsCount", this.replacements.size());
        }
        return purgedProperties;
    }
}

