/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.ws;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLSocketFactoryWrapper
extends SSLSocketFactory {
    private SSLSocketFactory delegate;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;

    public SSLSocketFactoryWrapper(SSLSocketFactory delegate, String[] enabledProtocols, String[] enabledCipherSuites) {
        this.delegate = delegate;
        this.enabledProtocols = enabledProtocols;
        this.enabledCipherSuites = enabledCipherSuites;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.initSocket(this.delegate.createSocket(s, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.initSocket(this.delegate.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.initSocket(this.delegate.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.initSocket(this.delegate.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.initSocket(this.delegate.createSocket(address, port, localAddress, localPort));
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.enabledCipherSuites;
    }

    private Socket initSocket(Socket socket) {
        if (socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(this.enabledProtocols);
            ((SSLSocket)socket).setEnabledCipherSuites(this.enabledCipherSuites);
        }
        return socket;
    }
}

