/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.ws;

import com.mirth.connect.connectors.ws.DefaultWebServiceConfiguration;
import com.mirth.connect.connectors.ws.WebServiceConfiguration;
import com.mirth.connect.connectors.ws.WebServiceDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProvider;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.MessageMaps;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.userutil.AttachmentEntry;
import com.mirth.connect.util.ErrorMessageBuilder;
import com.mirth.connect.util.HttpUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

public class WebServiceDispatcher
extends DestinationConnector {
    private static final int MAX_REDIRECTS = NumberUtils.toInt((String)System.getProperty("http.maxRedirects"), (int)20);
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private WebServiceConfiguration configuration;
    private RegistryBuilder<ConnectionSocketFactory> socketFactoryRegistry;
    private ExecutorService executor;
    private Set<DispatchTask<SOAPMessage>> dispatchTasks;
    private Map<Long, DispatchContainer> dispatchContainers = new ConcurrentHashMap<Long, DispatchContainer>();
    private Set<CloseableHttpClient> clients = Collections.newSetFromMap(new ConcurrentHashMap());

    public void onDeploy() throws ConnectorTaskException {
        String configurationClass = this.getConfigurationClass();
        try {
            this.configuration = (WebServiceConfiguration)Class.forName(configurationClass).newInstance();
        }
        catch (Exception e) {
            this.logger.trace("could not find custom configuration class, using default");
            this.configuration = new DefaultWebServiceConfiguration();
        }
        try {
            this.socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
            this.configuration.configureConnectorDeploy((Connector)this);
        }
        catch (Exception e) {
            throw new ConnectorTaskException((Throwable)e);
        }
    }

    public void onUndeploy() throws ConnectorTaskException {
        this.configuration.configureConnectorUndeploy((Connector)this);
    }

    public void onStart() throws ConnectorTaskException {
        this.executor = Executors.newCachedThreadPool();
        this.dispatchTasks = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public void onStop() throws ConnectorTaskException {
        for (CloseableHttpClient client : this.clients.toArray(new CloseableHttpClient[this.clients.size()])) {
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
        this.clients.clear();
        if (this.executor != null) {
            this.executor.shutdown();
        }
        for (DispatchContainer dispatchContainer : this.dispatchContainers.values()) {
            for (File tempFile : dispatchContainer.getTempFiles()) {
                tempFile.delete();
            }
        }
        this.dispatchContainers.clear();
    }

    public void onHalt() throws ConnectorTaskException {
        for (CloseableHttpClient closeableHttpClient : this.clients.toArray(new CloseableHttpClient[this.clients.size()])) {
            HttpClientUtils.closeQuietly((HttpClient)closeableHttpClient);
        }
        this.clients.clear();
        if (this.executor != null) {
            boolean bl = this.executor.isShutdown();
            this.executor.shutdownNow();
            if (!bl) {
                try {
                    this.executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new ConnectorTaskException("Halt task interrupted while waiting for executor to shutdown.", (Throwable)e);
                }
                int numTasks = this.dispatchTasks.size();
                if (numTasks > 0) {
                    String message = "Error halting Web Service Sender: " + numTasks + " request" + (numTasks == 1 ? "" : "s") + " failed to be halted. This can potentially lead to a thread leak if the requests continue to hang.";
                    this.logger.error(message);
                    this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), null, ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), this.getConnectorProperties().getName(), message, null));
                }
            }
        }
        for (DispatchContainer dispatchContainer : this.dispatchContainers.values().toArray(new DispatchContainer[this.dispatchContainers.size()])) {
            for (File tempFile : dispatchContainer.getTempFiles().toArray(new File[dispatchContainer.getTempFiles().size()])) {
                tempFile.delete();
            }
        }
        this.dispatchContainers.clear();
    }

    protected String getConfigurationClass() {
        return this.configurationController.getProperty(this.getConnectorProperties().getProtocol(), "wsConfigurationClass");
    }

    private String sourceToXmlString(Source source) throws TransformerConfigurationException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        StringWriter writer = new StringWriter();
        transformer.transform(source, new StreamResult(writer));
        return ((Object)writer).toString();
    }

    private void createDispatch(WebServiceDispatcherProperties webServiceDispatcherProperties, DispatchContainer dispatchContainer, int timeout) throws Exception {
        String wsdlUrl = webServiceDispatcherProperties.getWsdlUrl();
        String username = webServiceDispatcherProperties.getUsername();
        String password = webServiceDispatcherProperties.getPassword();
        String serviceName = webServiceDispatcherProperties.getService();
        String portName = webServiceDispatcherProperties.getPort();
        if (!(dispatchContainer.getDispatch() != null && StringUtils.equals((CharSequence)wsdlUrl, (CharSequence)dispatchContainer.getCurrentWsdlUrl()) && StringUtils.equals((CharSequence)username, (CharSequence)dispatchContainer.getCurrentUsername()) && StringUtils.equals((CharSequence)password, (CharSequence)dispatchContainer.getCurrentPassword()) && StringUtils.equals((CharSequence)serviceName, (CharSequence)dispatchContainer.getCurrentServiceName()) && StringUtils.equals((CharSequence)portName, (CharSequence)dispatchContainer.getCurrentPortName()))) {
            HashMap requestHeaders;
            dispatchContainer.setCurrentWsdlUrl(wsdlUrl);
            dispatchContainer.setCurrentUsername(username);
            dispatchContainer.setCurrentPassword(password);
            dispatchContainer.setCurrentServiceName(serviceName);
            dispatchContainer.setCurrentPortName(portName);
            URL endpointUrl = this.getWsdlUrl(webServiceDispatcherProperties, dispatchContainer, timeout);
            QName serviceQName = QName.valueOf(serviceName);
            QName portQName = QName.valueOf(portName);
            this.logger.debug("Creating web service: url=" + endpointUrl.toString() + ", service=" + String.valueOf(serviceQName) + ", port=" + String.valueOf(portQName));
            Service service = Service.create((URL)endpointUrl, (QName)serviceQName);
            Dispatch dispatch = service.createDispatch(portQName, SOAPMessage.class, Service.Mode.MESSAGE);
            if (timeout > 0) {
                dispatch.getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", timeout);
                dispatch.getRequestContext().put("com.sun.xml.internal.ws.request.timeout", timeout);
                dispatch.getRequestContext().put("com.sun.xml.ws.connect.timeout", timeout);
                dispatch.getRequestContext().put("com.sun.xml.ws.request.timeout", timeout);
            }
            if ((requestHeaders = (HashMap)dispatch.getRequestContext().get("javax.xml.ws.http.request.headers")) == null) {
                requestHeaders = new HashMap();
            }
            dispatchContainer.setDefaultRequestHeaders(requestHeaders);
            dispatchContainer.setDispatch((Dispatch<SOAPMessage>)dispatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getWsdlUrl(WebServiceDispatcherProperties webServiceDispatcherProperties, DispatchContainer dispatchContainer, int timeout) throws Exception {
        URI uri = new URI(dispatchContainer.getCurrentWsdlUrl());
        if (!uri.getScheme().equalsIgnoreCase("file")) {
            BasicHttpClientConnectionManager httpClientConnectionManager = new BasicHttpClientConnectionManager((Lookup)this.socketFactoryRegistry.build());
            httpClientConnectionManager.setSocketConfig(SocketConfig.custom().setSoTimeout(timeout).build());
            HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager);
            HttpUtil.configureClientBuilder((HttpClientBuilder)clientBuilder);
            CloseableHttpClient client = clientBuilder.build();
            try {
                this.clients.add(client);
                HttpClientContext context = HttpClientContext.create();
                if (dispatchContainer.getCurrentUsername() != null && dispatchContainer.getCurrentPassword() != null) {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM);
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(dispatchContainer.getCurrentUsername(), dispatchContainer.getCurrentPassword());
                    credsProvider.setCredentials(authScope, (Credentials)credentials);
                    BasicAuthCache authCache = new BasicAuthCache();
                    RegistryBuilder registryBuilder = RegistryBuilder.create();
                    registryBuilder.register("Basic", (Object)new BasicSchemeFactory());
                    context.setCredentialsProvider((CredentialsProvider)credsProvider);
                    context.setAuthSchemeRegistry((Lookup)registryBuilder.build());
                    context.setAuthCache((AuthCache)authCache);
                }
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).setStaleConnectionCheckEnabled(true).build();
                context.setRequestConfig(requestConfig);
                URL uRL = this.getWsdl(client, (HttpContext)context, dispatchContainer, new HashMap<String, File>(), dispatchContainer.getCurrentWsdlUrl()).toURI().toURL();
                return uRL;
            }
            finally {
                HttpClientUtils.closeQuietly((HttpClient)client);
                this.clients.remove(client);
            }
        }
        return uri.toURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getWsdl(CloseableHttpClient client, HttpContext context, DispatchContainer dispatchContainer, Map<String, File> visitedUrls, String wsdlUrl) throws Exception {
        if (visitedUrls.containsKey(wsdlUrl)) {
            return visitedUrls.get(wsdlUrl);
        }
        String wsdl = null;
        StatusLine responseStatusLine = null;
        CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(wsdlUrl), context);
        try {
            responseStatusLine = response.getStatusLine();
            if (responseStatusLine.getStatusCode() == 200) {
                ContentType responseContentType = ContentType.get((HttpEntity)response.getEntity());
                if (responseContentType == null) {
                    responseContentType = ContentType.TEXT_XML;
                }
                Charset responseCharset = responseContentType.getCharset();
                if (responseContentType.getCharset() == null) {
                    responseCharset = ContentType.TEXT_XML.getCharset();
                }
                wsdl = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)responseCharset);
            }
        }
        finally {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        }
        if (StringUtils.isNotBlank(wsdl)) {
            File tempFile = File.createTempFile("WebServiceSender", ".wsdl");
            tempFile.deleteOnExit();
            visitedUrls.put(wsdlUrl, tempFile);
            try {
                DonkeyElement element = new DonkeyElement(wsdl);
                for (DonkeyElement child : element.getChildElements()) {
                    if (!child.getLocalName().equals("import") || !child.hasAttribute("location")) continue;
                    String location = new URI(wsdlUrl).resolve(child.getAttribute("location")).toString();
                    child.setAttribute("location", this.getWsdl(client, context, dispatchContainer, visitedUrls, location).toURI().toURL().toString());
                }
                wsdl = element.toXml();
            }
            catch (Exception e) {
                this.logger.warn("Unable to cache imports for WSDL at URL: " + wsdlUrl, (Throwable)e);
            }
            FileUtils.writeStringToFile((File)tempFile, (String)wsdl);
            dispatchContainer.getTempFiles().add(tempFile);
            return tempFile;
        }
        throw new Exception("Unable to load WSDL at URL \"" + wsdlUrl + "\": " + String.valueOf(responseStatusLine));
    }

    public void replaceConnectorProperties(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        WebServiceDispatcherProperties webServiceDispatcherProperties = (WebServiceDispatcherProperties)connectorProperties;
        webServiceDispatcherProperties.setWsdlUrl(this.replacer.replaceValues(webServiceDispatcherProperties.getWsdlUrl(), connectorMessage));
        webServiceDispatcherProperties.setUsername(this.replacer.replaceValues(webServiceDispatcherProperties.getUsername(), connectorMessage));
        webServiceDispatcherProperties.setPassword(this.replacer.replaceValues(webServiceDispatcherProperties.getPassword(), connectorMessage));
        webServiceDispatcherProperties.setService(this.replacer.replaceValues(webServiceDispatcherProperties.getService(), connectorMessage));
        webServiceDispatcherProperties.setPort(this.replacer.replaceValues(webServiceDispatcherProperties.getPort(), connectorMessage));
        webServiceDispatcherProperties.setLocationURI(this.replacer.replaceValues(webServiceDispatcherProperties.getLocationURI(), connectorMessage));
        webServiceDispatcherProperties.setSocketTimeout(this.replacer.replaceValues(webServiceDispatcherProperties.getSocketTimeout(), connectorMessage));
        webServiceDispatcherProperties.setSoapAction(this.replacer.replaceValues(webServiceDispatcherProperties.getSoapAction(), connectorMessage));
        webServiceDispatcherProperties.setEnvelope(this.replacer.replaceValues(webServiceDispatcherProperties.getEnvelope(), connectorMessage));
        Map headers = webServiceDispatcherProperties.getHeadersMap();
        for (Map.Entry entry : headers.entrySet()) {
            this.replacer.replaceValuesInList((List)entry.getValue(), connectorMessage);
        }
        webServiceDispatcherProperties.setHeadersMap(headers);
        webServiceDispatcherProperties.setHeadersVariable(this.replacer.replaceValues(webServiceDispatcherProperties.getHeadersVariable(), connectorMessage));
        if (webServiceDispatcherProperties.isUseMtom()) {
            this.replacer.replaceValuesInList(webServiceDispatcherProperties.getAttachmentNames(), connectorMessage);
            this.replacer.replaceValuesInList(webServiceDispatcherProperties.getAttachmentContents(), connectorMessage);
            this.replacer.replaceValuesInList(webServiceDispatcherProperties.getAttachmentTypes(), connectorMessage);
            webServiceDispatcherProperties.setAttachmentsVariable(this.replacer.replaceValues(webServiceDispatcherProperties.getAttachmentsVariable(), connectorMessage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response send(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        WebServiceDispatcherProperties webServiceDispatcherProperties = (WebServiceDispatcherProperties)connectorProperties;
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.SENDING));
        String responseData = null;
        String responseError = null;
        String responseStatusMessage = null;
        Status responseStatus = Status.QUEUED;
        boolean validateResponse = false;
        try {
            String soapAction;
            long dispatcherId = connectorMessage.getDispatcherId();
            DispatchContainer dispatchContainer = this.dispatchContainers.get(dispatcherId);
            if (dispatchContainer == null) {
                dispatchContainer = new DispatchContainer();
                this.dispatchContainers.put(dispatcherId, dispatchContainer);
            }
            int timeout = NumberUtils.toInt((String)webServiceDispatcherProperties.getSocketTimeout(), (int)30000);
            this.createDispatch(webServiceDispatcherProperties, dispatchContainer, timeout);
            Dispatch<SOAPMessage> dispatch = dispatchContainer.getDispatch();
            this.configuration.configureDispatcher(this, webServiceDispatcherProperties, dispatch.getRequestContext());
            SOAPBinding soapBinding = (SOAPBinding)dispatch.getBinding();
            if (webServiceDispatcherProperties.isUseAuthentication()) {
                String currentUsername = dispatchContainer.getCurrentUsername();
                String currentPassword = dispatchContainer.getCurrentPassword();
                dispatch.getRequestContext().put("javax.xml.ws.security.auth.username", currentUsername);
                dispatch.getRequestContext().put("javax.xml.ws.security.auth.password", currentPassword);
            }
            if (StringUtils.isNotEmpty((CharSequence)(soapAction = webServiceDispatcherProperties.getSoapAction()))) {
                dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.use", true);
                dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", soapAction);
            }
            HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>(dispatchContainer.getDefaultRequestHeaders());
            Map<String, List<String>> headersSource = this.getHeaders(webServiceDispatcherProperties, connectorMessage);
            if (MapUtils.isNotEmpty(headersSource)) {
                for (Map.Entry<String, List<String>> entry : headersSource.entrySet()) {
                    ArrayList valueList = (ArrayList)requestHeaders.get(entry.getKey());
                    if (valueList == null) {
                        valueList = new ArrayList();
                        requestHeaders.put(entry.getKey(), valueList);
                    }
                    valueList.addAll(entry.getValue());
                }
            }
            dispatch.getRequestContext().put("javax.xml.ws.http.request.headers", requestHeaders);
            this.logger.debug("Creating SOAP envelope.");
            AttachmentHandlerProvider attachmentHandlerProvider = this.getAttachmentHandlerProvider();
            String content = attachmentHandlerProvider.reAttachMessage(webServiceDispatcherProperties.getEnvelope(), connectorMessage, webServiceDispatcherProperties.getDestinationConnectorProperties().isReattachAttachments());
            StreamSource source = new StreamSource(new StringReader(content));
            SOAPMessage message = soapBinding.getMessageFactory().createMessage();
            message.getSOAPPart().setContent((Source)source);
            if (webServiceDispatcherProperties.isUseMtom()) {
                soapBinding.setMTOMEnabled(true);
                List<AttachmentEntry> attachmentEntries = this.getAttachments(webServiceDispatcherProperties, connectorMessage);
                for (AttachmentEntry entry : attachmentEntries) {
                    String attachmentContentId = entry.getName();
                    String attachmentContentType = entry.getMimeType();
                    String attachmentContent = attachmentHandlerProvider.reAttachMessage(entry.getContent(), connectorMessage, webServiceDispatcherProperties.getDestinationConnectorProperties().isReattachAttachments());
                    AttachmentPart attachment = message.createAttachmentPart();
                    attachment.setBase64Content((InputStream)new ByteArrayInputStream(attachmentContent.getBytes("UTF-8")), attachmentContentType);
                    attachment.setContentId(attachmentContentId);
                    message.addAttachmentPart(attachment);
                }
            } else {
                soapBinding.setMTOMEnabled(false);
            }
            message.saveChanges();
            if (StringUtils.isNotBlank((CharSequence)webServiceDispatcherProperties.getLocationURI())) {
                dispatch.getRequestContext().put("javax.xml.ws.service.endpoint.address", webServiceDispatcherProperties.getLocationURI());
            }
            boolean redirect = false;
            int tryCount = 0;
            do {
                redirect = false;
                ++tryCount;
                try {
                    SOAPMessage result;
                    DispatchTask<SOAPMessage> task = new DispatchTask<SOAPMessage>(dispatch, message, webServiceDispatcherProperties.isOneWay());
                    if (timeout == 0) {
                        Future<SOAPMessage> future = this.executor.submit(task);
                        this.dispatchTasks.add(task);
                        result = future.get();
                    } else {
                        result = task.call();
                    }
                    this.handleSOAPResult(connectorProperties, connectorMessage, result);
                    if (webServiceDispatcherProperties.isOneWay()) {
                        responseStatusMessage = "Invoked one way operation successfully.";
                    } else {
                        responseData = this.sourceToXmlString(result.getSOAPPart().getContent());
                        responseStatusMessage = "Invoked two way operation successfully.";
                    }
                    this.logger.debug("Finished invoking web service, got result.");
                    responseStatus = Status.SENT;
                }
                catch (Throwable e) {
                    if (e instanceof ExecutionException && e.getCause() != null) {
                        e = e.getCause();
                    }
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    Integer responseCode = null;
                    String location = null;
                    if (dispatch.getResponseContext() != null) {
                        List locations;
                        responseCode = (Integer)dispatch.getResponseContext().get("javax.xml.ws.http.response.code");
                        Map headers = (Map)dispatch.getResponseContext().get("javax.xml.ws.http.response.headers");
                        if (MapUtils.isNotEmpty((Map)headers) && CollectionUtils.isNotEmpty((Collection)(locations = (List)headers.get("Location")))) {
                            location = (String)locations.get(0);
                        }
                    }
                    if (tryCount < MAX_REDIRECTS && responseCode != null && responseCode >= 300 && responseCode < 400 && StringUtils.isNotBlank(location)) {
                        redirect = true;
                        dispatch.getRequestContext().put("javax.xml.ws.service.endpoint.address", location);
                        continue;
                    }
                    if (e instanceof NoRouteToHostException || e.getCause() != null && e.getCause() instanceof NoRouteToHostException) {
                        responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)"HTTP transport error", (Throwable)e);
                        responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)"HTTP transport error", (Throwable)e);
                        this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(connectorMessage.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), "HTTP transport error.", e));
                        continue;
                    }
                    if (e.getClass() == ConnectException.class || e.getCause() != null && e.getCause().getClass() == ConnectException.class) {
                        responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)"Connection refused.", (Throwable)e);
                        responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)"Connection refused", (Throwable)e);
                        this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(connectorMessage.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), "Connection refused.", e));
                        continue;
                    }
                    if (e instanceof SOAPFaultException) {
                        responseStatus = Status.ERROR;
                        try {
                            responseData = new DonkeyElement((Element)((SOAPFaultException)e).getFault()).toXml();
                        }
                        catch (DonkeyElement.DonkeyElementException donkeyElementException) {
                            // empty catch block
                        }
                    }
                    responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)"Error invoking web service", (Throwable)e);
                    responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)"Error invoking web service", (Throwable)e);
                    this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(connectorMessage.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), "Error invoking web service.", e));
                }
            } while (redirect && tryCount < MAX_REDIRECTS);
        }
        catch (Exception e) {
            responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)"Error creating web service dispatch", (Throwable)e);
            responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)"Error creating web service dispatch", (Throwable)e);
            this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(connectorMessage.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), "Error creating web service dispatch.", (Throwable)e));
        }
        finally {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
        }
        return new Response(responseStatus, responseData, responseStatusMessage, responseError, validateResponse);
    }

    protected void handleSOAPResult(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage, SOAPMessage result) throws Exception {
    }

    public RegistryBuilder<ConnectionSocketFactory> getSocketFactoryRegistry() {
        return this.socketFactoryRegistry;
    }

    Map<String, List<String>> getHeaders(WebServiceDispatcherProperties webServiceDispatcherProperties, ConnectorMessage connectorMessage) {
        return HttpUtil.getTableMap((boolean)webServiceDispatcherProperties.isUseHeadersVariable(), (String)webServiceDispatcherProperties.getHeadersVariable(), (Map)webServiceDispatcherProperties.getHeadersMap(), (MessageMaps)this.getMessageMaps(), (ConnectorMessage)connectorMessage);
    }

    List<AttachmentEntry> getAttachments(WebServiceDispatcherProperties webServiceDispatcherProperties, ConnectorMessage connectorMessage) {
        ArrayList<AttachmentEntry> attachmentList;
        block8: {
            attachmentList = new ArrayList<AttachmentEntry>();
            if (webServiceDispatcherProperties.isUseAttachmentsVariable()) {
                try {
                    List attachmentEntries = (List)this.getMessageMaps().get(webServiceDispatcherProperties.getAttachmentsVariable(), connectorMessage);
                    if (attachmentEntries != null) {
                        for (Object entry : attachmentEntries) {
                            if (entry instanceof AttachmentEntry) {
                                attachmentList.add(new AttachmentEntry((AttachmentEntry)entry));
                                continue;
                            }
                            this.logger.trace("Error getting attachment entry from map '" + webServiceDispatcherProperties.getAttachmentsVariable() + "'. Skipping entry.");
                        }
                        break block8;
                    }
                    this.logger.warn("Attachments list variable '" + webServiceDispatcherProperties.getAttachmentsVariable() + "' not found.");
                }
                catch (Exception e) {
                    this.logger.warn("Error getting attachments from map '" + webServiceDispatcherProperties.getHeadersVariable() + "'.", (Throwable)e);
                }
            } else {
                ArrayList attachmentIds = new ArrayList(webServiceDispatcherProperties.getAttachmentNames());
                ArrayList attachmentContents = new ArrayList(webServiceDispatcherProperties.getAttachmentContents());
                ArrayList attachmentTypes = new ArrayList(webServiceDispatcherProperties.getAttachmentTypes());
                for (int i = 0; i < attachmentIds.size(); ++i) {
                    attachmentList.add(new AttachmentEntry((String)attachmentIds.get(i), (String)attachmentContents.get(i), (String)attachmentTypes.get(i)));
                }
            }
        }
        return attachmentList;
    }

    public WebServiceDispatcherProperties getConnectorProperties() {
        return (WebServiceDispatcherProperties)super.getConnectorProperties();
    }

    protected class DispatchContainer {
        private Dispatch<SOAPMessage> dispatch = null;
        private String currentWsdlUrl = null;
        private String currentUsername = null;
        private String currentPassword = null;
        private String currentServiceName = null;
        private String currentPortName = null;
        private List<File> tempFiles = new ArrayList<File>();
        private Map<String, List<String>> defaultRequestHeaders;

        protected DispatchContainer() {
        }

        public Dispatch<SOAPMessage> getDispatch() {
            return this.dispatch;
        }

        public void setDispatch(Dispatch<SOAPMessage> dispatch) {
            this.dispatch = dispatch;
        }

        public String getCurrentWsdlUrl() {
            return this.currentWsdlUrl;
        }

        public void setCurrentWsdlUrl(String currentWsdlUrl) {
            this.currentWsdlUrl = currentWsdlUrl;
        }

        public String getCurrentUsername() {
            return this.currentUsername;
        }

        public void setCurrentUsername(String currentUsername) {
            this.currentUsername = currentUsername;
        }

        public String getCurrentPassword() {
            return this.currentPassword;
        }

        public void setCurrentPassword(String currentPassword) {
            this.currentPassword = currentPassword;
        }

        public String getCurrentServiceName() {
            return this.currentServiceName;
        }

        public void setCurrentServiceName(String currentServiceName) {
            this.currentServiceName = currentServiceName;
        }

        public String getCurrentPortName() {
            return this.currentPortName;
        }

        public void setCurrentPortName(String currentPortName) {
            this.currentPortName = currentPortName;
        }

        public List<File> getTempFiles() {
            return this.tempFiles;
        }

        public Map<String, List<String>> getDefaultRequestHeaders() {
            return this.defaultRequestHeaders;
        }

        public void setDefaultRequestHeaders(Map<String, List<String>> defaultRequestHeaders) {
            this.defaultRequestHeaders = defaultRequestHeaders;
        }
    }

    private class DispatchTask<T>
    implements Callable<T> {
        private Dispatch<T> dispatch;
        private T message;
        private boolean oneWay;

        public DispatchTask(Dispatch<T> dispatch, T message, boolean oneWay) {
            this.dispatch = dispatch;
            this.message = message;
            this.oneWay = oneWay;
        }

        @Override
        public T call() throws Exception {
            try {
                if (this.oneWay) {
                    WebServiceDispatcher.this.logger.debug("Invoking one way service...");
                    this.dispatch.invokeOneWay(this.message);
                    T t = null;
                    return t;
                }
                WebServiceDispatcher.this.logger.debug("Invoking web service...");
                Object object = this.dispatch.invoke(this.message);
                return (T)object;
            }
            finally {
                if (WebServiceDispatcher.this.dispatchTasks != null) {
                    WebServiceDispatcher.this.dispatchTasks.remove(this);
                }
            }
        }
    }
}

