/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.dicom;

import com.mirth.connect.donkey.model.message.MessageSerializer;
import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.model.converters.DICOMConverter;
import com.mirth.connect.model.converters.DocumentSerializer;
import com.mirth.connect.model.converters.IMessageSerializer;
import com.mirth.connect.model.datatype.SerializerProperties;
import com.mirth.connect.util.ErrorMessageBuilder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.io.IOUtils;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.ContentHandlerAdapter;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.SAXWriter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DICOMSerializer
implements IMessageSerializer {
    private DocumentSerializer documentSerializer = new DocumentSerializer();

    public DICOMSerializer() {
    }

    public DICOMSerializer(SerializerProperties DICOMProperties) {
    }

    public static Map<String, String> getDefaultProperties() {
        return new HashMap<String, String>();
    }

    public static byte[] removePixelData(byte[] content) throws IOException {
        DicomObject dicomObject = DICOMConverter.byteArrayToDicomObject((byte[])content, (boolean)false);
        dicomObject.remove(2145386512);
        return DICOMConverter.dicomObjectToByteArray((DicomObject)dicomObject);
    }

    public boolean isSerializationRequired(boolean toXml) {
        boolean serializationRequired = false;
        return serializationRequired;
    }

    public String transformWithoutSerializing(String message, MessageSerializer outboundSerializer) throws MessageSerializerException {
        return null;
    }

    public String fromXML(String source) throws MessageSerializerException {
        if (source == null || source.length() == 0) {
            return "";
        }
        try {
            Document document = this.documentSerializer.fromXML(source);
            Element element = document.getDocumentElement();
            for (Node node = element.getChildNodes().item(0); node != null; node = node.getNextSibling()) {
                this.renameTagToAttr(document, node);
            }
            NodeList items = document.getElementsByTagName("item");
            if (items != null) {
                for (int i = 0; i < items.getLength(); ++i) {
                    Node itemNode = items.item(i);
                    if (itemNode.getChildNodes() == null) continue;
                    NodeList itemNodes = itemNode.getChildNodes();
                    for (int j = 0; j < itemNodes.getLength(); ++j) {
                        Node nodeItem = itemNodes.item(j);
                        this.renameTagToAttr(document, nodeItem);
                    }
                }
            }
            String charset = null;
            Element charsetElement = (Element)document.getElementsByTagName("tag00080005").item(0);
            charset = charsetElement != null ? charsetElement.getNodeValue() : "utf-8";
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            SAXParser parser = factory.newSAXParser();
            BasicDicomObject dicomObject = new BasicDicomObject();
            ContentHandlerAdapter contentHandler = new ContentHandlerAdapter((DicomObject)dicomObject);
            byte[] documentBytes = this.documentSerializer.toXML(document).trim().getBytes(charset);
            parser.parse(new InputSource(new ByteArrayInputStream(documentBytes)), (DefaultHandler)contentHandler);
            return StringUtils.newStringUsAscii((byte[])Base64Util.encodeBase64((byte[])DICOMConverter.dicomObjectToByteArray((DicomObject)dicomObject)));
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error converting XML to DICOM", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error converting XML to DICOM", (Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toXML(String source) throws MessageSerializerException {
        try {
            byte[] encodedMessage = StringUtils.getBytesUsAscii((String)source);
            StringWriter output = new StringWriter();
            DicomInputStream dis = new DicomInputStream((InputStream)new BufferedInputStream((InputStream)new Base64InputStream((InputStream)new ByteArrayInputStream(encodedMessage))));
            dis.setAllocateLimit(-1);
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                SAXTransformerFactory factory = (SAXTransformerFactory)tf;
                TransformerHandler handler = factory.newTransformerHandler();
                handler.getTransformer().setOutputProperty("indent", "no");
                handler.setResult(new StreamResult(output));
                SAXWriter writer = new SAXWriter((ContentHandler)handler, null);
                dis.setHandler((DicomInputHandler)writer);
                dis.readDicomObject((DicomObject)new BasicDicomObject(), -1);
                String serializedDicomObject = output.toString();
                Document document = this.documentSerializer.fromXML(serializedDicomObject);
                NodeList attrElements = document.getElementsByTagName("attr");
                for (int i = 0; i < attrElements.getLength(); ++i) {
                    Element attrElement = (Element)attrElements.item(i);
                    this.renameAttrToTag(document, attrElement);
                }
                String string = this.documentSerializer.toXML(document);
                return string;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                IOUtils.closeQuietly((InputStream)dis);
                IOUtils.closeQuietly((Writer)output);
                if (dis != null) {
                    dis.close();
                }
            }
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error converting DICOM to XML", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error converting DICOM to XML", (Throwable)e));
        }
    }

    private void renameAttrToTag(Document document, Node node) throws DOMException {
        String tag;
        if (node.getNodeName().equals("attr") && !(tag = node.getAttributes().getNamedItem("tag").getNodeValue()).equals("?")) {
            document.renameNode(node, null, "tag" + tag);
        }
    }

    private void renameTagToAttr(Document document, Node node) throws DOMException {
        String tag;
        Node tagAttr;
        NamedNodeMap attr = node.getAttributes();
        if (attr != null && (tagAttr = attr.getNamedItem("tag")) != null && !(tag = "tag" + tagAttr.getNodeValue()).equals("?") && tag.equals(node.getNodeName())) {
            document.renameNode(node, null, "attr");
        }
    }

    public Map<String, Object> getMetaDataFromMessage(String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mirth_version", "");
        map.put("message_type", "DICOM");
        return map;
    }

    public void populateMetaData(String message, Map<String, Object> map) {
    }

    public String toJSON(String message) throws MessageSerializerException {
        return null;
    }

    public String fromJSON(String message) throws MessageSerializerException {
        return null;
    }
}

