/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth.oauth2;

import com.mirth.connect.donkey.model.channel.ConnectorPluginProperties;
import com.mirth.connect.plugins.httpauth.HttpAuthConnectorPluginProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OAuth2HttpAuthProperties
extends HttpAuthConnectorPluginProperties {
    private TokenLocation tokenLocation;
    private String locationKey;
    private String verificationURL;
    private Set<ConnectorPluginProperties> connectorPluginProperties;

    public OAuth2HttpAuthProperties() {
        super(HttpAuthConnectorPluginProperties.AuthType.OAUTH2_VERIFICATION);
        this.tokenLocation = TokenLocation.HEADER;
        this.locationKey = "Authorization";
        this.verificationURL = "";
    }

    public OAuth2HttpAuthProperties(OAuth2HttpAuthProperties props) {
        super(HttpAuthConnectorPluginProperties.AuthType.OAUTH2_VERIFICATION);
        this.tokenLocation = props.getTokenLocation();
        this.locationKey = props.getLocationKey();
        this.verificationURL = props.getVerificationURL();
        if (props.getConnectorPluginProperties() != null) {
            this.connectorPluginProperties = new HashSet<ConnectorPluginProperties>();
            for (ConnectorPluginProperties pluginProperties : props.getConnectorPluginProperties()) {
                this.connectorPluginProperties.add(pluginProperties.clone());
            }
        }
    }

    public TokenLocation getTokenLocation() {
        return this.tokenLocation;
    }

    public void setTokenLocation(TokenLocation tokenLocation) {
        this.tokenLocation = tokenLocation;
    }

    public String getLocationKey() {
        return this.locationKey;
    }

    public void setLocationKey(String locationKey) {
        this.locationKey = locationKey;
    }

    public String getVerificationURL() {
        return this.verificationURL;
    }

    public void setVerificationURL(String verificationURL) {
        this.verificationURL = verificationURL;
    }

    public Set<ConnectorPluginProperties> getConnectorPluginProperties() {
        return this.connectorPluginProperties;
    }

    public void setConnectorPluginProperties(Set<ConnectorPluginProperties> connectorPluginProperties) {
        this.connectorPluginProperties = connectorPluginProperties;
    }

    public OAuth2HttpAuthProperties clone() {
        return new OAuth2HttpAuthProperties(this);
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("authType", (Object)this.getAuthType());
        purgedProperties.put("tokenLocation", (Object)this.tokenLocation);
        if (this.connectorPluginProperties != null) {
            HashSet<Map> purgedPluginProperties = new HashSet<Map>();
            for (ConnectorPluginProperties cpp : this.connectorPluginProperties) {
                purgedPluginProperties.add(cpp.getPurgedProperties());
            }
            purgedProperties.put("connectorPluginProperties", purgedPluginProperties);
        }
        return purgedProperties;
    }

    public static enum TokenLocation {
        HEADER("Request Header"),
        QUERY("Query Parameter");

        private String value;

        private TokenLocation(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

