/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file.filters;

import java.util.regex.Pattern;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFilenameFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmbFilenameWildcardFilter
implements SmbFilenameFilter {
    private static transient Log logger = LogFactory.getLog(SmbFilenameFilter.class);
    private boolean isRegex;
    private String[] wildcardPatterns;
    private Pattern regexPattern;

    public SmbFilenameWildcardFilter(String pattern, boolean isRegex) {
        this.isRegex = isRegex;
        if (isRegex) {
            this.regexPattern = Pattern.compile(pattern);
        } else {
            this.wildcardPatterns = pattern.trim().split("\\s*,\\s*");
        }
    }

    public boolean accept(SmbFile dir, String name) {
        if (name == null) {
            logger.warn((Object)"The filename and or directory was null");
            return false;
        }
        if (this.isRegex) {
            return this.regexPattern.matcher(name).matches();
        }
        return this.accept(name);
    }

    private boolean accept(String name) {
        if (name == null) {
            return false;
        }
        String pattern = null;
        boolean match = false;
        for (int x = 0; x < this.wildcardPatterns.length; ++x) {
            pattern = this.wildcardPatterns[x];
            if ("*".equals(pattern) || "**".equals(pattern)) {
                return true;
            }
            int i = pattern.indexOf("*");
            if (i == -1) {
                match = pattern.equals(name);
            } else {
                String partialName = name;
                String partialPattern = pattern;
                boolean partialMatch = true;
                boolean first = true;
                while (i != -1) {
                    String prefix = partialPattern.substring(0, i);
                    partialPattern = partialPattern.substring(i + 1);
                    if (!prefix.isEmpty()) {
                        int prefixIndex = partialName.indexOf(prefix);
                        if (first && prefixIndex == 0) {
                            partialName = partialName.substring(prefix.length());
                        } else if (!first && prefixIndex >= 0) {
                            partialName = partialName.substring(prefixIndex + prefix.length());
                        } else {
                            partialMatch = false;
                            break;
                        }
                    }
                    i = partialPattern.indexOf("*");
                    first = false;
                }
                if (partialMatch && !partialPattern.isEmpty() && !partialName.endsWith(partialPattern)) {
                    partialMatch = false;
                }
                match = partialMatch;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }
}

