/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.xml;

import com.mirth.connect.donkey.model.message.MessageSerializer;
import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.model.converters.IMessageSerializer;
import com.mirth.connect.model.datatype.SerializerProperties;
import com.mirth.connect.plugins.datatypes.xml.XMLSerializationProperties;
import com.mirth.connect.util.ErrorMessageBuilder;
import com.mirth.connect.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class XMLSerializer
implements IMessageSerializer {
    private XMLSerializationProperties serializationProperties;

    public XMLSerializer(SerializerProperties properties) {
        this.serializationProperties = (XMLSerializationProperties)properties.getSerializationProperties();
    }

    public boolean isSerializationRequired(boolean toXml) {
        boolean serializationRequired = false;
        return serializationRequired;
    }

    public String transformWithoutSerializing(String message, MessageSerializer outboundSerializer) throws MessageSerializerException {
        try {
            if (this.serializationProperties.isStripNamespaces()) {
                return StringUtil.stripNamespaces((String)message);
            }
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error transforming XML", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error transforming XML", (Throwable)e));
        }
        return null;
    }

    public String toXML(String source) throws MessageSerializerException {
        try {
            if (this.serializationProperties.isStripNamespaces()) {
                source = StringUtil.stripNamespaces((String)source);
            }
            source = source.trim();
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error transforming XML", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error transforming XML", (Throwable)e));
        }
        return source;
    }

    public String fromXML(String source) throws MessageSerializerException {
        return source;
    }

    public Map<String, Object> getMetaDataFromMessage(String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mirth_version", "1.0");
        map.put("message_type", "XML-Message");
        return map;
    }

    public void populateMetaData(String message, Map<String, Object> map) {
    }

    public String toJSON(String message) throws MessageSerializerException {
        return null;
    }

    public String fromJSON(String message) throws MessageSerializerException {
        return null;
    }
}

