/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datapruner;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.AbstractSettingsPanel;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.PollingSettingsPanel;
import com.mirth.connect.client.ui.panels.export.MessageExportPanel;
import com.mirth.connect.donkey.model.channel.PollConnectorProperties;
import com.mirth.connect.donkey.model.channel.PollingType;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.plugins.SettingsPanelPlugin;
import com.mirth.connect.plugins.datapruner.DataPrunerServletInterface;
import com.mirth.connect.util.messagewriter.MessageWriterOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class DataPrunerPanel
extends AbstractSettingsPanel {
    private static final int MIN_PRUNING_BLOCK_SIZE = 50;
    private static final int MAX_PRUNING_BLOCK_SIZE = 10000;
    private static final Color ACTIVE_STATUS_COLOR = new Color(200, 0, 0);
    private static final Color INACTIVE_STATUS_COLOR = new Color(0, 100, 0);
    private static final Color UNKNOWN_STATUS_COLOR = new Color(0, 0, 0);
    private SettingsPanelPlugin plugin = null;
    private ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
    private AtomicBoolean refreshing = new AtomicBoolean(false);
    private Frame parent;
    private int startIndex;
    private int stopIndex;
    private JPanel statusPanel;
    private JLabel currentStateLabel;
    private JLabel currentStateTextLabel;
    private JLabel currentProcessLabel;
    private JLabel currentProcessTextLabel;
    private JLabel lastProcessLabel;
    private JLabel lastProcessTextLabel;
    private JLabel nextProcessLabel;
    private JLabel nextProcessTextLabel;
    private JPanel pruningSchedulePanel;
    private JLabel enabledLabel;
    private MirthRadioButton yesEnabledRadio;
    private MirthRadioButton noEnabledRadio;
    private ButtonGroup enabledButtonGroup;
    private PollingSettingsPanel pollingSettingsPanel;
    private JPanel pruneSettingsPanel;
    private JLabel blockSizeLabel;
    private MirthTextField blockSizeTextField;
    private JLabel pruneEventsLabel;
    private MirthRadioButton pruneEventsYes;
    private MirthRadioButton pruneEventsNo;
    private ButtonGroup pruneEventsButtonGroup;
    private JLabel pruneEventAgeLabel;
    private MirthTextField pruneEventAgeTextField;
    private JLabel eventDaysLabel;
    private JPanel archiverContainerPanel;
    private MessageExportPanel archiverPanel;

    public DataPrunerPanel(String tabName, SettingsPanelPlugin plugin) {
        super(tabName);
        this.plugin = plugin;
        this.parent = PlatformUI.MIRTH_FRAME;
        this.addTask("doViewEvents", "View Events", "View the Data Pruner events.", "", new ImageIcon(Frame.class.getResource("images/table.png")));
        this.startIndex = this.addTask("doStart", "Prune Now", "Start the Data Pruner now.", "", new ImageIcon(Frame.class.getResource("images/control_play_blue.png")));
        this.stopIndex = this.addTask("doStop", "Stop Pruner", "Stop the current Data Pruner process.", "", new ImageIcon(Frame.class.getResource("images/stop.png")));
        this.setStartTaskVisible(false);
        this.setStopTaskVisible(false);
        this.initComponents();
        this.initLayout();
        this.blockSizeTextField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        this.pruneEventAgeTextField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
    }

    public void doRefresh() {
        if (PlatformUI.MIRTH_FRAME.alertRefresh()) {
            return;
        }
        final String workingId = this.getFrame().startWorking("Loading " + this.getTabName() + " properties...");
        final Properties serverProperties = new Properties();
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    Properties propertiesFromServer = DataPrunerPanel.this.plugin.getPropertiesFromServer();
                    if (propertiesFromServer != null) {
                        serverProperties.putAll((Map<?, ?>)propertiesFromServer);
                    }
                }
                catch (Exception e) {
                    DataPrunerPanel.this.getFrame().alertThrowable((Component)DataPrunerPanel.this.getFrame(), (Throwable)e);
                }
                return null;
            }

            @Override
            public void done() {
                DataPrunerPanel.this.setProperties(serverProperties);
                DataPrunerPanel.this.getFrame().stopWorking(workingId);
            }
        };
        worker.execute();
    }

    private boolean validateFields() {
        String errorMessage;
        String prunerBlockSize;
        int frequency;
        PollConnectorProperties properties;
        PollingType pollingType;
        boolean valid = true;
        StringBuilder builder = new StringBuilder();
        this.archiverPanel.resetInvalidProperties();
        this.pruneEventAgeTextField.setBackground(null);
        this.blockSizeTextField.setBackground(null);
        this.pollingSettingsPanel.setInvalidProperties(false, false);
        if (this.yesEnabledRadio.isSelected() && (pollingType = (properties = this.pollingSettingsPanel.getProperties()).getPollingType()).equals((Object)PollingType.INTERVAL) && ((frequency = properties.getPollingFrequency()) < 3600000 || frequency >= 86400000)) {
            valid = false;
            this.pollingSettingsPanel.setInvalidProperties(!valid, false);
            builder.append("Frequency must be between 1 and 24 hours when converted to milliseconds.");
        }
        if (StringUtils.isEmpty((CharSequence)(prunerBlockSize = this.blockSizeTextField.getText())) || Integer.parseInt(prunerBlockSize) < 50 || Integer.parseInt(prunerBlockSize) > 10000) {
            this.blockSizeTextField.setBackground(UIConstants.INVALID_COLOR);
            builder.append("\n");
            builder.append("Pruner Block size must be between 50 and 10000. The recommended value for most servers is 1000.");
            valid = false;
        }
        if (this.pruneEventsYes.isSelected() && StringUtils.isBlank((CharSequence)this.pruneEventAgeTextField.getText())) {
            this.pruneEventAgeTextField.setBackground(UIConstants.INVALID_COLOR);
            builder.append("\n");
            builder.append("Event Age is required when pruning events.");
            valid = false;
        }
        if (StringUtils.isNotEmpty((CharSequence)(errorMessage = this.archiverPanel.validate(true)))) {
            builder.append("\n");
            builder.append(errorMessage);
            valid = false;
        }
        if (!valid) {
            this.parent.alertError((Component)((Object)this), builder.toString());
        }
        return valid;
    }

    public boolean doSave() {
        if (!this.validateFields()) {
            return false;
        }
        final String workingId = this.getFrame().startWorking("Saving " + this.getTabName() + " properties...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    DataPrunerPanel.this.plugin.setPropertiesToServer(DataPrunerPanel.this.getProperties());
                }
                catch (Exception e) {
                    DataPrunerPanel.this.getFrame().alertThrowable((Component)DataPrunerPanel.this.getFrame(), (Throwable)e);
                }
                return null;
            }

            @Override
            public void done() {
                DataPrunerPanel.this.setSaveEnabled(false);
                DataPrunerPanel.this.getFrame().stopWorking(workingId);
                DataPrunerPanel.this.updateStatus();
            }
        };
        worker.execute();
        return true;
    }

    public void doViewEvents() {
        this.getFrame().doShowEvents("Data Pruner");
    }

    public void doStart() {
        final MutableBoolean saveChanges = new MutableBoolean(false);
        if (this.isSaveEnabled()) {
            if (0 == JOptionPane.showConfirmDialog((Component)((Object)this), "Settings changes must be saved first, would you like to save the settings and prune now?", "Select an Option", 2)) {
                if (!this.validateFields()) {
                    return;
                }
                saveChanges.setValue(true);
            } else {
                return;
            }
        }
        this.setStartTaskVisible(false);
        final String workingId = this.parent.startWorking("Starting the data pruner...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                if (saveChanges.getValue().booleanValue()) {
                    try {
                        DataPrunerPanel.this.plugin.setPropertiesToServer(DataPrunerPanel.this.getProperties());
                    }
                    catch (Exception e) {
                        DataPrunerPanel.this.getFrame().alertThrowable((Component)DataPrunerPanel.this.getFrame(), (Throwable)e);
                        return null;
                    }
                }
                try {
                    ((DataPrunerServletInterface)DataPrunerPanel.this.parent.mirthClient.getServlet(DataPrunerServletInterface.class)).start();
                }
                catch (Exception e) {
                    DataPrunerPanel.this.parent.alertThrowable((Component)DataPrunerPanel.this.parent, (Throwable)e, "An error occurred while attempting to start the data pruner.");
                    return null;
                }
                return null;
            }

            @Override
            public void done() {
                if (saveChanges.getValue().booleanValue()) {
                    DataPrunerPanel.this.setSaveEnabled(false);
                }
                DataPrunerPanel.this.parent.stopWorking(workingId);
                DataPrunerPanel.this.updateStatus();
            }
        };
        worker.execute();
    }

    public void doStop() {
        this.setStopTaskVisible(false);
        final String workingId = this.parent.startWorking("Stopping the data pruner...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                try {
                    ((DataPrunerServletInterface)DataPrunerPanel.this.parent.mirthClient.getServlet(DataPrunerServletInterface.class)).stop();
                }
                catch (Exception e) {
                    DataPrunerPanel.this.parent.alertThrowable((Component)DataPrunerPanel.this.parent, (Throwable)e, "An error occurred while attempting to stop the data pruner.");
                    return null;
                }
                return null;
            }

            @Override
            public void done() {
                DataPrunerPanel.this.parent.stopWorking(workingId);
                DataPrunerPanel.this.updateStatus();
            }
        };
        worker.execute();
    }

    public void setProperties(Properties properties) {
        if (Boolean.parseBoolean(properties.getProperty("enabled"))) {
            this.yesEnabledRadio.setSelected(true);
        } else {
            this.noEnabledRadio.setSelected(true);
        }
        this.archiverPanel.resetInvalidProperties();
        this.archiverPanel.setIncludeAttachments(Boolean.parseBoolean(properties.getProperty("includeAttachments", Boolean.FALSE.toString())));
        String archiverOptions = properties.getProperty("archiverOptions");
        if (archiverOptions == null) {
            this.archiverPanel.setMessageWriterOptions(new MessageWriterOptions());
        } else {
            this.archiverPanel.setMessageWriterOptions((MessageWriterOptions)this.serializer.deserialize(archiverOptions, MessageWriterOptions.class));
        }
        if (this.archiverPanel.isEnabled()) {
            this.archiverPanel.setArchiveEnabled(Boolean.parseBoolean(properties.getProperty("archiveEnabled", Boolean.FALSE.toString())));
        }
        if (properties.getProperty("pruningBlockSize") != null && !properties.getProperty("pruningBlockSize").equals("")) {
            this.blockSizeTextField.setText(properties.getProperty("pruningBlockSize"));
        } else {
            this.blockSizeTextField.setText("1000");
        }
        if (Boolean.parseBoolean(properties.getProperty("pruneEvents", Boolean.FALSE.toString()))) {
            this.pruneEventsYes.setSelected(true);
            this.pruneEventsNo.setSelected(false);
            this.pruneEventAgeLabel.setEnabled(true);
            this.pruneEventAgeTextField.setEnabled(true);
        } else {
            this.pruneEventsYes.setSelected(false);
            this.pruneEventsNo.setSelected(true);
            this.pruneEventAgeLabel.setEnabled(false);
            this.pruneEventAgeTextField.setEnabled(false);
        }
        this.pruneEventAgeTextField.setText(properties.getProperty("maxEventAge"));
        if (properties.getProperty("archiverBlockSize") != null && !properties.getProperty("archiverBlockSize").equals("")) {
            this.archiverPanel.setArchiverBlockSize(properties.getProperty("archiverBlockSize"));
        } else {
            this.archiverPanel.setArchiverBlockSize("50");
        }
        PollConnectorProperties pollProperties = null;
        String pollingProperties = properties.getProperty("pollingProperties");
        pollProperties = pollingProperties == null ? new PollConnectorProperties() : (PollConnectorProperties)this.serializer.deserialize(pollingProperties, PollConnectorProperties.class);
        this.pollingSettingsPanel.setProperties(pollProperties);
        this.enabledActionPerformed();
        this.repaint();
        this.updateStatus();
        this.parent.setSaveEnabled(false);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        if (this.blockSizeTextField.getText().equals("")) {
            this.blockSizeTextField.setText("1000");
        }
        String enabled = "true";
        if (this.noEnabledRadio.isSelected()) {
            enabled = "false";
        }
        properties.setProperty("enabled", enabled);
        properties.setProperty("pollingProperties", this.serializer.serialize((Object)this.pollingSettingsPanel.getProperties()));
        properties.setProperty("pruningBlockSize", this.blockSizeTextField.getText());
        properties.setProperty("pruneEvents", Boolean.toString(this.pruneEventsYes.isSelected()));
        properties.setProperty("maxEventAge", this.pruneEventAgeTextField.getText());
        properties.setProperty("archiveEnabled", Boolean.toString(this.archiverPanel.isArchiveEnabled()));
        properties.setProperty("archiverBlockSize", this.archiverPanel.getArchiverBlockSize());
        properties.setProperty("includeAttachments", Boolean.toString(this.archiverPanel.isIncludeAttachments()));
        properties.setProperty("archiverOptions", this.serializer.serialize((Object)this.archiverPanel.getMessageWriterOptions()));
        return properties;
    }

    private void updateStatus() {
        final String workingId = this.parent.startWorking("Refreshing status...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                try {
                    Map status = ((DataPrunerServletInterface)DataPrunerPanel.this.parent.mirthClient.getServlet(DataPrunerServletInterface.class)).getStatusMap();
                    DataPrunerPanel.this.currentStateTextLabel.setText((String)status.get("currentState"));
                    DataPrunerPanel.this.currentProcessTextLabel.setText((String)status.get("currentProcess"));
                    DataPrunerPanel.this.lastProcessTextLabel.setText((String)status.get("lastProcess"));
                    String nextProcess = "Not scheduled";
                    if (DataPrunerPanel.this.yesEnabledRadio.isSelected()) {
                        nextProcess = (String)status.get("nextProcess");
                    }
                    DataPrunerPanel.this.nextProcessTextLabel.setText(nextProcess);
                    if (((String)status.get("isRunning")).equals("false")) {
                        DataPrunerPanel.this.currentStateTextLabel.setForeground(INACTIVE_STATUS_COLOR);
                        DataPrunerPanel.this.setStartTaskVisible(true);
                        DataPrunerPanel.this.setStopTaskVisible(false);
                    } else {
                        DataPrunerPanel.this.currentStateTextLabel.setForeground(ACTIVE_STATUS_COLOR);
                        DataPrunerPanel.this.setStartTaskVisible(false);
                        DataPrunerPanel.this.setStopTaskVisible(true);
                    }
                }
                catch (ClientException e) {
                    DataPrunerPanel.this.currentStateTextLabel.setText("Unknown");
                    DataPrunerPanel.this.currentStateTextLabel.setForeground(UNKNOWN_STATUS_COLOR);
                    DataPrunerPanel.this.currentProcessTextLabel.setText("");
                    DataPrunerPanel.this.lastProcessTextLabel.setText("");
                    DataPrunerPanel.this.nextProcessTextLabel.setText("");
                    DataPrunerPanel.this.setStartTaskVisible(false);
                    DataPrunerPanel.this.setStopTaskVisible(false);
                    DataPrunerPanel.this.parent.alertThrowable((Component)DataPrunerPanel.this.parent, (Throwable)e, "An error occurred while attempting to retrieve the status of the data pruner.");
                }
                return null;
            }

            @Override
            public void done() {
                DataPrunerPanel.this.parent.stopWorking(workingId);
                DataPrunerPanel.this.refreshing.set(false);
            }
        };
        worker.execute();
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.statusPanel = new JPanel();
        this.statusPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.statusPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Status", 0, 0, new Font("Tahoma", 1, 11)));
        this.currentStateLabel = new JLabel("Current State:");
        this.currentStateTextLabel = new JLabel("Unknown");
        this.currentProcessLabel = new JLabel("Current Process:");
        this.currentProcessTextLabel = new JLabel("Unknown");
        this.lastProcessLabel = new JLabel("Last Process:");
        this.lastProcessTextLabel = new JLabel("Unknown");
        this.nextProcessLabel = new JLabel("Next Process:");
        this.nextProcessTextLabel = new JLabel("Unknown");
        this.pruningSchedulePanel = new JPanel();
        this.pruningSchedulePanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.pruningSchedulePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Schedule", 0, 0, new Font("Tahoma", 1, 11)));
        this.enabledLabel = new JLabel("Enable:");
        this.yesEnabledRadio = new MirthRadioButton("Yes");
        this.yesEnabledRadio.setFocusable(false);
        this.yesEnabledRadio.setBackground(Color.white);
        this.yesEnabledRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DataPrunerPanel.this.enabledActionPerformed();
            }
        });
        this.noEnabledRadio = new MirthRadioButton("No");
        this.noEnabledRadio.setFocusable(false);
        this.noEnabledRadio.setBackground(Color.white);
        this.noEnabledRadio.setSelected(true);
        this.noEnabledRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DataPrunerPanel.this.enabledActionPerformed();
            }
        });
        this.enabledButtonGroup = new ButtonGroup();
        this.enabledButtonGroup.add((AbstractButton)this.yesEnabledRadio);
        this.enabledButtonGroup.add((AbstractButton)this.noEnabledRadio);
        this.pollingSettingsPanel = new PollingSettingsPanel(false);
        this.pruneSettingsPanel = new JPanel();
        this.pruneSettingsPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.pruneSettingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Prune Settings", 0, 0, new Font("Tahoma", 1, 11)));
        this.blockSizeLabel = new JLabel("Block Size:");
        this.blockSizeTextField = new MirthTextField();
        this.blockSizeTextField.setToolTipText("<html>The number of messages that will be pruned at a time. This value must<br/>be between 50 and 10000. The recommended value for most servers is 1000.</html>");
        this.pruneEventsLabel = new JLabel("Prune Events:");
        this.pruneEventsYes = new MirthRadioButton("Yes");
        this.pruneEventsYes.setBackground(UIConstants.BACKGROUND_COLOR);
        this.pruneEventsYes.setToolTipText("<html>If Yes, event records older than the Event Age will be pruned. If No, event records will not be pruned.</html>");
        this.pruneEventsYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataPrunerPanel.this.pruneEventsActionPerformed(evt);
            }
        });
        this.pruneEventsNo = new MirthRadioButton("No");
        this.pruneEventsNo.setBackground(UIConstants.BACKGROUND_COLOR);
        this.pruneEventsNo.setToolTipText("<html>If Yes, event records will be pruned in addition to messages. If No, event records will not be pruned.</html>");
        this.pruneEventsNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataPrunerPanel.this.pruneEventsActionPerformed(evt);
            }
        });
        this.pruneEventsButtonGroup = new ButtonGroup();
        this.pruneEventsButtonGroup.add((AbstractButton)this.pruneEventsYes);
        this.pruneEventsButtonGroup.add((AbstractButton)this.pruneEventsNo);
        this.pruneEventAgeLabel = new JLabel("Prune Event Age:");
        this.pruneEventAgeTextField = new MirthTextField();
        this.pruneEventAgeTextField.setToolTipText("<html>Events older than this number of days will be pruned if Prune Events is set to Yes.</html>");
        this.eventDaysLabel = new JLabel("days");
        this.eventDaysLabel.setEnabled(false);
        this.archiverContainerPanel = new JPanel();
        this.archiverContainerPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.archiverContainerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Archive Settings", 0, 0, new Font("Tahoma", 1, 11)));
        this.archiverContainerPanel.setLayout(null);
        this.archiverPanel = new MessageExportPanel(Frame.userPreferences, true, false);
        this.archiverPanel.setBackground(this.archiverContainerPanel.getBackground());
        this.archiverContainerPanel.setLayout((LayoutManager)new MigLayout("fillx, insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
        this.archiverContainerPanel.add((Component)this.archiverPanel, "height 250!, aligny top");
        this.enabledActionPerformed();
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3, novisualpadding, insets 12", "[grow]"));
        this.statusPanel.setLayout((LayoutManager)new MigLayout("hidemode 3, novisualpadding, insets 0", "12[right][left]"));
        this.statusPanel.add(this.currentStateLabel);
        this.statusPanel.add((Component)this.currentStateTextLabel, "wrap");
        this.statusPanel.add(this.currentProcessLabel);
        this.statusPanel.add((Component)this.currentProcessTextLabel, "wrap");
        this.statusPanel.add(this.lastProcessLabel);
        this.statusPanel.add((Component)this.lastProcessTextLabel, "wrap");
        this.statusPanel.add(this.nextProcessLabel);
        this.statusPanel.add((Component)this.nextProcessTextLabel, "wrap");
        this.pruningSchedulePanel.setLayout((LayoutManager)new MigLayout("hidemode 3, novisualpadding, insets 0", "21[][]"));
        this.pruningSchedulePanel.add((Component)this.enabledLabel, "gapleft 37, split");
        this.pruningSchedulePanel.add((Component)this.yesEnabledRadio, "gapleft 12");
        this.pruningSchedulePanel.add((Component)this.noEnabledRadio, "wrap");
        this.pruningSchedulePanel.add((Component)this.pollingSettingsPanel);
        this.pruneSettingsPanel.setLayout((LayoutManager)new MigLayout("hidemode 3, novisualpadding, insets 0", "11[right]12[left]"));
        this.pruneSettingsPanel.add(this.blockSizeLabel);
        this.pruneSettingsPanel.add((Component)this.blockSizeTextField, "w 75!, h 22!, wrap");
        this.pruneSettingsPanel.add(this.pruneEventsLabel);
        this.pruneSettingsPanel.add((Component)this.pruneEventsYes, "split");
        this.pruneSettingsPanel.add((Component)this.pruneEventsNo, "wrap");
        this.pruneSettingsPanel.add(this.pruneEventAgeLabel);
        this.pruneSettingsPanel.add((Component)this.pruneEventAgeTextField, "w 75!, h 22!, split");
        this.pruneSettingsPanel.add((Component)this.eventDaysLabel, "gapleft 8, wrap");
        this.add(this.statusPanel, "grow, sx, wrap");
        this.add(this.pruningSchedulePanel, "grow, sx, wrap");
        this.add(this.pruneSettingsPanel, "grow, sx, wrap");
        this.add(this.archiverContainerPanel, "grow, sx");
    }

    private void pruneEventsActionPerformed(ActionEvent evt) {
        this.pruneEventAgeLabel.setEnabled(this.pruneEventsYes.isSelected());
        this.pruneEventAgeTextField.setEnabled(this.pruneEventsYes.isSelected());
        this.eventDaysLabel.setEnabled(this.pruneEventsYes.isSelected());
    }

    private void enabledActionPerformed() {
        this.pollingSettingsPanel.enableComponents(this.yesEnabledRadio.isSelected());
    }

    private void setStartTaskVisible(boolean visible) {
        this.setVisibleTasks(this.startIndex, this.startIndex, visible);
    }

    private void setStopTaskVisible(boolean visible) {
        this.setVisibleTasks(this.stopIndex, this.stopIndex, visible);
    }
}

