/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.model.message;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@XStreamAlias(value="message")
public class Message
implements Serializable {
    private Long messageId;
    private String serverId;
    private String channelId;
    private String channelName;
    private Calendar receivedDate;
    private boolean processed;
    private Long originalId;
    private Long importId;
    private String importChannelId;
    private List<Attachment> attachments;
    private Map<Integer, ConnectorMessage> connectorMessages = new LinkedHashMap<Integer, ConnectorMessage>();
    private transient ConnectorMessage mergedConnectorMessage;

    public Long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(Long messageId) {
        this.messageId = messageId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public Calendar getReceivedDate() {
        return this.receivedDate;
    }

    public void setReceivedDate(Calendar receivedDate) {
        this.receivedDate = receivedDate;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public Long getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(Long originalId) {
        this.originalId = originalId;
    }

    public Long getImportId() {
        return this.importId;
    }

    public void setImportId(Long importId) {
        this.importId = importId;
    }

    public String getImportChannelId() {
        return this.importChannelId;
    }

    public void setImportChannelId(String importChannelId) {
        this.importChannelId = importChannelId;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public Map<Integer, ConnectorMessage> getConnectorMessages() {
        return this.connectorMessages;
    }

    public ConnectorMessage getMergedConnectorMessage() {
        if (this.mergedConnectorMessage == null) {
            this.mergedConnectorMessage = new ConnectorMessage();
            this.mergedConnectorMessage.setChannelId(this.channelId);
            this.mergedConnectorMessage.setMessageId(this.messageId);
            this.mergedConnectorMessage.setServerId(this.serverId);
            this.mergedConnectorMessage.setReceivedDate(this.receivedDate);
            Map<String, Object> sourceMap = null;
            HashMap<String, Object> responseMap = new HashMap<String, Object>();
            HashMap<String, Object> channelMap = new HashMap<String, Object>();
            ConnectorMessage sourceConnectorMessage = this.connectorMessages.get(0);
            if (sourceConnectorMessage != null) {
                this.mergedConnectorMessage.setRaw(sourceConnectorMessage.getRaw());
                this.mergedConnectorMessage.setProcessedRaw(sourceConnectorMessage.getProcessedRaw());
                sourceMap = sourceConnectorMessage.getSourceMap();
                responseMap.putAll(sourceConnectorMessage.getResponseMap());
                channelMap.putAll(sourceConnectorMessage.getChannelMap());
            }
            ArrayList<ConnectorMessage> orderedConnectorMessages = new ArrayList<ConnectorMessage>(this.connectorMessages.values());
            Collections.sort(orderedConnectorMessages, new Comparator<ConnectorMessage>(){

                @Override
                public int compare(ConnectorMessage m1, ConnectorMessage m2) {
                    if (m1.getChainId() == m2.getChainId()) {
                        return m1.getOrderId() - m2.getOrderId();
                    }
                    return m1.getChainId() - m2.getChainId();
                }
            });
            for (ConnectorMessage connectorMessage : orderedConnectorMessages) {
                if (connectorMessage.getMetaDataId() <= 0) continue;
                if (sourceMap == null) {
                    sourceMap = connectorMessage.getSourceMap();
                }
                responseMap.putAll(connectorMessage.getResponseMap());
                channelMap.putAll(connectorMessage.getChannelMap());
            }
            this.mergedConnectorMessage.setSourceMap(sourceMap);
            this.mergedConnectorMessage.setResponseMap(responseMap);
            this.mergedConnectorMessage.setChannelMap(channelMap);
        }
        return this.mergedConnectorMessage;
    }

    public String toString() {
        return "message " + this.messageId;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }
}

