/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.util;

import com.mirth.connect.donkey.model.channel.PollConnectorProperties;
import com.mirth.connect.donkey.model.channel.PollingType;
import com.mirth.connect.donkey.util.DummyJob;
import com.mirth.connect.donkey.util.TriggerFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.spi.JobFactory;

public class PollConnectorJobHandler {
    private PollConnectorProperties pollConnectorProperties;
    private TriggerFactory triggerFactory;
    private String id;
    private boolean initialTriggerFired;
    private boolean isPollConnector;
    private JobDetail job;
    private Scheduler scheduler;
    private List<Trigger> triggerList;
    private BaseCalendar calendar;

    public PollConnectorJobHandler(PollConnectorProperties pollConnectorProperties, String id, boolean isPollConnector) {
        this.pollConnectorProperties = pollConnectorProperties;
        this.id = id;
        this.isPollConnector = isPollConnector;
        this.initialTriggerFired = false;
    }

    public void configureJob(Class className, JobFactory jobFactory, String identity) throws SchedulerException {
        JobBuilder jobBuilder = JobBuilder.newJob(className != null ? className : DummyJob.class).withIdentity(identity + this.id, this.id);
        jobBuilder.storeDurably(true);
        this.job = jobBuilder.build();
        this.createTriggers();
        if (className != null) {
            Properties schedulerProperties = new Properties();
            schedulerProperties.setProperty("org.quartz.scheduler.instanceName", this.id);
            schedulerProperties.setProperty("org.quartz.threadPool.threadCount", String.valueOf(this.triggerList.size()));
            StdSchedulerFactory factory = new StdSchedulerFactory();
            factory.initialize(schedulerProperties);
            this.scheduler = factory.getScheduler();
            if (jobFactory != null) {
                this.scheduler.setJobFactory(jobFactory);
            }
            if (this.calendar != null) {
                this.scheduler.addCalendar("Calendar", (Calendar)this.calendar, true, true);
            }
        }
    }

    private void createTriggers() throws SchedulerException {
        this.triggerList = new ArrayList<Trigger>();
        this.triggerFactory = new TriggerFactory(this.job, this.pollConnectorProperties, this.id);
        PollingType pollingType = this.pollConnectorProperties.getPollingType();
        if (pollingType.equals((Object)PollingType.CRON)) {
            this.triggerList.addAll(this.triggerFactory.createCronTriggers());
        } else {
            if (pollingType.equals((Object)PollingType.INTERVAL)) {
                this.triggerList.add(this.triggerFactory.createDailyInterval());
            } else if (pollingType.equals((Object)PollingType.TIME)) {
                this.triggerList.add(this.triggerFactory.createTimeTrigger());
            }
            this.calendar = this.triggerFactory.getCalendar();
        }
    }

    public void scheduleJob(boolean start) throws SchedulerException {
        if (!this.triggerList.isEmpty()) {
            this.scheduler.addJob(this.job, false);
            for (Trigger trigger : this.triggerList) {
                this.scheduler.scheduleJob(trigger);
            }
            if (this.isPollConnector && this.pollConnectorProperties.isPollOnStart() && !this.initialTriggerFired) {
                this.scheduler.triggerJob(this.job.getKey());
                this.initialTriggerFired = true;
            }
            if (start) {
                this.scheduler.start();
            }
        }
    }

    public JobDetail getJob() {
        return this.job;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public String getNextFireTime() {
        String time = "";
        Date earliestTriggerTime = null;
        java.util.Calendar currentTime = java.util.Calendar.getInstance();
        try {
            boolean isTimeIncluded;
            for (Trigger trigger : this.triggerList) {
                Date nextFireTime = trigger.getFireTimeAfter(currentTime.getTime());
                if (earliestTriggerTime != null && (nextFireTime == null || !nextFireTime.before(earliestTriggerTime))) continue;
                earliestTriggerTime = nextFireTime = nextFireTime == null ? trigger.getNextFireTime() : nextFireTime;
            }
            PollingType pollingType = this.pollConnectorProperties.getPollingType();
            if (pollingType != PollingType.CRON && !(isTimeIncluded = this.calendar.isTimeIncluded(earliestTriggerTime.getTime()))) {
                if (pollingType == PollingType.TIME) {
                    for (int count = 0; !isTimeIncluded && count < 60; ++count) {
                        earliestTriggerTime = this.triggerList.get(0).getFireTimeAfter(earliestTriggerTime);
                        isTimeIncluded = this.calendar.isTimeIncluded(earliestTriggerTime.getTime());
                    }
                } else {
                    java.util.Calendar includedTime = java.util.Calendar.getInstance();
                    includedTime.setTimeInMillis(this.calendar.getNextIncludedTime(currentTime.getTimeInMillis()));
                    earliestTriggerTime = includedTime.getTime();
                }
            }
            if (earliestTriggerTime != null) {
                time = new SimpleDateFormat("EEEE, MMM d, h:mm:ss a").format(earliestTriggerTime);
            }
        }
        catch (Exception e) {
            time = "Invalid Schedule.";
        }
        return time;
    }

    public static boolean validateExpression(String expression) {
        return CronExpression.isValidExpression((String)expression);
    }
}

